/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.BitmapInputStreamDecoder;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/clevertap/android/sdk/bitmap/GzipBitmapInputStreamReader;", "Lcom/clevertap/android/sdk/bitmap/BitmapInputStreamDecoder;", "saveBytes", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "<init>", "(ZLcom/clevertap/android/sdk/Logger;)V", "readInputStream", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "downloadStartTimeInMilliseconds", "", "getDownloadedBitmapFromStream", "dataReadFromStream", "Ljava/io/ByteArrayOutputStream;", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nGzipBitmapInputStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipBitmapInputStreamReader.kt\ncom/clevertap/android/sdk/bitmap/GzipBitmapInputStreamReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class GzipBitmapInputStreamReader
extends BitmapInputStreamDecoder {
    public GzipBitmapInputStreamReader(boolean saveBytes, @Nullable Logger logger) {
        super(saveBytes, false, logger, 2, null);
    }

    public /* synthetic */ GzipBitmapInputStreamReader(boolean bl, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            logger = null;
        }
        this(bl, logger);
    }

    @Override
    @NotNull
    public DownloadedBitmap readInputStream(@NotNull InputStream inputStream, @NotNull HttpURLConnection connection, long downloadStartTimeInMilliseconds) {
        boolean isGZipEncoded;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Logger.v("reading bitmap input stream in GzipBitmapInputStreamReader....");
        String string2 = connection.getContentEncoding();
        boolean bl = isGZipEncoded = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"gzip", (boolean)false, (int)2, null) : false;
        if (isGZipEncoded) {
            GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
            byte[] bufferForGzipInputStream = new byte[16384];
            ByteArrayOutputStream decompressedFile = new ByteArrayOutputStream();
            int totalBytesRead = 0;
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = gzipInputStream.read(bufferForGzipInputStream);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                totalBytesRead += bytesRead;
                decompressedFile.write(bufferForGzipInputStream, 0, bytesRead);
            }
            Logger logger = this.getLogger();
            if (logger != null) {
                logger.verbose("Total decompressed download size for bitmap from output stream = " + decompressedFile.size());
            }
            return this.getDownloadedBitmapFromStream(decompressedFile, downloadStartTimeInMilliseconds);
        }
        return super.readInputStream(inputStream, connection, downloadStartTimeInMilliseconds);
    }

    private final DownloadedBitmap getDownloadedBitmapFromStream(ByteArrayOutputStream dataReadFromStream, long downloadStartTimeInMilliseconds) {
        byte[] dataReadFromStreamInByteArray = dataReadFromStream.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])dataReadFromStreamInByteArray, (int)0, (int)dataReadFromStreamInByteArray.length);
        Intrinsics.checkNotNull((Object)bitmap);
        return DownloadedBitmapFactory.successBitmap$default(DownloadedBitmapFactory.INSTANCE, bitmap, Utils.getNowInMillis() - downloadStartTimeInMilliseconds, null, 4, null);
    }

    public GzipBitmapInputStreamReader() {
        this(false, null, 3, null);
    }
}

