/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images.repo;

import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.images.cleanup.FileCleanupStrategy;
import com.clevertap.android.sdk.inapp.images.preload.FilePreloaderStrategy;
import com.clevertap.android.sdk.inapp.images.repo.DownloadState;
import com.clevertap.android.sdk.inapp.images.repo.DownloadTriggerForUrls;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepo;
import com.clevertap.android.sdk.inapp.store.preference.FileStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u00af\u0001\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00160\u00152-\u0010\u0019\u001a)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00130\u001a2-\u0010 \u001a)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00130\u001a2-\u0010!\u001a)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00130\u001aH\u0016J$\u0010\"\u001a\u00020\u00132\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020\u00132\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0018H\u0016JW\u0010+\u001a\u00020\u00132\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\b\b\u0002\u0010-\u001a\u00020.2\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0017002#\b\u0002\u00101\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020.0\u001aH\u0002J\u0016\u00103\u001a\u00020\u00132\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J\b\u00105\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepoImpl;", "Lcom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepo;", "cleanupStrategy", "Lcom/clevertap/android/sdk/inapp/images/cleanup/FileCleanupStrategy;", "preloaderStrategy", "Lcom/clevertap/android/sdk/inapp/images/preload/FilePreloaderStrategy;", "inAppAssetsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "fileStore", "Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;", "legacyInAppsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;", "<init>", "(Lcom/clevertap/android/sdk/inapp/images/cleanup/FileCleanupStrategy;Lcom/clevertap/android/sdk/inapp/images/preload/FilePreloaderStrategy;Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;)V", "getCleanupStrategy", "()Lcom/clevertap/android/sdk/inapp/images/cleanup/FileCleanupStrategy;", "getPreloaderStrategy", "()Lcom/clevertap/android/sdk/inapp/images/preload/FilePreloaderStrategy;", "preloadFilesAndCache", "", "urlMeta", "", "Lkotlin/Pair;", "", "Lcom/clevertap/android/sdk/inapp/data/CtCacheType;", "completionCallback", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "urlStatusMap", "successBlock", "failureBlock", "updateRepoStatus", "meta", "downloadState", "Lcom/clevertap/android/sdk/inapp/images/repo/DownloadState;", "cleanupStaleFiles", "urls", "cleanupExpiredResources", "cacheTpe", "cleanupAllResources", "cleanupStaleFilesNow", "validUrls", "currentTime", "", "allFileUrls", "", "expiryTs", "url", "cleanupAllFiles", "cleanupUrls", "repoUpdated", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nFileResourcesRepoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileResourcesRepoImpl.kt\ncom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepoImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1279#2,2:239\n1293#2,4:241\n774#2:245\n865#2,2:246\n1863#2:248\n1734#2,3:249\n1864#2:252\n*S KotlinDebug\n*F\n+ 1 FileResourcesRepoImpl.kt\ncom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepoImpl\n*L\n178#1:239,2\n178#1:241,4\n182#1:245\n182#1:246,2\n208#1:248\n210#1:249,3\n208#1:252\n*E\n"})
public final class FileResourcesRepoImpl
implements FileResourcesRepo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCleanupStrategy cleanupStrategy;
    @NotNull
    private final FilePreloaderStrategy preloaderStrategy;
    @NotNull
    private final InAppAssetsStore inAppAssetsStore;
    @NotNull
    private final FileStore fileStore;
    @NotNull
    private final LegacyInAppStore legacyInAppsStore;
    private static final long EXPIRY_OFFSET_MILLIS = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)14, (DurationUnit)DurationUnit.DAYS));
    @NotNull
    private static final Set<DownloadTriggerForUrls> urlTriggers = new LinkedHashSet();
    @NotNull
    private static final HashMap<String, DownloadState> downloadInProgressUrls = new HashMap();
    @NotNull
    private static final Object fetchAllFilesLock = new Object();

    public FileResourcesRepoImpl(@NotNull FileCleanupStrategy cleanupStrategy, @NotNull FilePreloaderStrategy preloaderStrategy, @NotNull InAppAssetsStore inAppAssetsStore, @NotNull FileStore fileStore, @NotNull LegacyInAppStore legacyInAppsStore) {
        Intrinsics.checkNotNullParameter((Object)cleanupStrategy, (String)"cleanupStrategy");
        Intrinsics.checkNotNullParameter((Object)preloaderStrategy, (String)"preloaderStrategy");
        Intrinsics.checkNotNullParameter((Object)inAppAssetsStore, (String)"inAppAssetsStore");
        Intrinsics.checkNotNullParameter((Object)fileStore, (String)"fileStore");
        Intrinsics.checkNotNullParameter((Object)legacyInAppsStore, (String)"legacyInAppsStore");
        this.cleanupStrategy = cleanupStrategy;
        this.preloaderStrategy = preloaderStrategy;
        this.inAppAssetsStore = inAppAssetsStore;
        this.fileStore = fileStore;
        this.legacyInAppsStore = legacyInAppsStore;
    }

    @Override
    @NotNull
    public FileCleanupStrategy getCleanupStrategy() {
        return this.cleanupStrategy;
    }

    @Override
    @NotNull
    public FilePreloaderStrategy getPreloaderStrategy() {
        return this.preloaderStrategy;
    }

    @Override
    public void preloadFilesAndCache(@NotNull List<? extends Pair<String, ? extends CtCacheType>> urlMeta, @NotNull Function1<? super Map<String, Boolean>, Unit> completionCallback, @NotNull Function1<? super Pair<String, ? extends CtCacheType>, Unit> successBlock, @NotNull Function1<? super Pair<String, ? extends CtCacheType>, Unit> failureBlock) {
        Intrinsics.checkNotNullParameter(urlMeta, (String)"urlMeta");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        Intrinsics.checkNotNullParameter(successBlock, (String)"successBlock");
        Intrinsics.checkNotNullParameter(failureBlock, (String)"failureBlock");
        Function1 successBlockk = arg_0 -> FileResourcesRepoImpl.preloadFilesAndCache$lambda$0(this, successBlock, arg_0);
        Function1 failureBlockk = arg_0 -> FileResourcesRepoImpl.preloadFilesAndCache$lambda$1(this, failureBlock, arg_0);
        Function1 started = arg_0 -> FileResourcesRepoImpl.preloadFilesAndCache$lambda$2(this, arg_0);
        this.getPreloaderStrategy().preloadFilesAndCache(urlMeta, (Function1<? super Pair<String, ? extends CtCacheType>, Unit>)successBlockk, (Function1<? super Pair<String, ? extends CtCacheType>, Unit>)failureBlockk, (Function1<? super Pair<String, ? extends CtCacheType>, Unit>)started, completionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateRepoStatus(Pair<String, ? extends CtCacheType> meta, DownloadState downloadState) {
        if (urlTriggers.isEmpty()) {
            return;
        }
        Object object = fetchAllFilesLock;
        synchronized (object) {
            boolean bl = false;
            ((Map)downloadInProgressUrls).put(meta.getFirst(), downloadState);
            this.repoUpdated();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void cleanupStaleFiles(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.legacyInAppsStore.lastCleanupTs() < EXPIRY_OFFSET_MILLIS) {
            return;
        }
        FileResourcesRepoImpl.cleanupStaleFilesNow$default(this, urls, currentTime, null, null, 12, null);
        this.legacyInAppsStore.updateAssetCleanupTs(currentTime);
    }

    @Override
    public void cleanupExpiredResources(@NotNull CtCacheType cacheTpe) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)((Object)cacheTpe), (String)"cacheTpe");
        switch (WhenMappings.$EnumSwitchMapping$0[cacheTpe.ordinal()]) {
            case 1: 
            case 2: {
                set = this.inAppAssetsStore.getAllAssetUrls();
                break;
            }
            case 3: {
                set = SetsKt.plus(this.fileStore.getAllFileUrls(), (Iterable)this.inAppAssetsStore.getAllAssetUrls());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Set allFileUrls = set;
        FileResourcesRepoImpl.cleanupStaleFilesNow$default(this, null, 0L, allFileUrls, null, 11, null);
    }

    @Override
    public void cleanupAllResources(@NotNull CtCacheType cacheTpe) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)((Object)cacheTpe), (String)"cacheTpe");
        switch (WhenMappings.$EnumSwitchMapping$0[cacheTpe.ordinal()]) {
            case 1: 
            case 2: {
                set = this.inAppAssetsStore.getAllAssetUrls();
                break;
            }
            case 3: {
                set = SetsKt.plus(this.fileStore.getAllFileUrls(), (Iterable)this.inAppAssetsStore.getAllAssetUrls());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Set cleanupUrls = set;
        this.cleanupAllFiles(CollectionsKt.toList((Iterable)cleanupUrls));
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupStaleFilesNow(List<String> validUrls, long currentTime, Set<String> allFileUrls, Function1<? super String, Long> expiryTs) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$associateWith$iv = validUrls;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            void var21_21 = it;
            map.put(t, var21_21);
        }
        Map valid = result$iv;
        Iterable $i$f$associateWith22 = CollectionsKt.toMutableSet((Iterable)allFileUrls);
        boolean $i$f$filter = false;
        $this$associateWithTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String key = (String)element$iv$iv;
            boolean bl = false;
            boolean first = !valid.containsKey(key);
            boolean second = currentTime > ((Number)expiryTs.invoke((Object)key)).longValue();
            if (!(first && second)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cleanupFileUrls = (List)destination$iv$iv;
        this.cleanupAllFiles(cleanupFileUrls);
    }

    static /* synthetic */ void cleanupStaleFilesNow$default(FileResourcesRepoImpl fileResourcesRepoImpl, List list, long l, Set set, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n & 4) != 0) {
            set = SetsKt.plus(fileResourcesRepoImpl.fileStore.getAllFileUrls(), (Iterable)fileResourcesRepoImpl.inAppAssetsStore.getAllAssetUrls());
        }
        if ((n & 8) != 0) {
            function1 = arg_0 -> FileResourcesRepoImpl.cleanupStaleFilesNow$lambda$4(fileResourcesRepoImpl, arg_0);
        }
        fileResourcesRepoImpl.cleanupStaleFilesNow(list, l, set, (Function1<? super String, Long>)function1);
    }

    private final void cleanupAllFiles(List<String> cleanupUrls) {
        Function1 successBlock = arg_0 -> FileResourcesRepoImpl.cleanupAllFiles$lambda$7(this, arg_0);
        this.getCleanupStrategy().clearFileAssets(cleanupUrls, (Function1<? super String, Unit>)successBlock);
    }

    private final void repoUpdated() {
        Iterable $this$forEach$iv = urlTriggers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean all;
            boolean bl;
            DownloadTriggerForUrls dt;
            block4: {
                dt = (DownloadTriggerForUrls)element$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = dt.getUrls();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        String url = (String)element$iv2;
                        boolean bl3 = false;
                        if (downloadInProgressUrls.get(url) == DownloadState.SUCCESSFUL || downloadInProgressUrls.get(url) == DownloadState.FAILED) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!(all = bl)) continue;
            dt.getCallback().invoke();
        }
    }

    @Override
    public void preloadFilesAndCache(@NotNull List<? extends Pair<String, ? extends CtCacheType>> urlMeta) {
        FileResourcesRepo.DefaultImpls.preloadFilesAndCache(this, urlMeta);
    }

    @Override
    public void preloadFilesAndCache(@NotNull List<? extends Pair<String, ? extends CtCacheType>> urlMeta, @NotNull Function1<? super Map<String, Boolean>, Unit> completionCallback) {
        FileResourcesRepo.DefaultImpls.preloadFilesAndCache(this, urlMeta, completionCallback);
    }

    @Override
    public void cleanupStaleFiles() {
        FileResourcesRepo.DefaultImpls.cleanupStaleFiles(this);
    }

    private static final Unit preloadFilesAndCache$lambda$0(FileResourcesRepoImpl this$0, Function1 $successBlock, Pair meta) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$successBlock, (String)"$successBlock");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        Companion.saveUrlExpiryToStore((Pair<String, ? extends CtCacheType>)meta, (Pair<FileStore, InAppAssetsStore>)new Pair((Object)this$0.fileStore, (Object)this$0.inAppAssetsStore));
        this$0.updateRepoStatus((Pair<String, ? extends CtCacheType>)meta, DownloadState.SUCCESSFUL);
        $successBlock.invoke((Object)meta);
        return Unit.INSTANCE;
    }

    private static final Unit preloadFilesAndCache$lambda$1(FileResourcesRepoImpl this$0, Function1 $failureBlock, Pair meta) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$failureBlock, (String)"$failureBlock");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        this$0.updateRepoStatus((Pair<String, ? extends CtCacheType>)meta, DownloadState.FAILED);
        $failureBlock.invoke((Object)meta);
        return Unit.INSTANCE;
    }

    private static final Unit preloadFilesAndCache$lambda$2(FileResourcesRepoImpl this$0, Pair meta) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        this$0.updateRepoStatus((Pair<String, ? extends CtCacheType>)meta, DownloadState.IN_PROGRESS);
        return Unit.INSTANCE;
    }

    private static final long cleanupStaleFilesNow$lambda$4(FileResourcesRepoImpl this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Math.max(this$0.fileStore.expiryForUrl(key), this$0.inAppAssetsStore.expiryForUrl(key));
    }

    private static final Unit cleanupAllFiles$lambda$7(FileResourcesRepoImpl this$0, String url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this$0.fileStore.clearFileUrl(url);
        this$0.inAppAssetsStore.clearAssetUrl(url);
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void saveUrlExpiryToStore(@NotNull Pair<String, ? extends CtCacheType> urlMeta, @NotNull Pair<FileStore, InAppAssetsStore> storePair) {
        Companion.saveUrlExpiryToStore(urlMeta, storePair);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepoImpl$Companion;", "", "<init>", "()V", "EXPIRY_OFFSET_MILLIS", "", "urlTriggers", "", "Lcom/clevertap/android/sdk/inapp/images/repo/DownloadTriggerForUrls;", "downloadInProgressUrls", "Ljava/util/HashMap;", "", "Lcom/clevertap/android/sdk/inapp/images/repo/DownloadState;", "fetchAllFilesLock", "saveUrlExpiryToStore", "", "urlMeta", "Lkotlin/Pair;", "Lcom/clevertap/android/sdk/inapp/data/CtCacheType;", "storePair", "Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void saveUrlExpiryToStore(@NotNull Pair<String, ? extends CtCacheType> urlMeta, @NotNull Pair<FileStore, InAppAssetsStore> storePair) {
            Intrinsics.checkNotNullParameter(urlMeta, (String)"urlMeta");
            Intrinsics.checkNotNullParameter(storePair, (String)"storePair");
            String url = (String)urlMeta.getFirst();
            long expiry = System.currentTimeMillis() + EXPIRY_OFFSET_MILLIS;
            FileStore fileStore = (FileStore)storePair.getFirst();
            InAppAssetsStore inAppAssetsStore = (InAppAssetsStore)storePair.getSecond();
            switch (WhenMappings.$EnumSwitchMapping$0[((CtCacheType)((Object)urlMeta.getSecond())).ordinal()]) {
                case 1: 
                case 2: {
                    inAppAssetsStore.saveAssetUrl(url, expiry);
                    fileStore.saveFileUrl(url, expiry);
                    break;
                }
                case 3: {
                    fileStore.saveFileUrl(url, expiry);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CtCacheType.values().length];
                try {
                    nArray[CtCacheType.IMAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CtCacheType.GIF.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CtCacheType.FILES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CtCacheType.values().length];
            try {
                nArray[CtCacheType.IMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CtCacheType.GIF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CtCacheType.FILES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

