/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.location.Location;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapMetaData;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CoreMetaData
extends CleverTapMetaData {
    private static boolean appForeground = false;
    private static WeakReference<Activity> currentActivity;
    private WeakReference<Activity> appInboxActivity;
    private static int activityCount;
    private long appInstallTime = 0L;
    private boolean appLaunchPushed = false;
    private final Object appLaunchPushedLock = new Object();
    private String currentScreenName = null;
    private int currentSessionId = 0;
    private boolean currentUserOptedOut = false;
    private boolean allowSystemEvents = true;
    private boolean firstRequestInSession = false;
    private boolean firstSession = false;
    private int geofenceSDKVersion = 0;
    private boolean installReferrerDataSent = false;
    private boolean isBgPing = false;
    private boolean isLocationForGeofence = false;
    private boolean isProductConfigRequested;
    private int lastSessionLength = 0;
    private Location locationFromUser = null;
    private boolean offline;
    private boolean webInterfaceInitializedExternally;
    private final Object optOutFlagLock = new Object();
    private HashMap<String, Integer> customSdkVersions = new HashMap();
    private long referrerClickTime = 0L;
    private String source = null;
    private String medium = null;
    private String campaign = null;
    private JSONObject wzrkParams = null;
    private boolean relaxNetwork = false;
    private static int initialAppEnteredForegroundTime;

    public static Activity getCurrentActivity() {
        return currentActivity == null ? null : (Activity)currentActivity.get();
    }

    static int getInitialAppEnteredForegroundTime() {
        return initialAppEnteredForegroundTime;
    }

    public static void setCurrentActivity(@Nullable Activity activity) {
        if (activity == null) {
            currentActivity = null;
            return;
        }
        if (!activity.getLocalClassName().contains("InAppNotificationActivity")) {
            currentActivity = new WeakReference<Activity>(activity);
        }
    }

    public static String getCurrentActivityName() {
        Activity current = CoreMetaData.getCurrentActivity();
        return current != null ? current.getLocalClassName() : null;
    }

    public void setAppInboxActivity(@Nullable Activity activity) {
        this.appInboxActivity = new WeakReference<Activity>(activity);
    }

    public Activity getAppInboxActivity() {
        return this.appInboxActivity == null ? null : (Activity)this.appInboxActivity.get();
    }

    public static boolean isAppForeground() {
        return appForeground;
    }

    public static void setAppForeground(boolean isForeground) {
        appForeground = isForeground;
    }

    static void setInitialAppEnteredForegroundTime(int initialAppEnteredForegroundTime) {
        CoreMetaData.initialAppEnteredForegroundTime = initialAppEnteredForegroundTime;
    }

    public long getAppInstallTime() {
        return this.appInstallTime;
    }

    public void setAppInstallTime(long appInstallTime) {
        this.appInstallTime = appInstallTime;
    }

    public Location getLocationFromUser() {
        return this.locationFromUser;
    }

    public void setLocationFromUser(Location locationFromUser) {
        this.locationFromUser = locationFromUser;
    }

    public boolean isProductConfigRequested() {
        return this.isProductConfigRequested;
    }

    public void setProductConfigRequested(boolean productConfigRequested) {
        this.isProductConfigRequested = productConfigRequested;
    }

    public void setCurrentScreenName(String currentScreenName) {
        this.currentScreenName = currentScreenName;
    }

    synchronized void clearCampaign() {
        this.campaign = null;
    }

    synchronized void clearMedium() {
        this.medium = null;
    }

    synchronized void clearSource() {
        this.source = null;
    }

    synchronized void clearWzrkParams() {
        this.wzrkParams = null;
    }

    public static int getActivityCount() {
        return activityCount;
    }

    synchronized void setCampaign(String campaign) {
        if (this.campaign == null) {
            this.campaign = campaign;
        }
    }

    public synchronized String getCampaign() {
        return this.campaign;
    }

    public int getCurrentSessionId() {
        return this.currentSessionId;
    }

    public int getGeofenceSDKVersion() {
        return this.geofenceSDKVersion;
    }

    public void setGeofenceSDKVersion(int geofenceSDKVersion) {
        this.geofenceSDKVersion = geofenceSDKVersion;
    }

    public int getCustomSdkVersion(String customSdkName) {
        Integer version = this.customSdkVersions.get(customSdkName);
        return version != null ? version : 0;
    }

    public void setCustomSdkVersion(String customSdkName, int customSdkVersion) {
        this.customSdkVersions.put(customSdkName, customSdkVersion);
    }

    public HashMap<String, Integer> getAllCustomSdkVersions() {
        return this.customSdkVersions;
    }

    void setLastSessionLength(int lastSessionLength) {
        this.lastSessionLength = lastSessionLength;
    }

    public int getLastSessionLength() {
        return this.lastSessionLength;
    }

    synchronized void setMedium(String medium) {
        if (this.medium == null) {
            this.medium = medium;
        }
    }

    public synchronized String getMedium() {
        return this.medium;
    }

    void setReferrerClickTime(long referrerClickTime) {
        this.referrerClickTime = referrerClickTime;
    }

    public long getReferrerClickTime() {
        return this.referrerClickTime;
    }

    public synchronized String getSource() {
        return this.source;
    }

    synchronized void setSource(String source) {
        if (this.source == null) {
            this.source = source;
        }
    }

    public String getScreenName() {
        return this.currentScreenName;
    }

    public synchronized void setWzrkParams(JSONObject wzrkParams) {
        if (this.wzrkParams == null) {
            this.wzrkParams = wzrkParams;
        }
    }

    public synchronized JSONObject getWzrkParams() {
        return this.wzrkParams;
    }

    public boolean inCurrentSession() {
        return this.currentSessionId > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppLaunchPushed(boolean pushed) {
        Object object = this.appLaunchPushedLock;
        synchronized (object) {
            this.appLaunchPushed = pushed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppLaunchPushed() {
        Object object = this.appLaunchPushedLock;
        synchronized (object) {
            return this.appLaunchPushed;
        }
    }

    public boolean isBgPing() {
        return this.isBgPing;
    }

    public void setBgPing(boolean bgPing) {
        this.isBgPing = bgPing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUserOptedOut(boolean enable) {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            this.currentUserOptedOut = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentUserOptedOut() {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            return this.currentUserOptedOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledSystemEvents(boolean enable) {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            this.allowSystemEvents = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEnabledSystemEvents() {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            return this.allowSystemEvents;
        }
    }

    public boolean isFirstRequestInSession() {
        return this.firstRequestInSession;
    }

    public void setFirstRequestInSession(boolean firstRequestInSession) {
        this.firstRequestInSession = firstRequestInSession;
    }

    void setFirstSession(boolean firstSession) {
        this.firstSession = firstSession;
    }

    public boolean isFirstSession() {
        return this.firstSession;
    }

    void setInstallReferrerDataSent(boolean installReferrerDataSent) {
        this.installReferrerDataSent = installReferrerDataSent;
    }

    public boolean isInstallReferrerDataSent() {
        return this.installReferrerDataSent;
    }

    public boolean isLocationForGeofence() {
        return this.isLocationForGeofence;
    }

    public void setLocationForGeofence(boolean locationForGeofence) {
        this.isLocationForGeofence = locationForGeofence;
    }

    void setOffline(boolean value) {
        this.offline = value;
    }

    void setCurrentSessionId(int sessionId) {
        this.currentSessionId = sessionId;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setWebInterfaceInitializedExternally(boolean isInitialized) {
        this.webInterfaceInitializedExternally = isInitialized;
    }

    public boolean isWebInterfaceInitializedExternally() {
        return this.webInterfaceInitializedExternally;
    }

    public static void setActivityCount(int count) {
        activityCount = count;
    }

    static void incrementActivityCount() {
        ++activityCount;
    }

    public boolean isRelaxNetwork() {
        return this.relaxNetwork;
    }

    public void setRelaxNetwork(boolean relaxNetwork) {
        this.relaxNetwork = relaxNetwork;
    }

    static {
        activityCount = 0;
        initialAppEnteredForegroundTime = 0;
    }
}

