/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppNotificationMedia;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateInAppData;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInAppNotification
implements Parcelable {
    public static final double HTML_DEFAULT_ASPECT_RATIO = -1.0;
    public static final Parcelable.Creator<CTInAppNotification> CREATOR = new Parcelable.Creator<CTInAppNotification>(){

        public CTInAppNotification createFromParcel(Parcel in) {
            return new CTInAppNotification(in);
        }

        public CTInAppNotification[] newArray(int size) {
            return new CTInAppNotification[size];
        }
    };
    private JSONObject actionExtras;
    private String backgroundColor;
    private int buttonCount;
    private ArrayList<CTInAppNotificationButton> buttons = new ArrayList();
    private String campaignId;
    private JSONObject customExtras;
    private String customInAppUrl;
    private boolean darkenScreen;
    private String error;
    private boolean excludeFromCaps;
    private int height;
    private int heightPercentage;
    private double aspectRatio = -1.0;
    private boolean hideCloseButton;
    private String html;
    private String id;
    private CTInAppType inAppType;
    private boolean isLandscape;
    private boolean isPortrait;
    private boolean isTablet;
    private boolean jsEnabled;
    private JSONObject jsonDescription;
    private String landscapeImageUrl;
    private int maxPerSession;
    private ArrayList<CTInAppNotificationMedia> mediaList = new ArrayList();
    private String message;
    private String messageColor;
    private char position;
    private boolean showClose;
    private long timeToLive;
    private String title;
    private String titleColor;
    private int totalDailyCount;
    private int totalLifetimeCount;
    private String type;
    private boolean videoSupported;
    private int width;
    private int widthPercentage;
    private boolean isLocalInApp = false;
    private boolean fallBackToNotificationSettings = false;
    private boolean isRequestForPushPermission = false;
    private CustomTemplateInAppData customTemplateData;

    CTInAppNotification() {
    }

    private CTInAppNotification(Parcel in) {
        try {
            this.id = in.readString();
            this.campaignId = in.readString();
            this.inAppType = (CTInAppType)((Object)in.readValue(CTInAppType.class.getClassLoader()));
            this.html = in.readString();
            this.excludeFromCaps = in.readByte() != 0;
            this.showClose = in.readByte() != 0;
            this.darkenScreen = in.readByte() != 0;
            this.maxPerSession = in.readInt();
            this.totalLifetimeCount = in.readInt();
            this.totalDailyCount = in.readInt();
            this.position = ((Character)in.readValue(Character.TYPE.getClassLoader())).charValue();
            this.height = in.readInt();
            this.heightPercentage = in.readInt();
            this.width = in.readInt();
            this.widthPercentage = in.readInt();
            this.jsonDescription = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.error = in.readString();
            this.customExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.actionExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.type = in.readString();
            this.title = in.readString();
            this.titleColor = in.readString();
            this.backgroundColor = in.readString();
            this.message = in.readString();
            this.messageColor = in.readString();
            try {
                this.buttons = in.createTypedArrayList(CTInAppNotificationButton.CREATOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.mediaList = in.createTypedArrayList(CTInAppNotificationMedia.CREATOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.hideCloseButton = in.readByte() != 0;
            this.buttonCount = in.readInt();
            this.isTablet = in.readByte() != 0;
            this.customInAppUrl = in.readString();
            this.jsEnabled = in.readByte() != 0;
            this.isPortrait = in.readByte() != 0;
            this.isLandscape = in.readByte() != 0;
            this.isLocalInApp = in.readByte() != 0;
            this.fallBackToNotificationSettings = in.readByte() != 0;
            this.landscapeImageUrl = in.readString();
            this.timeToLive = in.readLong();
            this.customTemplateData = (CustomTemplateInAppData)in.readParcelable(CustomTemplateInAppData.class.getClassLoader());
            this.aspectRatio = in.readDouble();
            this.isRequestForPushPermission = in.readByte() != 0;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public int describeContents() {
        return 0;
    }

    public JSONObject getActionExtras() {
        return this.actionExtras;
    }

    public String getId() {
        return this.id;
    }

    public CTInAppType getInAppType() {
        return this.inAppType;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isExcludeFromCaps() {
        return this.excludeFromCaps;
    }

    public CustomTemplateInAppData getCustomTemplateData() {
        return this.customTemplateData;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.campaignId);
        dest.writeValue((Object)this.inAppType);
        dest.writeString(this.html);
        dest.writeByte((byte)(this.excludeFromCaps ? 1 : 0));
        dest.writeByte((byte)(this.showClose ? 1 : 0));
        dest.writeByte((byte)(this.darkenScreen ? 1 : 0));
        dest.writeInt(this.maxPerSession);
        dest.writeInt(this.totalLifetimeCount);
        dest.writeInt(this.totalDailyCount);
        dest.writeValue((Object)Character.valueOf(this.position));
        dest.writeInt(this.height);
        dest.writeInt(this.heightPercentage);
        dest.writeInt(this.width);
        dest.writeInt(this.widthPercentage);
        if (this.jsonDescription == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.jsonDescription.toString());
        }
        dest.writeString(this.error);
        if (this.customExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.customExtras.toString());
        }
        if (this.actionExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.actionExtras.toString());
        }
        dest.writeString(this.type);
        dest.writeString(this.title);
        dest.writeString(this.titleColor);
        dest.writeString(this.backgroundColor);
        dest.writeString(this.message);
        dest.writeString(this.messageColor);
        dest.writeTypedList(this.buttons);
        dest.writeTypedList(this.mediaList);
        dest.writeByte((byte)(this.hideCloseButton ? 1 : 0));
        dest.writeInt(this.buttonCount);
        dest.writeByte((byte)(this.isTablet ? 1 : 0));
        dest.writeString(this.customInAppUrl);
        dest.writeByte((byte)(this.jsEnabled ? 1 : 0));
        dest.writeByte((byte)(this.isPortrait ? 1 : 0));
        dest.writeByte((byte)(this.isLandscape ? 1 : 0));
        dest.writeByte((byte)(this.isLocalInApp ? 1 : 0));
        dest.writeByte((byte)(this.fallBackToNotificationSettings ? 1 : 0));
        dest.writeString(this.landscapeImageUrl);
        dest.writeLong(this.timeToLive);
        dest.writeParcelable((Parcelable)this.customTemplateData, flags);
        dest.writeDouble(this.aspectRatio);
        dest.writeByte((byte)(this.isRequestForPushPermission ? 1 : 0));
    }

    String getBackgroundColor() {
        return this.backgroundColor;
    }

    int getButtonCount() {
        return this.buttonCount;
    }

    public ArrayList<CTInAppNotificationButton> getButtons() {
        return this.buttons;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    JSONObject getCustomExtras() {
        return this.customExtras;
    }

    String getCustomInAppUrl() {
        return this.customInAppUrl;
    }

    String getError() {
        return this.error;
    }

    void setError(String error) {
        this.error = error;
    }

    public boolean isLocalInApp() {
        return this.isLocalInApp;
    }

    public boolean fallBackToNotificationSettings() {
        return this.fallBackToNotificationSettings;
    }

    int getHeight() {
        return this.height;
    }

    int getHeightPercentage() {
        return this.heightPercentage;
    }

    double getAspectRatio() {
        return this.aspectRatio;
    }

    String getHtml() {
        return this.html;
    }

    CTInAppNotificationMedia getInAppMediaForOrientation(int orientation) {
        CTInAppNotificationMedia returningMedia = null;
        for (CTInAppNotificationMedia inAppNotificationMedia : this.mediaList) {
            if (orientation != inAppNotificationMedia.getOrientation()) continue;
            returningMedia = inAppNotificationMedia;
            break;
        }
        return returningMedia;
    }

    public JSONObject getJsonDescription() {
        return this.jsonDescription;
    }

    public int getMaxPerSession() {
        return this.maxPerSession;
    }

    ArrayList<CTInAppNotificationMedia> getMediaList() {
        return this.mediaList;
    }

    public String getMessage() {
        return this.message;
    }

    String getMessageColor() {
        return this.messageColor;
    }

    char getPosition() {
        return this.position;
    }

    public String getTitle() {
        return this.title;
    }

    String getTitleColor() {
        return this.titleColor;
    }

    public int getTotalDailyCount() {
        return this.totalDailyCount;
    }

    public int getTotalLifetimeCount() {
        return this.totalLifetimeCount;
    }

    String getType() {
        return this.type;
    }

    int getWidth() {
        return this.width;
    }

    int getWidthPercentage() {
        return this.widthPercentage;
    }

    CTInAppNotification initWithJSON(JSONObject jsonObject, boolean videoSupported) {
        this.videoSupported = videoSupported;
        this.jsonDescription = jsonObject;
        try {
            String string2 = this.type = jsonObject.has("type") ? jsonObject.getString("type") : null;
            if (this.type == null || this.type.equals("custom-html")) {
                this.legacyConfigureWithJson(jsonObject);
            } else {
                this.configureWithJson(jsonObject);
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON : " + e.getLocalizedMessage();
        }
        return this;
    }

    CTInAppNotification createNotificationForAction(CustomTemplateInAppData actionData) {
        try {
            JSONObject notificationJson = new JSONObject();
            notificationJson.put("ti", (Object)this.id);
            notificationJson.put("wzrk_id", (Object)this.campaignId);
            notificationJson.put("type", (Object)InAppActionType.CUSTOM_CODE.toString());
            notificationJson.put("efc", 1);
            notificationJson.put("excludeGlobalFCaps", 1);
            notificationJson.put("wzrk_ttl", this.timeToLive);
            if (this.jsonDescription.has("wzrk_pivot")) {
                notificationJson.put("wzrk_pivot", (Object)this.jsonDescription.optString("wzrk_pivot"));
            }
            if (this.jsonDescription.has("wzrk_cgId")) {
                notificationJson.put("wzrk_cgId", (Object)this.jsonDescription.optString("wzrk_cgId"));
            }
            CTInAppNotification notification = new CTInAppNotification().initWithJSON(notificationJson, this.videoSupported);
            notification.setCustomTemplateData(actionData);
            return notification;
        }
        catch (JSONException jsonException) {
            return null;
        }
    }

    void setCustomTemplateData(CustomTemplateInAppData inAppData) {
        this.customTemplateData = inAppData;
        this.customTemplateData.writeFieldsToJson(this.jsonDescription);
    }

    boolean isDarkenScreen() {
        return this.darkenScreen;
    }

    boolean isHideCloseButton() {
        return this.hideCloseButton;
    }

    boolean isJsEnabled() {
        return this.jsEnabled;
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }

    public boolean isPortrait() {
        return this.isPortrait;
    }

    boolean isShowClose() {
        return this.showClose;
    }

    boolean isTablet() {
        return this.isTablet;
    }

    boolean isVideoSupported() {
        return this.videoSupported;
    }

    public boolean hasStreamMedia() {
        return !this.getMediaList().isEmpty() && this.getMediaList().get(0).isMediaStreamable();
    }

    public boolean isRequestForPushPermission() {
        return this.isRequestForPushPermission;
    }

    private void configureWithJson(JSONObject jsonObject) {
        try {
            JSONArray buttonArray;
            CTInAppNotificationMedia landscapeMedia;
            JSONObject mediaLandscape;
            CTInAppNotificationMedia portraitMedia;
            JSONObject msgObject;
            this.id = jsonObject.optString("ti", "");
            this.campaignId = jsonObject.optString("wzrk_id", "");
            this.type = jsonObject.getString("type");
            this.isLocalInApp = jsonObject.optBoolean("isLocalInApp", false);
            this.fallBackToNotificationSettings = jsonObject.optBoolean("fallbackToNotificationSettings", false);
            this.excludeFromCaps = jsonObject.optInt("efc", -1) == 1 || jsonObject.optInt("excludeGlobalFCaps", -1) == 1;
            this.totalLifetimeCount = jsonObject.optInt("tlc", -1);
            this.totalDailyCount = jsonObject.optInt("tdc", -1);
            this.maxPerSession = jsonObject.optInt("mdc", -1);
            this.inAppType = CTInAppType.fromString(this.type);
            this.isTablet = jsonObject.optBoolean("tablet", false);
            this.backgroundColor = jsonObject.optString("bg", "#FFFFFF");
            this.isPortrait = !jsonObject.has("hasPortrait") || jsonObject.getBoolean("hasPortrait");
            this.isLandscape = jsonObject.optBoolean("hasLandscape", false);
            this.timeToLive = jsonObject.optLong("wzrk_ttl", CTInAppNotification.defaultTtl());
            JSONObject titleObject = jsonObject.optJSONObject("title");
            if (titleObject != null) {
                this.title = titleObject.optString("text", "");
                this.titleColor = titleObject.optString("color", "#000000");
            }
            if ((msgObject = jsonObject.optJSONObject("message")) != null) {
                this.message = msgObject.optString("text", "");
                this.messageColor = msgObject.optString("color", "#000000");
            }
            this.hideCloseButton = jsonObject.optBoolean("close", false);
            JSONObject media = jsonObject.optJSONObject("media");
            if (media != null && (portraitMedia = new CTInAppNotificationMedia().initWithJSON(media, 1)) != null) {
                this.mediaList.add(portraitMedia);
            }
            if ((mediaLandscape = jsonObject.optJSONObject("mediaLandscape")) != null && (landscapeMedia = new CTInAppNotificationMedia().initWithJSON(mediaLandscape, 2)) != null) {
                this.mediaList.add(landscapeMedia);
            }
            if ((buttonArray = jsonObject.optJSONArray("buttons")) != null) {
                for (int i = 0; i < buttonArray.length(); ++i) {
                    JSONObject buttonJson = buttonArray.getJSONObject(i);
                    CTInAppNotificationButton inAppNotificationButton = new CTInAppNotificationButton().initWithJSON(buttonJson);
                    if (inAppNotificationButton.getError() != null) continue;
                    this.buttons.add(inAppNotificationButton);
                    ++this.buttonCount;
                }
            }
            this.isRequestForPushPermission = jsonObject.optBoolean("rfp", false);
            this.customTemplateData = CustomTemplateInAppData.createFromJson(jsonObject);
            block1 : switch (this.inAppType) {
                case CTInAppTypeFooter: 
                case CTInAppTypeHeader: 
                case CTInAppTypeCover: 
                case CTInAppTypeHalfInterstitial: {
                    for (CTInAppNotificationMedia inAppMedia : this.mediaList) {
                        if (!inAppMedia.isGIF() && !inAppMedia.isAudio() && !inAppMedia.isVideo()) continue;
                        inAppMedia.setMediaUrl(null);
                        Logger.d("Unable to download to media. Wrong media type for template");
                    }
                    break;
                }
                case CTInAppTypeCoverImageOnly: 
                case CTInAppTypeHalfInterstitialImageOnly: 
                case CTInAppTypeInterstitialImageOnly: {
                    if (!this.mediaList.isEmpty()) {
                        for (CTInAppNotificationMedia inAppMedia : this.mediaList) {
                            if (!inAppMedia.isGIF() && !inAppMedia.isAudio() && !inAppMedia.isVideo() && inAppMedia.isImage()) continue;
                            this.error = "Wrong media type for template";
                            break block1;
                        }
                        break;
                    }
                    this.error = "No media type for template";
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON" + e.getLocalizedMessage();
        }
    }

    private boolean isKeyValid(Bundle b, String key, Class<?> type) {
        return b.containsKey(key) && b.get(key).getClass().equals(type);
    }

    private void legacyConfigureWithJson(JSONObject jsonObject) {
        Bundle b = CTInAppNotification.getBundleFromJsonObject(jsonObject);
        if (!this.validateNotifBundle(b)) {
            this.error = "Invalid JSON";
            return;
        }
        try {
            this.id = jsonObject.optString("ti", "");
            this.campaignId = jsonObject.optString("wzrk_id", "");
            this.excludeFromCaps = jsonObject.optInt("efc", -1) == 1 || jsonObject.optInt("excludeGlobalFCaps", -1) == 1;
            this.totalLifetimeCount = jsonObject.optInt("tlc", -1);
            this.totalDailyCount = jsonObject.optInt("tdc", -1);
            this.jsEnabled = jsonObject.optBoolean("isJsEnabled", false);
            this.timeToLive = jsonObject.optLong("wzrk_ttl", CTInAppNotification.defaultTtl());
            this.isRequestForPushPermission = jsonObject.optBoolean("rfp", false);
            JSONObject data = jsonObject.optJSONObject("d");
            if (data != null) {
                this.html = data.getString("html");
                this.customInAppUrl = data.optString("url", "");
                this.customExtras = data.optJSONObject("kv") != null ? data.getJSONObject("kv") : new JSONObject();
                JSONObject displayParams = jsonObject.optJSONObject("w");
                if (displayParams != null) {
                    this.darkenScreen = displayParams.getBoolean("dk");
                    this.showClose = displayParams.getBoolean("sc");
                    this.position = displayParams.getString("pos").charAt(0);
                    this.width = displayParams.optInt("xdp", 0);
                    this.widthPercentage = displayParams.optInt("xp", 0);
                    this.height = displayParams.optInt("ydp", 0);
                    this.heightPercentage = displayParams.optInt("yp", 0);
                    this.maxPerSession = displayParams.optInt("mdc", -1);
                    this.aspectRatio = displayParams.optDouble("aspectRatio", -1.0);
                    if (this.aspectRatio <= 0.0) {
                        this.aspectRatio = -1.0;
                    }
                }
                if (this.html != null) {
                    switch (this.position) {
                        case 't': {
                            if (this.aspectRatio == -1.0 && (this.widthPercentage != 100 || this.heightPercentage > 30)) break;
                            this.inAppType = CTInAppType.CTInAppTypeHeaderHTML;
                            break;
                        }
                        case 'b': {
                            if (this.aspectRatio == -1.0 && (this.widthPercentage != 100 || this.heightPercentage > 30)) break;
                            this.inAppType = CTInAppType.CTInAppTypeFooterHTML;
                            break;
                        }
                        case 'c': {
                            if (this.widthPercentage == 90 && this.heightPercentage == 85) {
                                this.inAppType = CTInAppType.CTInAppTypeInterstitialHTML;
                                break;
                            }
                            if (this.widthPercentage == 100 && this.heightPercentage == 100) {
                                this.inAppType = CTInAppType.CTInAppTypeCoverHTML;
                                break;
                            }
                            if (this.widthPercentage != 90 || this.heightPercentage != 50) break;
                            this.inAppType = CTInAppType.CTInAppTypeHalfInterstitialHTML;
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON";
        }
    }

    static long defaultTtl() {
        return (System.currentTimeMillis() + 172800000L) / 1000L;
    }

    private boolean validateNotifBundle(Bundle notif) {
        try {
            Bundle w = notif.getBundle("w");
            Bundle d = notif.getBundle("d");
            if (w == null || d == null) {
                return false;
            }
            if (!this.isKeyValid(w, "xdp", Integer.class) && !this.isKeyValid(w, "xp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "ydp", Integer.class) && !this.isKeyValid(w, "yp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "dk", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "sc", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(d, "html", String.class)) {
                return false;
            }
            if (this.isKeyValid(w, "pos", String.class)) {
                char pos = w.getString("pos").charAt(0);
                switch (pos) {
                    case 't': {
                        break;
                    }
                    case 'r': {
                        break;
                    }
                    case 'b': {
                        break;
                    }
                    case 'l': {
                        break;
                    }
                    case 'c': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            Logger.v("Failed to parse in-app notification!", t);
            return false;
        }
    }

    private static Bundle getBundleFromJsonObject(JSONObject notif) {
        Bundle b = new Bundle();
        Iterator iterator = notif.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value = notif.get(key);
                if (value instanceof String) {
                    b.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Character) {
                    b.putChar(key, ((Character)value).charValue());
                    continue;
                }
                if (value instanceof Integer) {
                    b.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Float) {
                    b.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    b.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Long) {
                    b.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    b.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                b.putBundle(key, CTInAppNotification.getBundleFromJsonObject((JSONObject)value));
            }
            catch (JSONException e) {
                Logger.v("Key had unknown object. Discarding");
            }
        }
        return b;
    }
}

