/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.CTWebInterface;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.inapp.CTInAppWebView;
import com.clevertap.android.sdk.inapp.InAppWebViewClient;

public abstract class CTInAppBaseFullHtmlFragment
extends CTInAppBaseFullFragment {
    protected CTInAppWebView webView;

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return this.displayHTMLView(inflater, container);
    }

    public void onDestroyView() {
        this.cleanupWebView();
        super.onDestroyView();
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reDrawInApp();
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.reDrawInApp();
    }

    protected RelativeLayout.LayoutParams getLayoutParamsForCloseButton() {
        RelativeLayout.LayoutParams closeIvLp = new RelativeLayout.LayoutParams(-1, -1);
        closeIvLp.addRule(2, this.webView.getId());
        closeIvLp.addRule(1, this.webView.getId());
        int sub = this.getScaledPixels(40) / 2;
        closeIvLp.setMargins(-sub, 0, 0, -sub);
        return closeIvLp;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private View displayHTMLView(LayoutInflater inflater, ViewGroup container) {
        View inAppView;
        try {
            inAppView = inflater.inflate(R.layout.inapp_html_full, container, false);
            RelativeLayout rl = (RelativeLayout)inAppView.findViewById(R.id.inapp_html_full_relative_layout);
            RelativeLayout.LayoutParams webViewLp = new RelativeLayout.LayoutParams(-1, -1);
            webViewLp.addRule(13);
            this.initWebViewLayoutParams(webViewLp);
            this.webView = new CTInAppWebView(this.context, this.inAppNotification.getWidth(), this.inAppNotification.getHeight(), this.inAppNotification.getWidthPercentage(), this.inAppNotification.getHeightPercentage());
            InAppWebViewClient webViewClient = new InAppWebViewClient(this);
            this.webView.setWebViewClient(webViewClient);
            if (this.inAppNotification.isJsEnabled()) {
                CleverTapAPI instance = CleverTapAPI.instanceWithConfig((Context)this.getActivity(), this.config);
                CTWebInterface ctWebInterface = new CTWebInterface(instance, this);
                this.webView.setJavaScriptInterface(ctWebInterface);
            }
            if (this.isDarkenEnabled()) {
                rl.setBackground((Drawable)new ColorDrawable(-1157627904));
            } else {
                rl.setBackground((Drawable)new ColorDrawable(0));
            }
            rl.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLp);
            if (this.isCloseButtonEnabled()) {
                this.closeImageView = new CloseImageView(this.context);
                RelativeLayout.LayoutParams closeIvLp = this.getLayoutParamsForCloseButton();
                this.closeImageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CTInAppBaseFullHtmlFragment.this.didDismiss(null);
                    }
                });
                this.closeImageView.setContentDescription(this.context.getString(R.string.ct_inapp_close_btn));
                rl.addView((View)this.closeImageView, (ViewGroup.LayoutParams)closeIvLp);
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Fragment view not created", t);
            return null;
        }
        return inAppView;
    }

    private void initWebViewLayoutParams(RelativeLayout.LayoutParams params) {
        char pos = this.inAppNotification.getPosition();
        switch (pos) {
            case 't': {
                params.addRule(10);
                break;
            }
            case 'l': {
                params.addRule(9);
                break;
            }
            case 'b': {
                params.addRule(12);
                break;
            }
            case 'r': {
                params.addRule(11);
                break;
            }
            case 'c': {
                params.addRule(13);
            }
        }
        params.setMargins(0, 0, 0, 0);
    }

    private boolean isCloseButtonEnabled() {
        return this.inAppNotification.isShowClose();
    }

    private boolean isDarkenEnabled() {
        return this.inAppNotification.isDarkenScreen();
    }

    private void reDrawInApp() {
        this.webView.updateDimension();
        if (this.inAppNotification.getCustomInAppUrl().isEmpty()) {
            int mHeight = this.webView.dim.y;
            int mWidth = this.webView.dim.x;
            float d = this.getResources().getDisplayMetrics().density;
            mHeight = (int)((float)mHeight / d);
            mWidth = (int)((float)mWidth / d);
            String html = this.inAppNotification.getHtml();
            String style2 = "<style>body{width:" + mWidth + "px; height: " + mHeight + "px; margin: 0; padding:0;}</style>";
            html = html.replaceFirst("<head>", "<head>" + style2);
            Logger.v("Density appears to be " + d);
            this.webView.setInitialScale((int)(d * 100.0f));
            this.webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
        } else {
            String url = this.inAppNotification.getCustomInAppUrl();
            this.webView.setWebViewClient(new WebViewClient());
            this.webView.loadUrl(url);
        }
    }

    private void cleanupWebView() {
        try {
            if (this.webView != null) {
                this.webView.cleanup(this.inAppNotification.isJsEnabled());
                this.webView = null;
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose("cleanupWebView -> there was some crash in cleanup", e);
        }
    }
}

