/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.clevertap.android.sdk.CTPreferenceCache;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.PushPermissionResponseListener;
import com.clevertap.android.sdk.Utils;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0000\u0018\u0000 )2\u00020\u0001:\u0004'()*BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/clevertap/android/sdk/PushPermissionHandler;", "", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "ctListeners", "", "Lcom/clevertap/android/sdk/PushPermissionResponseListener;", "callback", "Lcom/clevertap/android/sdk/PushPermissionHandler$PushPermissionResultCallback;", "cacheProvider", "Lkotlin/Function1;", "Landroid/content/Context;", "Lcom/clevertap/android/sdk/CTPreferenceCache;", "systemPermissionInterface", "Lcom/clevertap/android/sdk/PushPermissionHandler$SystemPushPermissionInterface;", "<init>", "(Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Ljava/util/List;Lcom/clevertap/android/sdk/PushPermissionHandler$PushPermissionResultCallback;Lkotlin/jvm/functions/Function1;Lcom/clevertap/android/sdk/PushPermissionHandler$SystemPushPermissionInterface;)V", "pushPermissionCallback", "Ljava/lang/ref/WeakReference;", "isFromNotificationSettingsActivity", "", "isPushPermissionGranted", "context", "notifyPushPermissionListeners", "", "requestPermission", "activity", "Landroid/app/Activity;", "fallbackToSettings", "requestCallback", "Lcom/clevertap/android/sdk/PushPermissionHandler$PushPermissionRequestCallback;", "onActivityResume", "onRequestPermissionsResult", "requestCode", "", "grantResults", "", "notifyListeners", "isPermissionGranted", "PushPermissionResultCallback", "PushPermissionRequestCallback", "Companion", "SystemPushPermissionInterface", "clevertap-core_release"})
public final class PushPermissionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CleverTapInstanceConfig config;
    @Nullable
    private final List<PushPermissionResponseListener> ctListeners;
    @NotNull
    private final Function1<Context, CTPreferenceCache> cacheProvider;
    @NotNull
    private final SystemPushPermissionInterface systemPermissionInterface;
    @NotNull
    private final WeakReference<PushPermissionResultCallback> pushPermissionCallback;
    private boolean isFromNotificationSettingsActivity;
    @NotNull
    public static final String ANDROID_PERMISSION_STRING = "android.permission.POST_NOTIFICATIONS";

    @JvmOverloads
    public PushPermissionHandler(@NotNull CleverTapInstanceConfig config, @Nullable List<? extends PushPermissionResponseListener> ctListeners, @Nullable PushPermissionResultCallback callback, @NotNull Function1<? super Context, CTPreferenceCache> cacheProvider, @NotNull SystemPushPermissionInterface systemPermissionInterface) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(cacheProvider, (String)"cacheProvider");
        Intrinsics.checkNotNullParameter((Object)systemPermissionInterface, (String)"systemPermissionInterface");
        this.config = config;
        this.ctListeners = ctListeners;
        this.cacheProvider = cacheProvider;
        this.systemPermissionInterface = systemPermissionInterface;
        this.pushPermissionCallback = new WeakReference<PushPermissionResultCallback>(callback);
    }

    public /* synthetic */ PushPermissionHandler(CleverTapInstanceConfig cleverTapInstanceConfig, List list, PushPermissionResultCallback pushPermissionResultCallback, Function1 function1, SystemPushPermissionInterface systemPushPermissionInterface, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pushPermissionResultCallback = null;
        }
        if ((n & 8) != 0) {
            function1 = PushPermissionHandler.Companion.defaultCacheProvider(cleverTapInstanceConfig);
        }
        if ((n & 0x10) != 0) {
            systemPushPermissionInterface = PushPermissionHandler.Companion.defaultSystemInterface();
        }
        this(cleverTapInstanceConfig, list, pushPermissionResultCallback, (Function1<? super Context, CTPreferenceCache>)function1, systemPushPermissionInterface);
    }

    public final boolean isPushPermissionGranted(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.systemPermissionInterface.isPushPermissionGranted(context);
    }

    public final void notifyPushPermissionListeners(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.notifyListeners(this.isPushPermissionGranted(context));
    }

    public final boolean requestPermission(@NotNull Activity activity, boolean fallbackToSettings, @NotNull PushPermissionRequestCallback requestCallback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)requestCallback, (String)"requestCallback");
        if (this.isPushPermissionGranted((Context)activity)) {
            this.notifyListeners(true);
            return false;
        }
        boolean isFirstTimeRequest = ((CTPreferenceCache)this.cacheProvider.invoke((Object)activity)).isFirstTimeRequest();
        boolean showRationale = this.systemPermissionInterface.shouldShowRequestPermissionRationale(activity);
        if (isFirstTimeRequest || showRationale) {
            requestCallback.onRequestPermission();
            return true;
        }
        if (fallbackToSettings) {
            this.isFromNotificationSettingsActivity = true;
            this.systemPermissionInterface.navigateToNotificationSettings(activity);
            return true;
        }
        this.notifyListeners(false);
        return false;
    }

    public final void requestPermission(@NotNull Activity activity, boolean fallbackToSettings) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.requestPermission(activity, fallbackToSettings, new PushPermissionRequestCallback(this, activity){
            final /* synthetic */ PushPermissionHandler this$0;
            final /* synthetic */ Activity $activity;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
            }

            public void onRequestPermission() {
                PushPermissionHandler.access$getSystemPermissionInterface$p(this.this$0).requestPushPermission(this.$activity);
            }
        });
    }

    public final void onActivityResume(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.isFromNotificationSettingsActivity) {
            this.isFromNotificationSettingsActivity = false;
            if (Build.VERSION.SDK_INT >= 33) {
                this.notifyListeners(this.isPushPermissionGranted((Context)activity));
            }
        }
    }

    public final void onRequestPermissionsResult(@NotNull Activity activity, int requestCode, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        CTPreferenceCache ctCache = (CTPreferenceCache)this.cacheProvider.invoke((Object)activity);
        ctCache.setFirstTimeRequest(false);
        ctCache.updateCacheToDisk((Context)activity, this.config);
        if (requestCode == 102) {
            Integer n = ArraysKt.firstOrNull((int[])grantResults);
            boolean isGranted = n != null && 0 == n;
            this.notifyListeners(isGranted);
        }
    }

    private final void notifyListeners(boolean isPermissionGranted) {
        PushPermissionResultCallback pushPermissionResultCallback = (PushPermissionResultCallback)this.pushPermissionCallback.get();
        if (pushPermissionResultCallback != null) {
            pushPermissionResultCallback.onPushPermissionResult(isPermissionGranted);
        }
        if (this.ctListeners != null) {
            Iterator<PushPermissionResponseListener> iterator = this.ctListeners.iterator();
            while (iterator.hasNext()) {
                PushPermissionResponseListener listener;
                PushPermissionResponseListener pushPermissionResponseListener = listener = iterator.next();
                if (pushPermissionResponseListener != null) {
                    pushPermissionResponseListener.onPushPermissionResponse(isPermissionGranted);
                }
            }
        }
    }

    @JvmOverloads
    public PushPermissionHandler(@NotNull CleverTapInstanceConfig config, @Nullable List<? extends PushPermissionResponseListener> ctListeners, @Nullable PushPermissionResultCallback callback, @NotNull Function1<? super Context, CTPreferenceCache> cacheProvider) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(cacheProvider, (String)"cacheProvider");
        this(config, ctListeners, callback, cacheProvider, null, 16, null);
    }

    @JvmOverloads
    public PushPermissionHandler(@NotNull CleverTapInstanceConfig config, @Nullable List<? extends PushPermissionResponseListener> ctListeners, @Nullable PushPermissionResultCallback callback) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(config, ctListeners, callback, null, null, 24, null);
    }

    @JvmOverloads
    public PushPermissionHandler(@NotNull CleverTapInstanceConfig config, @Nullable List<? extends PushPermissionResponseListener> ctListeners) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(config, ctListeners, null, null, null, 28, null);
    }

    public static final /* synthetic */ SystemPushPermissionInterface access$getSystemPermissionInterface$p(PushPermissionHandler $this) {
        return $this.systemPermissionInterface;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/clevertap/android/sdk/PushPermissionHandler$Companion;", "", "<init>", "()V", "ANDROID_PERMISSION_STRING", "", "defaultCacheProvider", "Lkotlin/Function1;", "Landroid/content/Context;", "Lcom/clevertap/android/sdk/CTPreferenceCache;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "defaultSystemInterface", "Lcom/clevertap/android/sdk/PushPermissionHandler$SystemPushPermissionInterface;", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<Context, CTPreferenceCache> defaultCacheProvider(CleverTapInstanceConfig config) {
            return arg_0 -> Companion.defaultCacheProvider$lambda$0(config, arg_0);
        }

        private final SystemPushPermissionInterface defaultSystemInterface() {
            return new SystemPushPermissionInterface(){

                public boolean isPushPermissionGranted(Context context) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") == 0;
                }

                public void requestPushPermission(Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    String[] stringArray = new String[]{"android.permission.POST_NOTIFICATIONS"};
                    ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)102);
                }

                public void navigateToNotificationSettings(Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Utils.navigateToAndroidSettingsForNotifications((Context)activity);
                }

                public boolean shouldShowRequestPermissionRationale(Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.POST_NOTIFICATIONS");
                }
            };
        }

        private static final CTPreferenceCache defaultCacheProvider$lambda$0(CleverTapInstanceConfig $config, Context context) {
            Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return CTPreferenceCache.Companion.getInstance(context, $config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/clevertap/android/sdk/PushPermissionHandler$PushPermissionRequestCallback;", "", "onRequestPermission", "", "clevertap-core_release"})
    public static interface PushPermissionRequestCallback {
        public void onRequestPermission();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/PushPermissionHandler$PushPermissionResultCallback;", "", "onPushPermissionResult", "", "isGranted", "", "clevertap-core_release"})
    public static interface PushPermissionResultCallback {
        public void onPushPermissionResult(boolean var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/PushPermissionHandler$SystemPushPermissionInterface;", "", "isPushPermissionGranted", "", "context", "Landroid/content/Context;", "requestPushPermission", "", "activity", "Landroid/app/Activity;", "navigateToNotificationSettings", "shouldShowRequestPermissionRationale", "clevertap-core_release"})
    public static interface SystemPushPermissionInterface {
        public boolean isPushPermissionGranted(@NotNull Context var1);

        public void requestPushPermission(@NotNull Activity var1);

        public void navigateToNotificationSettings(@NotNull Activity var1);

        public boolean shouldShowRequestPermissionRationale(@NotNull Activity var1);
    }
}

