/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.os.Bundle;
import android.webkit.JavascriptInterface;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CoreState;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppBaseFragment;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTWebInterface {
    private WeakReference<CleverTapAPI> cleverTapWr = new WeakReference<Object>(null);
    private WeakReference<CTInAppBaseFragment> fragmentWr = new WeakReference<Object>(null);

    public CTWebInterface(CleverTapAPI instance) {
        CoreState coreState;
        this.cleverTapWr = new WeakReference<CleverTapAPI>(instance);
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI != null && (coreState = cleverTapAPI.getCoreState()) != null) {
            coreState.getCoreMetaData().setWebInterfaceInitializedExternally(true);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CTWebInterface(CleverTapAPI instance, CTInAppBaseFragment inAppBaseFragment) {
        this.cleverTapWr = new WeakReference<CleverTapAPI>(instance);
        this.fragmentWr = new WeakReference<CTInAppBaseFragment>(inAppBaseFragment);
    }

    @JavascriptInterface
    public void promptPushPermission(boolean shouldShowFallbackSettings) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            this.dismissInAppNotification();
            cleverTapAPI.promptForPushPermission(shouldShowFallbackSettings);
        }
    }

    @JavascriptInterface
    public void dismissInAppNotification() {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            CTInAppBaseFragment fragment = (CTInAppBaseFragment)((Object)this.fragmentWr.get());
            if (fragment != null) {
                fragment.didDismiss(null);
            }
        }
    }

    @JavascriptInterface
    public void addMultiValueForKey(String key, String value) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            cleverTapAPI.addMultiValueForKey(key, value);
        }
    }

    @JavascriptInterface
    public void incrementValue(String key, double value) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            cleverTapAPI.incrementValue(key, value);
        }
    }

    @JavascriptInterface
    public void decrementValue(String key, double value) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            cleverTapAPI.decrementValue(key, value);
        }
    }

    @JavascriptInterface
    public void addMultiValuesForKey(String key, String values) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (values != null) {
                try {
                    JSONArray valuesArray = new JSONArray(values);
                    cleverTapAPI.addMultiValuesForKey(key, Utils.convertJSONArrayToArrayList(valuesArray));
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse values from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("values passed to CTWebInterface is null");
            }
        }
    }

    @JavascriptInterface
    public void pushChargedEvent(String chargeDetails, String items) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            HashMap<String, Object> chargeDetailsHashMap = new HashMap();
            if (chargeDetails != null) {
                try {
                    JSONObject chargeDetailsObject = new JSONObject(chargeDetails);
                    chargeDetailsHashMap = Utils.convertJSONObjectToHashMap(chargeDetailsObject);
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse chargeDetails for Charged Event from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("chargeDetails passed to CTWebInterface is null");
                return;
            }
            ArrayList<HashMap<String, Object>> itemsArrayList = null;
            if (items != null) {
                try {
                    JSONArray itemsArray = new JSONArray(items);
                    itemsArrayList = Utils.convertJSONArrayOfJSONObjectsToArrayListOfHashMaps(itemsArray);
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse items for Charged Event from WebView " + e.getLocalizedMessage());
                }
            } else {
                return;
            }
            cleverTapAPI.pushChargedEvent(chargeDetailsHashMap, itemsArrayList);
        }
    }

    @JavascriptInterface
    public void pushEvent(String eventName) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            cleverTapAPI.pushEvent(eventName);
        }
    }

    @JavascriptInterface
    public void pushEvent(String eventName, String eventActions) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else if (eventActions != null) {
            try {
                JSONObject eventActionsObject = new JSONObject(eventActions);
                cleverTapAPI.pushEvent(eventName, Utils.convertJSONObjectToHashMap(eventActionsObject));
            }
            catch (JSONException e) {
                Logger.v("Unable to parse eventActions from WebView " + e.getLocalizedMessage());
            }
        } else {
            Logger.v("eventActions passed to CTWebInterface is null");
        }
    }

    @JavascriptInterface
    public void pushProfile(String profile) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else if (profile != null) {
            try {
                JSONObject profileObject = new JSONObject(profile);
                cleverTapAPI.pushProfile(Utils.convertJSONObjectToHashMap(profileObject));
            }
            catch (JSONException e) {
                Logger.v("Unable to parse profile from WebView " + e.getLocalizedMessage());
            }
        } else {
            Logger.v("profile passed to CTWebInterface is null");
        }
    }

    @JavascriptInterface
    public void removeMultiValueForKey(String key, String value) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (value == null) {
                Logger.v("Value passed to CTWebInterface is null");
                return;
            }
            cleverTapAPI.removeMultiValueForKey(key, value);
        }
    }

    @JavascriptInterface
    public void removeMultiValuesForKey(String key, String values) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (values != null) {
                try {
                    JSONArray valuesArray = new JSONArray(values);
                    cleverTapAPI.removeMultiValuesForKey(key, Utils.convertJSONArrayToArrayList(valuesArray));
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse values from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("values passed to CTWebInterface is null");
            }
        }
    }

    @JavascriptInterface
    public void removeValueForKey(String key) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            cleverTapAPI.removeValueForKey(key);
        }
    }

    @JavascriptInterface
    public void setMultiValueForKey(String key, String values) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else {
            if (key == null) {
                Logger.v("Key passed to CTWebInterface is null");
                return;
            }
            if (values != null) {
                try {
                    JSONArray valuesArray = new JSONArray(values);
                    cleverTapAPI.setMultiValuesForKey(key, Utils.convertJSONArrayToArrayList(valuesArray));
                }
                catch (JSONException e) {
                    Logger.v("Unable to parse values from WebView " + e.getLocalizedMessage());
                }
            } else {
                Logger.v("values passed to CTWebInterface is null");
            }
        }
    }

    @JavascriptInterface
    public void onUserLogin(String profile) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CleverTap Instance is null.");
        } else if (profile != null) {
            try {
                JSONObject profileObject = new JSONObject(profile);
                cleverTapAPI.onUserLogin(Utils.convertJSONObjectToHashMap(profileObject));
            }
            catch (JSONException e) {
                Logger.v("Unable to parse profile from WebView " + e.getLocalizedMessage());
            }
        } else {
            Logger.v("profile passed to CTWebInterface is null");
        }
    }

    @JavascriptInterface
    public void triggerInAppAction(String actionJson, String callToAction, String buttonId) {
        CleverTapAPI cleverTapAPI = (CleverTapAPI)this.cleverTapWr.get();
        if (cleverTapAPI == null) {
            Logger.d("CTWebInterface CleverTap Instance is null.");
            return;
        }
        CTInAppBaseFragment fragment = (CTInAppBaseFragment)((Object)this.fragmentWr.get());
        if (fragment == null) {
            Logger.d("CTWebInterface Fragment is null");
            return;
        }
        if (actionJson == null) {
            Logger.d("CTWebInterface action JSON is null");
            return;
        }
        try {
            CTInAppAction action = CTInAppAction.createFromJson(new JSONObject(actionJson));
            if (action == null) {
                Logger.d("CTWebInterface invalid action JSON: " + actionJson);
                return;
            }
            Bundle actionData = new Bundle();
            if (buttonId != null) {
                actionData.putString("button_id", buttonId);
            }
            fragment.triggerAction(action, callToAction, actionData);
        }
        catch (JSONException je) {
            Logger.d("CTWebInterface invalid action JSON: " + actionJson);
        }
    }

    @JavascriptInterface
    public int getSdkVersion() {
        return 70400;
    }
}

