/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.displayunits.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.Logger;
import org.json.JSONObject;

public class CleverTapDisplayUnitContent
implements Parcelable {
    public static final Parcelable.Creator<CleverTapDisplayUnitContent> CREATOR = new Parcelable.Creator<CleverTapDisplayUnitContent>(){

        public CleverTapDisplayUnitContent createFromParcel(Parcel in) {
            return new CleverTapDisplayUnitContent(in);
        }

        public CleverTapDisplayUnitContent[] newArray(int size) {
            return new CleverTapDisplayUnitContent[size];
        }
    };
    private String actionUrl;
    private String contentType;
    private String error;
    private String icon;
    private String media;
    private String message;
    private String messageColor;
    private String posterUrl;
    private String title;
    private String titleColor;

    private CleverTapDisplayUnitContent(String title, String titleColor, String message, String messageColor, String icon, String media, String contentType, String posterUrl, String actionUrl, String error) {
        this.title = title;
        this.titleColor = titleColor;
        this.message = message;
        this.messageColor = messageColor;
        this.icon = icon;
        this.media = media;
        this.contentType = contentType;
        this.posterUrl = posterUrl;
        this.actionUrl = actionUrl;
        this.error = error;
    }

    private CleverTapDisplayUnitContent(Parcel in) {
        this.title = in.readString();
        this.titleColor = in.readString();
        this.message = in.readString();
        this.messageColor = in.readString();
        this.icon = in.readString();
        this.media = in.readString();
        this.contentType = in.readString();
        this.posterUrl = in.readString();
        this.actionUrl = in.readString();
        this.error = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getError() {
        return this.error;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getMedia() {
        return this.media;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageColor() {
        return this.messageColor;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    public boolean mediaIsAudio() {
        return this.contentType != null && this.media != null && this.contentType.startsWith("audio");
    }

    public boolean mediaIsGIF() {
        return this.contentType != null && this.media != null && this.contentType.equals("image/gif");
    }

    public boolean mediaIsImage() {
        return this.contentType != null && this.media != null && this.contentType.startsWith("image") && !this.contentType.equals("image/gif");
    }

    public boolean mediaIsVideo() {
        return this.contentType != null && this.media != null && this.contentType.startsWith("video");
    }

    @NonNull
    public String toString() {
        return "[ title:" + this.title + ", titleColor:" + this.titleColor + " message:" + this.message + ", messageColor:" + this.messageColor + ", media:" + this.media + ", contentType:" + this.contentType + ", posterUrl:" + this.posterUrl + ", actionUrl:" + this.actionUrl + ", icon:" + this.icon + ", error:" + this.error + " ]";
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        dest.writeString(this.titleColor);
        dest.writeString(this.message);
        dest.writeString(this.messageColor);
        dest.writeString(this.icon);
        dest.writeString(this.media);
        dest.writeString(this.contentType);
        dest.writeString(this.posterUrl);
        dest.writeString(this.actionUrl);
        dest.writeString(this.error);
    }

    static CleverTapDisplayUnitContent toContent(JSONObject contentObject) {
        try {
            JSONObject actionObject;
            JSONObject mediaObject;
            JSONObject iconObject;
            JSONObject msgObject;
            JSONObject titleObject;
            String title = "";
            String titleColor = "";
            String message = "";
            String messageColor = "";
            String icon = "";
            String media = "";
            String contentType = "";
            String posterUrl = "";
            String actionUrl = "";
            JSONObject jSONObject = titleObject = contentObject.has("title") ? contentObject.getJSONObject("title") : null;
            if (titleObject != null) {
                title = titleObject.has("text") ? titleObject.getString("text") : "";
                titleColor = titleObject.has("color") ? titleObject.getString("color") : "";
            }
            JSONObject jSONObject2 = msgObject = contentObject.has("message") ? contentObject.getJSONObject("message") : null;
            if (msgObject != null) {
                message = msgObject.has("text") ? msgObject.getString("text") : "";
                messageColor = msgObject.has("color") ? msgObject.getString("color") : "";
            }
            JSONObject jSONObject3 = iconObject = contentObject.has("icon") ? contentObject.getJSONObject("icon") : null;
            if (iconObject != null) {
                icon = iconObject.has("url") ? iconObject.getString("url") : "";
            }
            JSONObject jSONObject4 = mediaObject = contentObject.has("media") ? contentObject.getJSONObject("media") : null;
            if (mediaObject != null) {
                media = mediaObject.has("url") ? mediaObject.getString("url") : "";
                contentType = mediaObject.has("content_type") ? mediaObject.getString("content_type") : "";
                posterUrl = mediaObject.has("poster") ? mediaObject.getString("poster") : "";
            }
            JSONObject jSONObject5 = actionObject = contentObject.has("action") ? contentObject.getJSONObject("action") : null;
            if (actionObject != null) {
                JSONObject urlObject;
                JSONObject jSONObject6 = urlObject = actionObject.has("url") ? actionObject.getJSONObject("url") : null;
                if (urlObject != null) {
                    JSONObject androidObject;
                    JSONObject jSONObject7 = androidObject = urlObject.has("android") ? urlObject.getJSONObject("android") : null;
                    if (androidObject != null) {
                        actionUrl = androidObject.has("text") ? androidObject.getString("text") : "";
                    }
                }
            }
            return new CleverTapDisplayUnitContent(title, titleColor, message, messageColor, icon, media, contentType, posterUrl, actionUrl, null);
        }
        catch (Exception e) {
            Logger.d("DisplayUnit : ", "Unable to init CleverTapDisplayUnitContent with JSON - " + e.getLocalizedMessage());
            return new CleverTapDisplayUnitContent("", "", "", "", "", "", "", "", "", "Error Creating DisplayUnit Content from JSON : " + e.getLocalizedMessage());
        }
    }
}

