/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;

public final class ActivityLifecycleCallback {
    public static boolean registered = false;
    private static String cleverTapId = null;
    private static final Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, Bundle bundle) {
            CleverTapAPI.onActivityCreated(activity, cleverTapId);
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
            CleverTapAPI.onActivityPaused();
        }

        public void onActivityResumed(@NonNull Activity activity) {
            CleverTapAPI.onActivityResumed(activity, cleverTapId);
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }
    };

    public static void register(Application application) {
        ActivityLifecycleCallback.register(application, null);
    }

    public static void register(Application application, String cleverTapID) {
        if (application == null) {
            Logger.i("Application instance is null/system API is too old");
            return;
        }
        if (registered) {
            Logger.v("Lifecycle callbacks have already been registered");
            return;
        }
        cleverTapId = cleverTapID;
        registered = true;
        application.unregisterActivityLifecycleCallbacks(lifecycleCallbacks);
        application.registerActivityLifecycleCallbacks(lifecycleCallbacks);
        Logger.i("Activity Lifecycle Callback successfully registered");
    }
}

