/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.cryption.Crypt;
import com.clevertap.android.sdk.cryption.CryptFactory;
import com.clevertap.android.sdk.cryption.CryptRepository;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J$\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler;", "", "encryptionLevel", "Lcom/clevertap/android/sdk/cryption/EncryptionLevel;", "accountID", "", "repository", "Lcom/clevertap/android/sdk/cryption/CryptRepository;", "cryptFactory", "Lcom/clevertap/android/sdk/cryption/CryptFactory;", "<init>", "(Lcom/clevertap/android/sdk/cryption/EncryptionLevel;Ljava/lang/String;Lcom/clevertap/android/sdk/cryption/CryptRepository;Lcom/clevertap/android/sdk/cryption/CryptFactory;)V", "encrypt", "plainText", "key", "algorithm", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "decrypt", "cipherText", "updateMigrationFailureCount", "", "migrationSuccessful", "", "EncryptionAlgorithm", "Companion", "clevertap-core_release"})
public final class CryptHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptionLevel encryptionLevel;
    @NotNull
    private final String accountID;
    @NotNull
    private final CryptRepository repository;
    @NotNull
    private final CryptFactory cryptFactory;

    public CryptHandler(@NotNull EncryptionLevel encryptionLevel, @NotNull String accountID, @NotNull CryptRepository repository, @NotNull CryptFactory cryptFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionLevel), (String)"encryptionLevel");
        Intrinsics.checkNotNullParameter((Object)accountID, (String)"accountID");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)cryptFactory, (String)"cryptFactory");
        this.encryptionLevel = encryptionLevel;
        this.accountID = accountID;
        this.repository = repository;
        this.cryptFactory = cryptFactory;
    }

    @JvmOverloads
    @Nullable
    public final String encrypt(@NotNull String plainText, @NotNull String key, @NotNull EncryptionAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        if (Companion.isTextEncrypted(plainText)) {
            return plainText;
        }
        Crypt crypt = this.cryptFactory.getCryptInstance(algorithm);
        if (WhenMappings.$EnumSwitchMapping$0[this.encryptionLevel.ordinal()] == 1) {
            if (Constants.MEDIUM_CRYPT_KEYS.contains(key)) {
                return crypt.encryptInternal(plainText);
            }
        } else {
            return plainText;
        }
        return plainText;
    }

    public static /* synthetic */ String encrypt$default(CryptHandler cryptHandler, String string2, String string3, EncryptionAlgorithm encryptionAlgorithm, int n, Object object) {
        if ((n & 4) != 0) {
            encryptionAlgorithm = EncryptionAlgorithm.AES_GCM;
        }
        return cryptHandler.encrypt(string2, string3, encryptionAlgorithm);
    }

    @JvmOverloads
    @Nullable
    public final String decrypt(@NotNull String cipherText, @NotNull String key, @NotNull EncryptionAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        if (!Companion.isTextEncrypted(cipherText)) {
            return cipherText;
        }
        Crypt crypt = this.cryptFactory.getCryptInstance(algorithm);
        if (WhenMappings.$EnumSwitchMapping$0[this.encryptionLevel.ordinal()] == 1) {
            if (Constants.MEDIUM_CRYPT_KEYS.contains(key)) {
                return crypt.decryptInternal(cipherText);
            }
        } else {
            return crypt.decryptInternal(cipherText);
        }
        return cipherText;
    }

    public static /* synthetic */ String decrypt$default(CryptHandler cryptHandler, String string2, String string3, EncryptionAlgorithm encryptionAlgorithm, int n, Object object) {
        if ((n & 4) != 0) {
            encryptionAlgorithm = EncryptionAlgorithm.AES_GCM;
        }
        return cryptHandler.decrypt(string2, string3, encryptionAlgorithm);
    }

    @Nullable
    public final String encrypt(@NotNull String plainText, @NotNull EncryptionAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Crypt crypt = this.cryptFactory.getCryptInstance(algorithm);
        return crypt.encryptInternal(plainText);
    }

    public static /* synthetic */ String encrypt$default(CryptHandler cryptHandler, String string2, EncryptionAlgorithm encryptionAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            encryptionAlgorithm = EncryptionAlgorithm.AES_GCM;
        }
        return cryptHandler.encrypt(string2, encryptionAlgorithm);
    }

    @JvmOverloads
    @Nullable
    public final String decrypt(@NotNull String cipherText, @NotNull EncryptionAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Crypt crypt = this.cryptFactory.getCryptInstance(algorithm);
        return crypt.decryptInternal(cipherText);
    }

    public static /* synthetic */ String decrypt$default(CryptHandler cryptHandler, String string2, EncryptionAlgorithm encryptionAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            encryptionAlgorithm = EncryptionAlgorithm.AES_GCM;
        }
        return cryptHandler.decrypt(string2, encryptionAlgorithm);
    }

    public final void updateMigrationFailureCount(boolean migrationSuccessful) {
        this.repository.updateMigrationFailureCount(migrationSuccessful);
    }

    @JvmOverloads
    @Nullable
    public final String encrypt(@NotNull String plainText, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return CryptHandler.encrypt$default(this, plainText, key, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final String decrypt(@NotNull String cipherText, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return CryptHandler.decrypt$default(this, cipherText, key, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final String decrypt(@NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        return CryptHandler.decrypt$default(this, cipherText, null, 2, null);
    }

    @JvmStatic
    public static final boolean isTextEncrypted(@NotNull String plainText) {
        return Companion.isTextEncrypted(plainText);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$Companion;", "", "<init>", "()V", "isTextEncrypted", "", "plainText", "", "isTextAESEncrypted", "isTextAESGCMEncrypted", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isTextEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return this.isTextAESEncrypted(plainText) || this.isTextAESGCMEncrypted(plainText);
        }

        public final boolean isTextAESEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return StringsKt.startsWith$default((String)plainText, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)plainText, (String)"]", (boolean)false, (int)2, null);
        }

        public final boolean isTextAESGCMEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return StringsKt.startsWith$default((String)plainText, (String)"<ct<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)plainText, (String)">ct>", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "getValue", "()I", "AES", "AES_GCM", "clevertap-core_release"})
    public static final class EncryptionAlgorithm
    extends Enum<EncryptionAlgorithm> {
        private final int value;
        public static final /* enum */ EncryptionAlgorithm AES = new EncryptionAlgorithm(0);
        public static final /* enum */ EncryptionAlgorithm AES_GCM = new EncryptionAlgorithm(1);
        private static final /* synthetic */ EncryptionAlgorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EncryptionAlgorithm(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static EncryptionAlgorithm[] values() {
            return (EncryptionAlgorithm[])$VALUES.clone();
        }

        public static EncryptionAlgorithm valueOf(String value) {
            return Enum.valueOf(EncryptionAlgorithm.class, value);
        }

        @NotNull
        public static EnumEntries<EncryptionAlgorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = encryptionAlgorithmArray = new EncryptionAlgorithm[]{EncryptionAlgorithm.AES, EncryptionAlgorithm.AES_GCM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionLevel.values().length];
            try {
                nArray[EncryptionLevel.MEDIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

