/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.Logger;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ManifestInfo {
    private static final String LABEL_ACCOUNT_ID = "CLEVERTAP_ACCOUNT_ID";
    private static final String LABEL_TOKEN = "CLEVERTAP_TOKEN";
    public static final String LABEL_NOTIFICATION_ICON = "CLEVERTAP_NOTIFICATION_ICON";
    private static final String LABEL_INAPP_EXCLUDE = "CLEVERTAP_INAPP_EXCLUDE";
    private static final String LABEL_REGION = "CLEVERTAP_REGION";
    private static final String LABEL_PROXY_DOMAIN = "CLEVERTAP_PROXY_DOMAIN";
    private static final String LABEL_SPIKY_PROXY_DOMAIN = "CLEVERTAP_SPIKY_PROXY_DOMAIN";
    private static final String LABEL_CLEVERTAP_HANDSHAKE_DOMAIN = "CLEVERTAP_HANDSHAKE_DOMAIN";
    private static final String LABEL_DISABLE_APP_LAUNCH = "CLEVERTAP_DISABLE_APP_LAUNCHED";
    private static final String LABEL_SSL_PINNING = "CLEVERTAP_SSL_PINNING";
    private static final String LABEL_BACKGROUND_SYNC = "CLEVERTAP_BACKGROUND_SYNC";
    private static final String LABEL_CUSTOM_ID = "CLEVERTAP_USE_CUSTOM_ID";
    private static final String LABEL_USE_GOOGLE_AD_ID = "CLEVERTAP_USE_GOOGLE_AD_ID";
    private static final String LABEL_FCM_SENDER_ID = "FCM_SENDER_ID";
    private static final String LABEL_PACKAGE_NAME = "CLEVERTAP_APP_PACKAGE";
    private static final String LABEL_BETA = "CLEVERTAP_BETA";
    private static final String LABEL_INTENT_SERVICE = "CLEVERTAP_INTENT_SERVICE";
    private static final String LABEL_ENCRYPTION_LEVEL = "CLEVERTAP_ENCRYPTION_LEVEL";
    private static final String LABEL_DEFAULT_CHANNEL_ID = "CLEVERTAP_DEFAULT_CHANNEL_ID";
    private static final String LABEL_PUSH_PROVIDER_1 = "CLEVERTAP_PROVIDER_1";
    private static final String LABEL_PUSH_PROVIDER_2 = "CLEVERTAP_PROVIDER_2";
    private static ManifestInfo instance;
    private static String accountId;
    private static String accountToken;
    private static String accountRegion;
    private static String proxyDomain;
    private static String spikyProxyDomain;
    private static String handshakeDomain;
    private final boolean useADID;
    private final boolean appLaunchedDisabled;
    private final String notificationIcon;
    private final String excludedActivitiesForInApps;
    private final boolean sslPinning;
    private final boolean backgroundSync;
    private final boolean useCustomID;
    private final String fcmSenderId;
    private final String packageName;
    private final boolean beta;
    private final String intentServiceName;
    private final String devDefaultPushChannelId;
    private final String[] profileKeys;
    private final int encryptionLevel;
    private final String provider1;
    private final String provider2;

    public static synchronized ManifestInfo getInstance(Context context) {
        if (instance == null) {
            instance = new ManifestInfo(context);
        }
        return instance;
    }

    static void changeCredentials(String id2, String token, String region) {
        accountId = id2;
        accountToken = token;
        accountRegion = region;
    }

    static void changeCredentials(String id2, String token, String _proxyDomain, String _spikyProxyDomain) {
        accountId = id2;
        accountToken = token;
        proxyDomain = _proxyDomain;
        spikyProxyDomain = _spikyProxyDomain;
    }

    static void changeCredentials(String id2, String token, String _proxyDomain, String _spikyProxyDomain, String customHandshakeDomain) {
        accountId = id2;
        accountToken = token;
        proxyDomain = _proxyDomain;
        spikyProxyDomain = _spikyProxyDomain;
        handshakeDomain = customHandshakeDomain;
    }

    private ManifestInfo(Context context) {
        int encLvlTemp;
        Bundle metaData = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            metaData = ai.metaData;
        }
        catch (Throwable pm) {
            // empty catch block
        }
        if (metaData == null) {
            metaData = new Bundle();
        }
        if (accountId == null) {
            accountId = this._getManifestStringValueForKey(metaData, LABEL_ACCOUNT_ID);
        }
        if (accountToken == null) {
            accountToken = this._getManifestStringValueForKey(metaData, LABEL_TOKEN);
        }
        if (accountRegion == null) {
            accountRegion = this._getManifestStringValueForKey(metaData, LABEL_REGION);
        }
        if (proxyDomain == null) {
            proxyDomain = this._getManifestStringValueForKey(metaData, LABEL_PROXY_DOMAIN);
        }
        if (spikyProxyDomain == null) {
            spikyProxyDomain = this._getManifestStringValueForKey(metaData, LABEL_SPIKY_PROXY_DOMAIN);
        }
        if (handshakeDomain == null) {
            handshakeDomain = this._getManifestStringValueForKey(metaData, LABEL_CLEVERTAP_HANDSHAKE_DOMAIN);
        }
        this.notificationIcon = this._getManifestStringValueForKey(metaData, LABEL_NOTIFICATION_ICON);
        this.useADID = "1".equals(this._getManifestStringValueForKey(metaData, LABEL_USE_GOOGLE_AD_ID));
        this.appLaunchedDisabled = "1".equals(this._getManifestStringValueForKey(metaData, LABEL_DISABLE_APP_LAUNCH));
        this.excludedActivitiesForInApps = this._getManifestStringValueForKey(metaData, LABEL_INAPP_EXCLUDE);
        this.sslPinning = "1".equals(this._getManifestStringValueForKey(metaData, LABEL_SSL_PINNING));
        this.backgroundSync = "1".equals(this._getManifestStringValueForKey(metaData, LABEL_BACKGROUND_SYNC));
        this.useCustomID = "1".equals(this._getManifestStringValueForKey(metaData, LABEL_CUSTOM_ID));
        String fcmSenderIdTemp = this._getManifestStringValueForKey(metaData, LABEL_FCM_SENDER_ID);
        if (fcmSenderIdTemp != null) {
            fcmSenderIdTemp = fcmSenderIdTemp.replace("id:", "");
        }
        this.fcmSenderId = fcmSenderIdTemp;
        try {
            int parsedEncryptionLevel = Integer.parseInt(this._getManifestStringValueForKey(metaData, LABEL_ENCRYPTION_LEVEL));
            if (parsedEncryptionLevel >= 0 && parsedEncryptionLevel <= 1) {
                encLvlTemp = parsedEncryptionLevel;
            } else {
                encLvlTemp = 0;
                Logger.v("Supported encryption levels are only 0 and 1. Setting it to 0 by default");
            }
        }
        catch (Throwable t) {
            encLvlTemp = 0;
            Logger.v("Unable to parse encryption level from the Manifest, Setting it to 0 by default", t.getCause());
        }
        this.encryptionLevel = encLvlTemp;
        this.packageName = this._getManifestStringValueForKey(metaData, LABEL_PACKAGE_NAME);
        this.beta = "1".equals(this._getManifestStringValueForKey(metaData, LABEL_BETA));
        this.intentServiceName = this._getManifestStringValueForKey(metaData, LABEL_INTENT_SERVICE);
        this.devDefaultPushChannelId = this._getManifestStringValueForKey(metaData, LABEL_DEFAULT_CHANNEL_ID);
        this.profileKeys = this.parseProfileKeys(metaData);
        this.provider1 = this._getManifestStringValueForKey(metaData, LABEL_PUSH_PROVIDER_1);
        this.provider2 = this._getManifestStringValueForKey(metaData, LABEL_PUSH_PROVIDER_2);
    }

    ManifestInfo(String accountId, String accountToken, String accountRegion, String proxyDomain, String spikyProxyDomain, String handshakeDomain, boolean useADID, boolean appLaunchedDisabled, String notificationIcon, String excludedActivitiesForInApps, boolean sslPinning, boolean backgroundSync, boolean useCustomID, String fcmSenderId, String packageName, boolean beta, String intentServiceName, String devDefaultPushChannelId, String[] profileKeys, int encryptionLevel, String provider1, String provider2) {
        if (ManifestInfo.accountId == null) {
            ManifestInfo.accountId = accountId;
        }
        if (ManifestInfo.accountToken == null) {
            ManifestInfo.accountToken = accountToken;
        }
        if (ManifestInfo.accountRegion == null) {
            ManifestInfo.accountRegion = accountRegion;
        }
        if (ManifestInfo.proxyDomain == null) {
            ManifestInfo.proxyDomain = proxyDomain;
        }
        if (ManifestInfo.spikyProxyDomain == null) {
            ManifestInfo.spikyProxyDomain = spikyProxyDomain;
        }
        if (ManifestInfo.handshakeDomain == null) {
            ManifestInfo.handshakeDomain = handshakeDomain;
        }
        this.useADID = useADID;
        this.appLaunchedDisabled = appLaunchedDisabled;
        this.notificationIcon = notificationIcon;
        this.excludedActivitiesForInApps = excludedActivitiesForInApps;
        this.sslPinning = sslPinning;
        this.backgroundSync = backgroundSync;
        this.useCustomID = useCustomID;
        this.fcmSenderId = fcmSenderId;
        this.packageName = packageName;
        this.beta = beta;
        this.intentServiceName = intentServiceName;
        this.devDefaultPushChannelId = devDefaultPushChannelId;
        this.profileKeys = profileKeys;
        this.encryptionLevel = encryptionLevel;
        this.provider1 = provider1;
        this.provider2 = provider2;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getExcludedActivities() {
        return this.excludedActivitiesForInApps;
    }

    public String getFCMSenderId() {
        return this.fcmSenderId;
    }

    public String getDevDefaultPushChannelId() {
        return this.devDefaultPushChannelId;
    }

    public String getIntentServiceName() {
        return this.intentServiceName;
    }

    public String getNotificationIcon() {
        return this.notificationIcon;
    }

    public String[] getProfileKeys() {
        return this.profileKeys;
    }

    boolean enableBeta() {
        return this.beta;
    }

    public int getEncryptionLevel() {
        return this.encryptionLevel;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getAccountRegion() {
        Logger.v("ManifestInfo: getAccountRegion called, returning region:" + accountRegion);
        return accountRegion;
    }

    String getAccountToken() {
        return accountToken;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getProxyDomain() {
        Logger.v("ManifestInfo: getProxyDomain called, returning proxyDomain:" + proxyDomain);
        return proxyDomain;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getSpikeyProxyDomain() {
        Logger.v("ManifestInfo: getSpikeyProxyDomain called, returning spikeyProxyDomain:" + spikyProxyDomain);
        return spikyProxyDomain;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getHandshakeDomain() {
        Logger.v("ManifestInfo: getHandshakeDomain called, returning handshakeDomain:" + handshakeDomain);
        return handshakeDomain;
    }

    String getPackageName() {
        return this.packageName;
    }

    boolean isAppLaunchedDisabled() {
        return this.appLaunchedDisabled;
    }

    boolean isBackgroundSync() {
        return this.backgroundSync;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isSSLPinningEnabled() {
        return this.sslPinning;
    }

    boolean useCustomId() {
        return this.useCustomID;
    }

    boolean useGoogleAdId() {
        return this.useADID;
    }

    private String[] parseProfileKeys(Bundle metaData) {
        String profileKeyString = this._getManifestStringValueForKey(metaData, "CLEVERTAP_IDENTIFIER");
        return !TextUtils.isEmpty((CharSequence)profileKeyString) ? profileKeyString.split(",") : Constants.NULL_STRING_ARRAY;
    }

    private String _getManifestStringValueForKey(Bundle manifest, String name) {
        try {
            Object o = manifest.get(name);
            return o != null ? o.toString() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getVendorOneProvider() {
        return this.provider1;
    }

    public String getVendorTwoProvider() {
        return this.provider2;
    }
}

