/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.ActivityLifeCycleManager;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CTPreferenceCache;
import com.clevertap.android.sdk.CallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.CoreState;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.LocationManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ProfileValueHandler;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.StoreProvider;
import com.clevertap.android.sdk.cryption.CryptFactory;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.cryption.CryptMigrator;
import com.clevertap.android.sdk.cryption.CryptRepository;
import com.clevertap.android.sdk.cryption.DataMigrationRepository;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import com.clevertap.android.sdk.db.DBManager;
import com.clevertap.android.sdk.events.EventMediator;
import com.clevertap.android.sdk.events.EventQueueManager;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsFactory;
import com.clevertap.android.sdk.inapp.ImpressionManager;
import com.clevertap.android.sdk.inapp.InAppController;
import com.clevertap.android.sdk.inapp.InAppQueue;
import com.clevertap.android.sdk.inapp.TriggerManager;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatesManager;
import com.clevertap.android.sdk.inapp.evaluation.EvaluationManager;
import com.clevertap.android.sdk.inapp.evaluation.LimitsMatcher;
import com.clevertap.android.sdk.inapp.evaluation.TriggersMatcher;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoFactory;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoImpl;
import com.clevertap.android.sdk.inapp.store.preference.ImpressionStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.login.LoginController;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.network.AppLaunchListener;
import com.clevertap.android.sdk.network.CompositeBatchListener;
import com.clevertap.android.sdk.network.FetchInAppListener;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.network.api.CtApiWrapper;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.pushnotification.work.CTWorkManager;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.MainLooperHandler;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.Clock;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import com.clevertap.android.sdk.variables.CTVariables;
import com.clevertap.android.sdk.variables.Parser;
import com.clevertap.android.sdk.variables.VarCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J>\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/clevertap/android/sdk/CleverTapFactory;", "", "<init>", "()V", "getCoreState", "Lcom/clevertap/android/sdk/CoreState;", "context", "Landroid/content/Context;", "cleverTapInstanceConfig", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "cleverTapID", "", "initFeatureFlags", "", "controllerManager", "Lcom/clevertap/android/sdk/ControllerManager;", "config", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "callbackManager", "Lcom/clevertap/android/sdk/BaseCallbackManager;", "analyticsManager", "Lcom/clevertap/android/sdk/AnalyticsManager;", "clevertap-core_release"})
public final class CleverTapFactory {
    @NotNull
    public static final CleverTapFactory INSTANCE = new CleverTapFactory();

    private CleverTapFactory() {
    }

    @JvmStatic
    @NotNull
    public static final CoreState getCoreState(@Nullable Context context, @Nullable CleverTapInstanceConfig cleverTapInstanceConfig, @Nullable String cleverTapID) {
        if (context == null || cleverTapInstanceConfig == null) {
            throw new RuntimeException("This is invalid case and will not happen. Context/Config is null");
        }
        CoreState coreState = new CoreState();
        TemplatesManager templatesManager = TemplatesManager.Companion.createInstance(cleverTapInstanceConfig);
        coreState.setTemplatesManager(templatesManager);
        StoreProvider storeProvider = StoreProvider.Companion.getInstance();
        String accountId = cleverTapInstanceConfig.getAccountId();
        Intrinsics.checkNotNull((Object)accountId);
        StoreRegistry storeRegistry = new StoreRegistry(null, null, storeProvider.provideLegacyInAppStore(context, accountId), storeProvider.provideInAppAssetsStore(context, accountId), storeProvider.provideFileStore(context, accountId));
        coreState.setStoreRegistry(storeRegistry);
        CoreMetaData coreMetaData = new CoreMetaData();
        coreState.setCoreMetaData(coreMetaData);
        Validator validator = new Validator();
        ValidationResultStack validationResultStack = new ValidationResultStack();
        coreState.setValidationResultStack(validationResultStack);
        CTLockManager ctLockManager = new CTLockManager();
        coreState.setCTLockManager(ctLockManager);
        MainLooperHandler mainLooperHandler = new MainLooperHandler();
        coreState.setMainLooperHandler(mainLooperHandler);
        CleverTapInstanceConfig config = new CleverTapInstanceConfig(cleverTapInstanceConfig);
        coreState.setConfig(config);
        DBManager baseDatabaseManager = new DBManager(config, ctLockManager);
        coreState.setDatabaseManager(baseDatabaseManager);
        String string2 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        CryptRepository repository = new CryptRepository(context, string2);
        String string3 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAccountId(...)");
        CryptFactory cryptFactory = new CryptFactory(context, string3);
        EncryptionLevel encryptionLevel = EncryptionLevel.Companion.fromInt(config.getEncryptionLevel());
        String string4 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAccountId(...)");
        CryptHandler cryptHandler = new CryptHandler(encryptionLevel, string4, repository, cryptFactory);
        coreState.setCryptHandler(cryptHandler);
        Task<Void> task = CTExecutorFactory.executors(config).postAsyncSafelyTask();
        task.execute("migratingEncryption", () -> CleverTapFactory.getCoreState$lambda$0(context, config, baseDatabaseManager, cryptHandler, repository));
        DeviceInfo deviceInfo = new DeviceInfo(context, config, cleverTapID, coreMetaData);
        coreState.setDeviceInfo(deviceInfo);
        deviceInfo.onInitDeviceInfo(cleverTapID);
        LocalDataStore localDataStore = new LocalDataStore(context, config, cryptHandler, deviceInfo, baseDatabaseManager);
        coreState.setLocalDataStore(localDataStore);
        ProfileValueHandler profileValueHandler = new ProfileValueHandler(validator, validationResultStack);
        coreState.setProfileValueHandler(profileValueHandler);
        EventMediator eventMediator = new EventMediator(context, config, coreMetaData, localDataStore, profileValueHandler);
        coreState.setEventMediator(eventMediator);
        CTPreferenceCache.Companion.getInstance(context, config);
        BaseCallbackManager callbackManager = new CallbackManager(config, deviceInfo);
        coreState.setCallbackManager(callbackManager);
        SessionManager sessionManager = new SessionManager(config, coreMetaData, validator, localDataStore);
        coreState.setSessionManager(sessionManager);
        ControllerManager controllerManager = new ControllerManager(context, config, ctLockManager, callbackManager, deviceInfo, baseDatabaseManager);
        coreState.setControllerManager(controllerManager);
        TriggersMatcher triggersMatcher = new TriggersMatcher(localDataStore);
        String string5 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAccountId(...)");
        TriggerManager triggersManager = new TriggerManager(context, string5, deviceInfo);
        ImpressionManager impressionManager = new ImpressionManager(storeRegistry, null, null, 6, null);
        LimitsMatcher limitsMatcher = new LimitsMatcher(impressionManager, triggersManager);
        coreState.setImpressionManager(impressionManager);
        EvaluationManager evaluationManager = new EvaluationManager(triggersMatcher, triggersManager, limitsMatcher, storeRegistry, templatesManager);
        coreState.setEvaluationManager(evaluationManager);
        Task<Void> taskInitStores = CTExecutorFactory.executors(config).ioTask();
        taskInitStores.execute("initStores", () -> CleverTapFactory.getCoreState$lambda$1(coreState, storeRegistry, storeProvider, context, cryptHandler, deviceInfo, config, evaluationManager, callbackManager));
        Task<Void> taskInitFCManager = CTExecutorFactory.executors(config).ioTask();
        taskInitFCManager.execute("initFCManager", () -> CleverTapFactory.getCoreState$lambda$2(coreState, controllerManager, config, context, storeRegistry, impressionManager));
        Logger logger = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FileResourcesRepoImpl impl = FileResourcesRepoFactory.Companion.createFileResourcesRepo(context, logger, storeRegistry);
        FileResourceProvider fileResourceProvider = new FileResourceProvider(context, config.getLogger());
        VarCache varCache = new VarCache(config, context, impl, fileResourceProvider);
        coreState.setVarCache(varCache);
        CTVariables ctVariables = new CTVariables(varCache);
        coreState.setCTVariables(ctVariables);
        coreState.getControllerManager().setCtVariables(ctVariables);
        Parser parser = new Parser(ctVariables);
        coreState.setParser(parser);
        Task<Void> taskVariablesInit = CTExecutorFactory.executors(config).ioTask();
        taskVariablesInit.execute("initCTVariables", () -> CleverTapFactory.getCoreState$lambda$3(ctVariables));
        InAppResponse inAppResponse = new InAppResponse(config, controllerManager, false, storeRegistry, triggersManager, templatesManager, coreMetaData);
        CtApiWrapper ctApiWrapper = new CtApiWrapper(context, config, deviceInfo);
        NetworkManager networkManager = new NetworkManager(context, config, deviceInfo, coreMetaData, validationResultStack, controllerManager, baseDatabaseManager, callbackManager, ctLockManager, validator, inAppResponse, ctApiWrapper);
        coreState.setNetworkManager(networkManager);
        LoginInfoProvider loginInfoProvider = new LoginInfoProvider(context, config, cryptHandler);
        EventQueueManager baseEventQueueManager = new EventQueueManager(baseDatabaseManager, context, config, eventMediator, sessionManager, callbackManager, mainLooperHandler, deviceInfo, validationResultStack, networkManager, coreMetaData, ctLockManager, localDataStore, controllerManager, loginInfoProvider);
        coreState.setBaseEventQueueManager(baseEventQueueManager);
        InAppResponse inAppResponseForSendTestInApp = new InAppResponse(config, controllerManager, true, storeRegistry, triggersManager, templatesManager, coreMetaData);
        AnalyticsManager analyticsManager = new AnalyticsManager(context, config, baseEventQueueManager, validator, validationResultStack, coreMetaData, deviceInfo, callbackManager, controllerManager, ctLockManager, inAppResponseForSendTestInApp, Clock.Companion.getSYSTEM());
        coreState.setAnalyticsManager(analyticsManager);
        networkManager.addNetworkHeadersListener(evaluationManager);
        InAppController inAppController = new InAppController(context, config, mainLooperHandler, controllerManager, callbackManager, analyticsManager, coreMetaData, deviceInfo, new InAppQueue(config, storeRegistry), evaluationManager, fileResourceProvider, templatesManager, storeRegistry);
        coreState.setInAppController(inAppController);
        coreState.getControllerManager().setInAppController(inAppController);
        AppLaunchListener appLaunchListener = new AppLaunchListener();
        Function0<Unit> function0 = inAppController.onAppLaunchEventSent;
        Intrinsics.checkNotNullExpressionValue(function0, (String)"onAppLaunchEventSent");
        appLaunchListener.addListener(function0);
        CompositeBatchListener batchListener = new CompositeBatchListener();
        batchListener.addListener(appLaunchListener);
        batchListener.addListener(new FetchInAppListener(callbackManager));
        callbackManager.setBatchListener(batchListener);
        Task<Void> taskInitFeatureFlags = CTExecutorFactory.executors(config).ioTask();
        taskInitFeatureFlags.execute("initFeatureFlags", () -> CleverTapFactory.getCoreState$lambda$4(context, controllerManager, config, deviceInfo, callbackManager, analyticsManager));
        LocationManager locationManager = new LocationManager(context, config, coreMetaData, baseEventQueueManager);
        coreState.setLocationManager(locationManager);
        CTWorkManager ctWorkManager = new CTWorkManager(context, config);
        PushProviders pushProviders = PushProviders.load(context, config, baseDatabaseManager, validationResultStack, analyticsManager, controllerManager, ctWorkManager);
        Intrinsics.checkNotNullExpressionValue((Object)pushProviders, (String)"load(...)");
        PushProviders pushProviders2 = pushProviders;
        coreState.setPushProviders(pushProviders2);
        ActivityLifeCycleManager activityLifeCycleManager = new ActivityLifeCycleManager(context, config, analyticsManager, coreMetaData, sessionManager, pushProviders2, callbackManager, inAppController, baseEventQueueManager);
        coreState.setActivityLifeCycleManager(activityLifeCycleManager);
        LoginController loginController = new LoginController(context, config, deviceInfo, validationResultStack, baseEventQueueManager, analyticsManager, coreMetaData, controllerManager, sessionManager, localDataStore, callbackManager, baseDatabaseManager, ctLockManager, loginInfoProvider);
        coreState.setLoginController(loginController);
        return coreState;
    }

    private final void initFeatureFlags(Context context, ControllerManager controllerManager, CleverTapInstanceConfig config, DeviceInfo deviceInfo, BaseCallbackManager callbackManager, AnalyticsManager analyticsManager) {
        config.getLogger().verbose(config.getAccountId() + ":async_deviceID", "Initializing Feature Flags with device Id = " + deviceInfo.getDeviceID());
        if (config.isAnalyticsOnly()) {
            config.getLogger().debug(config.getAccountId(), "Feature Flag is not enabled for this instance");
        } else {
            controllerManager.setCTFeatureFlagsController(CTFeatureFlagsFactory.getInstance(context, deviceInfo.getDeviceID(), config, callbackManager, analyticsManager));
            config.getLogger().verbose(config.getAccountId() + ":async_deviceID", "Feature Flags initialized");
        }
    }

    private static final Void getCoreState$lambda$0(Context $context, CleverTapInstanceConfig $config, DBManager $baseDatabaseManager, CryptHandler $cryptHandler, CryptRepository $repository) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$baseDatabaseManager, (String)"$baseDatabaseManager");
        Intrinsics.checkNotNullParameter((Object)$cryptHandler, (String)"$cryptHandler");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        DataMigrationRepository dataMigrationRepository = new DataMigrationRepository($context, $config, $baseDatabaseManager.loadDBAdapter($context));
        String string2 = $config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        int n = $config.getEncryptionLevel();
        Logger logger = $config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        CryptMigrator cryptMigrator = new CryptMigrator(string2, n, logger, $cryptHandler, $repository, dataMigrationRepository);
        cryptMigrator.migrateEncryption();
        return null;
    }

    private static final Void getCoreState$lambda$1(CoreState $coreState, StoreRegistry $storeRegistry, StoreProvider $storeProvider, Context $context, CryptHandler $cryptHandler, DeviceInfo $deviceInfo, CleverTapInstanceConfig $config, EvaluationManager $evaluationManager, BaseCallbackManager $callbackManager) {
        Intrinsics.checkNotNullParameter((Object)$coreState, (String)"$coreState");
        Intrinsics.checkNotNullParameter((Object)$storeRegistry, (String)"$storeRegistry");
        Intrinsics.checkNotNullParameter((Object)$storeProvider, (String)"$storeProvider");
        Intrinsics.checkNotNullParameter((Object)$cryptHandler, (String)"$cryptHandler");
        Intrinsics.checkNotNullParameter((Object)$deviceInfo, (String)"$deviceInfo");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$evaluationManager, (String)"$evaluationManager");
        Intrinsics.checkNotNullParameter((Object)$callbackManager, (String)"$callbackManager");
        if ($coreState.getDeviceInfo() != null && $coreState.getDeviceInfo().getDeviceID() != null) {
            if ($storeRegistry.getInAppStore() == null) {
                String string2 = $deviceInfo.getDeviceID();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceID(...)");
                String string3 = $config.getAccountId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAccountId(...)");
                InAppStore inAppStore = $storeProvider.provideInAppStore($context, $cryptHandler, string2, string3);
                $storeRegistry.setInAppStore(inAppStore);
                $evaluationManager.loadSuppressedCSAndEvaluatedSSInAppsIds();
                $callbackManager.addChangeUserCallback(inAppStore);
            }
            if ($storeRegistry.getImpressionStore() == null) {
                String string4 = $deviceInfo.getDeviceID();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDeviceID(...)");
                String string5 = $config.getAccountId();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAccountId(...)");
                ImpressionStore impStore = $storeProvider.provideImpressionStore($context, string4, string5);
                $storeRegistry.setImpressionStore(impStore);
                $callbackManager.addChangeUserCallback(impStore);
            }
        }
        return null;
    }

    private static final Void getCoreState$lambda$2(CoreState $coreState, ControllerManager $controllerManager, CleverTapInstanceConfig $config, Context $context, StoreRegistry $storeRegistry, ImpressionManager $impressionManager) {
        Intrinsics.checkNotNullParameter((Object)$coreState, (String)"$coreState");
        Intrinsics.checkNotNullParameter((Object)$controllerManager, (String)"$controllerManager");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$storeRegistry, (String)"$storeRegistry");
        Intrinsics.checkNotNullParameter((Object)$impressionManager, (String)"$impressionManager");
        if ($coreState.getDeviceInfo() != null && $coreState.getDeviceInfo().getDeviceID() != null && $controllerManager.getInAppFCManager() == null) {
            $coreState.getConfig().getLogger().verbose($config.getAccountId() + ":async_deviceID", "Initializing InAppFC with device Id = " + $coreState.getDeviceInfo().getDeviceID());
            $controllerManager.setInAppFCManager(new InAppFCManager($context, $config, $coreState.getDeviceInfo().getDeviceID(), $storeRegistry, $impressionManager));
        }
        return null;
    }

    private static final Void getCoreState$lambda$3(CTVariables $ctVariables) {
        Intrinsics.checkNotNullParameter((Object)$ctVariables, (String)"$ctVariables");
        $ctVariables.init();
        return null;
    }

    private static final Void getCoreState$lambda$4(Context $context, ControllerManager $controllerManager, CleverTapInstanceConfig $config, DeviceInfo $deviceInfo, BaseCallbackManager $callbackManager, AnalyticsManager $analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)$controllerManager, (String)"$controllerManager");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$deviceInfo, (String)"$deviceInfo");
        Intrinsics.checkNotNullParameter((Object)$callbackManager, (String)"$callbackManager");
        Intrinsics.checkNotNullParameter((Object)$analyticsManager, (String)"$analyticsManager");
        INSTANCE.initFeatureFlags($context, $controllerManager, $config, $deviceInfo, $callbackManager, $analyticsManager);
        return null;
    }
}

