/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.activity.ComponentDialog;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.media3.common.util.UnstableApi;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.gif.GifImageView;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullNativeFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppNotificationMedia;
import com.clevertap.android.sdk.video.InAppVideoPlayerHandle;
import com.clevertap.android.sdk.video.VideoLibChecker;
import com.clevertap.android.sdk.video.VideoLibraryIntegrated;
import com.clevertap.android.sdk.video.inapps.ExoplayerHandle;
import com.clevertap.android.sdk.video.inapps.Media3Handle;
import java.util.ArrayList;

@UnstableApi
public class CTInAppNativeInterstitialFragment
extends CTInAppBaseFullNativeFragment {
    private boolean exoPlayerFullscreen = false;
    private ComponentDialog fullScreenDialog;
    private ImageView fullScreenIcon;
    private GifImageView gifImageView;
    private InAppVideoPlayerHandle handle;
    private RelativeLayout relativeLayout;
    private CloseImageView closeImageView;
    private FrameLayout videoFrameLayout;
    private FrameLayout videoFrameInDialog;
    private ViewGroup.LayoutParams imageViewLayoutParams;
    private final OnBackPressedCallback onBackPressedCallback = new OnBackPressedCallback(false){

        public void handleOnBackPressed() {
            if (CTInAppNativeInterstitialFragment.this.exoPlayerFullscreen) {
                CTInAppNativeInterstitialFragment.this.closeFullscreenDialog();
                CTInAppNativeInterstitialFragment.this.onBackPressedCallback.setEnabled(false);
            }
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.handle = VideoLibChecker.mediaLibType == VideoLibraryIntegrated.MEDIA3 ? new Media3Handle() : new ExoplayerHandle();
    }

    @Nullable
    @SuppressLint(value={"ResourceType"})
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View inAppView = this.inAppNotification.isTablet() && this.isTablet() ? inflater.inflate(R.layout.tab_inapp_interstitial, container, false) : inflater.inflate(R.layout.inapp_interstitial, container, false);
        FrameLayout fl = (FrameLayout)inAppView.findViewById(R.id.inapp_interstitial_frame_layout);
        this.closeImageView = (CloseImageView)fl.findViewById(199272);
        this.relativeLayout = (RelativeLayout)fl.findViewById(R.id.interstitial_relative_layout);
        this.videoFrameLayout = (FrameLayout)this.relativeLayout.findViewById(R.id.video_frame);
        this.relativeLayout.setBackgroundColor(Color.parseColor((String)this.inAppNotification.getBackgroundColor()));
        fl.setBackground((Drawable)new ColorDrawable(-1157627904));
        this.resizeContainer(fl, this.closeImageView);
        this.setMediaForInApp();
        this.setTitleAndMessage();
        this.setButtons();
        this.handleCloseButton();
        return inAppView;
    }

    private void handleCloseButton() {
        if (!this.inAppNotification.isHideCloseButton()) {
            this.closeImageView.setOnClickListener(null);
            this.closeImageView.setVisibility(8);
        } else {
            this.closeImageView.setVisibility(0);
            this.closeImageView.setOnClickListener(v -> {
                FragmentActivity activity;
                this.didDismiss(null);
                if (this.gifImageView != null) {
                    this.gifImageView.clear();
                }
                if ((activity = this.getActivity()) != null) {
                    activity.finish();
                }
            });
        }
    }

    private void setButtons() {
        ArrayList<Button> buttonViews = new ArrayList<Button>();
        LinearLayout linearLayout = (LinearLayout)this.relativeLayout.findViewById(R.id.interstitial_linear_layout);
        Button mainButton = (Button)linearLayout.findViewById(R.id.interstitial_button1);
        buttonViews.add(mainButton);
        Button secondaryButton = (Button)linearLayout.findViewById(R.id.interstitial_button2);
        buttonViews.add(secondaryButton);
        ArrayList<CTInAppNotificationButton> buttons = this.inAppNotification.getButtons();
        if (buttons.size() == 1) {
            if (this.currentOrientation == 2) {
                mainButton.setVisibility(8);
            } else if (this.currentOrientation == 1) {
                mainButton.setVisibility(4);
            }
            this.setupInAppButton(secondaryButton, buttons.get(0), 0);
        } else if (!buttons.isEmpty()) {
            for (int i = 0; i < buttons.size(); ++i) {
                if (i >= 2) continue;
                CTInAppNotificationButton inAppNotificationButton = buttons.get(i);
                Button button = (Button)buttonViews.get(i);
                this.setupInAppButton(button, inAppNotificationButton, i);
            }
        }
    }

    private void setTitleAndMessage() {
        TextView textView1 = (TextView)this.relativeLayout.findViewById(R.id.interstitial_title);
        textView1.setText((CharSequence)this.inAppNotification.getTitle());
        textView1.setTextColor(Color.parseColor((String)this.inAppNotification.getTitleColor()));
        TextView textView2 = (TextView)this.relativeLayout.findViewById(R.id.interstitial_message);
        textView2.setText((CharSequence)this.inAppNotification.getMessage());
        textView2.setTextColor(Color.parseColor((String)this.inAppNotification.getMessageColor()));
    }

    private void setMediaForInApp() {
        if (!this.inAppNotification.getMediaList().isEmpty()) {
            CTInAppNotificationMedia media = this.inAppNotification.getMediaList().get(0);
            if (media.isImage()) {
                Bitmap image = this.resourceProvider().cachedInAppImageV1(media.getMediaUrl());
                if (image != null) {
                    ImageView imageView = (ImageView)this.relativeLayout.findViewById(R.id.backgroundImage);
                    imageView.setVisibility(0);
                    imageView.setImageBitmap(image);
                }
            } else if (media.isGIF()) {
                byte[] gifByteArray = this.resourceProvider().cachedInAppGifV1(media.getMediaUrl());
                if (gifByteArray != null) {
                    this.gifImageView = (GifImageView)this.relativeLayout.findViewById(R.id.gifImage);
                    this.gifImageView.setVisibility(0);
                    this.gifImageView.setBytes(gifByteArray);
                    this.gifImageView.startAnimation();
                }
            } else if (media.isVideo()) {
                this.initFullScreenIconForStream();
                this.prepareMedia();
                this.playMedia();
            } else if (media.isAudio()) {
                this.initFullScreenIconForStream();
                this.prepareMedia();
                this.playMedia();
                this.disableFullScreenButton();
            }
        }
    }

    private void initFullScreenIconForStream() {
        this.fullScreenIcon = new ImageView(this.context);
        this.fullScreenIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_ic_fullscreen_expand, null));
        this.fullScreenIcon.setOnClickListener(v -> {
            if (!this.exoPlayerFullscreen) {
                this.onBackPressedCallback.setEnabled(true);
                this.openFullscreenDialog();
            } else {
                this.closeFullscreenDialog();
                this.onBackPressedCallback.setEnabled(false);
            }
        });
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int iconSide = this.inAppNotification.isTablet() && this.isTablet() ? (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics) : (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        int iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics);
        int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(iconSide, iconSide);
        layoutParams.gravity = 0x800005;
        layoutParams.setMargins(0, iconTop, iconRight, 0);
        this.fullScreenIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void resizeContainer(final FrameLayout fl, final CloseImageView closeImageView) {
        switch (this.currentOrientation) {
            case 1: {
                this.relativeLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)CTInAppNativeInterstitialFragment.this.relativeLayout.getLayoutParams();
                        if (CTInAppNativeInterstitialFragment.this.inAppNotification.isTablet() && CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawInterstitialTabletInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else if (CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawInterstitialMobileInAppOnTablet(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else {
                            CTInAppNativeInterstitialFragment.this.redrawInterstitialInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, closeImageView);
                        }
                        CTInAppNativeInterstitialFragment.this.relativeLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                });
                break;
            }
            case 2: {
                this.relativeLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)CTInAppNativeInterstitialFragment.this.relativeLayout.getLayoutParams();
                        if (CTInAppNativeInterstitialFragment.this.inAppNotification.isTablet() && CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawLandscapeInterstitialTabletInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else if (CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawLandscapeInterstitialMobileInAppOnTablet(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else {
                            CTInAppNativeInterstitialFragment.this.redrawLandscapeInterstitialInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, closeImageView);
                        }
                        CTInAppNativeInterstitialFragment.this.relativeLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                });
            }
        }
    }

    public void onStart() {
        super.onStart();
        if (this.gifImageView != null) {
            CTInAppNotificationMedia inAppMedia = this.inAppNotification.getMediaList().get(0);
            this.gifImageView.setBytes(this.resourceProvider().cachedInAppGifV1(inAppMedia.getMediaUrl()));
            this.gifImageView.startAnimation();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.inAppNotification.hasStreamMedia()) {
            this.prepareMedia();
            this.playMedia();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.gifImageView != null) {
            this.gifImageView.clear();
        }
        if (this.exoPlayerFullscreen) {
            this.closeFullscreenDialog();
            this.onBackPressedCallback.setEnabled(false);
        }
        this.handle.savePosition();
        this.handle.pause();
    }

    public void onStop() {
        super.onStop();
        if (this.gifImageView != null) {
            this.gifImageView.clear();
        }
        this.handle.pause();
    }

    @Override
    void cleanup() {
        super.cleanup();
        if (this.gifImageView != null) {
            this.gifImageView.clear();
        }
        this.handle.pause();
    }

    private void disableFullScreenButton() {
        this.fullScreenIcon.setVisibility(8);
    }

    private void closeFullscreenDialog() {
        View playerView = this.handle.videoSurface();
        this.handle.switchToFullScreen(false);
        this.fullScreenIcon.setLayoutParams(this.imageViewLayoutParams);
        this.videoFrameInDialog.removeAllViews();
        this.videoFrameLayout.addView(playerView);
        this.videoFrameLayout.addView((View)this.fullScreenIcon);
        this.exoPlayerFullscreen = false;
        this.fullScreenDialog.dismiss();
        this.fullScreenIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ct_ic_fullscreen_expand));
    }

    private void openFullscreenDialog() {
        View playerView = this.handle.videoSurface();
        this.imageViewLayoutParams = this.fullScreenIcon.getLayoutParams();
        this.handle.switchToFullScreen(true);
        this.videoFrameLayout.removeAllViews();
        if (this.fullScreenDialog == null) {
            this.fullScreenDialog = new ComponentDialog(this.context, 16973834);
            FrameLayout.LayoutParams fullScreenParams = new FrameLayout.LayoutParams(-1, -1);
            this.videoFrameInDialog = new FrameLayout(this.context);
            this.fullScreenDialog.addContentView((View)this.videoFrameInDialog, (ViewGroup.LayoutParams)fullScreenParams);
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                this.fullScreenDialog.getOnBackPressedDispatcher().addCallback((LifecycleOwner)activity, this.onBackPressedCallback);
            }
        }
        this.videoFrameInDialog.addView(playerView);
        this.exoPlayerFullscreen = true;
        this.fullScreenDialog.show();
    }

    private void playMedia() {
        this.handle.play();
    }

    private void prepareMedia() {
        this.handle.initPlayerView(this.context, this.inAppNotification.isTablet() && this.isTablet());
        this.addViewsForStreamMedia();
        this.handle.initExoplayer(this.context, this.inAppNotification.getMediaList().get(0).getMediaUrl());
    }

    private void addViewsForStreamMedia() {
        this.videoFrameLayout.setVisibility(0);
        View videoSurface = this.handle.videoSurface();
        if (this.videoFrameLayout.getChildCount() == 0) {
            this.videoFrameLayout.addView(videoSurface);
            this.videoFrameLayout.addView((View)this.fullScreenIcon);
        } else {
            Logger.d("Video views and controls are already added, not re-attaching");
        }
    }
}

