/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface PushConstants {
    public static final String LOG_TAG = "PushProvider";
    public static final String FCM_LOG_TAG = PushType.FCM.toString();
    @NonNull
    public static final String FCM_DELIVERY_TYPE = "fcm";
    @NonNull
    public static final String CT_FIREBASE_PROVIDER_CLASS = "com.clevertap.android.sdk.pushnotification.fcm.FcmPushProvider";
    public static final String FIREBASE_SDK_CLASS = "com.google.firebase.messaging.FirebaseMessagingService";
    public static final String FCM_PROPERTY_REG_ID = "fcm_token";
    public static final int ANDROID_PLATFORM = 1;

    public static enum PushType {
        FCM("fcm", "fcm_token", "com.clevertap.android.sdk.pushnotification.fcm.FcmPushProvider", "com.google.firebase.messaging.FirebaseMessagingService");

        private final String ctProviderClassName;
        private final String messagingSDKClassName;
        private final String tokenPrefKey;
        private final String type;

        private PushType(String type, String prefKey, String className, String messagingSDKClassName) {
            this.type = type;
            this.tokenPrefKey = prefKey;
            this.ctProviderClassName = className;
            this.messagingSDKClassName = messagingSDKClassName;
        }

        public String getCtProviderClassName() {
            return this.ctProviderClassName;
        }

        public String getMessagingSDKClassName() {
            return this.messagingSDKClassName;
        }

        public String getTokenPrefKey() {
            return this.tokenPrefKey;
        }

        public String getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return " [PushType:" + this.name() + "] ";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Platform {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegKeyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PushMessagingClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CTPushProviderClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeliveryType {
    }
}

