/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.customtemplates;

import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateException;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplatePresenter;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateType;
import com.clevertap.android.sdk.inapp.customtemplates.FunctionPresenter;
import com.clevertap.android.sdk.inapp.customtemplates.TemplateArgumentType;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatePresenter;
import com.clevertap.android.sdk.inapp.customtemplates.TemplateProducer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/clevertap/android/sdk/inapp/customtemplates/JsonTemplatesProducer;", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplateProducer;", "jsonTemplatesDefinition", "", "templatesPresenter", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatePresenter;", "functionsPresenter", "Lcom/clevertap/android/sdk/inapp/customtemplates/FunctionPresenter;", "(Ljava/lang/String;Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatePresenter;Lcom/clevertap/android/sdk/inapp/customtemplates/FunctionPresenter;)V", "addJsonArgumentsToBuilder", "", "builder", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplate$FunctionBuilder;", "json", "Lorg/json/JSONObject;", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplate$TemplateBuilder;", "argumentTypeFromStringOrThrow", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplateArgumentType;", "argumentTypeString", "createTemplateFromJson", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplate;", "templateName", "defineTemplates", "", "ctConfig", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "jsonArgToMap", "", "", "clevertap-core_release"})
public class JsonTemplatesProducer
implements TemplateProducer {
    @NotNull
    private final String jsonTemplatesDefinition;
    @Nullable
    private final TemplatePresenter templatesPresenter;
    @Nullable
    private final FunctionPresenter functionsPresenter;

    public JsonTemplatesProducer(@NotNull String jsonTemplatesDefinition, @Nullable TemplatePresenter templatesPresenter, @Nullable FunctionPresenter functionsPresenter) {
        Intrinsics.checkNotNullParameter((Object)jsonTemplatesDefinition, (String)"jsonTemplatesDefinition");
        this.jsonTemplatesDefinition = jsonTemplatesDefinition;
        this.templatesPresenter = templatesPresenter;
        this.functionsPresenter = functionsPresenter;
    }

    @Override
    @NotNull
    public Set<CustomTemplate> defineTemplates(@NotNull CleverTapInstanceConfig ctConfig) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)ctConfig, (String)"ctConfig");
        try {
            JSONObject jsonDefinitions = new JSONObject(this.jsonTemplatesDefinition);
            Set templatesSet = new LinkedHashSet();
            Iterator iterator = jsonDefinitions.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jsonDefinitions.keys()");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                String templateName = (String)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)templateName, (String)"templateName");
                JSONObject jSONObject = jsonDefinitions.getJSONObject(templateName);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"jsonDefinitions.getJSONObject(templateName)");
                templatesSet.add(this.createTemplateFromJson(templateName, jSONObject));
            }
            set = templatesSet;
        }
        catch (JSONException je) {
            throw new CustomTemplateException("Invalid JSON format for templates' definitions", je);
        }
        return set;
    }

    private final CustomTemplate createTemplateFromJson(String templateName, JSONObject json) {
        CustomTemplate customTemplate;
        String stringType = json.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)stringType, (String)"stringType");
        CustomTemplateType customTemplateType = CustomTemplateType.Companion.fromString(stringType);
        if (customTemplateType == null) {
            throw new CustomTemplateException("Invalid template type: \"" + stringType + '\"', null, 2, null);
        }
        CustomTemplateType type = customTemplateType;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                if (this.templatesPresenter == null) {
                    throw new CustomTemplateException("JSON definition contains a template definition and a templates presenter is required", null, 2, null);
                }
                CustomTemplate.TemplateBuilder builder = new CustomTemplate.TemplateBuilder();
                builder.name(templateName);
                builder.presenter((CustomTemplatePresenter)this.templatesPresenter);
                JSONObject jSONObject = json.getJSONObject("arguments");
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"json.getJSONObject(\"arguments\")");
                this.addJsonArgumentsToBuilder(builder, jSONObject);
                customTemplate = builder.build();
                break;
            }
            case 2: {
                if (this.functionsPresenter == null) {
                    throw new CustomTemplateException("JSON definition contains a function definition and a function presenter is required", null, 2, null);
                }
                boolean isVisual = json.getBoolean("isVisual");
                CustomTemplate.FunctionBuilder builder = new CustomTemplate.FunctionBuilder(isVisual);
                builder.name(templateName);
                builder.presenter((CustomTemplatePresenter)this.functionsPresenter);
                JSONObject jSONObject = json.getJSONObject("arguments");
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"json.getJSONObject(\"arguments\")");
                this.addJsonArgumentsToBuilder(builder, jSONObject);
                customTemplate = builder.build();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return customTemplate;
    }

    private final void addJsonArgumentsToBuilder(CustomTemplate.TemplateBuilder builder, JSONObject json) {
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.keys()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            TemplateArgumentType argumentType;
            String key = (String)iterator2.next();
            JSONObject argumentJson = json.getJSONObject(key);
            String typeString = argumentJson.getString("type");
            if (Intrinsics.areEqual((Object)typeString, (Object)"object")) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                JSONObject jSONObject = argumentJson.getJSONObject("value");
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"argumentJson.getJSONObject(\"value\")");
                builder.mapArgument(key, this.jsonArgToMap(jSONObject));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeString, (String)"typeString");
            if (TemplateArgumentType.Companion.fromString(typeString) == null) {
                throw new CustomTemplateException("Unsupported argument type: \"" + typeString + '\"', null, 2, null);
            }
            switch (WhenMappings.$EnumSwitchMapping$1[argumentType.ordinal()]) {
                case 1: {
                    boolean value = argumentJson.getBoolean("value");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.booleanArgument(key, value);
                    break;
                }
                case 2: {
                    double value = argumentJson.getDouble("value");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.doubleArgument(key, value);
                    break;
                }
                case 3: {
                    String value = argumentJson.getString("value");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    builder.stringArgument(key, value);
                    break;
                }
                case 4: {
                    if (argumentJson.has("value")) {
                        throw new CustomTemplateException("File arguments should not specify a value. Remove value from argument: \"" + key + '\"', null, 2, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.fileArgument(key);
                    break;
                }
                case 5: {
                    if (argumentJson.has("value")) {
                        throw new CustomTemplateException("Action arguments should not specify a value. Remove value from argument: \"" + key + '\"', null, 2, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.actionArgument(key);
                }
            }
        }
    }

    private final void addJsonArgumentsToBuilder(CustomTemplate.FunctionBuilder builder, JSONObject json) {
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.keys()");
        Iterator iterator2 = iterator;
        block7: while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            JSONObject argumentJson = json.getJSONObject(key);
            String typeString = argumentJson.getString("type");
            if (Intrinsics.areEqual((Object)typeString, (Object)"object")) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                JSONObject jSONObject = argumentJson.getJSONObject("value");
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"argumentJson.getJSONObject(\"value\")");
                builder.mapArgument(key, this.jsonArgToMap(jSONObject));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeString, (String)"typeString");
            TemplateArgumentType type = this.argumentTypeFromStringOrThrow(typeString);
            switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    boolean value = argumentJson.getBoolean("value");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.booleanArgument(key, value);
                    continue block7;
                }
                case 2: {
                    double value = argumentJson.getDouble("value");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.doubleArgument(key, value);
                    continue block7;
                }
                case 3: {
                    String value = argumentJson.getString("value");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    builder.stringArgument(key, value);
                    continue block7;
                }
                case 4: {
                    if (argumentJson.has("value")) {
                        throw new CustomTemplateException("File arguments should not specify a value. Remove value from argument: \"" + key + '\"', null, 2, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    builder.fileArgument(key);
                    continue block7;
                }
                case 5: {
                    throw new CustomTemplateException("Function templates cannot have action arguments. Remove argument: \"" + key + '\"', null, 2, null);
                }
            }
        }
    }

    private final Map<String, Object> jsonArgToMap(JSONObject json) {
        Map map = new LinkedHashMap();
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.keys()");
        Iterator iterator2 = iterator;
        block6: while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            JSONObject argumentJson = json.getJSONObject(key);
            String typeString = argumentJson.getString("type");
            if (Intrinsics.areEqual((Object)typeString, (Object)"object")) {
                Map map2 = map;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string2 = key;
                JSONObject jSONObject = argumentJson.getJSONObject("value");
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"argumentJson.getJSONObject(\"value\")");
                Map<String, Object> map3 = this.jsonArgToMap(jSONObject);
                map2.put(string2, map3);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeString, (String)"typeString");
            TemplateArgumentType type = this.argumentTypeFromStringOrThrow(typeString);
            switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    map.put(key, argumentJson.getBoolean("value"));
                    continue block6;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    map.put(key, argumentJson.getDouble("value"));
                    continue block6;
                }
                case 3: {
                    String string3;
                    Map map4 = map;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    String string4 = key;
                    Intrinsics.checkNotNullExpressionValue((Object)argumentJson.getString("value"), (String)"argumentJson.getString(\"value\")");
                    map4.put(string4, string3);
                    continue block6;
                }
                case 4: 
                case 5: {
                    throw new CustomTemplateException("Nesting of file and action arguments within objects is not supported. To define nested file and actions use '.' notation in the argument name.", null, 2, null);
                }
            }
        }
        return map;
    }

    private final TemplateArgumentType argumentTypeFromStringOrThrow(String argumentTypeString) {
        TemplateArgumentType templateArgumentType = TemplateArgumentType.Companion.fromString(argumentTypeString);
        if (templateArgumentType == null) {
            throw new CustomTemplateException("Unsupported argument type: \"" + argumentTypeString + '\"', null, 2, null);
        }
        return templateArgumentType;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CustomTemplateType.values().length];
            try {
                nArray[CustomTemplateType.TEMPLATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CustomTemplateType.FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TemplateArgumentType.values().length];
            try {
                nArray[TemplateArgumentType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateArgumentType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateArgumentType.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateArgumentType.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateArgumentType.ACTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

