/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images;

import android.content.Context;
import android.graphics.Bitmap;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.images.FileFetchApi;
import com.clevertap.android.sdk.inapp.images.FileFetchApiContract;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.inapp.images.memory.FileMemoryAccessObject;
import com.clevertap.android.sdk.inapp.images.memory.InAppGifMemoryAccessObjectV1;
import com.clevertap.android.sdk.inapp.images.memory.InAppImageMemoryAccessObjectV1;
import com.clevertap.android.sdk.inapp.images.memory.MemoryAccessObject;
import com.clevertap.android.sdk.inapp.images.memory.MemoryCreator;
import com.clevertap.android.sdk.inapp.images.memory.MemoryDataTransformationType;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.utils.CTCaches;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B[\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002J9\u0010*\u001a\u0004\u0018\u0001H+\"\u0004\b\u0000\u0010+2\u0014\u0010,\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020\u00180'2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.H\u0002\u00a2\u0006\u0002\u0010/Jo\u00100\u001a\u0004\u0018\u0001H+\"\u0004\b\u0000\u0010+2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00180'2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H+0\u001a2\u0014\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u0001H+042 \u00105\u001a\u001c\u0012\u0004\u0012\u00020)\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020\u001c\u0018\u00010'04H\u0002\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u0004\u0018\u00010\u001c2\u0006\u00108\u001a\u00020\u001eJ\u0010\u00109\u001a\u0004\u0018\u00010\u001c2\u0006\u00108\u001a\u00020\u001eJ\u0010\u0010:\u001a\u0004\u0018\u00010#2\u0006\u00108\u001a\u00020\u001eJ\u000e\u0010;\u001a\u00020<2\u0006\u00108\u001a\u00020\u001eJ8\u0010=\u001a\u00020%\"\u0004\b\u0000\u0010+2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020\u001c0'2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H+0\u001aH\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/clevertap/android/sdk/inapp/images/FileResourceProvider;", "", "context", "Landroid/content/Context;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "(Landroid/content/Context;Lcom/clevertap/android/sdk/ILogger;)V", "images", "Ljava/io/File;", "gifs", "allFileTypesDir", "inAppRemoteSource", "Lcom/clevertap/android/sdk/inapp/images/FileFetchApiContract;", "ctCaches", "Lcom/clevertap/android/sdk/utils/CTCaches;", "imageMAO", "Lcom/clevertap/android/sdk/inapp/images/memory/InAppImageMemoryAccessObjectV1;", "gifMAO", "Lcom/clevertap/android/sdk/inapp/images/memory/InAppGifMemoryAccessObjectV1;", "fileMAO", "Lcom/clevertap/android/sdk/inapp/images/memory/FileMemoryAccessObject;", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/inapp/images/FileFetchApiContract;Lcom/clevertap/android/sdk/utils/CTCaches;Lcom/clevertap/android/sdk/inapp/images/memory/InAppImageMemoryAccessObjectV1;Lcom/clevertap/android/sdk/inapp/images/memory/InAppGifMemoryAccessObjectV1;Lcom/clevertap/android/sdk/inapp/images/memory/FileMemoryAccessObject;)V", "mapOfMAO", "", "Lcom/clevertap/android/sdk/inapp/data/CtCacheType;", "", "Lcom/clevertap/android/sdk/inapp/images/memory/MemoryAccessObject;", "cachedFileInBytes", "", "cacheKey", "", "cachedFileInstance", "cachedFilePath", "cachedInAppGifV1", "cachedInAppImageV1", "Landroid/graphics/Bitmap;", "deleteData", "", "downloadedBytesFromApi", "Lkotlin/Pair;", "downloadedBitmap", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "fetchCachedData", "T", "cacheKeyAndType", "transformationType", "Lcom/clevertap/android/sdk/inapp/images/memory/MemoryDataTransformationType;", "(Lkotlin/Pair;Lcom/clevertap/android/sdk/inapp/images/memory/MemoryDataTransformationType;)Ljava/lang/Object;", "fetchData", "urlMeta", "mao", "cachedDataFetcherBlock", "Lkotlin/Function1;", "dataToSaveBlock", "(Lkotlin/Pair;Lcom/clevertap/android/sdk/inapp/images/memory/MemoryAccessObject;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "fetchFile", "url", "fetchInAppGifV1", "fetchInAppImageV1", "isFileCached", "", "saveData", "data", "Companion", "clevertap-core_release"})
public final class FileResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ILogger logger;
    @NotNull
    private final FileFetchApiContract inAppRemoteSource;
    @NotNull
    private final InAppImageMemoryAccessObjectV1 imageMAO;
    @NotNull
    private final InAppGifMemoryAccessObjectV1 gifMAO;
    @NotNull
    private final FileMemoryAccessObject fileMAO;
    @NotNull
    private final Map<CtCacheType, List<MemoryAccessObject<?>>> mapOfMAO;
    @NotNull
    private static final String IMAGE_DIRECTORY_NAME = "CleverTap.Images.";
    @NotNull
    private static final String GIF_DIRECTORY_NAME = "CleverTap.Gif.";
    @NotNull
    private static final String ALL_FILE_TYPES_DIRECTORY_NAME = "CleverTap.Files.";

    public FileResourceProvider(@NotNull File images, @NotNull File gifs, @NotNull File allFileTypesDir, @Nullable ILogger logger, @NotNull FileFetchApiContract inAppRemoteSource, @NotNull CTCaches ctCaches, @NotNull InAppImageMemoryAccessObjectV1 imageMAO, @NotNull InAppGifMemoryAccessObjectV1 gifMAO, @NotNull FileMemoryAccessObject fileMAO) {
        Intrinsics.checkNotNullParameter((Object)images, (String)"images");
        Intrinsics.checkNotNullParameter((Object)gifs, (String)"gifs");
        Intrinsics.checkNotNullParameter((Object)allFileTypesDir, (String)"allFileTypesDir");
        Intrinsics.checkNotNullParameter((Object)inAppRemoteSource, (String)"inAppRemoteSource");
        Intrinsics.checkNotNullParameter((Object)ctCaches, (String)"ctCaches");
        Intrinsics.checkNotNullParameter((Object)imageMAO, (String)"imageMAO");
        Intrinsics.checkNotNullParameter((Object)gifMAO, (String)"gifMAO");
        Intrinsics.checkNotNullParameter((Object)fileMAO, (String)"fileMAO");
        this.logger = logger;
        this.inAppRemoteSource = inAppRemoteSource;
        this.imageMAO = imageMAO;
        this.gifMAO = gifMAO;
        this.fileMAO = fileMAO;
        Pair[] pairArray = new Pair[3];
        Object[] objectArray = new MemoryAccessObject[]{this.imageMAO, this.fileMAO, this.gifMAO};
        pairArray[0] = TuplesKt.to((Object)((Object)CtCacheType.IMAGE), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new MemoryAccessObject[]{this.gifMAO, this.fileMAO, this.imageMAO};
        pairArray[1] = TuplesKt.to((Object)((Object)CtCacheType.GIF), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new MemoryAccessObject[]{this.fileMAO, this.imageMAO, this.gifMAO};
        pairArray[2] = TuplesKt.to((Object)((Object)CtCacheType.FILES), (Object)CollectionsKt.listOf((Object[])objectArray));
        this.mapOfMAO = MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ FileResourceProvider(File file, File file2, File file3, ILogger iLogger, FileFetchApiContract fileFetchApiContract, CTCaches cTCaches, InAppImageMemoryAccessObjectV1 inAppImageMemoryAccessObjectV1, InAppGifMemoryAccessObjectV1 inAppGifMemoryAccessObjectV1, FileMemoryAccessObject fileMemoryAccessObject, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            iLogger = null;
        }
        if ((n & 0x10) != 0) {
            fileFetchApiContract = new FileFetchApi();
        }
        if ((n & 0x20) != 0) {
            cTCaches = CTCaches.Companion.instance(MemoryCreator.Companion.createInAppImageMemoryV1(file, iLogger), MemoryCreator.Companion.createInAppGifMemoryV1(file2, iLogger), MemoryCreator.Companion.createFileMemoryV2(file3, iLogger));
        }
        if ((n & 0x40) != 0) {
            inAppImageMemoryAccessObjectV1 = new InAppImageMemoryAccessObjectV1(cTCaches, iLogger);
        }
        if ((n & 0x80) != 0) {
            inAppGifMemoryAccessObjectV1 = new InAppGifMemoryAccessObjectV1(cTCaches, iLogger);
        }
        if ((n & 0x100) != 0) {
            fileMemoryAccessObject = new FileMemoryAccessObject(cTCaches, iLogger);
        }
        this(file, file2, file3, iLogger, fileFetchApiContract, cTCaches, inAppImageMemoryAccessObjectV1, inAppGifMemoryAccessObjectV1, fileMemoryAccessObject);
    }

    public FileResourceProvider(@NotNull Context context, @Nullable ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getDir(IMAGE_DIRECTORY_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDir(IMAGE_DIR\u2026ME, Context.MODE_PRIVATE)");
        File file2 = context.getDir(GIF_DIRECTORY_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.getDir(GIF_DIREC\u2026ME, Context.MODE_PRIVATE)");
        File file3 = context.getDir(ALL_FILE_TYPES_DIRECTORY_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"context.getDir(ALL_FILE_\u2026ME, Context.MODE_PRIVATE)");
        this(file, file2, file3, logger, null, null, null, null, null, 496, null);
    }

    public /* synthetic */ FileResourceProvider(Context context, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iLogger = null;
        }
        this(context, iLogger);
    }

    private final <T> void saveData(String cacheKey, Pair<? extends T, byte[]> data, MemoryAccessObject<T> mao) {
        File savedFile = mao.saveDiskMemory(cacheKey, (byte[])data.getSecond());
        mao.saveInMemory(cacheKey, new Pair(data.getFirst(), (Object)savedFile));
    }

    public final boolean isFileCached(@NotNull String url) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        List<MemoryAccessObject<?>> list = this.mapOfMAO.get((Object)CtCacheType.FILES);
        if (list != null) {
            Pair pair;
            List<MemoryAccessObject<?>> $this$isFileCached_u24lambda_u242;
            block6: {
                $this$isFileCached_u24lambda_u242 = list;
                boolean bl = false;
                for (Object it : (Iterable)$this$isFileCached_u24lambda_u242) {
                    boolean bl2 = false;
                    if ((it = it.fetchInMemory(url)) == null) continue;
                    pair = it;
                    break block6;
                }
                pair = null;
            }
            if (pair != null) {
                serializable = (Serializable)pair;
            } else {
                File file;
                block7: {
                    for (Object it : (Iterable)$this$isFileCached_u24lambda_u242) {
                        boolean bl = false;
                        File file2 = it.fetchDiskMemory(url);
                        if (file2 == null) continue;
                        file = file2;
                        break block7;
                    }
                    file = null;
                }
                serializable = file;
            }
        } else {
            serializable = null;
        }
        return serializable != null;
    }

    @Nullable
    public final Bitmap cachedInAppImageV1(@Nullable String cacheKey) {
        return (Bitmap)this.fetchCachedData((Pair<String, ? extends CtCacheType>)new Pair((Object)cacheKey, (Object)CtCacheType.IMAGE), MemoryDataTransformationType.ToBitmap.INSTANCE);
    }

    @Nullable
    public final byte[] cachedInAppGifV1(@Nullable String cacheKey) {
        return (byte[])this.fetchCachedData((Pair<String, ? extends CtCacheType>)new Pair((Object)cacheKey, (Object)CtCacheType.GIF), MemoryDataTransformationType.ToByteArray.INSTANCE);
    }

    @Nullable
    public final byte[] cachedFileInBytes(@Nullable String cacheKey) {
        return (byte[])this.fetchCachedData((Pair<String, ? extends CtCacheType>)new Pair((Object)cacheKey, (Object)CtCacheType.FILES), MemoryDataTransformationType.ToByteArray.INSTANCE);
    }

    @Nullable
    public final String cachedFilePath(@Nullable String cacheKey) {
        File file = this.cachedFileInstance(cacheKey);
        return file != null ? file.getAbsolutePath() : null;
    }

    @Nullable
    public final File cachedFileInstance(@Nullable String cacheKey) {
        return (File)this.fetchCachedData((Pair<String, ? extends CtCacheType>)new Pair((Object)cacheKey, (Object)CtCacheType.FILES), MemoryDataTransformationType.ToFile.INSTANCE);
    }

    @Nullable
    public final Bitmap fetchInAppImageV1(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Bitmap)this.fetchData((Pair<String, ? extends CtCacheType>)new Pair((Object)url, (Object)CtCacheType.IMAGE), this.imageMAO, (Function1)new Function1<String, Bitmap>((Object)this){

            @Nullable
            public final Bitmap invoke(@Nullable String p0) {
                return ((FileResourceProvider)this.receiver).cachedInAppImageV1(p0);
            }
        }, fetchInAppImageV1.2.INSTANCE);
    }

    @Nullable
    public final byte[] fetchInAppGifV1(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (byte[])this.fetchData((Pair<String, ? extends CtCacheType>)new Pair((Object)url, (Object)CtCacheType.GIF), this.gifMAO, (Function1)new Function1<String, byte[]>((Object)this){

            @Nullable
            public final byte[] invoke(@Nullable String p0) {
                return ((FileResourceProvider)this.receiver).cachedInAppGifV1(p0);
            }
        }, (Function1)new Function1<DownloadedBitmap, Pair<? extends byte[], ? extends byte[]>>((Object)this){

            @Nullable
            public final Pair<byte[], byte[]> invoke(@NotNull DownloadedBitmap p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return FileResourceProvider.access$downloadedBytesFromApi((FileResourceProvider)this.receiver, p0);
            }
        });
    }

    @Nullable
    public final byte[] fetchFile(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (byte[])this.fetchData((Pair<String, ? extends CtCacheType>)new Pair((Object)url, (Object)CtCacheType.FILES), this.fileMAO, (Function1)new Function1<String, byte[]>((Object)this){

            @Nullable
            public final byte[] invoke(@Nullable String p0) {
                return ((FileResourceProvider)this.receiver).cachedFileInBytes(p0);
            }
        }, (Function1)new Function1<DownloadedBitmap, Pair<? extends byte[], ? extends byte[]>>((Object)this){

            @Nullable
            public final Pair<byte[], byte[]> invoke(@NotNull DownloadedBitmap p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return FileResourceProvider.access$downloadedBytesFromApi((FileResourceProvider)this.receiver, p0);
            }
        });
    }

    private final Pair<byte[], byte[]> downloadedBytesFromApi(DownloadedBitmap downloadedBitmap) {
        Pair pair;
        if (WhenMappings.$EnumSwitchMapping$0[downloadedBitmap.getStatus().ordinal()] == 1) {
            byte[] byArray = downloadedBitmap.getBytes();
            Intrinsics.checkNotNull((Object)byArray);
            pair = new Pair((Object)byArray, (Object)downloadedBitmap.getBytes());
        } else {
            pair = null;
        }
        return pair;
    }

    public final void deleteData(@NotNull String cacheKey) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            List<MemoryAccessObject<?>> list = this.mapOfMAO.get((Object)CtCacheType.IMAGE);
            if (list == null) break block3;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean b;
                MemoryAccessObject mao = (MemoryAccessObject)element$iv;
                boolean bl = false;
                MemoryAccessObject memoryAccessObject = mao;
                CtCacheType cacheType = memoryAccessObject instanceof InAppImageMemoryAccessObjectV1 ? CtCacheType.IMAGE : (memoryAccessObject instanceof InAppGifMemoryAccessObjectV1 ? CtCacheType.GIF : (memoryAccessObject instanceof FileMemoryAccessObject ? CtCacheType.FILES : ""));
                Pair pair = mao.removeInMemory(cacheKey);
                if (pair != null) {
                    ILogger iLogger = this.logger;
                    if (iLogger != null) {
                        iLogger.verbose("FileDownload", cacheKey + " was present in " + (Object)((Object)cacheType) + " in-memory cache is successfully removed");
                    }
                }
                if (!(b = mao.removeDiskMemory(cacheKey))) continue;
                ILogger iLogger = this.logger;
                if (iLogger == null) continue;
                iLogger.verbose("FileDownload", cacheKey + " was present in " + (Object)((Object)cacheType) + " disk-memory cache is successfully removed");
            }
        }
    }

    private final <T> T fetchCachedData(Pair<String, ? extends CtCacheType> cacheKeyAndType, MemoryDataTransformationType<T> transformationType) {
        MemoryAccessObject memoryAccessObject;
        block9: {
            String cacheKey = (String)cacheKeyAndType.getFirst();
            CtCacheType cacheType = (CtCacheType)((Object)cacheKeyAndType.getSecond());
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", cacheType.name() + " data for key " + cacheKey + " requested");
            }
            if (cacheKey == null) {
                ILogger iLogger2 = this.logger;
                if (iLogger2 != null) {
                    iLogger2.verbose("FileDownload", cacheType.name() + " data for null key requested");
                }
                return null;
            }
            List<MemoryAccessObject<?>> list = this.mapOfMAO.get((Object)cacheType);
            if (list != null) {
                MemoryAccessObject memoryAccessObject2;
                List<MemoryAccessObject<?>> $this$fetchCachedData_u24lambda_u246;
                block8: {
                    $this$fetchCachedData_u24lambda_u246 = list;
                    boolean bl = false;
                    for (MemoryAccessObject it : (Iterable)$this$fetchCachedData_u24lambda_u246) {
                        boolean bl2 = false;
                        if ((it = it.fetchInMemoryAndTransform(cacheKey, transformationType)) == null) continue;
                        memoryAccessObject2 = it;
                        break block8;
                    }
                    memoryAccessObject2 = memoryAccessObject = null;
                }
                if (memoryAccessObject2 == null) {
                    for (MemoryAccessObject it : (Iterable)$this$fetchCachedData_u24lambda_u246) {
                        boolean bl = false;
                        T t = it.fetchDiskMemoryAndTransform(cacheKey, transformationType);
                        if (t == null) continue;
                        memoryAccessObject = t;
                        break block9;
                    }
                    memoryAccessObject = null;
                }
            } else {
                memoryAccessObject = null;
            }
        }
        return (T)memoryAccessObject;
    }

    private final <T> T fetchData(Pair<String, ? extends CtCacheType> urlMeta, MemoryAccessObject<T> mao, Function1<? super String, ? extends T> cachedDataFetcherBlock, Function1<? super DownloadedBitmap, ? extends Pair<? extends T, byte[]>> dataToSaveBlock) {
        Object object;
        Object cachedData = cachedDataFetcherBlock.invoke(urlMeta.getFirst());
        if (cachedData != null) {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", "Returning requested " + (String)urlMeta.getFirst() + ' ' + ((CtCacheType)((Object)urlMeta.getSecond())).name() + " from cache");
            }
            return (T)cachedData;
        }
        DownloadedBitmap downloadedData = this.inAppRemoteSource.makeApiCallForFile(urlMeta);
        if (WhenMappings.$EnumSwitchMapping$0[downloadedData.getStatus().ordinal()] == 1) {
            Object object2 = dataToSaveBlock.invoke((Object)downloadedData);
            Intrinsics.checkNotNull((Object)object2);
            Pair dataToSave = (Pair)object2;
            this.saveData((String)urlMeta.getFirst(), dataToSave, mao);
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", "Returning requested " + (String)urlMeta.getFirst() + ' ' + ((CtCacheType)((Object)urlMeta.getSecond())).name() + " with network, saved in cache");
            }
            object = dataToSave.getFirst();
        } else {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", "There was a problem fetching data for " + ((CtCacheType)((Object)urlMeta.getSecond())).name() + ", status: " + (Object)((Object)downloadedData.getStatus()));
            }
            object = null;
        }
        return (T)object;
    }

    public static final /* synthetic */ Pair access$downloadedBytesFromApi(FileResourceProvider $this, DownloadedBitmap downloadedBitmap) {
        return $this.downloadedBytesFromApi(downloadedBitmap);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/inapp/images/FileResourceProvider$Companion;", "", "()V", "ALL_FILE_TYPES_DIRECTORY_NAME", "", "GIF_DIRECTORY_NAME", "IMAGE_DIRECTORY_NAME", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DownloadedBitmap.Status.values().length];
            try {
                nArray[DownloadedBitmap.Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

