/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images.repo;

import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.images.cleanup.FileCleanupStrategy;
import com.clevertap.android.sdk.inapp.images.preload.FilePreloaderStrategy;
import com.clevertap.android.sdk.inapp.images.repo.DownloadState;
import com.clevertap.android.sdk.inapp.images.repo.DownloadTriggerForUrls;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepo;
import com.clevertap.android.sdk.inapp.store.preference.FileStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016JW\u0010\u001c\u001a\u00020\u00122\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!2#\b\u0002\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u001f0#H\u0002J\u00af\u0001\u0010'\u001a\u00020\u00122\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180)0\u00142-\u0010*\u001a)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020,0+\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u00120#2-\u0010.\u001a)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180)\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00120#2-\u0010/\u001a)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180)\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00120#H\u0016J\b\u00100\u001a\u00020\u0012H\u0002J$\u00101\u001a\u00020\u00122\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180)2\u0006\u00103\u001a\u000204H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00066"}, d2={"Lcom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepoImpl;", "Lcom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepo;", "cleanupStrategy", "Lcom/clevertap/android/sdk/inapp/images/cleanup/FileCleanupStrategy;", "preloaderStrategy", "Lcom/clevertap/android/sdk/inapp/images/preload/FilePreloaderStrategy;", "inAppAssetsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "fileStore", "Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;", "legacyInAppsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;", "(Lcom/clevertap/android/sdk/inapp/images/cleanup/FileCleanupStrategy;Lcom/clevertap/android/sdk/inapp/images/preload/FilePreloaderStrategy;Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;)V", "getCleanupStrategy", "()Lcom/clevertap/android/sdk/inapp/images/cleanup/FileCleanupStrategy;", "getPreloaderStrategy", "()Lcom/clevertap/android/sdk/inapp/images/preload/FilePreloaderStrategy;", "cleanupAllFiles", "", "cleanupUrls", "", "", "cleanupAllResources", "cacheTpe", "Lcom/clevertap/android/sdk/inapp/data/CtCacheType;", "cleanupExpiredResources", "cleanupStaleFiles", "urls", "cleanupStaleFilesNow", "validUrls", "currentTime", "", "allFileUrls", "", "expiryTs", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "url", "preloadFilesAndCache", "urlMeta", "Lkotlin/Pair;", "completionCallback", "", "", "urlStatusMap", "successBlock", "failureBlock", "repoUpdated", "updateRepoStatus", "meta", "downloadState", "Lcom/clevertap/android/sdk/inapp/images/repo/DownloadState;", "Companion", "clevertap-core_release"})
public final class FileResourcesRepoImpl
implements FileResourcesRepo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCleanupStrategy cleanupStrategy;
    @NotNull
    private final FilePreloaderStrategy preloaderStrategy;
    @NotNull
    private final InAppAssetsStore inAppAssetsStore;
    @NotNull
    private final FileStore fileStore;
    @NotNull
    private final LegacyInAppStore legacyInAppsStore;
    private static final long EXPIRY_OFFSET_MILLIS = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)14, (DurationUnit)DurationUnit.DAYS));
    @NotNull
    private static final Set<DownloadTriggerForUrls> urlTriggers = new LinkedHashSet();
    @NotNull
    private static final HashMap<String, DownloadState> downloadInProgressUrls = new HashMap();
    @NotNull
    private static final Object fetchAllFilesLock = new Object();

    public FileResourcesRepoImpl(@NotNull FileCleanupStrategy cleanupStrategy, @NotNull FilePreloaderStrategy preloaderStrategy, @NotNull InAppAssetsStore inAppAssetsStore, @NotNull FileStore fileStore, @NotNull LegacyInAppStore legacyInAppsStore) {
        Intrinsics.checkNotNullParameter((Object)cleanupStrategy, (String)"cleanupStrategy");
        Intrinsics.checkNotNullParameter((Object)preloaderStrategy, (String)"preloaderStrategy");
        Intrinsics.checkNotNullParameter((Object)inAppAssetsStore, (String)"inAppAssetsStore");
        Intrinsics.checkNotNullParameter((Object)fileStore, (String)"fileStore");
        Intrinsics.checkNotNullParameter((Object)legacyInAppsStore, (String)"legacyInAppsStore");
        this.cleanupStrategy = cleanupStrategy;
        this.preloaderStrategy = preloaderStrategy;
        this.inAppAssetsStore = inAppAssetsStore;
        this.fileStore = fileStore;
        this.legacyInAppsStore = legacyInAppsStore;
    }

    @Override
    @NotNull
    public FileCleanupStrategy getCleanupStrategy() {
        return this.cleanupStrategy;
    }

    @Override
    @NotNull
    public FilePreloaderStrategy getPreloaderStrategy() {
        return this.preloaderStrategy;
    }

    @Override
    public void preloadFilesAndCache(@NotNull List<? extends Pair<String, ? extends CtCacheType>> urlMeta, @NotNull Function1<? super Map<String, Boolean>, Unit> completionCallback, @NotNull Function1<? super Pair<String, ? extends CtCacheType>, Unit> successBlock2, @NotNull Function1<? super Pair<String, ? extends CtCacheType>, Unit> failureBlock) {
        Intrinsics.checkNotNullParameter(urlMeta, (String)"urlMeta");
        Intrinsics.checkNotNullParameter(completionCallback, (String)"completionCallback");
        Intrinsics.checkNotNullParameter(successBlock2, (String)"successBlock");
        Intrinsics.checkNotNullParameter(failureBlock, (String)"failureBlock");
        Function1 successBlockk2 = (Function1)new Function1<Pair<? extends String, ? extends CtCacheType>, Unit>(this, successBlock2){
            final /* synthetic */ FileResourcesRepoImpl this$0;
            final /* synthetic */ Function1<Pair<String, ? extends CtCacheType>, Unit> $successBlock;
            {
                this.this$0 = $receiver;
                this.$successBlock = $successBlock;
                super(1);
            }

            public final void invoke(@NotNull Pair<String, ? extends CtCacheType> meta) {
                Intrinsics.checkNotNullParameter(meta, (String)"meta");
                FileResourcesRepoImpl.Companion.saveUrlExpiryToStore(meta, (Pair<FileStore, InAppAssetsStore>)new Pair((Object)FileResourcesRepoImpl.access$getFileStore$p(this.this$0), (Object)FileResourcesRepoImpl.access$getInAppAssetsStore$p(this.this$0)));
                FileResourcesRepoImpl.access$updateRepoStatus(this.this$0, meta, DownloadState.SUCCESSFUL);
                this.$successBlock.invoke(meta);
            }
        };
        Function1 failureBlockk2 = (Function1)new Function1<Pair<? extends String, ? extends CtCacheType>, Unit>(this, failureBlock){
            final /* synthetic */ FileResourcesRepoImpl this$0;
            final /* synthetic */ Function1<Pair<String, ? extends CtCacheType>, Unit> $failureBlock;
            {
                this.this$0 = $receiver;
                this.$failureBlock = $failureBlock;
                super(1);
            }

            public final void invoke(@NotNull Pair<String, ? extends CtCacheType> meta) {
                Intrinsics.checkNotNullParameter(meta, (String)"meta");
                FileResourcesRepoImpl.access$updateRepoStatus(this.this$0, meta, DownloadState.FAILED);
                this.$failureBlock.invoke(meta);
            }
        };
        Function1 started2 = (Function1)new Function1<Pair<? extends String, ? extends CtCacheType>, Unit>(this){
            final /* synthetic */ FileResourcesRepoImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<String, ? extends CtCacheType> meta) {
                Intrinsics.checkNotNullParameter(meta, (String)"meta");
                FileResourcesRepoImpl.access$updateRepoStatus(this.this$0, meta, DownloadState.IN_PROGRESS);
            }
        };
        this.getPreloaderStrategy().preloadFilesAndCache(urlMeta, (Function1<? super Pair<String, ? extends CtCacheType>, Unit>)successBlockk2, (Function1<? super Pair<String, ? extends CtCacheType>, Unit>)failureBlockk2, (Function1<? super Pair<String, ? extends CtCacheType>, Unit>)started2, completionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateRepoStatus(Pair<String, ? extends CtCacheType> meta, DownloadState downloadState) {
        if (urlTriggers.isEmpty()) {
            return;
        }
        Object object = fetchAllFilesLock;
        synchronized (object) {
            boolean bl = false;
            ((Map)downloadInProgressUrls).put(meta.getFirst(), downloadState);
            this.repoUpdated();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void cleanupStaleFiles(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.legacyInAppsStore.lastCleanupTs() < EXPIRY_OFFSET_MILLIS) {
            return;
        }
        FileResourcesRepoImpl.cleanupStaleFilesNow$default(this, urls, currentTime, null, null, 12, null);
        this.legacyInAppsStore.updateAssetCleanupTs(currentTime);
    }

    @Override
    public void cleanupExpiredResources(@NotNull CtCacheType cacheTpe) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)((Object)cacheTpe), (String)"cacheTpe");
        switch (WhenMappings.$EnumSwitchMapping$0[cacheTpe.ordinal()]) {
            case 1: 
            case 2: {
                set = this.inAppAssetsStore.getAllAssetUrls();
                break;
            }
            case 3: {
                set = SetsKt.plus(this.fileStore.getAllFileUrls(), (Iterable)this.inAppAssetsStore.getAllAssetUrls());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Set allFileUrls = set;
        FileResourcesRepoImpl.cleanupStaleFilesNow$default(this, null, 0L, allFileUrls, null, 11, null);
    }

    @Override
    public void cleanupAllResources(@NotNull CtCacheType cacheTpe) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)((Object)cacheTpe), (String)"cacheTpe");
        switch (WhenMappings.$EnumSwitchMapping$0[cacheTpe.ordinal()]) {
            case 1: 
            case 2: {
                set = this.inAppAssetsStore.getAllAssetUrls();
                break;
            }
            case 3: {
                set = SetsKt.plus(this.fileStore.getAllFileUrls(), (Iterable)this.inAppAssetsStore.getAllAssetUrls());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Set cleanupUrls = set;
        this.cleanupAllFiles(CollectionsKt.toList((Iterable)cleanupUrls));
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupStaleFilesNow(List<String> validUrls, long currentTime, Set<String> allFileUrls, Function1<? super String, Long> expiryTs) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$associateWith$iv = validUrls;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            void var21_21 = it;
            map.put(t, var21_21);
        }
        Map valid = result$iv;
        Iterable $i$f$associateWith22 = CollectionsKt.toMutableSet((Iterable)allFileUrls);
        boolean $i$f$filter = false;
        $this$associateWithTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String key = (String)element$iv$iv;
            boolean bl = false;
            boolean first = !valid.containsKey(key);
            boolean second = currentTime > ((Number)expiryTs.invoke((Object)key)).longValue();
            if (!(first && second)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cleanupFileUrls = (List)destination$iv$iv;
        this.cleanupAllFiles(cleanupFileUrls);
    }

    static /* synthetic */ void cleanupStaleFilesNow$default(FileResourcesRepoImpl fileResourcesRepoImpl, List list, long l, Set set, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n & 4) != 0) {
            set = SetsKt.plus(fileResourcesRepoImpl.fileStore.getAllFileUrls(), (Iterable)fileResourcesRepoImpl.inAppAssetsStore.getAllAssetUrls());
        }
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<String, Long>(fileResourcesRepoImpl){
                final /* synthetic */ FileResourcesRepoImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Long invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return Math.max(FileResourcesRepoImpl.access$getFileStore$p(this.this$0).expiryForUrl(key), FileResourcesRepoImpl.access$getInAppAssetsStore$p(this.this$0).expiryForUrl(key));
                }
            };
        }
        fileResourcesRepoImpl.cleanupStaleFilesNow(list, l, set, (Function1<? super String, Long>)function1);
    }

    private final void cleanupAllFiles(List<String> cleanupUrls) {
        Function1 successBlock2 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ FileResourcesRepoImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                FileResourcesRepoImpl.access$getFileStore$p(this.this$0).clearFileUrl(url);
                FileResourcesRepoImpl.access$getInAppAssetsStore$p(this.this$0).clearAssetUrl(url);
            }
        };
        this.getCleanupStrategy().clearFileAssets(cleanupUrls, (Function1<? super String, Unit>)successBlock2);
    }

    private final void repoUpdated() {
        Iterable $this$forEach$iv = urlTriggers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean all;
            boolean bl;
            DownloadTriggerForUrls dt;
            block4: {
                dt = (DownloadTriggerForUrls)element$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = dt.getUrls();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        String url = (String)element$iv2;
                        boolean bl3 = false;
                        if (downloadInProgressUrls.get(url) == DownloadState.SUCCESSFUL || downloadInProgressUrls.get(url) == DownloadState.FAILED) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!(all = bl)) continue;
            dt.getCallback().invoke();
        }
    }

    @Override
    public void preloadFilesAndCache(@NotNull List<? extends Pair<String, ? extends CtCacheType>> urlMeta) {
        FileResourcesRepo.DefaultImpls.preloadFilesAndCache(this, urlMeta);
    }

    @Override
    public void preloadFilesAndCache(@NotNull List<? extends Pair<String, ? extends CtCacheType>> urlMeta, @NotNull Function1<? super Map<String, Boolean>, Unit> completionCallback) {
        FileResourcesRepo.DefaultImpls.preloadFilesAndCache(this, urlMeta, completionCallback);
    }

    @Override
    public void cleanupStaleFiles() {
        FileResourcesRepo.DefaultImpls.cleanupStaleFiles(this);
    }

    @JvmStatic
    public static final void saveUrlExpiryToStore(@NotNull Pair<String, ? extends CtCacheType> urlMeta, @NotNull Pair<FileStore, InAppAssetsStore> storePair) {
        Companion.saveUrlExpiryToStore(urlMeta, storePair);
    }

    public static final /* synthetic */ FileStore access$getFileStore$p(FileResourcesRepoImpl $this) {
        return $this.fileStore;
    }

    public static final /* synthetic */ InAppAssetsStore access$getInAppAssetsStore$p(FileResourcesRepoImpl $this) {
        return $this.inAppAssetsStore;
    }

    public static final /* synthetic */ void access$updateRepoStatus(FileResourcesRepoImpl $this, Pair meta, DownloadState downloadState) {
        $this.updateRepoStatus((Pair<String, ? extends CtCacheType>)meta, downloadState);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/inapp/images/repo/FileResourcesRepoImpl$Companion;", "", "()V", "EXPIRY_OFFSET_MILLIS", "", "downloadInProgressUrls", "Ljava/util/HashMap;", "", "Lcom/clevertap/android/sdk/inapp/images/repo/DownloadState;", "Lkotlin/collections/HashMap;", "fetchAllFilesLock", "urlTriggers", "", "Lcom/clevertap/android/sdk/inapp/images/repo/DownloadTriggerForUrls;", "saveUrlExpiryToStore", "", "urlMeta", "Lkotlin/Pair;", "Lcom/clevertap/android/sdk/inapp/data/CtCacheType;", "storePair", "Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void saveUrlExpiryToStore(@NotNull Pair<String, ? extends CtCacheType> urlMeta, @NotNull Pair<FileStore, InAppAssetsStore> storePair) {
            Intrinsics.checkNotNullParameter(urlMeta, (String)"urlMeta");
            Intrinsics.checkNotNullParameter(storePair, (String)"storePair");
            String url = (String)urlMeta.getFirst();
            long expiry = System.currentTimeMillis() + EXPIRY_OFFSET_MILLIS;
            FileStore fileStore = (FileStore)storePair.getFirst();
            InAppAssetsStore inAppAssetsStore = (InAppAssetsStore)storePair.getSecond();
            switch (WhenMappings.$EnumSwitchMapping$0[((CtCacheType)((Object)urlMeta.getSecond())).ordinal()]) {
                case 1: 
                case 2: {
                    inAppAssetsStore.saveAssetUrl(url, expiry);
                    fileStore.saveFileUrl(url, expiry);
                    break;
                }
                case 3: {
                    fileStore.saveFileUrl(url, expiry);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CtCacheType.values().length];
                try {
                    nArray[CtCacheType.IMAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CtCacheType.GIF.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CtCacheType.FILES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CtCacheType.values().length];
            try {
                nArray[CtCacheType.IMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CtCacheType.GIF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CtCacheType.FILES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

