/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.BitmapInputStreamDecoder;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/clevertap/android/sdk/bitmap/GzipBitmapInputStreamReader;", "Lcom/clevertap/android/sdk/bitmap/BitmapInputStreamDecoder;", "saveBytes", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "(ZLcom/clevertap/android/sdk/Logger;)V", "getDownloadedBitmapFromStream", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "dataReadFromStream", "Ljava/io/ByteArrayOutputStream;", "downloadStartTimeInMilliseconds", "", "readInputStream", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "clevertap-core_release"})
public final class GzipBitmapInputStreamReader
extends BitmapInputStreamDecoder {
    public GzipBitmapInputStreamReader(boolean saveBytes, @Nullable Logger logger) {
        super(saveBytes, false, logger, 2, null);
    }

    public /* synthetic */ GzipBitmapInputStreamReader(boolean bl, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            logger = null;
        }
        this(bl, logger);
    }

    @Override
    @NotNull
    public DownloadedBitmap readInputStream(@NotNull InputStream inputStream, @NotNull HttpURLConnection connection, long downloadStartTimeInMilliseconds) {
        boolean isGZipEncoded;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Logger.v("reading bitmap input stream in GzipBitmapInputStreamReader....");
        String string2 = connection.getContentEncoding();
        boolean bl = isGZipEncoded = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"gzip", (boolean)false, (int)2, null) : false;
        if (isGZipEncoded) {
            GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
            byte[] bufferForGzipInputStream = new byte[16384];
            ByteArrayOutputStream decompressedFile = new ByteArrayOutputStream();
            int totalBytesRead = 0;
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = gzipInputStream.read(bufferForGzipInputStream);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                totalBytesRead += bytesRead;
                decompressedFile.write(bufferForGzipInputStream, 0, bytesRead);
            }
            Logger logger = this.getLogger();
            if (logger != null) {
                logger.verbose("Total decompressed download size for bitmap from output stream = " + decompressedFile.size());
            }
            return this.getDownloadedBitmapFromStream(decompressedFile, downloadStartTimeInMilliseconds);
        }
        return super.readInputStream(inputStream, connection, downloadStartTimeInMilliseconds);
    }

    private final DownloadedBitmap getDownloadedBitmapFromStream(ByteArrayOutputStream dataReadFromStream, long downloadStartTimeInMilliseconds) {
        byte[] dataReadFromStreamInByteArray = dataReadFromStream.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])dataReadFromStreamInByteArray, (int)0, (int)dataReadFromStreamInByteArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return DownloadedBitmapFactory.successBitmap$default(DownloadedBitmapFactory.INSTANCE, bitmap, Utils.getNowInMillis() - downloadStartTimeInMilliseconds, null, 4, null);
    }

    public GzipBitmapInputStreamReader() {
        this(false, null, 3, null);
    }
}

