/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.utils.CacheKt;
import com.clevertap.android.sdk.utils.UrlHashGenerator;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0012J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/utils/DiskMemory;", "", "directory", "Ljava/io/File;", "maxFileSizeKb", "", "logger", "Lcom/clevertap/android/sdk/ILogger;", "hashFunction", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "key", "(Ljava/io/File;ILcom/clevertap/android/sdk/ILogger;Lkotlin/jvm/functions/Function1;)V", "getHashFunction$clevertap_core_release", "()Lkotlin/jvm/functions/Function1;", "add", "", "value", "", "addAndReturnFileInstance", "empty", "fetchFile", "get", "remove", "Companion", "clevertap-core_release"})
public final class DiskMemory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File directory;
    private final int maxFileSizeKb;
    @Nullable
    private final ILogger logger;
    @NotNull
    private final Function1<String, String> hashFunction;
    @NotNull
    private static final String FILE_PREFIX = "CT_FILE";

    public DiskMemory(@NotNull File directory, int maxFileSizeKb, @Nullable ILogger logger, @NotNull Function1<? super String, String> hashFunction) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(hashFunction, (String)"hashFunction");
        this.directory = directory;
        this.maxFileSizeKb = maxFileSizeKb;
        this.logger = logger;
        this.hashFunction = hashFunction;
    }

    public /* synthetic */ DiskMemory(File file, int n, ILogger iLogger, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            iLogger = null;
        }
        if ((n2 & 8) != 0) {
            function1 = UrlHashGenerator.INSTANCE.hash();
        }
        this(file, n, iLogger, function1);
    }

    @NotNull
    public final Function1<String, String> getHashFunction$clevertap_core_release() {
        return this.hashFunction;
    }

    public final boolean add(@NotNull String key, @NotNull byte[] value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            this.addAndReturnFileInstance(key, value);
            bl = true;
        }
        catch (Exception e) {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("Error while adding file to disk. Key: " + key + ", Value Size: " + value.length + " bytes", e);
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final File addAndReturnFileInstance(@NotNull String key, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (CacheKt.sizeInKb(value) > this.maxFileSizeKb) {
            this.remove(key);
            throw new IllegalArgumentException("File size exceeds the maximum limit of " + this.maxFileSizeKb);
        }
        File file = this.fetchFile(key);
        if (file.exists()) {
            file.delete();
        }
        File newFile = this.fetchFile(key);
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "mapped file path - " + newFile.getAbsoluteFile() + " to key - " + key);
        }
        FileOutputStream os = new FileOutputStream(newFile);
        os.write(value);
        os.close();
        return newFile;
    }

    @Nullable
    public final File get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        File file = this.fetchFile(key);
        return file.exists() ? file : (File)null;
    }

    public final boolean remove(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        File file = this.fetchFile(key);
        if (file.exists()) {
            file.delete();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean empty() {
        return FilesKt.deleteRecursively((File)this.directory);
    }

    private final File fetchFile(String key) {
        String filePath = this.directory + "/CT_FILE_" + (String)this.hashFunction.invoke((Object)key);
        return new File(filePath);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/sdk/utils/DiskMemory$Companion;", "", "()V", "FILE_PREFIX", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

