/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductConfigResponse
extends CleverTapResponseDecorator {
    private final CleverTapInstanceConfig config;
    private final CoreMetaData coreMetaData;
    private final Logger logger;
    private final ControllerManager controllerManager;

    public ProductConfigResponse(CleverTapInstanceConfig config, CoreMetaData coreMetaData, ControllerManager controllerManager) {
        this.config = config;
        this.logger = this.config.getLogger();
        this.coreMetaData = coreMetaData;
        this.controllerManager = controllerManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        this.logger.verbose(this.config.getAccountId(), "Processing Product Config response...");
        if (this.config.isAnalyticsOnly()) {
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing Product Config response");
            return;
        }
        if (response == null) {
            this.logger.verbose(this.config.getAccountId(), "Product Config : Can't parse Product Config Response, JSON response object is null");
            this.onProductConfigFailed();
            return;
        }
        if (!response.has("pc_notifs")) {
            this.logger.verbose(this.config.getAccountId(), "Product Config : JSON object doesn't contain the Product Config key");
            this.onProductConfigFailed();
            return;
        }
        try {
            this.logger.verbose(this.config.getAccountId(), "Product Config : Processing Product Config response");
            this.parseProductConfigs(response.getJSONObject("pc_notifs"));
        }
        catch (Throwable t) {
            this.onProductConfigFailed();
            this.logger.verbose(this.config.getAccountId(), "Product Config : Failed to parse Product Config response", t);
        }
    }

    private void onProductConfigFailed() {
        if (this.coreMetaData.isProductConfigRequested()) {
            if (this.controllerManager.getCTProductConfigController() != null) {
                this.controllerManager.getCTProductConfigController().onFetchFailed();
            }
            this.coreMetaData.setProductConfigRequested(false);
        }
    }

    private void parseProductConfigs(JSONObject responseKV) throws JSONException {
        JSONArray kvArray = responseKV.getJSONArray("kv");
        if (kvArray != null && this.controllerManager.getCTProductConfigController() != null) {
            this.controllerManager.getCTProductConfigController().onFetchSuccess(responseKV);
        } else {
            this.onProductConfigFailed();
        }
    }
}

