/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.db.CtDatabaseKt;
import com.clevertap.android.sdk.db.Table;
import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/clevertap/android/sdk/db/DatabaseHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "dbName", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Ljava/lang/String;Lcom/clevertap/android/sdk/Logger;)V", "getConfig", "()Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "getContext", "()Landroid/content/Context;", "databaseFile", "Ljava/io/File;", "belowMemThreshold", "", "deleteDatabase", "", "executeStatement", "db", "Landroid/database/sqlite/SQLiteDatabase;", "statement", "getDeviceIdForAccountIdFromPrefs", "accountId", "migrateDataString", "dataString", "migrateUserProfilesTable", "onCreate", "onUpgrade", "oldVersion", "", "newVersion", "Companion", "clevertap-core_release"})
public final class DatabaseHelper
extends SQLiteOpenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final Logger logger;
    @NotNull
    private final File databaseFile;
    private static final int DATABASE_VERSION = 4;
    private static final int DB_LIMIT = 0x1400000;

    public DatabaseHelper(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @Nullable String dbName, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(context, dbName, null, 4);
        this.context = context;
        this.config = config;
        this.logger = logger;
        File file = this.context.getDatabasePath(dbName);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDatabasePath(dbName)");
        this.databaseFile = file;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CleverTapInstanceConfig getConfig() {
        return this.config;
    }

    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.logger.verbose("Creating CleverTap DB");
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_EVENTS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_PROFILE_EVENTS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_USER_PROFILES_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_INBOX_MESSAGES_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_PUSH_NOTIFICATIONS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_UNINSTALL_TS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_NOTIFICATION_VIEWED_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getEVENTS_TIME_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getPROFILE_EVENTS_TIME_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getUNINSTALL_TS_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getPUSH_NOTIFICATIONS_TIME_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getINBOX_MESSAGES_COMP_ID_USERID_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getNOTIFICATION_VIEWED_INDEX$p());
    }

    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.logger.verbose("Upgrading CleverTap DB to version " + newVersion);
        switch (oldVersion) {
            case 1: {
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_UNINSTALL_TS$p());
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_INBOX_MESSAGES$p());
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_PUSH_NOTIFICATION_VIEWED$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_INBOX_MESSAGES_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_PUSH_NOTIFICATIONS_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_UNINSTALL_TS_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_NOTIFICATION_VIEWED_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getUNINSTALL_TS_INDEX$p());
                this.executeStatement(db, CtDatabaseKt.access$getPUSH_NOTIFICATIONS_TIME_INDEX$p());
                this.executeStatement(db, CtDatabaseKt.access$getINBOX_MESSAGES_COMP_ID_USERID_INDEX$p());
                this.executeStatement(db, CtDatabaseKt.access$getNOTIFICATION_VIEWED_INDEX$p());
                this.migrateUserProfilesTable(db);
                break;
            }
            case 2: {
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_PUSH_NOTIFICATION_VIEWED$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_NOTIFICATION_VIEWED_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getNOTIFICATION_VIEWED_INDEX$p());
                this.migrateUserProfilesTable(db);
                break;
            }
            case 3: {
                this.migrateUserProfilesTable(db);
            }
        }
    }

    private final String getDeviceIdForAccountIdFromPrefs(String accountId) {
        String string2;
        String baseKey = "deviceId:" + accountId;
        String fallbackKey = "fallbackId:" + accountId;
        String string3 = StorageHelper.getString(this.context, baseKey, null);
        if (string3 == null) {
            String string4 = this.config.isDefaultInstance() ? StorageHelper.getString(this.context, baseKey, null) : StorageHelper.getString(this.context, fallbackKey, "");
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"if (config.isDefaultInst\u2026context, fallbackKey, \"\")");
        } else {
            string2 = string3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void migrateUserProfilesTable(SQLiteDatabase db) {
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_TEMP_USER_PROFILES_TABLE$p());
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.accountId");
        String deviceId = this.getDeviceIdForAccountIdFromPrefs(string2);
        String selectQuery = "SELECT _id, data FROM " + Table.USER_PROFILES.getTableName() + ';';
        Cursor cursor = db.rawQuery(selectQuery, null);
        Closeable closeable = (Closeable)cursor;
        Throwable throwable = null;
        try {
            Cursor it = (Cursor)closeable;
            boolean bl = false;
            if (cursor.moveToFirst()) {
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                String dataString = cursor.getString(cursor.getColumnIndexOrThrow("data"));
                Intrinsics.checkNotNullExpressionValue((Object)dataString, (String)"dataString");
                String updatedDataString = this.migrateDataString(dataString);
                String insertQuery = "INSERT INTO temp_" + Table.USER_PROFILES.getTableName() + " (_id, deviceID, data)\n                                 VALUES ('" + id2 + "', '" + deviceId + "', '" + updatedDataString + "');";
                this.executeStatement(db, insertQuery);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.executeStatement(db, CtDatabaseKt.access$getDROP_USER_PROFILES_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getRENAME_USER_PROFILES_TABLE$p());
    }

    private final String migrateDataString(String dataString) {
        String string2;
        try {
            JSONObject jsonObject = new JSONObject(dataString);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = jsonObject.get(key);
                if (value instanceof String && StringsKt.startsWith$default((String)((String)value), (String)"$D_", (boolean)false, (int)2, null)) {
                    value = Long.parseLong(StringsKt.removePrefix((String)((String)value), (CharSequence)"$D_"));
                    jsonObject.put(key, ((Number)value).longValue());
                }
                if (!(value instanceof JSONObject)) continue;
                if (((JSONObject)value).has("$set")) {
                    jsonObject.put(key, (Object)((JSONObject)value).getJSONArray("$set"));
                    continue;
                }
                if (!((JSONObject)value).has("$add")) continue;
                jsonObject.put(key, (Object)((JSONObject)value).getJSONArray("$add"));
            }
            string2 = jsonObject.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            val jsonOb\u2026ject.toString()\n        }");
        }
        catch (JSONException e) {
            this.logger.verbose("Error while migrating data column for userProfiles table for data = " + dataString, e);
            string2 = dataString;
        }
        return string2;
    }

    @SuppressLint(value={"UsableSpace"})
    public final boolean belowMemThreshold() {
        return this.databaseFile.exists() ? Math.max(this.databaseFile.getUsableSpace(), 0x1400000L) >= this.databaseFile.length() : true;
    }

    public final void deleteDatabase() {
        this.close();
        if (!this.databaseFile.delete()) {
            this.logger.debug("Could not delete database");
        }
    }

    private final void executeStatement(SQLiteDatabase db, String statement) {
        SQLiteStatement sqLiteStatement = db.compileStatement(statement);
        this.logger.verbose("Executing - " + statement);
        sqLiteStatement.execute();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/db/DatabaseHelper$Companion;", "", "()V", "DATABASE_VERSION", "", "DB_LIMIT", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

