/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u000ej\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\u000fH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J,\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0001H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/clevertap/android/sdk/ProfileValueHandler;", "", "validator", "Lcom/clevertap/android/sdk/validation/Validator;", "validationResultStack", "Lcom/clevertap/android/sdk/validation/ValidationResultStack;", "(Lcom/clevertap/android/sdk/validation/Validator;Lcom/clevertap/android/sdk/validation/ValidationResultStack;)V", "numberValueType", "Lcom/clevertap/android/sdk/ProfileValueHandler$NumberValueType;", "cleanMultiValues", "Lorg/json/JSONArray;", "key", "", "values", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "constructExistingMultiValue", "command", "existing", "generateEmptyMultiValueError", "", "getNumberValueType", "value", "", "handleIncrementDecrementValues", "existingValue", "handleMultiValues", "existingValues", "stringifyAndCleanScalarProfilePropValue", "NumberValueType", "clevertap-core_release"})
public final class ProfileValueHandler {
    @NotNull
    private final Validator validator;
    @NotNull
    private final ValidationResultStack validationResultStack;
    @Nullable
    private NumberValueType numberValueType;

    public ProfileValueHandler(@NotNull Validator validator, @NotNull ValidationResultStack validationResultStack) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)validationResultStack, (String)"validationResultStack");
        this.validator = validator;
        this.validationResultStack = validationResultStack;
    }

    @Nullable
    public final Number handleIncrementDecrementValues(@NotNull Number value, @NotNull String command, @Nullable Number existingValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Number updatedValue = null;
        if (existingValue == null) {
            NumberValueType numberValueType = this.getNumberValueType(value);
            switch (numberValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[numberValueType.ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                        updatedValue = value.doubleValue();
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                    updatedValue = -value.doubleValue();
                    break;
                }
                case 2: {
                    if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                        updatedValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                    updatedValue = Float.valueOf(-value.floatValue());
                    break;
                }
                default: {
                    if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                        updatedValue = value.intValue();
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                    updatedValue = -value.intValue();
                }
            }
            return updatedValue;
        }
        NumberValueType numberValueType = this.getNumberValueType(existingValue);
        switch (numberValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[numberValueType.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                    updatedValue = existingValue.doubleValue() + value.doubleValue();
                    break;
                }
                if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                updatedValue = existingValue.doubleValue() - value.doubleValue();
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                    updatedValue = Float.valueOf(existingValue.floatValue() + value.floatValue());
                    break;
                }
                if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                updatedValue = Float.valueOf(existingValue.floatValue() - value.floatValue());
                break;
            }
            default: {
                if (Intrinsics.areEqual((Object)command, (Object)"$incr")) {
                    updatedValue = existingValue.intValue() + value.intValue();
                    break;
                }
                if (!Intrinsics.areEqual((Object)command, (Object)"$decr")) break;
                updatedValue = existingValue.intValue() - value.intValue();
            }
        }
        return updatedValue;
    }

    private final NumberValueType getNumberValueType(Number value) {
        Number number = value;
        return Intrinsics.areEqual((Object)number, (Object)value.intValue()) ? NumberValueType.INT_NUMBER : (Intrinsics.areEqual((Object)number, (Object)value.doubleValue()) ? NumberValueType.DOUBLE_NUMBER : (Intrinsics.areEqual((Object)number, (Object)Float.valueOf(value.floatValue())) ? NumberValueType.FLOAT_NUMBER : this.numberValueType));
    }

    @Nullable
    public final JSONArray handleMultiValues(@NotNull String key, @Nullable JSONArray values, @NotNull String command, @Nullable Object existingValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        JSONArray currentValues = this.constructExistingMultiValue(command, existingValues);
        JSONArray jSONArray = values;
        Intrinsics.checkNotNull((Object)jSONArray);
        ArrayList<String> arrayList = CTJsonConverter.toList(jSONArray);
        Intrinsics.checkNotNull(arrayList, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.String>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.String> }");
        JSONArray newValues = this.cleanMultiValues(key, arrayList);
        if (currentValues == null || newValues == null) {
            return null;
        }
        String mergeOperation = Intrinsics.areEqual((Object)command, (Object)"$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
        ValidationResult vr = this.validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
        if (vr.getErrorCode() != 0) {
            this.validationResultStack.pushValidationResult(vr);
        }
        Object object = vr.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONArray");
        JSONArray localValues = (JSONArray)object;
        return localValues.length() <= 0 ? (JSONArray)null : localValues;
    }

    private final JSONArray constructExistingMultiValue(String command, Object existing) {
        boolean remove = Intrinsics.areEqual((Object)command, (Object)"$remove");
        boolean add = Intrinsics.areEqual((Object)command, (Object)"$add");
        if (!remove && !add) {
            return new JSONArray();
        }
        if (existing == null) {
            return remove ? (JSONArray)null : new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray jSONArray = add ? new JSONArray() : null;
        String stringified = this.stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : jSONArray;
    }

    private final JSONArray cleanMultiValues(String key, ArrayList<String> values) {
        JSONArray jSONArray;
        try {
            if (values == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            ValidationResult vr = null;
            for (String value : values) {
                Object vrValue;
                Intrinsics.checkNotNullExpressionValue((Object)this.validator.cleanMultiValuePropertyValue(value), (String)"validator.cleanMultiValuePropertyValue(value)");
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                String cleanedValue = (vrValue = vr.getObject()) != null ? vr.getObject().toString() : null;
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (((CharSequence)value).length() == 0) {
                    this.generateEmptyMultiValueError(key);
                    return null;
                }
                cleanedValues.put((Object)cleanedValue);
            }
        }
        catch (Throwable t) {
            Logger.v("Error cleaning multi values for key " + key, t);
            this.generateEmptyMultiValueError(key);
            jSONArray = null;
        }
        return jSONArray;
    }

    private final void generateEmptyMultiValueError(String key) {
        String[] stringArray = new String[]{key};
        ValidationResult error = ValidationResultFactory.create(512, 1, stringArray);
        this.validationResultStack.pushValidationResult(error);
        Logger.v(error.getErrorDesc());
    }

    private final String stringifyAndCleanScalarProfilePropValue(Object value) {
        String cleanedValue = CTJsonConverter.toJsonString(value);
        if (cleanedValue != null) {
            Object vrValue;
            ValidationResult vr = this.validator.cleanMultiValuePropertyValue(cleanedValue);
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            cleanedValue = (vrValue = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return cleanedValue;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/ProfileValueHandler$NumberValueType;", "", "(Ljava/lang/String;I)V", "INT_NUMBER", "FLOAT_NUMBER", "DOUBLE_NUMBER", "clevertap-core_release"})
    public static final class NumberValueType
    extends Enum<NumberValueType> {
        public static final /* enum */ NumberValueType INT_NUMBER = new NumberValueType();
        public static final /* enum */ NumberValueType FLOAT_NUMBER = new NumberValueType();
        public static final /* enum */ NumberValueType DOUBLE_NUMBER = new NumberValueType();
        private static final /* synthetic */ NumberValueType[] $VALUES;

        public static NumberValueType[] values() {
            return (NumberValueType[])$VALUES.clone();
        }

        public static NumberValueType valueOf(String value) {
            return Enum.valueOf(NumberValueType.class, value);
        }

        static {
            $VALUES = numberValueTypeArray = new NumberValueType[]{NumberValueType.INT_NUMBER, NumberValueType.FLOAT_NUMBER, NumberValueType.DOUBLE_NUMBER};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NumberValueType.values().length];
            try {
                nArray[NumberValueType.DOUBLE_NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberValueType.FLOAT_NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

