/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation;

import android.app.Application;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.clevertap.android.sdk.ActivityLifecycleCallback;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.pushnotification.CTNotificationIntentService;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationReceiver;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import java.util.ArrayList;

public final class ManifestValidator {
    private static final String ourApplicationClassName = "com.clevertap.android.sdk.Application";

    public static void validate(Context context, DeviceInfo deviceInfo, PushProviders pushProviders) {
        if (!Utils.hasPermission(context, "android.permission.INTERNET")) {
            Logger.d("Missing Permission: android.permission.INTERNET");
        }
        ManifestValidator.checkSDKVersion(deviceInfo);
        ManifestValidator.validationApplicationLifecyleCallback(context);
        ManifestValidator.checkReceiversServices(context, pushProviders);
        if (!TextUtils.isEmpty((CharSequence)ManifestInfo.getInstance(context).getFCMSenderId())) {
            Logger.i("We have noticed that your app is using a custom FCM Sender ID, this feature will be DISCONTINUED from the next version of the CleverTap Android SDK. With the next release, CleverTap Android SDK will only fetch the token using the google-services.json. Please reach out to CleverTap Support for any questions.");
        }
    }

    private static void checkApplicationClass(Context context) {
        String appName = context.getApplicationInfo().className;
        if (appName == null || appName.isEmpty()) {
            Logger.i("Unable to determine Application Class");
        } else if (appName.equals(ourApplicationClassName)) {
            Logger.i("AndroidManifest.xml uses the CleverTap Application class, be sure you have properly added the CleverTap Account ID and Token to your AndroidManifest.xml, \nor set them programmatically in the onCreate method of your custom application class prior to calling super.onCreate()");
        } else {
            Logger.i("Application Class is " + appName);
        }
    }

    private static void checkReceiversServices(Context context, PushProviders pushProviders) {
        try {
            ManifestValidator.validateReceiverInManifest((Application)context.getApplicationContext(), CTPushNotificationReceiver.class.getName());
            ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), CTNotificationIntentService.class.getName());
            ManifestValidator.validateActivityInManifest((Application)context.getApplicationContext(), InAppNotificationActivity.class);
            ManifestValidator.validateActivityInManifest((Application)context.getApplicationContext(), CTInboxActivity.class);
            ManifestValidator.validateReceiverInManifest((Application)context.getApplicationContext(), "com.clevertap.android.geofence.CTGeofenceReceiver");
            ManifestValidator.validateReceiverInManifest((Application)context.getApplicationContext(), "com.clevertap.android.geofence.CTLocationUpdateReceiver");
            ManifestValidator.validateReceiverInManifest((Application)context.getApplicationContext(), "com.clevertap.android.geofence.CTGeofenceBootReceiver");
        }
        catch (Exception e) {
            Logger.v("Receiver/Service issue : " + e.toString());
        }
        ArrayList<PushConstants.PushType> enabledPushTypes = pushProviders.getAvailablePushTypes();
        if (enabledPushTypes == null) {
            return;
        }
        for (PushConstants.PushType pushType : enabledPushTypes) {
            if (pushType == PushConstants.PushType.FCM) {
                try {
                    ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), "com.clevertap.android.sdk.pushnotification.fcm.FcmMessageListenerService");
                }
                catch (Exception e) {
                    Logger.v("Receiver/Service issue : " + e.toString());
                }
                catch (Error error) {
                    Logger.v("FATAL : " + error.getMessage());
                }
                continue;
            }
            if (pushType != PushConstants.PushType.HPS) continue;
            try {
                ManifestValidator.validateServiceInManifest((Application)context.getApplicationContext(), "com.clevertap.android.hms.CTHmsMessageService");
            }
            catch (Exception e) {
                Logger.v("Receiver/Service issue : " + e.toString());
            }
            catch (Error error) {
                Logger.v("FATAL : " + error.getMessage());
            }
        }
    }

    private static void checkSDKVersion(DeviceInfo deviceInfo) {
        Logger.i("SDK Version Code is " + deviceInfo.getSdkVersion());
    }

    private static void validateActivityInManifest(Application application, Class activityClass) throws PackageManager.NameNotFoundException {
        PackageManager pm = application.getPackageManager();
        String packageName = application.getPackageName();
        PackageInfo packageInfo = pm.getPackageInfo(packageName, 1);
        ActivityInfo[] activities = packageInfo.activities;
        String activityClassName = activityClass.getName();
        for (ActivityInfo activityInfo : activities) {
            if (!activityInfo.name.equals(activityClassName)) continue;
            Logger.i(activityClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
            return;
        }
        Logger.i(activityClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
    }

    private static void validateReceiverInManifest(Application application, String receiverClassName) throws PackageManager.NameNotFoundException {
        ActivityInfo[] receivers;
        PackageManager pm = application.getPackageManager();
        String packageName = application.getPackageName();
        PackageInfo packageInfo = pm.getPackageInfo(packageName, 2);
        for (ActivityInfo activityInfo : receivers = packageInfo.receivers) {
            if (!activityInfo.name.equals(receiverClassName)) continue;
            Logger.i(receiverClassName.replaceFirst("com.clevertap.android.", "") + " is present");
            return;
        }
        Logger.i(receiverClassName.replaceFirst("com.clevertap.android.", "") + " not present");
    }

    private static void validateServiceInManifest(Application application, String serviceClassName) throws PackageManager.NameNotFoundException {
        ServiceInfo[] services;
        PackageManager pm = application.getPackageManager();
        String packageName = application.getPackageName();
        PackageInfo packageInfo = pm.getPackageInfo(packageName, 4);
        for (ServiceInfo serviceInfo : services = packageInfo.services) {
            if (!serviceInfo.name.equals(serviceClassName)) continue;
            Logger.i(serviceClassName.replaceFirst("com.clevertap.android.sdk.", "") + " is present");
            return;
        }
        Logger.i(serviceClassName.replaceFirst("com.clevertap.android.sdk.", "") + " not present");
    }

    private static void validationApplicationLifecyleCallback(Context context) {
        if (!ActivityLifecycleCallback.registered && !CleverTapAPI.isAppForeground()) {
            Logger.i("Activity Lifecycle Callback not registered. Either set the android:name in your AndroidManifest.xml application tag to com.clevertap.android.sdk.Application, \n or, if you have a custom Application class, call ActivityLifecycleCallback.register(this); before super.onCreate() in your class");
            ManifestValidator.checkApplicationClass(context);
        }
    }
}

