/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images.memory;

import android.graphics.Bitmap;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.images.memory.MemoryAccessObject;
import com.clevertap.android.sdk.inapp.images.memory.MemoryAccessObjectKt;
import com.clevertap.android.sdk.inapp.images.memory.MemoryDataTransformationType;
import com.clevertap.android.sdk.utils.CTCaches;
import com.clevertap.android.sdk.utils.DiskMemory;
import com.clevertap.android.sdk.utils.InMemoryLruCache;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J+\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J+\u0010\u0013\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/inapp/images/memory/InAppImageMemoryAccessObjectV1;", "Lcom/clevertap/android/sdk/inapp/images/memory/MemoryAccessObject;", "Landroid/graphics/Bitmap;", "ctCaches", "Lcom/clevertap/android/sdk/utils/CTCaches;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "(Lcom/clevertap/android/sdk/utils/CTCaches;Lcom/clevertap/android/sdk/ILogger;)V", "fetchDiskMemory", "Ljava/io/File;", "key", "", "fetchDiskMemoryAndTransform", "A", "transformTo", "Lcom/clevertap/android/sdk/inapp/images/memory/MemoryDataTransformationType;", "(Ljava/lang/String;Lcom/clevertap/android/sdk/inapp/images/memory/MemoryDataTransformationType;)Ljava/lang/Object;", "fetchInMemory", "Lkotlin/Pair;", "fetchInMemoryAndTransform", "removeDiskMemory", "", "removeInMemory", "saveDiskMemory", "data", "", "saveInMemory", "clevertap-core_release"})
public final class InAppImageMemoryAccessObjectV1
implements MemoryAccessObject<Bitmap> {
    @NotNull
    private final CTCaches ctCaches;
    @Nullable
    private final ILogger logger;

    public InAppImageMemoryAccessObjectV1(@NotNull CTCaches ctCaches, @Nullable ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)ctCaches, (String)"ctCaches");
        this.ctCaches = ctCaches;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Pair<Bitmap, File> fetchInMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        InMemoryLruCache<Pair<Bitmap, File>> imageInMemory = this.ctCaches.imageInMemory();
        return imageInMemory.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public <A> A fetchInMemoryAndTransform(@NotNull String key, @NotNull MemoryDataTransformationType<A> transformTo) {
        Object object;
        Pair<Bitmap, File> pair;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(transformTo, (String)"transformTo");
        Pair<Bitmap, File> pair2 = pair = this.fetchInMemory(key);
        if (pair2 != null) {
            Pair<Bitmap, File> it = pair2;
            boolean bl = false;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", key + " data found in image in-memory");
            }
            MemoryDataTransformationType<A> memoryDataTransformationType = transformTo;
            if (Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToBitmap.INSTANCE)) {
                object = it.getFirst();
                if (object != null) return (A)object;
                object = null;
                return (A)object;
            } else if (Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToByteArray.INSTANCE)) {
                Function1<Bitmap, byte[]> function1 = MemoryAccessObjectKt.getBitmapToBytes();
                Object object2 = it.getFirst();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.graphics.Bitmap");
                object = function1.invoke((Object)((Bitmap)object2));
                if (object != null) return (A)object;
                object = null;
                return (A)object;
            } else {
                if (!Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToFile.INSTANCE)) throw new NoWhenBranchMatchedException();
                object = it.getSecond();
                if (object != null) return (A)object;
                object = null;
            }
            return (A)object;
        } else {
            object = null;
        }
        return (A)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public <A> A fetchDiskMemoryAndTransform(@NotNull String key, @NotNull MemoryDataTransformationType<A> transformTo) {
        Object object;
        File file;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(transformTo, (String)"transformTo");
        File file2 = file = this.fetchDiskMemory(key);
        if (file2 != null) {
            MemoryDataTransformationType<A> memoryDataTransformationType;
            File it = file2;
            boolean bl = false;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", key + " data found in image disk memory");
            }
            Bitmap bitmap = (Bitmap)MemoryAccessObjectKt.getFileToBitmap().invoke((Object)it);
            if (bitmap != null) {
                this.saveInMemory(key, (Pair<Bitmap, ? extends File>)new Pair((Object)bitmap, (Object)it));
            }
            if (Intrinsics.areEqual(memoryDataTransformationType = transformTo, (Object)MemoryDataTransformationType.ToBitmap.INSTANCE)) {
                object = bitmap instanceof Object ? bitmap : null;
                return (A)object;
            } else if (Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToByteArray.INSTANCE)) {
                object = MemoryAccessObjectKt.getFileToBytes().invoke((Object)it);
                if (object != null) return (A)object;
                object = null;
                return (A)object;
            } else {
                if (!Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToFile.INSTANCE)) throw new NoWhenBranchMatchedException();
                object = it instanceof Object ? it : null;
            }
            return (A)object;
        } else {
            object = null;
        }
        return (A)object;
    }

    @Override
    @Nullable
    public File fetchDiskMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "IMAGE In-Memory cache miss for " + key + " data");
        }
        DiskMemory imageDiskMemory = this.ctCaches.imageDiskMemory();
        return imageDiskMemory.get(key);
    }

    @Override
    public boolean saveInMemory(@NotNull String key, @NotNull Pair<Bitmap, ? extends File> data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "Saving " + key + " data in IMAGE in-memory");
        }
        InMemoryLruCache<Pair<Bitmap, File>> imageInMemory = this.ctCaches.imageInMemory();
        return imageInMemory.add(key, data);
    }

    @Override
    @NotNull
    public File saveDiskMemory(@NotNull String key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DiskMemory imageDiskMemory = this.ctCaches.imageDiskMemory();
        return imageDiskMemory.addAndReturnFileInstance(key, data);
    }

    @Override
    public boolean removeDiskMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "If present, will remove " + key + " data from IMAGE disk-memory");
        }
        DiskMemory imageDiskMemory = this.ctCaches.imageDiskMemory();
        return imageDiskMemory.remove(key);
    }

    @Override
    @Nullable
    public Pair<Bitmap, File> removeInMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "If present, will remove " + key + " data from IMAGE in-memory");
        }
        InMemoryLruCache<Pair<Bitmap, File>> imageInMemory = this.ctCaches.imageInMemory();
        return imageInMemory.remove(key);
    }
}

