/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import android.content.Context;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBManager;
import com.clevertap.android.sdk.events.BaseEventQueueManager;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsController;
import com.clevertap.android.sdk.login.ChangeUserCallback;
import com.clevertap.android.sdk.login.IdentityRepo;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.product_config.CTProductConfigFactory;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class LoginController {
    private String cachedGUID = null;
    private final AnalyticsManager analyticsManager;
    private final BaseEventQueueManager baseEventQueueManager;
    private final CTLockManager ctLockManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private final BaseDatabaseManager dbManager;
    private final DeviceInfo deviceInfo;
    private final LocalDataStore localDataStore;
    private final PushProviders pushProviders;
    private final SessionManager sessionManager;
    private final ValidationResultStack validationResultStack;
    private final CryptHandler cryptHandler;

    public LoginController(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, ValidationResultStack validationResultStack, BaseEventQueueManager eventQueueManager, AnalyticsManager analyticsManager, CoreMetaData coreMetaData, ControllerManager controllerManager, SessionManager sessionManager, LocalDataStore localDataStore, BaseCallbackManager callbackManager, DBManager dbManager, CTLockManager ctLockManager, CryptHandler cryptHandler) {
        this.config = config;
        this.context = context;
        this.deviceInfo = deviceInfo;
        this.validationResultStack = validationResultStack;
        this.baseEventQueueManager = eventQueueManager;
        this.analyticsManager = analyticsManager;
        this.coreMetaData = coreMetaData;
        this.pushProviders = controllerManager.getPushProviders();
        this.sessionManager = sessionManager;
        this.localDataStore = localDataStore;
        this.callbackManager = callbackManager;
        this.dbManager = dbManager;
        this.controllerManager = controllerManager;
        this.ctLockManager = ctLockManager;
        this.cryptHandler = cryptHandler;
    }

    public void asyncProfileSwitchUser(final Map<String, Object> profile, final String cacheGuid, final String cleverTapID) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("resetProfile", new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    LoginController.this.config.getLogger().verbose(LoginController.this.config.getAccountId(), "asyncProfileSwitchUser:[profile " + profile + " with Cached GUID " + (cacheGuid != null ? LoginController.this.cachedGUID : "NULL and cleverTapID " + cleverTapID));
                    LoginController.this.coreMetaData.setCurrentUserOptedOut(false);
                    LoginController.this.pushProviders.forcePushDeviceToken(false);
                    LoginController.this.baseEventQueueManager.flushQueueSync(LoginController.this.context, EventGroup.REGULAR);
                    LoginController.this.baseEventQueueManager.flushQueueSync(LoginController.this.context, EventGroup.PUSH_NOTIFICATION_VIEWED);
                    LoginController.this.dbManager.clearQueues(LoginController.this.context);
                    CoreMetaData.setActivityCount(1);
                    LoginController.this.sessionManager.destroySession();
                    if (cacheGuid != null) {
                        LoginController.this.deviceInfo.forceUpdateDeviceId(cacheGuid);
                        LoginController.this.callbackManager.notifyUserProfileInitialized(cacheGuid);
                    } else if (LoginController.this.config.getEnableCustomCleverTapId()) {
                        LoginController.this.deviceInfo.forceUpdateCustomCleverTapID(cleverTapID);
                    } else {
                        LoginController.this.deviceInfo.forceNewDeviceID();
                    }
                    LoginController.this.localDataStore.changeUser();
                    LoginController.this.callbackManager.notifyUserProfileInitialized(LoginController.this.deviceInfo.getDeviceID());
                    LoginController.this.deviceInfo.setCurrentUserOptOutStateFromStorage();
                    LoginController.this.resetVariables();
                    LoginController.this.analyticsManager.forcePushAppLaunchedEvent();
                    if (profile != null) {
                        LoginController.this.analyticsManager.pushProfile(profile);
                    }
                    LoginController.this.pushProviders.forcePushDeviceToken(true);
                    LoginController.this.resetInbox();
                    LoginController.this.resetFeatureFlags();
                    LoginController.this.resetProductConfigs();
                    LoginController.this.recordDeviceIDErrors();
                    LoginController.this.resetDisplayUnits();
                    List<ChangeUserCallback> changeUserCallbackList = LoginController.this.callbackManager.getChangeUserCallbackList();
                    for (ChangeUserCallback callback : changeUserCallbackList) {
                        callback.onChangeUser(LoginController.this.deviceInfo.getDeviceID(), LoginController.this.config.getAccountId());
                    }
                    LoginController.this.controllerManager.getInAppFCManager().changeUser(LoginController.this.deviceInfo.getDeviceID());
                }
                catch (Throwable t) {
                    LoginController.this.config.getLogger().verbose(LoginController.this.config.getAccountId(), "Reset Profile error", t);
                }
                return null;
            }
        });
    }

    public void onUserLogin(final Map<String, Object> profile, final String cleverTapID) {
        if (this.config.getEnableCustomCleverTapId()) {
            if (cleverTapID == null) {
                Logger.i("CLEVERTAP_USE_CUSTOM_ID has been specified in the AndroidManifest.xml Please call onUserlogin() and pass a custom CleverTap ID");
            }
        } else if (cleverTapID != null) {
            Logger.i("CLEVERTAP_USE_CUSTOM_ID has not been specified in the AndroidManifest.xml Please call CleverTapAPI.defaultInstance() without a custom CleverTap ID");
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("_onUserLogin", new Callable<Void>(){

            @Override
            public Void call() {
                LoginController.this._onUserLogin(profile, cleverTapID);
                return null;
            }
        });
    }

    public void recordDeviceIDErrors() {
        for (ValidationResult validationResult : this.deviceInfo.getValidationResults()) {
            this.validationResultStack.pushValidationResult(validationResult);
        }
    }

    private void _onUserLogin(Map<String, Object> profile, String cleverTapID) {
        if (profile == null) {
            return;
        }
        try {
            String currentGUID = this.deviceInfo.getDeviceID();
            if (currentGUID == null) {
                return;
            }
            boolean haveIdentifier = false;
            LoginInfoProvider loginInfoProvider = new LoginInfoProvider(this.context, this.config, this.deviceInfo, this.cryptHandler);
            IdentityRepo iProfileHandler = IdentityRepoFactory.getRepo(this.context, this.config, this.deviceInfo, this.validationResultStack);
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                boolean isProfileKey = iProfileHandler.hasIdentity(key);
                if (!isProfileKey) continue;
                try {
                    String identifier = null;
                    if (value != null) {
                        identifier = value.toString();
                    }
                    if (identifier == null || identifier.length() <= 0) continue;
                    haveIdentifier = true;
                    this.cachedGUID = loginInfoProvider.getGUIDForIdentifier(key, identifier);
                    if (this.cachedGUID == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (!(this.deviceInfo.isErrorDeviceId() || haveIdentifier && !loginInfoProvider.isAnonymousDevice())) {
                this.config.getLogger().debug(this.config.getAccountId(), "onUserLogin: no identifier provided or device is anonymous, pushing on current user profile");
                this.analyticsManager.pushProfile(profile);
                return;
            }
            if (this.cachedGUID != null && this.cachedGUID.equals(currentGUID)) {
                this.config.getLogger().debug(this.config.getAccountId(), "onUserLogin: " + profile.toString() + " maps to current device id " + currentGUID + " pushing on current profile");
                this.analyticsManager.pushProfile(profile);
                return;
            }
            this.config.getLogger().verbose(this.config.getAccountId(), "onUserLogin: queuing reset profile for " + profile + " with Cached GUID " + (this.cachedGUID != null ? this.cachedGUID : "NULL"));
            this.asyncProfileSwitchUser(profile, this.cachedGUID, cleverTapID);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "onUserLogin failed", t);
        }
    }

    private void resetDisplayUnits() {
        if (this.controllerManager.getCTDisplayUnitController() != null) {
            this.controllerManager.getCTDisplayUnitController().reset();
        } else {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Can't reset Display Units, DisplayUnitcontroller is null");
        }
    }

    private void resetFeatureFlags() {
        CTFeatureFlagsController ctFeatureFlagsController = this.controllerManager.getCTFeatureFlagsController();
        if (ctFeatureFlagsController != null && ctFeatureFlagsController.isInitialized()) {
            ctFeatureFlagsController.resetWithGuid(this.deviceInfo.getDeviceID());
            ctFeatureFlagsController.fetchFeatureFlags();
        } else {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Can't reset Display Units, CTFeatureFlagsController is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInbox() {
        Object object = this.ctLockManager.getInboxControllerLock();
        synchronized (object) {
            this.controllerManager.setCTInboxController(null);
        }
        this.controllerManager.initializeInbox();
    }

    private void resetProductConfigs() {
        if (this.config.isAnalyticsOnly()) {
            this.config.getLogger().debug(this.config.getAccountId(), "Product Config is not enabled for this instance");
            return;
        }
        if (this.controllerManager.getCTProductConfigController() != null) {
            this.controllerManager.getCTProductConfigController().resetSettings();
        }
        CTProductConfigController ctProductConfigController = CTProductConfigFactory.getInstance(this.context, this.deviceInfo, this.config, this.analyticsManager, this.coreMetaData, this.callbackManager);
        this.controllerManager.setCTProductConfigController(ctProductConfigController);
        this.config.getLogger().verbose(this.config.getAccountId(), "Product Config reset");
    }

    private void resetVariables() {
        if (this.controllerManager.getCtVariables() != null) {
            this.controllerManager.getCtVariables().clearUserContent();
        }
    }
}

