/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.store.preference;

import com.clevertap.android.sdk.store.preference.ICTPreference;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "", "ctPreference", "Lcom/clevertap/android/sdk/store/preference/ICTPreference;", "(Lcom/clevertap/android/sdk/store/preference/ICTPreference;)V", "clearAssetUrl", "", "url", "", "expiryForUrl", "", "getAllAssetUrls", "", "saveAssetUrl", "expiry", "clevertap-core_release"})
public final class InAppAssetsStore {
    @NotNull
    private final ICTPreference ctPreference;

    public InAppAssetsStore(@NotNull ICTPreference ctPreference) {
        Intrinsics.checkNotNullParameter((Object)ctPreference, (String)"ctPreference");
        this.ctPreference = ctPreference;
    }

    public final void saveAssetUrl(@NotNull String url, long expiry) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.ctPreference.writeLong(url, expiry);
    }

    public final void clearAssetUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.ctPreference.remove(url);
    }

    @NotNull
    public final Set<String> getAllAssetUrls() {
        Map<String, ?> map = this.ctPreference.readAll();
        if (map == null || (map = map.keySet()) == null) {
            map = SetsKt.emptySet();
        }
        return map;
    }

    public final long expiryForUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.ctPreference.readLong(url, 0L);
    }
}

