/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.evaluation;

import androidx.annotation.VisibleForTesting;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.inapp.evaluation.TriggerAdapterKt;
import com.clevertap.android.sdk.inapp.evaluation.TriggerCondition;
import com.clevertap.android.sdk.inapp.evaluation.TriggerGeoRadius;
import com.clevertap.android.sdk.inapp.evaluation.TriggerOperator;
import com.clevertap.android.sdk.inapp.evaluation.TriggerValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/clevertap/android/sdk/inapp/evaluation/TriggerAdapter;", "", "triggerJSON", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "eventName", "", "getEventName", "()Ljava/lang/String;", "geoRadiusArray", "Lorg/json/JSONArray;", "getGeoRadiusArray", "()Lorg/json/JSONArray;", "geoRadiusCount", "", "getGeoRadiusCount", "()I", "items", "getItems", "itemsCount", "getItemsCount", "profileAttrName", "getProfileAttrName", "properties", "getProperties", "propertyCount", "getPropertyCount", "geoRadiusAtIndex", "Lcom/clevertap/android/sdk/inapp/evaluation/TriggerGeoRadius;", "index", "itemAtIndex", "Lcom/clevertap/android/sdk/inapp/evaluation/TriggerCondition;", "propertyAtIndex", "triggerConditionFromJSON", "property", "clevertap-core_release"})
public final class TriggerAdapter {
    @NotNull
    private final String eventName;
    @Nullable
    private final JSONArray properties;
    @Nullable
    private final JSONArray items;
    @Nullable
    private final JSONArray geoRadiusArray;
    @Nullable
    private final String profileAttrName;

    public TriggerAdapter(@NotNull JSONObject triggerJSON) {
        Intrinsics.checkNotNullParameter((Object)triggerJSON, (String)"triggerJSON");
        String string2 = triggerJSON.optString("eventName", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"triggerJSON.optString(Co\u2026tants.KEY_EVENT_NAME, \"\")");
        this.eventName = string2;
        this.properties = triggerJSON.optJSONArray("eventProperties");
        this.items = triggerJSON.optJSONArray("itemProperties");
        this.geoRadiusArray = triggerJSON.optJSONArray("geoRadius");
        this.profileAttrName = triggerJSON.optString("profileAttrName", null);
    }

    @NotNull
    public final String getEventName() {
        return this.eventName;
    }

    @Nullable
    public final JSONArray getProperties() {
        return this.properties;
    }

    @Nullable
    public final JSONArray getItems() {
        return this.items;
    }

    @Nullable
    public final JSONArray getGeoRadiusArray() {
        return this.geoRadiusArray;
    }

    @Nullable
    public final String getProfileAttrName() {
        return this.profileAttrName;
    }

    public final int getPropertyCount() {
        JSONArray jSONArray = this.properties;
        return jSONArray != null ? jSONArray.length() : 0;
    }

    public final int getItemsCount() {
        JSONArray jSONArray = this.items;
        return jSONArray != null ? jSONArray.length() : 0;
    }

    public final int getGeoRadiusCount() {
        JSONArray jSONArray = this.geoRadiusArray;
        return jSONArray != null ? jSONArray.length() : 0;
    }

    @VisibleForTesting
    @NotNull
    public final TriggerCondition triggerConditionFromJSON(@NotNull JSONObject property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        TriggerValue value = new TriggerValue(property.opt("propertyValue"), null, 2, null);
        TriggerOperator operator = TriggerAdapterKt.optTriggerOperator(property, "operator");
        String string2 = property.optString("propertyName", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.optString(Const\u2026s.INAPP_PROPERTYNAME, \"\")");
        return new TriggerCondition(string2, operator, value);
    }

    @Nullable
    public final TriggerCondition propertyAtIndex(int index) {
        if (CTXtensions.isInvalidIndex(this.properties, index)) {
            return null;
        }
        JSONArray jSONArray = this.properties;
        Object object = jSONArray != null ? jSONArray.optJSONObject(index) : null;
        if (object == null) {
            return null;
        }
        JSONObject propertyJSONObject = object;
        return this.triggerConditionFromJSON(propertyJSONObject);
    }

    @Nullable
    public final TriggerCondition itemAtIndex(int index) {
        if (CTXtensions.isInvalidIndex(this.items, index)) {
            return null;
        }
        JSONArray jSONArray = this.items;
        Object object = jSONArray != null ? jSONArray.optJSONObject(index) : null;
        if (object == null) {
            return null;
        }
        JSONObject itemJSONObject = object;
        return this.triggerConditionFromJSON(itemJSONObject);
    }

    @Nullable
    public final TriggerGeoRadius geoRadiusAtIndex(int index) {
        if (CTXtensions.isInvalidIndex(this.geoRadiusArray, index)) {
            return null;
        }
        JSONArray jSONArray = this.geoRadiusArray;
        Object object = jSONArray != null ? jSONArray.optJSONObject(index) : null;
        if (object == null) {
            return null;
        }
        JSONObject geoRadiusItem = object;
        double latitude = geoRadiusItem.optDouble("lat");
        double longitude = geoRadiusItem.optDouble("lng");
        double radius = geoRadiusItem.optDouble("rad");
        return new TriggerGeoRadius(latitude, longitude, radius);
    }
}

