/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.customviews;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.ResourcesCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.video.InboxVideoPlayerHandle;
import com.clevertap.android.sdk.video.VideoLibChecker;
import com.clevertap.android.sdk.video.VideoLibraryIntegrated;
import com.clevertap.android.sdk.video.inbox.ExoplayerHandle;
import com.clevertap.android.sdk.video.inbox.Media3Handle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u0018J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\u0006\u0010!\u001a\u00020\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/clevertap/android/sdk/customviews/MediaPlayerRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "handle", "Lcom/clevertap/android/sdk/video/InboxVideoPlayerHandle;", "onChildAttachStateChangeListener", "Landroidx/recyclerview/widget/RecyclerView$OnChildAttachStateChangeListener;", "onScrollListener", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "playingHolder", "Lcom/clevertap/android/sdk/inbox/CTInboxBaseMessageViewHolder;", "rect", "Landroid/graphics/Rect;", "artworkAsset", "Landroid/graphics/drawable/Drawable;", "bufferingStarted", "", "findBestVisibleMediaHolder", "initialize", "onPausePlayer", "onRestartPlayer", "playVideo", "playerReady", "recyclerViewListeners", "removeVideoView", "stop", "clevertap-core_release"})
@UnstableApi
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class MediaPlayerRecyclerView
extends RecyclerView {
    @NotNull
    private final InboxVideoPlayerHandle handle;
    @NotNull
    private final Rect rect;
    @NotNull
    private final RecyclerView.OnScrollListener onScrollListener;
    @NotNull
    private final RecyclerView.OnChildAttachStateChangeListener onChildAttachStateChangeListener;
    @Nullable
    private CTInboxBaseMessageViewHolder playingHolder;

    public MediaPlayerRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.handle = WhenMappings.$EnumSwitchMapping$0[VideoLibChecker.mediaLibType.ordinal()] == 1 ? (InboxVideoPlayerHandle)new Media3Handle() : (InboxVideoPlayerHandle)new ExoplayerHandle();
        this.rect = new Rect();
        this.onScrollListener = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    this.this$0.playVideo();
                }
            }
        };
        this.onChildAttachStateChangeListener = new RecyclerView.OnChildAttachStateChangeListener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onChildViewAttachedToWindow(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            }

            public void onChildViewDetachedFromWindow(@NotNull View view) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = MediaPlayerRecyclerView.access$getPlayingHolder$p(this.this$0);
                    if (cTInboxBaseMessageViewHolder == null) break block1;
                    CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder2 = cTInboxBaseMessageViewHolder;
                    MediaPlayerRecyclerView mediaPlayerRecyclerView = this.this$0;
                    CTInboxBaseMessageViewHolder ph = cTInboxBaseMessageViewHolder2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)ph.itemView, (Object)view)) {
                        mediaPlayerRecyclerView.stop();
                    }
                }
            }
        };
        this.initialize();
    }

    public MediaPlayerRecyclerView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.handle = WhenMappings.$EnumSwitchMapping$0[VideoLibChecker.mediaLibType.ordinal()] == 1 ? (InboxVideoPlayerHandle)new Media3Handle() : (InboxVideoPlayerHandle)new ExoplayerHandle();
        this.rect = new Rect();
        this.onScrollListener = new /* invalid duplicate definition of identical inner class */;
        this.onChildAttachStateChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.initialize();
    }

    public MediaPlayerRecyclerView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.handle = WhenMappings.$EnumSwitchMapping$0[VideoLibChecker.mediaLibType.ordinal()] == 1 ? (InboxVideoPlayerHandle)new Media3Handle() : (InboxVideoPlayerHandle)new ExoplayerHandle();
        this.rect = new Rect();
        this.onScrollListener = new /* invalid duplicate definition of identical inner class */;
        this.onChildAttachStateChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.initialize();
    }

    public final void onPausePlayer() {
        this.handle.setPlayWhenReady(false);
    }

    public final void onRestartPlayer() {
        this.initialize();
        this.playVideo();
    }

    public final void playVideo() {
        CTInboxBaseMessageViewHolder targetHolder = this.findBestVisibleMediaHolder();
        if (targetHolder == null) {
            this.removeVideoView();
            return;
        }
        CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
        if (cTInboxBaseMessageViewHolder != null) {
            CTInboxBaseMessageViewHolder ph = cTInboxBaseMessageViewHolder;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)ph.itemView, (Object)targetHolder.itemView)) {
                boolean play;
                boolean measured = ph.itemView.getGlobalVisibleRect(this.rect);
                int visibleHeight = measured ? this.rect.height() : 0;
                boolean bl2 = play = visibleHeight >= 400;
                if (play && ph.shouldAutoPlay()) {
                    this.handle.setPlayWhenReady(true);
                } else {
                    this.handle.setPlayWhenReady(false);
                }
                return;
            }
        }
        this.removeVideoView();
        this.initialize();
        float currentVolume = this.handle.playerVolume();
        boolean addedVideo2 = targetHolder.addMediaPlayer(currentVolume, (Function0<Float>)((Function0)new Function0<Float>(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Float invoke() {
                MediaPlayerRecyclerView.access$getHandle$p(this.this$0).handleMute();
                return Float.valueOf(MediaPlayerRecyclerView.access$getHandle$p(this.this$0).playerVolume());
            }
        }), (Function3<String, Boolean, Boolean, Void>)((Function3)new Function3<String, Boolean, Boolean, Void>(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final Void invoke(@NotNull String uri, boolean isMediaAudio, boolean isMediaVideo) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                InboxVideoPlayerHandle inboxVideoPlayerHandle = MediaPlayerRecyclerView.access$getHandle$p(this.this$0);
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                inboxVideoPlayerHandle.startPlaying(context, uri, isMediaAudio, isMediaVideo);
                return null;
            }
        }), this.handle.videoSurface());
        if (addedVideo2) {
            this.playingHolder = targetHolder;
        }
    }

    public final void stop() {
        this.handle.pause();
        this.playingHolder = null;
    }

    private final CTInboxBaseMessageViewHolder findBestVisibleMediaHolder() {
        CTInboxBaseMessageViewHolder bestHolder = null;
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.getLayoutManager();
        int startPosition = linearLayoutManager != null ? linearLayoutManager.findFirstVisibleItemPosition() : 0;
        LinearLayoutManager linearLayoutManager2 = (LinearLayoutManager)this.getLayoutManager();
        int endPosition = linearLayoutManager2 != null ? linearLayoutManager2.findLastVisibleItemPosition() : 0;
        int bestHeight = 0;
        int i = startPosition;
        if (i <= endPosition) {
            while (true) {
                int pos;
                if (this.getChildAt(pos = i - startPosition) != null) {
                    CTInboxBaseMessageViewHolder holder;
                    View child;
                    Object object = child.getTag();
                    CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = holder = object instanceof CTInboxBaseMessageViewHolder ? (CTInboxBaseMessageViewHolder)((Object)object) : null;
                    if (holder != null && holder.needsMediaPlayer()) {
                        int height;
                        boolean measured = holder.itemView.getGlobalVisibleRect(this.rect);
                        int n = height = measured ? this.rect.height() : 0;
                        if (height > bestHeight) {
                            bestHeight = height;
                            bestHolder = holder;
                        }
                    }
                }
                if (i == endPosition) break;
                ++i;
            }
        }
        return bestHolder;
    }

    private final void initialize() {
        Context context = this.getContext().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
        this.handle.initExoplayer(context, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                MediaPlayerRecyclerView.access$bufferingStarted((MediaPlayerRecyclerView)((Object)this.receiver));
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                MediaPlayerRecyclerView.access$playerReady((MediaPlayerRecyclerView)((Object)this.receiver));
            }
        }));
        Context context2 = this.getContext().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.handle.initPlayerView(context2, (Function0<? extends Drawable>)((Function0)new Function0<Drawable>((Object)this){

            @NotNull
            public final Drawable invoke() {
                return MediaPlayerRecyclerView.access$artworkAsset((MediaPlayerRecyclerView)((Object)this.receiver));
            }
        }));
        this.recyclerViewListeners();
    }

    private final void bufferingStarted() {
        block0: {
            CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
            if (cTInboxBaseMessageViewHolder == null) break block0;
            cTInboxBaseMessageViewHolder.playerBuffering();
        }
    }

    private final void playerReady() {
        block0: {
            CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
            if (cTInboxBaseMessageViewHolder == null) break block0;
            cTInboxBaseMessageViewHolder.playerReady();
        }
    }

    private final Drawable artworkAsset() {
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.ct_audio, null);
        Intrinsics.checkNotNull((Object)drawable2);
        return drawable2;
    }

    private final void recyclerViewListeners() {
        this.removeOnScrollListener(this.onScrollListener);
        this.removeOnChildAttachStateChangeListener(this.onChildAttachStateChangeListener);
        this.addOnScrollListener(this.onScrollListener);
        this.addOnChildAttachStateChangeListener(this.onChildAttachStateChangeListener);
    }

    private final void removeVideoView() {
        block0: {
            this.handle.pause();
            CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
            if (cTInboxBaseMessageViewHolder == null) break block0;
            cTInboxBaseMessageViewHolder.playerRemoved();
        }
    }

    public static final /* synthetic */ InboxVideoPlayerHandle access$getHandle$p(MediaPlayerRecyclerView $this) {
        return $this.handle;
    }

    public static final /* synthetic */ void access$bufferingStarted(MediaPlayerRecyclerView $this) {
        $this.bufferingStarted();
    }

    public static final /* synthetic */ void access$playerReady(MediaPlayerRecyclerView $this) {
        $this.playerReady();
    }

    public static final /* synthetic */ Drawable access$artworkAsset(MediaPlayerRecyclerView $this) {
        return $this.artworkAsset();
    }

    public static final /* synthetic */ CTInboxBaseMessageViewHolder access$getPlayingHolder$p(MediaPlayerRecyclerView $this) {
        return $this.playingHolder;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoLibraryIntegrated.values().length];
            try {
                nArray[VideoLibraryIntegrated.MEDIA3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

