/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.CtDatabaseKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/clevertap/android/sdk/db/DatabaseHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "dbName", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "(Landroid/content/Context;Ljava/lang/String;Lcom/clevertap/android/sdk/Logger;)V", "databaseFile", "Ljava/io/File;", "belowMemThreshold", "", "deleteDatabase", "", "executeStatement", "db", "Landroid/database/sqlite/SQLiteDatabase;", "statement", "onCreate", "onUpgrade", "oldVersion", "", "newVersion", "Companion", "clevertap-core_release"})
public final class DatabaseHelper
extends SQLiteOpenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final File databaseFile;
    private static final int DATABASE_VERSION = 3;
    private static final int DB_LIMIT = 0x1400000;

    public DatabaseHelper(@NotNull Context context, @Nullable String dbName, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(context, dbName, null, 3);
        this.logger = logger;
        File file = context.getDatabasePath(dbName);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDatabasePath(dbName)");
        this.databaseFile = file;
    }

    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.logger.verbose("Creating CleverTap DB");
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_EVENTS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_PROFILE_EVENTS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_USER_PROFILES_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_INBOX_MESSAGES_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_PUSH_NOTIFICATIONS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_UNINSTALL_TS_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getCREATE_NOTIFICATION_VIEWED_TABLE$p());
        this.executeStatement(db, CtDatabaseKt.access$getEVENTS_TIME_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getPROFILE_EVENTS_TIME_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getUNINSTALL_TS_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getPUSH_NOTIFICATIONS_TIME_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getINBOX_MESSAGES_COMP_ID_USERID_INDEX$p());
        this.executeStatement(db, CtDatabaseKt.access$getNOTIFICATION_VIEWED_INDEX$p());
    }

    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.logger.verbose("Upgrading CleverTap DB to version " + newVersion);
        switch (oldVersion) {
            case 1: {
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_UNINSTALL_TS$p());
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_INBOX_MESSAGES$p());
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_PUSH_NOTIFICATION_VIEWED$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_INBOX_MESSAGES_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_PUSH_NOTIFICATIONS_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_UNINSTALL_TS_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_NOTIFICATION_VIEWED_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getUNINSTALL_TS_INDEX$p());
                this.executeStatement(db, CtDatabaseKt.access$getPUSH_NOTIFICATIONS_TIME_INDEX$p());
                this.executeStatement(db, CtDatabaseKt.access$getINBOX_MESSAGES_COMP_ID_USERID_INDEX$p());
                this.executeStatement(db, CtDatabaseKt.access$getNOTIFICATION_VIEWED_INDEX$p());
                break;
            }
            case 2: {
                this.executeStatement(db, CtDatabaseKt.access$getDROP_TABLE_PUSH_NOTIFICATION_VIEWED$p());
                this.executeStatement(db, CtDatabaseKt.access$getCREATE_NOTIFICATION_VIEWED_TABLE$p());
                this.executeStatement(db, CtDatabaseKt.access$getNOTIFICATION_VIEWED_INDEX$p());
            }
        }
    }

    @SuppressLint(value={"UsableSpace"})
    public final boolean belowMemThreshold() {
        return this.databaseFile.exists() ? Math.max(this.databaseFile.getUsableSpace(), 0x1400000L) >= this.databaseFile.length() : true;
    }

    public final void deleteDatabase() {
        this.close();
        if (!this.databaseFile.delete()) {
            this.logger.debug("Could not delete database");
        }
    }

    private final void executeStatement(SQLiteDatabase db, String statement) {
        SQLiteStatement sqLiteStatement = db.compileStatement(statement);
        this.logger.verbose("Executing - " + statement);
        sqLiteStatement.execute();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/db/DatabaseHelper$Companion;", "", "()V", "DATABASE_VERSION", "", "DB_LIMIT", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

