/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0000\u0018\u0000 D2\u00020\u0001:\u0001DB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\rH\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0010J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\r\u0010\u001a\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u001bJ\u001c\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007J$\u0010\u001f\u001a\u00020\r2\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0018J\u0018\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0013\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180*\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u0004\u0018\u00010%2\b\u0010#\u001a\u0004\u0018\u00010\u0018J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010.\u001a\u00020\u0014J \u0010/\u001a\u0012\u0012\u0004\u0012\u00020100j\b\u0012\u0004\u0012\u000201`22\u0006\u0010\u001e\u001a\u00020\u0018H\u0007J\u0010\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020'H\u0002J\u001c\u00105\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007J$\u00106\u001a\u00020\r2\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007J\u000e\u00107\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u00108\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u0018J\u0018\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010;\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u00182\u0006\u0010<\u001a\u00020\u0014J\u0006\u0010=\u001a\u00020\u0010J\u001a\u0010>\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u00182\u0006\u0010:\u001a\u00020%H\u0007J\u001d\u0010?\u001a\u00020\u00102\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180*H\u0007\u00a2\u0006\u0002\u0010AJ\u0016\u0010B\u001a\u00020\u00102\f\u0010C\u001a\b\u0012\u0004\u0012\u0002010!H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/clevertap/android/sdk/db/DBAdapter;", "", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;)V", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/Logger;", "kotlin.jvm.PlatformType", "rtlDirtyFlag", "", "belowMemThreshold", "cleanInternal", "", "table", "Lcom/clevertap/android/sdk/db/Table;", "expiration", "", "cleanUpPushNotifications", "cleanupEventsFromLastId", "lastId", "", "cleanupStaleEvents", "deleteDB", "deleteDB$clevertap_core_release", "deleteMessageForId", "messageId", "userId", "deleteMessagesForIDs", "messageIDs", "", "doesPushNotificationIdExist", "id", "fetchEvents", "Lorg/json/JSONObject;", "limit", "", "fetchPushNotificationId", "fetchPushNotificationIds", "", "()[Ljava/lang/String;", "fetchUserProfileById", "getDatabaseName", "getLastUninstallTimestamp", "getMessages", "Ljava/util/ArrayList;", "Lcom/clevertap/android/sdk/inbox/CTMessageDAO;", "Lkotlin/collections/ArrayList;", "getTemplateMarkersList", "count", "markReadMessageForId", "markReadMessagesForIds", "removeEvents", "removeUserProfile", "storeObject", "obj", "storePushNotificationId", "ttl", "storeUninstallTimestamp", "storeUserProfile", "updatePushNotificationIds", "ids", "([Ljava/lang/String;)V", "upsertMessages", "inboxMessages", "Companion", "clevertap-core_release"})
public final class DBAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    private final DatabaseHelper dbHelper;
    private boolean rtlDirtyFlag;
    private static final long DATA_EXPIRATION = 432000000L;
    private static final long DB_UPDATE_ERROR = -1L;
    private static final long DB_OUT_OF_MEMORY_ERROR = -2L;
    private static final long DB_UNDEFINED_CODE = -3L;
    @NotNull
    private static final String DATABASE_NAME = "clevertap";
    @NotNull
    private static final String NOT_ENOUGH_SPACE_LOG = "There is not enough space left on the device to store data, data discarded";

    public DBAdapter(@NotNull Context context, @NotNull CleverTapInstanceConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.logger = config.getLogger();
        String string2 = this.getDatabaseName(config);
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.dbHelper = new DatabaseHelper(context, string2, logger);
        this.rtlDirtyFlag = true;
    }

    @WorkerThread
    public final synchronized boolean deleteMessageForId(@Nullable String messageId, @Nullable String userId) {
        boolean bl;
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        try {
            String[] stringArray = new String[]{messageId, userId};
            this.dbHelper.getWritableDatabase().delete(tName, "_id = ? AND messageUser = ?", stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    public final synchronized boolean deleteMessagesForIDs(@Nullable List<String> messageIDs, @Nullable String userId) {
        boolean bl;
        if (messageIDs == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        String idsTemplateGroup = this.getTemplateMarkersList(messageIDs.size());
        List whereArgs = CollectionsKt.toMutableList((Collection)messageIDs);
        whereArgs.add(userId);
        try {
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            String string2 = "_id IN (" + idsTemplateGroup + ") AND messageUser = ?";
            Collection $this$toTypedArray$iv = whereArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            sQLiteDatabase.delete(tName, string2, stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    public final synchronized boolean doesPushNotificationIdExist(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id, (Object)this.fetchPushNotificationId(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized String[] fetchPushNotificationIds() {
        List pushIds;
        block9: {
            if (!this.rtlDirtyFlag) {
                boolean $i$f$emptyArray = false;
                return (String[])((Object[])new String[0]);
            }
            String tName = Table.PUSH_NOTIFICATIONS.getTableName();
            pushIds = new ArrayList();
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "isRead = 0", null, null, null, null);
                if (cursor == null) break block9;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    while (cursor2.moveToNext()) {
                        int dataIndex = cursor2.getColumnIndex("data");
                        if (dataIndex < 0) continue;
                        String data = cursor2.getString(dataIndex);
                        this.logger.verbose("Fetching PID - " + data);
                        pushIds.add(data);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        Collection $this$toTypedArray$iv = pushIds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final synchronized JSONObject fetchUserProfileById(@Nullable String id) {
        JSONObject jSONObject;
        String profileString;
        block13: {
            if (id == null) {
                return null;
            }
            String tName = Table.USER_PROFILES.getTableName();
            profileString = null;
            try {
                Object object = new String[]{id};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "_id = ?", object, null, null, null);
                if (cursor == null) break block13;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    int dataIndex;
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    if (cursor2.moveToFirst() && (dataIndex = cursor2.getColumnIndex("data")) >= 0) {
                        profileString = cursor2.getString(dataIndex);
                    }
                    cursor2 = Unit.INSTANCE;
                }
                catch (Throwable cursor2) {
                    throwable = cursor2;
                    throw cursor2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        String string2 = profileString;
        if (string2 != null) {
            JSONObject jSONObject2;
            String it = string2;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized long getLastUninstallTimestamp() {
        long timestamp;
        block8: {
            String tName = Table.UNINSTALL_TS.getTableName();
            timestamp = 0L;
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, null, null, null, null, "created_at DESC", "1");
                if (cursor == null) break block8;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        timestamp = cursor2.getLong(cursor2.getColumnIndexOrThrow("created_at"));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final synchronized ArrayList<CTMessageDAO> getMessages(@NotNull String userId) {
        ArrayList<CTMessageDAO> messageDAOArrayList;
        block8: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            String tName = Table.INBOX_MESSAGES.getTableName();
            messageDAOArrayList = new ArrayList<CTMessageDAO>();
            try {
                Object object = new String[]{userId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "messageUser = ?", object, null, null, "created_at DESC");
                if (cursor == null) break block8;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    while (cursor2.moveToNext()) {
                        CTMessageDAO ctMessageDAO = new CTMessageDAO();
                        ctMessageDAO.setId(cursor2.getString(cursor2.getColumnIndexOrThrow("_id")));
                        ctMessageDAO.setJsonData(new JSONObject(cursor2.getString(cursor2.getColumnIndexOrThrow("data"))));
                        ctMessageDAO.setWzrkParams(new JSONObject(cursor2.getString(cursor2.getColumnIndexOrThrow("wzrkParams"))));
                        ctMessageDAO.setDate(cursor2.getLong(cursor2.getColumnIndexOrThrow("created_at")));
                        ctMessageDAO.setExpires(cursor2.getLong(cursor2.getColumnIndexOrThrow("expires")));
                        ctMessageDAO.setRead(cursor2.getInt(cursor2.getColumnIndexOrThrow("isRead")));
                        ctMessageDAO.setUserId(cursor2.getString(cursor2.getColumnIndexOrThrow("messageUser")));
                        ctMessageDAO.setTags(cursor2.getString(cursor2.getColumnIndexOrThrow("tags")));
                        ctMessageDAO.setCampaignId(cursor2.getString(cursor2.getColumnIndexOrThrow("campaignId")));
                        messageDAOArrayList.add(ctMessageDAO);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Error retrieving records from " + tName, e);
            }
        }
        return messageDAOArrayList;
    }

    @WorkerThread
    public final synchronized boolean markReadMessageForId(@Nullable String messageId, @Nullable String userId) {
        boolean bl;
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("isRead", Integer.valueOf(1));
        try {
            String[] stringArray = new String[]{messageId, userId};
            this.dbHelper.getWritableDatabase().update(Table.INBOX_MESSAGES.getTableName(), cv, "_id = ? AND messageUser = ?", stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    public final synchronized boolean markReadMessagesForIds(@Nullable List<String> messageIDs, @Nullable String userId) {
        boolean bl;
        if (messageIDs == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        String idsTemplateGroup = this.getTemplateMarkersList(messageIDs.size());
        List whereArgs = CollectionsKt.toMutableList((Collection)messageIDs);
        whereArgs.add(userId);
        ContentValues cv = new ContentValues();
        cv.put("isRead", Integer.valueOf(1));
        try {
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            String string2 = Table.INBOX_MESSAGES.getTableName();
            String string3 = "_id IN (" + idsTemplateGroup + ") AND messageUser = ?";
            Collection $this$toTypedArray$iv = whereArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            sQLiteDatabase.update(string2, cv, string3, stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    public final synchronized void removeUserProfile(@Nullable String id) {
        if (id == null) {
            return;
        }
        String tableName = Table.USER_PROFILES.getTableName();
        try {
            String[] stringArray = new String[]{id};
            this.dbHelper.getWritableDatabase().delete(tableName, "_id = ?", stringArray);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing user profile from " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    public final synchronized void storeUninstallTimestamp() {
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        String tableName = Table.UNINSTALL_TS.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    public final synchronized long storeUserProfile(@Nullable String id, @NotNull JSONObject obj) {
        long l;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (id == null) {
            return -1L;
        }
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("data", obj.toString());
        cv.put("_id", id);
        try {
            l = this.dbHelper.getWritableDatabase().insertWithOnConflict(tableName, null, cv, 5);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
            l = -1L;
        }
        return l;
    }

    @WorkerThread
    public final synchronized void upsertMessages(@NotNull List<? extends CTMessageDAO> inboxMessages) {
        Intrinsics.checkNotNullParameter(inboxMessages, (String)"inboxMessages");
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        for (CTMessageDAO cTMessageDAO : inboxMessages) {
            ContentValues cv = new ContentValues();
            cv.put("_id", cTMessageDAO.getId());
            cv.put("data", cTMessageDAO.getJsonData().toString());
            cv.put("wzrkParams", cTMessageDAO.getWzrkParams().toString());
            cv.put("campaignId", cTMessageDAO.getCampaignId());
            cv.put("tags", cTMessageDAO.getTags());
            cv.put("isRead", Integer.valueOf(cTMessageDAO.isRead()));
            cv.put("expires", Long.valueOf(cTMessageDAO.getExpires()));
            cv.put("created_at", Long.valueOf(cTMessageDAO.getDate()));
            cv.put("messageUser", cTMessageDAO.getUserId());
            try {
                this.dbHelper.getWritableDatabase().insertWithOnConflict(Table.INBOX_MESSAGES.getTableName(), null, cv, 5);
            }
            catch (SQLiteException e) {
                this.logger.verbose("Error adding data to table " + Table.INBOX_MESSAGES.getTableName());
            }
        }
    }

    public final synchronized void cleanUpPushNotifications() {
        this.cleanInternal(Table.PUSH_NOTIFICATIONS, 0L);
    }

    @WorkerThread
    public final synchronized void cleanupEventsFromLastId(@NotNull String lastId, @NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)lastId, (String)"lastId");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        try {
            String[] stringArray = new String[]{lastId};
            this.dbHelper.getWritableDatabase().delete(tName, "_id <= ?", stringArray);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing sent data from table " + tName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    public final synchronized void storePushNotificationId(@Nullable String id, long ttl) {
        if (id == null) {
            return;
        }
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getTableName();
        long createdAtTime = ttl > 0L ? ttl : System.currentTimeMillis() + 345600000L;
        ContentValues cv = new ContentValues();
        cv.put("data", id);
        cv.put("created_at", Long.valueOf(createdAtTime));
        cv.put("isRead", Integer.valueOf(0));
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
            this.rtlDirtyFlag = true;
            this.logger.verbose("Stored PN - " + id + " with TTL - " + createdAtTime);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    public final synchronized void cleanupStaleEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.cleanInternal(table, 432000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final synchronized JSONObject fetchEvents(@NotNull Table table, int limit) {
        JSONObject jSONObject;
        JSONArray events;
        String lastId;
        block15: {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            String tName = table.getTableName();
            lastId = null;
            events = new JSONArray();
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, null, null, null, null, "created_at ASC", String.valueOf(limit));
                if (cursor == null) break block15;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    while (cursor2.moveToNext()) {
                        if (cursor2.isLast()) {
                            lastId = cursor2.getString(cursor2.getColumnIndexOrThrow("_id"));
                        }
                        try {
                            JSONObject j = new JSONObject(cursor2.getString(cursor2.getColumnIndexOrThrow("data")));
                            events.put((Object)j);
                        }
                        catch (JSONException j) {}
                    }
                    cursor2 = Unit.INSTANCE;
                }
                catch (Throwable cursor2) {
                    throwable = cursor2;
                    throw cursor2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
                lastId = null;
            }
        }
        String string2 = lastId;
        if (string2 != null) {
            JSONObject jSONObject2;
            String it = string2;
            boolean bl = false;
            try {
                JSONObject ret = new JSONObject();
                ret.put(it, (Object)events);
                jSONObject2 = ret;
            }
            catch (JSONException e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    @WorkerThread
    public final synchronized void updatePushNotificationIds(@NotNull String[] ids) {
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        if (ids.length == 0) {
            return;
        }
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("isRead", Integer.valueOf(1));
        String idsTemplateGroup = this.getTemplateMarkersList(ids.length);
        try {
            this.dbHelper.getWritableDatabase().update(tableName, cv, "data IN (" + idsTemplateGroup + ')', ids);
            this.rtlDirtyFlag = false;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    public final synchronized long storeObject(@NotNull JSONObject obj, @NotNull Table table) {
        long l;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return -2L;
        }
        String tableName = table.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("data", obj.toString());
        cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
            String sql = "SELECT COUNT(*) FROM " + tableName;
            SQLiteStatement statement = this.dbHelper.getWritableDatabase().compileStatement(sql);
            l = statement.simpleQueryForLong();
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
            l = -1L;
        }
        return l;
    }

    public final synchronized void removeEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, null, null);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing all events from table " + tName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    private final boolean belowMemThreshold() {
        return this.dbHelper.belowMemThreshold();
    }

    private final void cleanInternal(Table table, long expiration) {
        long time = (System.currentTimeMillis() - expiration) / (long)1000;
        String tName = table.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale event records from " + tName + ". Recreating DB.", e);
            this.deleteDB$clevertap_core_release();
        }
    }

    @VisibleForTesting
    public final void deleteDB$clevertap_core_release() {
        this.dbHelper.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fetchPushNotificationId(String id) {
        String pushId;
        block8: {
            String tName = Table.PUSH_NOTIFICATIONS.getTableName();
            pushId = null;
            pushId = "";
            try {
                Object object = new String[]{id};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "data =?", object, null, null, null);
                if (cursor == null) break block8;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        String string2 = cursor2.getString(cursor2.getColumnIndexOrThrow("data"));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(cursor.\u2026ndexOrThrow(Column.DATA))");
                        pushId = string2;
                    }
                    this.logger.verbose("Fetching PID for check - " + pushId);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return pushId;
    }

    private final String getDatabaseName(CleverTapInstanceConfig config) {
        return config.isDefaultInstance() ? DATABASE_NAME : "clevertap_" + config.getAccountId();
    }

    private final String getTemplateMarkersList(int count) {
        StringBuilder stringBuilder;
        StringBuilder $this$getTemplateMarkersList_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (count > 0) {
            $this$getTemplateMarkersList_u24lambda_u249.append("?");
            int n = count - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                $this$getTemplateMarkersList_u24lambda_u249.append(", ?");
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/db/DBAdapter$Companion;", "", "()V", "DATABASE_NAME", "", "DATA_EXPIRATION", "", "DB_OUT_OF_MEMORY_ERROR", "DB_UNDEFINED_CODE", "getDB_UNDEFINED_CODE$annotations", "DB_UPDATE_ERROR", "NOT_ENOUGH_SPACE_LOG", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getDB_UNDEFINED_CODE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

