/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.events;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.variables.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EventMediator {
    private final CoreMetaData cleverTapMetaData;
    private final CleverTapInstanceConfig config;
    private final Context context;

    public EventMediator(Context context, CleverTapInstanceConfig config, CoreMetaData coreMetaData) {
        this.context = context;
        this.config = config;
        this.cleverTapMetaData = coreMetaData;
    }

    public boolean shouldDeferProcessingEvent(JSONObject event, int eventType) {
        if (eventType == 8) {
            return false;
        }
        if (this.config.isCreatedPostAppLaunch()) {
            return false;
        }
        if (event.has("evtName")) {
            try {
                if (Arrays.asList(Constants.SYSTEM_EVENTS).contains(event.getString("evtName"))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return eventType == 4 && !this.cleverTapMetaData.isAppLaunchPushed();
    }

    public boolean shouldDropEvent(JSONObject event, int eventType) {
        if (eventType == 7 || eventType == 8) {
            return false;
        }
        if (this.cleverTapMetaData.isCurrentUserOptedOut()) {
            String eventString = event == null ? "null" : event.toString();
            this.config.getLogger().debug(this.config.getAccountId(), "Current user is opted out dropping event: " + eventString);
            return true;
        }
        if (this.isMuted()) {
            this.config.getLogger().verbose(this.config.getAccountId(), "CleverTap is muted, dropping event - " + event.toString());
            return true;
        }
        return false;
    }

    public boolean isAppLaunchedEvent(JSONObject event) {
        try {
            return event.has("evtName") && event.getString("evtName").equals("App Launched");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public boolean isEvent(JSONObject event) {
        return event.has("evtName");
    }

    public String getEventName(JSONObject event) {
        try {
            return event.getString("evtName");
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Map<String, Object> getEventProperties(JSONObject event) {
        if (event.has("evtName") && event.has("evtData")) {
            try {
                return JsonUtil.mapFromJson(event.getJSONObject("evtData"));
            }
            catch (JSONException e) {
                Logger.v("Could not convert JSONObject to Map - " + e.getMessage());
            }
        }
        return new HashMap<String, Object>();
    }

    public boolean isChargedEvent(JSONObject event) {
        try {
            return event.has("evtName") && event.getString("evtName").equals("Charged");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public List<Map<String, Object>> getChargedEventItemDetails(JSONObject event) {
        try {
            return JsonUtil.listFromJson(event.getJSONObject("evtData").getJSONArray("Items"));
        }
        catch (JSONException e) {
            return new ArrayList<Map<String, Object>>();
        }
    }

    public Map<String, Object> getChargedEventDetails(JSONObject event) {
        try {
            Object items = event.getJSONObject("evtData").remove("Items");
            Map<String, Object> chargedDetails = JsonUtil.mapFromJson(event.getJSONObject("evtData"));
            event.getJSONObject("evtData").put("Items", items);
            return chargedDetails;
        }
        catch (JSONException e) {
            return new HashMap<String, Object>();
        }
    }

    private boolean isMuted() {
        int muteTS;
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - (muteTS = StorageHelper.getIntFromPrefs(this.context, this.config, "comms_mtd", 0)) < 86400;
    }
}

