/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.variables.CTVariableUtils;
import com.clevertap.android.sdk.variables.JsonUtil;
import com.clevertap.android.sdk.variables.VarCache;
import com.clevertap.android.sdk.variables.callbacks.FetchVariablesCallback;
import com.clevertap.android.sdk.variables.callbacks.VariablesChangedCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class CTVariables {
    private boolean hasVarsRequestCompleted = false;
    private final List<VariablesChangedCallback> variablesChangedCallbacks = new ArrayList<VariablesChangedCallback>();
    private final List<VariablesChangedCallback> oneTimeVariablesChangedCallbacks = new ArrayList<VariablesChangedCallback>();
    private final Runnable triggerGlobalCallbacks = () -> {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            for (VariablesChangedCallback callback : this.variablesChangedCallbacks) {
                Utils.runOnUiThread(callback);
            }
        }
        list = this.oneTimeVariablesChangedCallbacks;
        synchronized (list) {
            for (VariablesChangedCallback callback : this.oneTimeVariablesChangedCallbacks) {
                Utils.runOnUiThread(callback);
            }
            this.oneTimeVariablesChangedCallbacks.clear();
        }
    };
    private final VarCache varCache;

    private static void logD(String msg) {
        Logger.d("variables", msg);
    }

    public CTVariables(VarCache varCache) {
        this.varCache = varCache;
        this.varCache.setGlobalCallbacksRunnable(this.triggerGlobalCallbacks);
    }

    public void init() {
        CTVariables.logD("init() called");
        this.varCache.loadDiffs();
    }

    public void handleVariableResponse(@Nullable JSONObject response, @Nullable FetchVariablesCallback fetchCallback) {
        CTVariables.logD("handleVariableResponse() called with: response = [" + response + "]");
        if (response == null) {
            this.handleVariableResponseError(fetchCallback);
        } else {
            this.handleVariableResponseSuccess(response, fetchCallback);
        }
    }

    public void handleVariableResponseError(@Nullable FetchVariablesCallback fetchCallback) {
        if (!this.hasVarsRequestCompleted().booleanValue()) {
            this.setHasVarsRequestCompleted(true);
            this.varCache.loadDiffsAndTriggerHandlers();
        }
        if (fetchCallback != null) {
            fetchCallback.onVariablesFetched(false);
        }
    }

    private void handleVariableResponseSuccess(@NonNull JSONObject response, @Nullable FetchVariablesCallback fetchCallback) {
        this.setHasVarsRequestCompleted(true);
        Map<String, Object> variableDiffs = JsonUtil.mapFromJson(response);
        variableDiffs = CTVariableUtils.convertFlatMapToNestedMaps(variableDiffs);
        this.varCache.updateDiffsAndTriggerHandlers(variableDiffs);
        if (fetchCallback != null) {
            fetchCallback.onVariablesFetched(true);
        }
    }

    public void clearUserContent() {
        CTVariables.logD("Clear user content in CTVariables");
        this.setHasVarsRequestCompleted(false);
        this.varCache.clearUserContent();
    }

    public static boolean isDevelopmentMode(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            this.variablesChangedCallbacks.add(callback);
        }
        if (this.hasVarsRequestCompleted().booleanValue()) {
            callback.variablesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOneTimeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        if (this.hasVarsRequestCompleted) {
            callback.variablesChanged();
        } else {
            List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacks;
            synchronized (list) {
                this.oneTimeVariablesChangedCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            this.variablesChangedCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOneTimeVariablesChangedHandler(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacks;
        synchronized (list) {
            this.oneTimeVariablesChangedCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllVariablesChangedCallbacks() {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            this.variablesChangedCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllOneTimeVariablesChangedCallbacks() {
        List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacks;
        synchronized (list) {
            this.oneTimeVariablesChangedCallbacks.clear();
        }
    }

    public Boolean hasVarsRequestCompleted() {
        return this.hasVarsRequestCompleted;
    }

    public void setHasVarsRequestCompleted(boolean completed) {
        this.hasVarsRequestCompleted = completed;
    }

    VarCache getVarCache() {
        return this.varCache;
    }
}

