/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import com.clevertap.android.sdk.utils.CacheKt;
import com.clevertap.android.sdk.utils.CacheMethods;
import com.clevertap.android.sdk.utils.LruCacheProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u0014*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0014B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\tJ\u0015\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/clevertap/android/sdk/utils/LruCache;", "T", "", "maxSize", "", "memoryCache", "Lcom/clevertap/android/sdk/utils/CacheMethods;", "(ILcom/clevertap/android/sdk/utils/CacheMethods;)V", "add", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)Z", "empty", "", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "isEmpty", "remove", "Companion", "clevertap-core_release"})
public final class LruCache<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    @NotNull
    private final CacheMethods<T> memoryCache;
    @NotNull
    public static final String TYPE_LRU = "TYPE_LRU";

    public LruCache(int maxSize, @NotNull CacheMethods<T> memoryCache) {
        Intrinsics.checkNotNullParameter(memoryCache, (String)"memoryCache");
        this.maxSize = maxSize;
        this.memoryCache = memoryCache;
    }

    public /* synthetic */ LruCache(int n, CacheMethods cacheMethods, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            cacheMethods = new CacheMethods<T>(n){
                @NotNull
                private final android.util.LruCache<String, T> lru;
                {
                    this.lru = LruCacheProvider.INSTANCE.provide($maxSize);
                }

                @NotNull
                public final android.util.LruCache<String, T> getLru() {
                    return this.lru;
                }

                @Override
                public boolean add(@NotNull String key, @NotNull T value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    this.lru.put((Object)key, value);
                    return true;
                }

                @Override
                @Nullable
                public T get(@NotNull String key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return this.lru.get((Object)key);
                }

                @Override
                @Nullable
                public T remove(@NotNull String key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return this.lru.remove((Object)key);
                }

                @Override
                public void empty() {
                    this.lru.evictAll();
                }

                @Override
                public boolean isEmpty() {
                    return this.lru.size() == 0;
                }
            };
        }
        this(n, cacheMethods);
    }

    public final boolean add(@NotNull String key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (CacheKt.sizeInKb(value) > this.maxSize) {
            this.remove(key);
            return false;
        }
        this.memoryCache.add(key, value);
        return true;
    }

    @Nullable
    public final T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.memoryCache.get(key);
    }

    @Nullable
    public final T remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.memoryCache.remove(key);
    }

    public final void empty() {
        this.memoryCache.empty();
    }

    public final boolean isEmpty() {
        return this.memoryCache.isEmpty();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/sdk/utils/LruCache$Companion;", "", "()V", "TYPE_LRU", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

