/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import androidx.work.Constraints;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.interfaces.AudibleNotification;
import com.clevertap.android.sdk.pushnotification.CTPushProvider;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.CoreNotificationRenderer;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.pushnotification.UnregistrableCTPushProvider;
import com.clevertap.android.sdk.pushnotification.amp.CTPushAmpWorker;
import com.clevertap.android.sdk.pushnotification.work.CTWorkManager;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.PackageUtils;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PushProviders
implements CTPushProviderListener {
    private static final int DEFAULT_FLEX_INTERVAL = 5;
    private static final int PING_FREQUENCY_VALUE = 240;
    private static final String PF_JOB_ID = "pfjobid";
    private static final String PF_WORK_ID = "pfworkid";
    private static final String PING_FREQUENCY = "pf";
    private static final String inputFormat = "HH:mm";
    private final ArrayList<PushConstants.PushType> allEnabledPushTypes = new ArrayList();
    private final ArrayList<PushConstants.PushType> allDisabledPushTypes = new ArrayList();
    private final ArrayList<CTPushProvider> availableCTPushProviders = new ArrayList();
    private final ArrayList<PushConstants.PushType> customEnabledPushTypes = new ArrayList();
    private final AnalyticsManager analyticsManager;
    private final BaseDatabaseManager baseDatabaseManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final CTWorkManager ctWorkManager;
    private INotificationRenderer iNotificationRenderer = new CoreNotificationRenderer();
    private final ValidationResultStack validationResultStack;
    private final Object tokenLock = new Object();
    private final Object pushRenderingLock = new Object();
    private CleverTapAPI.DevicePushTokenRefreshListener tokenRefreshListener;

    @NonNull
    public static PushProviders load(Context context, CleverTapInstanceConfig config, BaseDatabaseManager baseDatabaseManager, ValidationResultStack validationResultStack, AnalyticsManager analyticsManager, ControllerManager controllerManager, CTWorkManager ctWorkManager) {
        PushProviders providers = new PushProviders(context, config, baseDatabaseManager, validationResultStack, analyticsManager, ctWorkManager);
        providers.init();
        controllerManager.setPushProviders(providers);
        return providers;
    }

    private PushProviders(Context context, CleverTapInstanceConfig config, BaseDatabaseManager baseDatabaseManager, ValidationResultStack validationResultStack, AnalyticsManager analyticsManager, CTWorkManager ctWorkManager) {
        this.context = context;
        this.config = config;
        this.baseDatabaseManager = baseDatabaseManager;
        this.validationResultStack = validationResultStack;
        this.analyticsManager = analyticsManager;
        this.ctWorkManager = ctWorkManager;
        this.initPushAmp();
    }

    public void _createNotification(Context context, Bundle extras, int notificationId) {
        if (extras == null || extras.get("wzrk_pn") == null) {
            return;
        }
        if (this.config.isAnalyticsOnly()) {
            this.config.getLogger().debug(this.config.getAccountId(), "Instance is set for Analytics only, cannot create notification");
            return;
        }
        try {
            String notifTitle;
            boolean isSilent = extras.getString("wzrk_pn_s", "").equalsIgnoreCase("true");
            if (isSilent) {
                this.analyticsManager.pushNotificationViewedEvent(extras);
                return;
            }
            String extrasFrom = extras.getString("extras_from");
            if (extrasFrom == null || !extrasFrom.equals("PTReceiver")) {
                this.config.getLogger().debug(this.config.getAccountId(), "Handling notification: " + extras);
                if (extras.getString("wzrk_pid") != null && this.baseDatabaseManager.loadDBAdapter(context).doesPushNotificationIdExist(extras.getString("wzrk_pid"))) {
                    this.config.getLogger().debug(this.config.getAccountId(), "Push Notification already rendered, not showing again");
                    return;
                }
                String notifMessage = this.iNotificationRenderer.getMessage(extras);
                String string2 = notifMessage = notifMessage != null ? notifMessage : "";
                if (notifMessage.isEmpty()) {
                    this.config.getLogger().verbose(this.config.getAccountId(), "Push notification message is empty, not rendering");
                    this.baseDatabaseManager.loadDBAdapter(context).storeUninstallTimestamp();
                    String pingFreq = extras.getString(PING_FREQUENCY, "");
                    if (!TextUtils.isEmpty((CharSequence)pingFreq)) {
                        this.updatePingFrequencyIfNeeded(context, Integer.parseInt(pingFreq));
                    }
                    return;
                }
            }
            notifTitle = (notifTitle = this.iNotificationRenderer.getTitle(extras, context)).isEmpty() ? context.getApplicationInfo().name : notifTitle;
            this.triggerNotification(context, extras, notificationId);
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Couldn't render notification: ", t);
        }
    }

    public void cacheToken(final String token, final PushConstants.PushType pushType) {
        if (TextUtils.isEmpty((CharSequence)token) || pushType == null) {
            return;
        }
        try {
            Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
            task.execute("PushProviders#cacheToken", new Callable<Void>(){

                @Override
                public Void call() {
                    if (PushProviders.this.alreadyHaveToken(token, pushType)) {
                        return null;
                    }
                    String key = pushType.getTokenPrefKey();
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        return null;
                    }
                    StorageHelper.putStringImmediate(PushProviders.this.context, StorageHelper.storageKeyWithSuffix(PushProviders.this.config, key), token);
                    PushProviders.this.config.log("PushProvider", (Object)((Object)pushType) + "Cached New Token successfully " + token);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.config.log("PushProvider", (Object)((Object)pushType) + "Unable to cache token " + token, t);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void doTokenRefresh(String token, PushConstants.PushType pushType) {
        if (TextUtils.isEmpty((CharSequence)token) || pushType == null) {
            return;
        }
        switch (pushType) {
            case FCM: {
                this.handleToken(token, PushConstants.PushType.FCM, true);
                break;
            }
            case XPS: {
                this.handleToken(token, PushConstants.PushType.XPS, true);
                break;
            }
            case HPS: {
                this.handleToken(token, PushConstants.PushType.HPS, true);
                break;
            }
            case BPS: {
                this.handleToken(token, PushConstants.PushType.BPS, true);
                break;
            }
            case ADM: {
                this.handleToken(token, PushConstants.PushType.ADM, true);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void forcePushDeviceToken(boolean register) {
        for (PushConstants.PushType pushType : this.allEnabledPushTypes) {
            this.pushDeviceTokenEvent(null, register, pushType);
        }
    }

    @NonNull
    public ArrayList<PushConstants.PushType> getAvailablePushTypes() {
        ArrayList<PushConstants.PushType> pushTypes = new ArrayList<PushConstants.PushType>();
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            pushTypes.add(pushProvider.getPushType());
        }
        return pushTypes;
    }

    public String getCachedToken(PushConstants.PushType pushType) {
        String key;
        if (pushType != null && !TextUtils.isEmpty((CharSequence)(key = pushType.getTokenPrefKey()))) {
            String cachedToken = StorageHelper.getStringFromPrefs(this.context, this.config, key, null);
            this.config.log("PushProvider", (Object)((Object)pushType) + "getting Cached Token - " + cachedToken);
            return cachedToken;
        }
        if (pushType != null) {
            this.config.log("PushProvider", (Object)((Object)pushType) + " Unable to find cached Token for type ");
        }
        return null;
    }

    public CleverTapAPI.DevicePushTokenRefreshListener getDevicePushTokenRefreshListener() {
        return this.tokenRefreshListener;
    }

    public void setDevicePushTokenRefreshListener(CleverTapAPI.DevicePushTokenRefreshListener tokenRefreshListener) {
        this.tokenRefreshListener = tokenRefreshListener;
    }

    public void handleToken(String token, PushConstants.PushType pushType, boolean register) {
        if (register) {
            this.registerToken(token, pushType);
        } else {
            this.unregisterToken(token, pushType);
        }
    }

    public boolean isNotificationSupported() {
        for (PushConstants.PushType pushType : this.getAvailablePushTypes()) {
            if (this.getCachedToken(pushType) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNewToken(String freshToken, PushConstants.PushType pushType) {
        if (!TextUtils.isEmpty((CharSequence)freshToken)) {
            this.doTokenRefresh(freshToken, pushType);
            this.deviceTokenDidRefresh(freshToken, pushType);
        }
    }

    public void onTokenRefresh() {
        this.refreshAllTokens();
    }

    public void processCustomPushNotification(final Bundle extras) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("customHandlePushAmplification", new Callable<Void>(){

            @Override
            public Void call() {
                String notifMessage = extras.getString("nm");
                String string2 = notifMessage = notifMessage != null ? notifMessage : "";
                if (notifMessage.isEmpty()) {
                    PushProviders.this.config.getLogger().verbose(PushProviders.this.config.getAccountId(), "Push notification message is empty, not rendering");
                    PushProviders.this.baseDatabaseManager.loadDBAdapter(PushProviders.this.context).storeUninstallTimestamp();
                    String pingFreq = extras.getString(PushProviders.PING_FREQUENCY, "");
                    if (!TextUtils.isEmpty((CharSequence)pingFreq)) {
                        PushProviders.this.updatePingFrequencyIfNeeded(PushProviders.this.context, Integer.parseInt(pingFreq));
                    }
                } else {
                    String wzrk_pid = extras.getString("wzrk_pid");
                    String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
                    long wzrk_ttl = Long.parseLong(ttl);
                    DBAdapter dbAdapter = PushProviders.this.baseDatabaseManager.loadDBAdapter(PushProviders.this.context);
                    PushProviders.this.config.getLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
                    dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
                }
                return null;
            }
        });
    }

    public void unregisterToken(String token, PushConstants.PushType pushType) {
        this.pushDeviceTokenEvent(token, false, pushType);
    }

    public void updatePingFrequencyIfNeeded(Context context, int frequency) {
        this.config.getLogger().verbose("Ping frequency received - " + frequency);
        this.config.getLogger().verbose("Stored Ping Frequency - " + this.getPingFrequency(context));
        if (frequency != this.getPingFrequency(context)) {
            this.setPingFrequency(context, frequency);
            if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
                Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
                task.execute("createOrResetWorker", new Callable<Void>(){

                    @Override
                    public Void call() {
                        PushProviders.this.createOrResetWorker(true);
                        return null;
                    }
                });
            }
        }
    }

    private boolean alreadyHaveToken(String newToken, PushConstants.PushType pushType) {
        boolean alreadyAvailable;
        boolean bl = alreadyAvailable = !TextUtils.isEmpty((CharSequence)newToken) && pushType != null && newToken.equalsIgnoreCase(this.getCachedToken(pushType));
        if (pushType != null) {
            this.config.log("PushProvider", (Object)((Object)pushType) + "Token Already available value: " + alreadyAvailable);
        }
        return alreadyAvailable;
    }

    public void runPushAmpWork(Context context) {
        Date endTime;
        Logger.v(this.config.getAccountId(), "Pushamp - Running work request");
        if (!this.isNotificationSupported()) {
            Logger.v(this.config.getAccountId(), "Pushamp - Token is not present, not running the work request");
            return;
        }
        Calendar now = Calendar.getInstance();
        int hour = now.get(11);
        int minute = now.get(12);
        SimpleDateFormat inputParser = new SimpleDateFormat(inputFormat, Locale.US);
        Date currentTime = this.parseTimeToDate(hour + ":" + minute, inputParser);
        Date startTime = this.parseTimeToDate("22:00", inputParser);
        if (this.isTimeBetweenDNDTime(startTime, endTime = this.parseTimeToDate("06:00", inputParser), currentTime)) {
            Logger.v(this.config.getAccountId(), "Pushamp won't run in default DND hours");
            return;
        }
        long lastTS = this.baseDatabaseManager.loadDBAdapter(context).getLastUninstallTimestamp();
        if (lastTS == 0L || lastTS > System.currentTimeMillis() - 86400000L) {
            try {
                JSONObject eventObject = new JSONObject();
                eventObject.put("bk", 1);
                this.analyticsManager.sendPingEvent(eventObject);
                Logger.v(this.config.getAccountId(), "Pushamp - Successfully completed work request");
            }
            catch (JSONException e) {
                Logger.v("Pushamp - Unable to complete work request");
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=21)
    private void stopJobScheduler(Context context) {
        int existingJobId = StorageHelper.getInt(context, PF_JOB_ID, -1);
        if (existingJobId != -1) {
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            jobScheduler.cancel(existingJobId);
            StorageHelper.remove(context, PF_JOB_ID);
        }
    }

    private void createOrResetWorker(boolean isPingFrequencyUpdated) {
        if (Build.VERSION.SDK_INT < 26) {
            this.config.getLogger().debug(this.config.getAccountId(), "Pushamp feature is not supported below Oreo");
            return;
        }
        String existingWorkName = StorageHelper.getString(this.context, PF_WORK_ID, "");
        int pingFrequency = this.getPingFrequency(this.context);
        if (existingWorkName.equals("") && pingFrequency <= 0) {
            this.config.getLogger().debug(this.config.getAccountId(), "Pushamp - There is no running work and nothing to create");
            return;
        }
        if (pingFrequency <= 0) {
            this.config.getLogger().debug(this.config.getAccountId(), "Pushamp - Cancelling worker as pingFrequency <=0 ");
            this.stopWorker();
            return;
        }
        try {
            WorkManager workManager = WorkManager.getInstance((Context)this.context);
            if (existingWorkName.equals("") || isPingFrequencyUpdated) {
                Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).setRequiresCharging(false).setRequiresBatteryNotLow(true).build();
                PeriodicWorkRequest request = (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(CTPushAmpWorker.class, (long)pingFrequency, TimeUnit.MINUTES, 5L, TimeUnit.MINUTES).setConstraints(constraints)).build();
                String workName = existingWorkName.equals("") ? this.config.getAccountId() : existingWorkName;
                workManager.enqueueUniquePeriodicWork(workName, ExistingPeriodicWorkPolicy.REPLACE, request);
                StorageHelper.putString(this.context, PF_WORK_ID, workName);
                this.config.getLogger().debug(this.config.getAccountId(), "Pushamp - Finished scheduling periodic work request - " + workName + " with repeatInterval- " + pingFrequency + " minutes");
            }
        }
        catch (Exception e) {
            this.config.getLogger().debug(this.config.getAccountId(), "Pushamp - Failed scheduling/cancelling periodic work request" + e);
        }
    }

    private void stopWorker() {
        String existingWorkName = StorageHelper.getString(this.context, PF_WORK_ID, "");
        if (!existingWorkName.equals("")) {
            try {
                WorkManager workManager = WorkManager.getInstance((Context)this.context);
                workManager.cancelUniqueWork(existingWorkName);
                StorageHelper.putString(this.context, PF_WORK_ID, "");
                this.config.getLogger().debug(this.config.getAccountId(), "Pushamp - Successfully cancelled work");
            }
            catch (Exception e) {
                this.config.getLogger().debug(this.config.getAccountId(), "Pushamp - Failure while cancelling work");
            }
        }
    }

    @NonNull
    private List<CTPushProvider> createProviders() {
        ArrayList<CTPushProvider> providers = new ArrayList<CTPushProvider>();
        for (PushConstants.PushType pushType : this.allEnabledPushTypes) {
            CTPushProvider pushProvider = this.getCTPushProviderFromPushType(pushType, true);
            if (pushProvider == null) continue;
            providers.add(pushProvider);
        }
        for (PushConstants.PushType pushType : this.allDisabledPushTypes) {
            CTPushProvider pushProvider;
            String cachedTokenXps;
            if (pushType != PushConstants.PushType.XPS || TextUtils.isEmpty((CharSequence)(cachedTokenXps = this.getCachedToken(PushConstants.PushType.XPS))) || !((pushProvider = this.getCTPushProviderFromPushType(pushType, false)) instanceof UnregistrableCTPushProvider)) continue;
            ((UnregistrableCTPushProvider)((Object)pushProvider)).unregisterPush(this.context);
            this.config.log("PushProvider", "unregistering existing token for disabled " + (Object)((Object)pushType));
        }
        return providers;
    }

    @Nullable
    private CTPushProvider getCTPushProviderFromPushType(PushConstants.PushType pushType, boolean isInit) {
        String className = pushType.getCtProviderClassName();
        CTPushProvider pushProvider = null;
        try {
            Class<?> providerClass = Class.forName(className);
            if (isInit) {
                Constructor<?> constructor = providerClass.getConstructor(CTPushProviderListener.class, Context.class, CleverTapInstanceConfig.class);
                pushProvider = (CTPushProvider)constructor.newInstance(this, this.context, this.config);
            } else {
                Constructor<?> constructor = providerClass.getConstructor(CTPushProviderListener.class, Context.class, CleverTapInstanceConfig.class, Boolean.class);
                pushProvider = (CTPushProvider)constructor.newInstance(this, this.context, this.config, false);
            }
            this.config.log("PushProvider", "Found provider:" + className);
        }
        catch (InstantiationException e) {
            this.config.log("PushProvider", "Unable to create provider InstantiationException" + className);
        }
        catch (IllegalAccessException e) {
            this.config.log("PushProvider", "Unable to create provider IllegalAccessException" + className);
        }
        catch (ClassNotFoundException e) {
            this.config.log("PushProvider", "Unable to create provider ClassNotFoundException" + className);
        }
        catch (Exception e) {
            this.config.log("PushProvider", "Unable to create provider " + className + " Exception:" + e.getClass().getName());
        }
        return pushProvider;
    }

    private void deviceTokenDidRefresh(String token, PushConstants.PushType type) {
        if (this.tokenRefreshListener != null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Notifying devicePushTokenDidRefresh: " + token);
            this.tokenRefreshListener.devicePushTokenDidRefresh(token, type);
        }
    }

    private void findCTPushProviders(List<CTPushProvider> providers) {
        if (providers.isEmpty()) {
            this.config.log("PushProvider", "No push providers found!. Make sure to install at least one push provider");
            return;
        }
        for (CTPushProvider provider : providers) {
            if (!this.isValid(provider)) {
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass());
                continue;
            }
            if (!provider.isSupported()) {
                this.config.log("PushProvider", "Unsupported Provider: " + provider.getClass());
                continue;
            }
            if (provider.isAvailable()) {
                this.config.log("PushProvider", "Available Provider: " + provider.getClass());
                this.availableCTPushProviders.add(provider);
                continue;
            }
            this.config.log("PushProvider", "Unavailable Provider: " + provider.getClass());
        }
    }

    private void findCustomEnabledPushTypes() {
        this.customEnabledPushTypes.addAll(this.allEnabledPushTypes);
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            this.customEnabledPushTypes.remove((Object)pushProvider.getPushType());
        }
    }

    private void findEnabledPushTypes() {
        for (PushConstants.PushType pushType : PushNotificationUtil.getPushTypes(this.config.getAllowedPushTypes())) {
            String className = pushType.getMessagingSDKClassName();
            try {
                Class.forName(className);
                this.allEnabledPushTypes.add(pushType);
                this.config.log("PushProvider", "SDK Class Available :" + className);
                if (pushType.getRunningDevices() == 3) {
                    this.allEnabledPushTypes.remove((Object)pushType);
                    this.allDisabledPushTypes.add(pushType);
                    this.config.log("PushProvider", "disabling " + (Object)((Object)pushType) + " due to flag set as PushConstants.NO_DEVICES");
                }
                if (pushType.getRunningDevices() != 2 || PackageUtils.isXiaomiDeviceRunningMiui(this.context)) continue;
                this.allEnabledPushTypes.remove((Object)pushType);
                this.allDisabledPushTypes.add(pushType);
                this.config.log("PushProvider", "disabling " + (Object)((Object)pushType) + " due to flag set as PushConstants.XIAOMI_MIUI_DEVICES");
            }
            catch (Exception e) {
                this.config.log("PushProvider", "SDK class Not available " + className + " Exception:" + e.getClass().getName());
            }
        }
    }

    private int getPingFrequency(Context context) {
        return StorageHelper.getInt(context, PING_FREQUENCY, 240);
    }

    private void init() {
        this.findEnabledPushTypes();
        List<CTPushProvider> providers = this.createProviders();
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.addOnSuccessListener(unused -> this.findCustomEnabledPushTypes());
        task.execute("asyncFindCTPushProviders", () -> {
            this.findCTPushProviders(providers);
            return null;
        });
    }

    private void initPushAmp() {
        if (!Utils.isMainProcess(this.context, this.context.getPackageName())) {
            return;
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("createOrResetWorker", new Callable<Void>(){

            @Override
            public Void call() {
                if (Build.VERSION.SDK_INT >= 21) {
                    PushProviders.this.stopJobScheduler(PushProviders.this.context);
                }
                if (PushProviders.this.config.isBackgroundSync() && !PushProviders.this.config.isAnalyticsOnly()) {
                    PushProviders.this.createOrResetWorker(false);
                } else {
                    PushProviders.this.config.getLogger().debug(PushProviders.this.config.getAccountId(), "Pushamp - Cancelling worker as background sync is disabled or config is analytics only");
                    PushProviders.this.stopWorker();
                }
                return null;
            }
        });
    }

    private boolean isTimeBetweenDNDTime(Date startTime, Date stopTime, Date currentTime) {
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(startTime);
        Calendar currentTimeCalendar = Calendar.getInstance();
        currentTimeCalendar.setTime(currentTime);
        Calendar stopTimeCalendar = Calendar.getInstance();
        stopTimeCalendar.setTime(stopTime);
        if (stopTime.compareTo(startTime) < 0) {
            if (currentTimeCalendar.compareTo(stopTimeCalendar) < 0) {
                currentTimeCalendar.add(5, 1);
            }
            stopTimeCalendar.add(5, 1);
        }
        return currentTimeCalendar.compareTo(startTimeCalendar) >= 0 && currentTimeCalendar.compareTo(stopTimeCalendar) < 0;
    }

    private boolean isValid(CTPushProvider provider) {
        if (60100 < provider.minSDKSupportVersionCode()) {
            this.config.log("PushProvider", "Provider: %s version %s does not match the SDK version %s. Make sure all CleverTap dependencies are the same version.");
            return false;
        }
        switch (provider.getPushType()) {
            case FCM: 
            case XPS: 
            case HPS: 
            case BPS: {
                if (provider.getPlatform() == 1) break;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass() + " delivery is only available for Android platforms." + (Object)((Object)provider.getPushType()));
                return false;
            }
            case ADM: {
                if (provider.getPlatform() == 2) break;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass() + " ADM delivery is only available for Amazon platforms." + (Object)((Object)provider.getPushType()));
                return false;
            }
        }
        return true;
    }

    private Date parseTimeToDate(String time, SimpleDateFormat inputParser) {
        try {
            return inputParser.parse(time);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDeviceTokenEvent(String token, boolean register, PushConstants.PushType pushType) {
        if (pushType == null) {
            return;
        }
        String string2 = token = !TextUtils.isEmpty((CharSequence)token) ? token : this.getCachedToken(pushType);
        if (TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        Object object = this.tokenLock;
        synchronized (object) {
            JSONObject event = new JSONObject();
            JSONObject data = new JSONObject();
            String action = register ? "register" : "unregister";
            try {
                data.put("action", (Object)action);
                data.put("id", (Object)token);
                data.put("type", (Object)pushType.getType());
                if (pushType == PushConstants.PushType.XPS) {
                    this.config.getLogger().verbose("PushProviders: pushDeviceTokenEvent requesting device region");
                    data.put("region", (Object)pushType.getServerRegion());
                }
                event.put("data", (Object)data);
                this.config.getLogger().verbose(this.config.getAccountId(), (Object)((Object)pushType) + action + " device token " + token);
                this.analyticsManager.sendDataEvent(event);
            }
            catch (Throwable t) {
                this.config.getLogger().verbose(this.config.getAccountId(), (Object)((Object)pushType) + action + " device token failed", t);
            }
        }
    }

    private void refreshAllTokens() {
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.execute("PushProviders#refreshAllTokens", new Callable<Void>(){

            @Override
            public Void call() {
                PushProviders.this.refreshCTProviderTokens();
                PushProviders.this.refreshCustomProviderTokens();
                return null;
            }
        });
    }

    private void refreshCTProviderTokens() {
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            try {
                pushProvider.requestToken();
            }
            catch (Throwable t) {
                this.config.log("PushProvider", "Token Refresh error " + pushProvider, t);
            }
        }
    }

    private void refreshCustomProviderTokens() {
        for (PushConstants.PushType pushType : this.customEnabledPushTypes) {
            try {
                this.pushDeviceTokenEvent(this.getCachedToken(pushType), true, pushType);
            }
            catch (Throwable t) {
                this.config.log("PushProvider", "Token Refresh error " + (Object)((Object)pushType), t);
            }
        }
    }

    private void registerToken(String token, PushConstants.PushType pushType) {
        this.pushDeviceTokenEvent(token, true, pushType);
        this.cacheToken(token, pushType);
    }

    private void setPingFrequency(Context context, int pingFrequency) {
        StorageHelper.putInt(context, PING_FREQUENCY, pingFrequency);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public INotificationRenderer getPushNotificationRenderer() {
        return this.iNotificationRenderer;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Object getPushRenderingLock() {
        return this.pushRenderingLock;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setPushNotificationRenderer(@NonNull INotificationRenderer iNotificationRenderer) {
        this.iNotificationRenderer = iNotificationRenderer;
    }

    private void triggerNotification(Context context, Bundle extras, int notificationId) {
        NotificationCompat.Builder nb;
        int priorityInt;
        boolean requiresChannelId;
        String updatedChannelId;
        NotificationManager notificationManager;
        block40: {
            int smallIcon;
            notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager == null) {
                String notificationManagerError = "Unable to render notification, Notification Manager is null.";
                this.config.getLogger().debug(this.config.getAccountId(), notificationManagerError);
                return;
            }
            String channelId = extras.getString("wzrk_cid", "");
            updatedChannelId = null;
            boolean bl = requiresChannelId = Build.VERSION.SDK_INT >= 26;
            if (requiresChannelId) {
                int messageCode = -1;
                String value = "";
                if (channelId.isEmpty()) {
                    messageCode = 8;
                    value = extras.toString();
                } else if (notificationManager.getNotificationChannel(channelId) == null) {
                    messageCode = 9;
                    value = channelId;
                }
                if (messageCode != -1) {
                    ValidationResult channelIdError = ValidationResultFactory.create(512, messageCode, value);
                    this.config.getLogger().debug(this.config.getAccountId(), channelIdError.getErrorDesc());
                    this.validationResultStack.pushValidationResult(channelIdError);
                }
                if ((updatedChannelId = CTXtensions.getOrCreateChannel(notificationManager, channelId, context)) == null || updatedChannelId.trim().isEmpty()) {
                    this.config.getLogger().debug(this.config.getAccountId(), "Not rendering Push since channel id is null or blank.");
                    return;
                }
                if (!CTXtensions.isNotificationChannelEnabled(context, updatedChannelId)) {
                    this.config.getLogger().verbose(this.config.getAccountId(), "Not rendering push notification as channel = " + updatedChannelId + " is blocked by user");
                    return;
                }
                this.config.getLogger().debug(this.config.getAccountId(), "Rendering Push on channel = " + updatedChannelId);
            }
            try {
                String x = ManifestInfo.getInstance(context).getNotificationIcon();
                if (x == null) {
                    throw new IllegalArgumentException();
                }
                smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                if (smallIcon == 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Throwable t) {
                smallIcon = DeviceInfo.getAppIconAsIntId(context);
            }
            this.iNotificationRenderer.setSmallIcon(smallIcon, context);
            priorityInt = 0;
            String priority2 = extras.getString("pr");
            if (priority2 != null) {
                if (priority2.equals("high")) {
                    priorityInt = 1;
                }
                if (priority2.equals("max")) {
                    priorityInt = 2;
                }
            }
            if (notificationId == -1000) {
                try {
                    Object collapse_key = this.iNotificationRenderer.getCollapseKey(extras);
                    if (collapse_key == null) break block40;
                    if (collapse_key instanceof Number) {
                        notificationId = ((Number)collapse_key).intValue();
                    } else if (collapse_key instanceof String) {
                        try {
                            notificationId = Integer.parseInt(collapse_key.toString());
                            this.config.getLogger().verbose(this.config.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                        }
                        catch (NumberFormatException e) {
                            notificationId = collapse_key.toString().hashCode();
                            this.config.getLogger().verbose(this.config.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                        }
                    }
                    notificationId = Math.abs(notificationId);
                    this.config.getLogger().debug(this.config.getAccountId(), "Creating the notification id: " + notificationId + " from collapse_key: " + collapse_key);
                }
                catch (NumberFormatException collapse_key) {}
            } else {
                this.config.getLogger().debug(this.config.getAccountId(), "Have user provided notificationId: " + notificationId + " won't use collapse_key (if any) as basis for notificationId");
            }
        }
        if (notificationId == -1000) {
            notificationId = (int)(Math.random() * 100.0);
            this.config.getLogger().debug(this.config.getAccountId(), "Setting random notificationId: " + notificationId);
        }
        if (requiresChannelId) {
            String badgeCountParam;
            nb = new NotificationCompat.Builder(context, updatedChannelId);
            String badgeIconParam = extras.getString("wzrk_bi", null);
            if (badgeIconParam != null) {
                try {
                    int badgeIconType = Integer.parseInt(badgeIconParam);
                    if (badgeIconType >= 0) {
                        nb.setBadgeIconType(badgeIconType);
                    }
                }
                catch (Throwable badgeIconType) {
                    // empty catch block
                }
            }
            if ((badgeCountParam = extras.getString("wzrk_bc", null)) != null) {
                try {
                    int badgeCount = Integer.parseInt(badgeCountParam);
                    if (badgeCount >= 0) {
                        nb.setNumber(badgeCount);
                    }
                }
                catch (Throwable badgeCount) {}
            }
        } else {
            nb = new NotificationCompat.Builder(context);
        }
        nb.setPriority(priorityInt);
        if (this.iNotificationRenderer instanceof AudibleNotification) {
            nb = ((AudibleNotification)((Object)this.iNotificationRenderer)).setSound(context, extras, nb, this.config);
        }
        if ((nb = this.iNotificationRenderer.renderNotification(extras, context, nb, this.config, notificationId)) == null) {
            return;
        }
        Notification n = nb.build();
        notificationManager.notify(notificationId, n);
        this.config.getLogger().debug(this.config.getAccountId(), "Rendered notification: " + n.toString());
        String extrasFrom = extras.getString("extras_from");
        if (extrasFrom == null || !extrasFrom.equals("PTReceiver")) {
            String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
            long wzrk_ttl = Long.parseLong(ttl);
            String wzrk_pid = extras.getString("wzrk_pid");
            DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(context);
            this.config.getLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
            dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
            boolean notificationViewedEnabled = "true".equals(extras.getString("wzrk_rnv", ""));
            if (!notificationViewedEnabled) {
                ValidationResult notificationViewedError = ValidationResultFactory.create(512, 10, extras.toString());
                this.config.getLogger().debug(notificationViewedError.getErrorDesc());
                this.validationResultStack.pushValidationResult(notificationViewedError);
                return;
            }
            long omrStart = extras.getLong("omr_invoke_time_in_millis", -1L);
            if (omrStart >= 0L) {
                long prt = System.currentTimeMillis() - omrStart;
                this.config.getLogger().verbose("Rendered Push Notification in " + prt + " millis");
            }
            this.ctWorkManager.init();
            this.analyticsManager.pushNotificationViewedEvent(extras);
        }
    }
}

