/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.clevertap.android.sdk.CTPreferenceCache;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DidClickForHardPermissionListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushPermissionManager;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlCoverFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlHalfInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeCoverFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeCoverImageFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHalfInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHalfInterstitialImageFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeInterstitialImageFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public final class InAppNotificationActivity
extends FragmentActivity
implements InAppListener,
DidClickForHardPermissionListener {
    private static boolean isAlertVisible = false;
    private CleverTapInstanceConfig config;
    private CTInAppNotification inAppNotification;
    private WeakReference<InAppListener> listenerWeakReference;
    private WeakReference<PushPermissionResultCallback> pushPermissionResultCallbackWeakReference;
    private PushPermissionManager pushPermissionManager;
    private Bundle returnBundle = null;
    private boolean invokedInAppDismissCallback = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int orientation = this.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            this.getWindow().addFlags(1024);
        }
        try {
            Bundle notif = this.getIntent().getExtras();
            if (notif == null) {
                throw new IllegalArgumentException();
            }
            this.inAppNotification = (CTInAppNotification)notif.getParcelable("inApp");
            boolean showHardNotificationPermission = notif.getBoolean("displayHardPermissionDialog", false);
            Bundle configBundle = notif.getBundle("configBundle");
            if (configBundle != null) {
                this.config = (CleverTapInstanceConfig)configBundle.getParcelable("config");
            }
            this.setListener(CleverTapAPI.instanceWithConfig((Context)this, this.config).getCoreState().getInAppController());
            this.setPermissionCallback(CleverTapAPI.instanceWithConfig((Context)this, this.config).getCoreState().getInAppController());
            this.pushPermissionManager = new PushPermissionManager((Activity)this, this.config);
            if (showHardNotificationPermission) {
                boolean shouldShowFallbackSettings = notif.getBoolean("shouldShowFallbackSettings", false);
                this.showHardPermissionPrompt(shouldShowFallbackSettings);
                return;
            }
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification bundle to show!", t);
            this.finish();
            return;
        }
        if (this.inAppNotification == null) {
            this.finish();
            return;
        }
        if (this.inAppNotification.isPortrait() && !this.inAppNotification.isLandscape()) {
            if (orientation == 2) {
                Logger.d("App in Landscape, dismissing portrait InApp Notification");
                this.finish();
                this.didDismiss(null);
                return;
            }
            Logger.d("App in Portrait, displaying InApp Notification anyway");
        }
        if (!this.inAppNotification.isPortrait() && this.inAppNotification.isLandscape()) {
            if (orientation == 1) {
                Logger.d("App in Portrait, dismissing landscape InApp Notification");
                this.finish();
                this.didDismiss(null);
                return;
            }
            Logger.d("App in Landscape, displaying InApp Notification anyway");
        }
        if (savedInstanceState == null) {
            CTInAppBaseFullFragment contentFragment = this.createContentFragment();
            if (contentFragment != null) {
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)this.inAppNotification);
                bundle.putParcelable("config", (Parcelable)this.config);
                contentFragment.setArguments(bundle);
                this.getSupportFragmentManager().beginTransaction().setCustomAnimations(0x10B0000, 0x10B0001).add(0x1020002, (Fragment)contentFragment, this.getFragmentTag()).commit();
            }
        } else if (isAlertVisible) {
            this.createContentFragment();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.pushPermissionManager.isFromNotificationSettingsActivity() && Build.VERSION.SDK_INT >= 33) {
            int permissionStatus = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.POST_NOTIFICATIONS");
            if (permissionStatus == 0) {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionAccept();
            } else {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionDeny();
            }
            this.didDismiss(null);
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        if (this.invokedInAppDismissCallback) {
            return;
        }
        this.notifyInAppDismissed();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        if (this.invokedInAppDismissCallback) {
            return;
        }
        this.notifyInAppDismissed();
    }

    private void notifyInAppDismissed() {
        InAppListener listener;
        if (isAlertVisible) {
            isAlertVisible = false;
        }
        if ((listener = this.getListener()) != null && this.getBaseContext() != null && this.inAppNotification != null) {
            listener.inAppNotificationDidDismiss(this.getBaseContext(), this.inAppNotification, this.returnBundle);
        }
        this.invokedInAppDismissCallback = true;
    }

    @Override
    public void inAppNotificationDidClick(CTInAppNotification inAppNotification, Bundle formData, HashMap<String, String> keyValueMap) {
        this.didClick(formData, keyValueMap);
    }

    @Override
    public void inAppNotificationDidDismiss(Context context, CTInAppNotification inAppNotification, Bundle formData) {
        this.didDismiss(formData);
    }

    @Override
    public void inAppNotificationDidShow(CTInAppNotification inAppNotification, Bundle formData) {
        this.didShow(formData);
    }

    public void setTheme(int resid) {
        super.setTheme(0x1030010);
    }

    void didClick(Bundle data, HashMap<String, String> keyValueMap) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidClick(this.inAppNotification, data, keyValueMap);
        }
    }

    @Override
    public void didClickForHardPermissionWithFallbackSettings(boolean fallbackToSettings) {
        this.showHardPermissionPrompt(fallbackToSettings);
    }

    @SuppressLint(value={"NewApi"})
    public void showHardPermissionPrompt(boolean isFallbackSettingsEnabled) {
        this.pushPermissionManager.showHardPermissionPrompt(isFallbackSettingsEnabled, (PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get());
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        CTPreferenceCache.getInstance((Context)this, this.config).setFirstTimeRequest(false);
        CTPreferenceCache.updateCacheToDisk((Context)this, this.config);
        if (requestCode == 102) {
            boolean granted;
            boolean bl = granted = grantResults.length > 0 && grantResults[0] == 0;
            if (granted) {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionAccept();
            } else {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionDeny();
            }
            this.didDismiss(null);
        }
    }

    void didDismiss(Bundle data) {
        this.returnBundle = data;
        this.finish();
    }

    void didShow(Bundle data) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.inAppNotification, data);
        }
    }

    void fireUrlThroughIntent(String url, Bundle formData) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url.replace("\n", "").replace("\r", "")));
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.didDismiss(formData);
    }

    InAppListener getListener() {
        InAppListener listener = null;
        try {
            listener = (InAppListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppActivityListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    void setListener(InAppListener listener) {
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    public void setPermissionCallback(PushPermissionResultCallback callback) {
        this.pushPermissionResultCallbackWeakReference = new WeakReference<PushPermissionResultCallback>(callback);
    }

    private CTInAppBaseFullFragment createContentFragment() {
        CTInAppType type = this.inAppNotification.getInAppType();
        CTInAppBaseFullFragment viewFragment = null;
        switch (type) {
            case CTInAppTypeCoverHTML: {
                viewFragment = new CTInAppHtmlCoverFragment();
                break;
            }
            case CTInAppTypeInterstitialHTML: {
                viewFragment = new CTInAppHtmlInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialHTML: {
                viewFragment = new CTInAppHtmlHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCover: {
                viewFragment = new CTInAppNativeCoverFragment();
                break;
            }
            case CTInAppTypeInterstitial: {
                viewFragment = new CTInAppNativeInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitial: {
                viewFragment = new CTInAppNativeHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCoverImageOnly: {
                viewFragment = new CTInAppNativeCoverImageFragment();
                break;
            }
            case CTInAppTypeInterstitialImageOnly: {
                viewFragment = new CTInAppNativeInterstitialImageFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialImageOnly: {
                viewFragment = new CTInAppNativeHalfInterstitialImageFragment();
                break;
            }
            case CTInAppTypeAlert: {
                AlertDialog alertDialog = null;
                if (this.inAppNotification.getButtons().size() > 0) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        alertDialog = new AlertDialog.Builder((Context)this, 16974394).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)this.inAppNotification.getButtons().get(0).getText(), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Bundle data = new Bundle();
                                data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getText());
                                InAppNotificationActivity.this.didClick(data, null);
                                String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getActionUrl();
                                if (actionUrl != null) {
                                    InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                    return;
                                }
                                if (InAppNotificationActivity.this.inAppNotification.isLocalInApp()) {
                                    InAppNotificationActivity.this.showHardPermissionPrompt(InAppNotificationActivity.this.inAppNotification.fallBackToNotificationSettings());
                                    return;
                                }
                                if (InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getType() != null && InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getType().equalsIgnoreCase("rfp")) {
                                    InAppNotificationActivity.this.showHardPermissionPrompt(InAppNotificationActivity.this.inAppNotification.getButtons().get(0).isFallbackToSettings());
                                    return;
                                }
                                InAppNotificationActivity.this.didDismiss(data);
                            }
                        }).create();
                        if (this.inAppNotification.getButtons().size() == 2) {
                            alertDialog.setButton(-2, (CharSequence)this.inAppNotification.getButtons().get(1).getText(), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    Bundle data = new Bundle();
                                    data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                    data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getText());
                                    InAppNotificationActivity.this.didClick(data, null);
                                    String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getActionUrl();
                                    if (actionUrl != null) {
                                        InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                        return;
                                    }
                                    if (InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getType() != null && InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getType().equalsIgnoreCase("rfp")) {
                                        InAppNotificationActivity.this.showHardPermissionPrompt(InAppNotificationActivity.this.inAppNotification.getButtons().get(1).isFallbackToSettings());
                                        return;
                                    }
                                    InAppNotificationActivity.this.didDismiss(data);
                                }
                            });
                        }
                    } else {
                        alertDialog = new AlertDialog.Builder((Context)this).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)this.inAppNotification.getButtons().get(0).getText(), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Bundle data = new Bundle();
                                data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getText());
                                InAppNotificationActivity.this.didClick(data, null);
                                String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(0).getActionUrl();
                                if (actionUrl != null) {
                                    InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                    return;
                                }
                                InAppNotificationActivity.this.didDismiss(data);
                            }
                        }).create();
                        if (this.inAppNotification.getButtons().size() == 2) {
                            alertDialog.setButton(-2, (CharSequence)this.inAppNotification.getButtons().get(1).getText(), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    Bundle data = new Bundle();
                                    data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                    data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getText());
                                    InAppNotificationActivity.this.didClick(data, null);
                                    String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(1).getActionUrl();
                                    if (actionUrl != null) {
                                        InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                        return;
                                    }
                                    InAppNotificationActivity.this.didDismiss(data);
                                }
                            });
                        }
                    }
                    if (this.inAppNotification.getButtons().size() > 2) {
                        alertDialog.setButton(-3, (CharSequence)this.inAppNotification.getButtons().get(2).getText(), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Bundle data = new Bundle();
                                data.putString("wzrk_id", InAppNotificationActivity.this.inAppNotification.getCampaignId());
                                data.putString("wzrk_c2a", InAppNotificationActivity.this.inAppNotification.getButtons().get(2).getText());
                                InAppNotificationActivity.this.didClick(data, null);
                                String actionUrl = InAppNotificationActivity.this.inAppNotification.getButtons().get(2).getActionUrl();
                                if (actionUrl != null) {
                                    InAppNotificationActivity.this.fireUrlThroughIntent(actionUrl, data);
                                    return;
                                }
                                InAppNotificationActivity.this.didDismiss(data);
                            }
                        });
                    }
                }
                if (alertDialog != null) {
                    alertDialog.show();
                    isAlertVisible = true;
                    this.didShow(null);
                    break;
                }
                this.config.getLogger().debug("InAppNotificationActivity: Alert Dialog is null, not showing Alert InApp");
                break;
            }
            default: {
                this.config.getLogger().verbose("InAppNotificationActivity: Unhandled InApp Type: " + (Object)((Object)type));
            }
        }
        return viewFragment;
    }

    private String getFragmentTag() {
        return this.config.getAccountId() + ":CT_INAPP_CONTENT_FRAGMENT";
    }

    public static interface PushPermissionResultCallback {
        public void onPushPermissionAccept();

        public void onPushPermissionDeny();
    }
}

