/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.BaseAnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.events.BaseEventQueueManager;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.utils.UriHelper;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsManager
extends BaseAnalyticsManager {
    private final CTLockManager ctLockManager;
    private final HashMap<String, Integer> installReferrerMap = new HashMap(8);
    private final BaseEventQueueManager baseEventQueueManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private final DeviceInfo deviceInfo;
    private final LocalDataStore localDataStore;
    private final ValidationResultStack validationResultStack;
    private final Validator validator;
    private final InAppResponse inAppResponse;
    private final HashMap<String, Object> notificationIdTagMap = new HashMap();
    private final Object notificationMapLock = new Object();
    private final HashMap<String, Object> notificationViewedIdTagMap = new HashMap();
    private NumberValueType numberValueType;

    AnalyticsManager(Context context, CleverTapInstanceConfig config, BaseEventQueueManager baseEventQueueManager, Validator validator, ValidationResultStack validationResultStack, CoreMetaData coreMetaData, LocalDataStore localDataStore, DeviceInfo deviceInfo, BaseCallbackManager callbackManager, ControllerManager controllerManager, CTLockManager ctLockManager, InAppResponse inAppResponse) {
        this.context = context;
        this.config = config;
        this.baseEventQueueManager = baseEventQueueManager;
        this.validator = validator;
        this.validationResultStack = validationResultStack;
        this.coreMetaData = coreMetaData;
        this.localDataStore = localDataStore;
        this.deviceInfo = deviceInfo;
        this.callbackManager = callbackManager;
        this.ctLockManager = ctLockManager;
        this.controllerManager = controllerManager;
        this.inAppResponse = inAppResponse;
    }

    @Override
    public void addMultiValuesForKey(final String key, final ArrayList<String> values) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("addMultiValuesForKey", new Callable<Void>(){

            @Override
            public Void call() {
                String command = "$add";
                AnalyticsManager.this._handleMultiValues(values, key, "$add");
                return null;
            }
        });
    }

    @Override
    public void incrementValue(String key, Number value) {
        this._constructIncrementDecrementValues(value, key, "$incr");
    }

    @Override
    public void decrementValue(String key, Number value) {
        this._constructIncrementDecrementValues(value, key, "$decr");
    }

    @Override
    public void fetchFeatureFlags() {
        if (this.config.isAnalyticsOnly()) {
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            notif.put("t", 1);
            event.put("evtName", (Object)"wzrk_fetch");
            event.put("evtData", (Object)notif);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendFetchEvent(event);
    }

    @Override
    public void forcePushAppLaunchedEvent() {
        this.coreMetaData.setAppLaunchPushed(false);
        this.pushAppLaunchedEvent();
    }

    @Override
    public void pushAppLaunchedEvent() {
        if (this.config.isDisableAppLaunchedEvent()) {
            this.coreMetaData.setAppLaunchPushed(true);
            this.config.getLogger().debug(this.config.getAccountId(), "App Launched Events disabled in the Android Manifest file");
            return;
        }
        if (this.coreMetaData.isAppLaunchPushed()) {
            this.config.getLogger().verbose(this.config.getAccountId(), "App Launched has already been triggered. Will not trigger it ");
            return;
        }
        this.config.getLogger().verbose(this.config.getAccountId(), "Firing App Launched event");
        this.coreMetaData.setAppLaunchPushed(true);
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)"App Launched");
            event.put("evtData", (Object)this.deviceInfo.getAppLaunchedFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.baseEventQueueManager.queueEvent(this.context, event, 4);
    }

    @Override
    public void pushDefineVarsEvent(JSONObject data) {
        this.baseEventQueueManager.queueEvent(this.context, data, 8);
    }

    @Override
    public void pushDisplayUnitClickedEventForID(String unitID) {
        JSONObject event = new JSONObject();
        try {
            JSONObject eventExtraData;
            CleverTapDisplayUnit displayUnit;
            event.put("evtName", (Object)"Notification Clicked");
            if (this.controllerManager.getCTDisplayUnitController() != null && (displayUnit = this.controllerManager.getCTDisplayUnitController().getDisplayUnitForID(unitID)) != null && (eventExtraData = displayUnit.getWZRKFields()) != null) {
                event.put("evtData", (Object)eventExtraData);
                try {
                    this.coreMetaData.setWzrkParams(eventExtraData);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Failed to push Display Unit clicked event" + t);
        }
    }

    @Override
    public void pushDisplayUnitViewedEventForID(String unitID) {
        JSONObject event = new JSONObject();
        try {
            JSONObject eventExtras;
            CleverTapDisplayUnit displayUnit;
            event.put("evtName", (Object)"Notification Viewed");
            if (this.controllerManager.getCTDisplayUnitController() != null && (displayUnit = this.controllerManager.getCTDisplayUnitController().getDisplayUnitForID(unitID)) != null && (eventExtras = displayUnit.getWZRKFields()) != null) {
                event.put("evtData", (Object)eventExtras);
            }
            this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Failed to push Display Unit viewed event" + t);
        }
    }

    @Override
    public void pushError(String errorMessage, int errorCode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Error Message", errorMessage);
        props.put("Error Code", errorCode);
        try {
            String activityName = CoreMetaData.getCurrentActivityName();
            if (activityName != null) {
                props.put("Location", activityName);
            } else {
                props.put("Location", "Unknown");
            }
        }
        catch (Throwable t) {
            props.put("Location", "Unknown");
        }
        this.pushEvent("Error Occurred", props);
    }

    @Override
    public void pushEvent(String eventName, Map<String, Object> eventActions) {
        if (eventName == null || eventName.equals("")) {
            return;
        }
        ValidationResult validationResult = this.validator.isRestrictedEventName(eventName);
        if (validationResult.getErrorCode() > 0) {
            this.validationResultStack.pushValidationResult(validationResult);
            return;
        }
        ValidationResult discardedResult = this.validator.isEventDiscarded(eventName);
        if (discardedResult.getErrorCode() > 0) {
            this.validationResultStack.pushValidationResult(discardedResult);
            return;
        }
        if (eventActions == null) {
            eventActions = new HashMap<String, Object>();
        }
        JSONObject event = new JSONObject();
        try {
            ValidationResult vr = this.validator.cleanEventName(eventName);
            if (vr.getErrorCode() != 0) {
                event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
            }
            eventName = vr.getObject().toString();
            JSONObject actions = new JSONObject();
            for (String key : eventActions.keySet()) {
                Object value = eventActions.get(key);
                vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = ValidationResultFactory.create(512, 7, eventName, key, value != null ? value.toString() : "");
                    this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                    this.validationResultStack.pushValidationResult(error);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                actions.put(key, value);
            }
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)actions);
            this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void pushInAppNotificationStateEvent(boolean clicked, CTInAppNotification data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.coreMetaData.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void pushInstallReferrer(String url) {
        try {
            this.config.getLogger().verbose(this.config.getAccountId(), "Referrer received: " + url);
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (this.installReferrerMap.containsKey(url) && now - this.installReferrerMap.get(url) < 10) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            this.installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        if (source == null && medium == null && campaign == null) {
            return;
        }
        try {
            int status = StorageHelper.getInt(this.context, "app_install_status", 0);
            if (status != 0) {
                Logger.d("Install referrer has already been set. Will not override it");
                return;
            }
            StorageHelper.putInt(this.context, "app_install_status", 1);
            if (source != null) {
                source = Uri.encode((String)source);
            }
            if (medium != null) {
                medium = Uri.encode((String)medium);
            }
            if (campaign != null) {
                campaign = Uri.encode((String)campaign);
            }
            String uriStr = "wzrk://track?install=true";
            if (source != null) {
                uriStr = uriStr + "&utm_source=" + source;
            }
            if (medium != null) {
                uriStr = uriStr + "&utm_medium=" + medium;
            }
            if (campaign != null) {
                uriStr = uriStr + "&utm_campaign=" + campaign;
            }
            Uri uri = Uri.parse((String)uriStr);
            this.pushDeepLink(uri, true);
        }
        catch (Throwable t) {
            Logger.v("Failed to push install referrer", t);
        }
    }

    @Override
    public void pushNotificationClickedEvent(final Bundle extras) {
        boolean shouldProcess;
        if (this.config.isAnalyticsOnly()) {
            this.config.getLogger().debug(this.config.getAccountId(), "is Analytics Only - will not process Notification Clicked event.");
            return;
        }
        if (extras == null || extras.isEmpty() || extras.get("wzrk_pn") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification not from CleverTap - will not process Notification Clicked event.");
            return;
        }
        String accountId = null;
        try {
            accountId = extras.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = shouldProcess = accountId == null && this.config.isDefaultInstance() || this.config.getAccountId().equals(accountId);
        if (!shouldProcess) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification not targeted at this instance, not processing Notification Clicked Event");
            return;
        }
        if (extras.containsKey("wzrk_inapp")) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("testInappNotification", new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        String inappPreviewPayloadType = extras.getString("wzrk_inapp_type");
                        String inappPreviewString = extras.getString("wzrk_inapp");
                        JSONObject inappPreviewPayload = new JSONObject(inappPreviewString);
                        JSONArray inappNotifs = new JSONArray();
                        if ("image-interstitial".equals(inappPreviewPayloadType)) {
                            inappNotifs.put((Object)AnalyticsManager.this.getHalfInterstitialInApp(inappPreviewPayload));
                        } else {
                            inappNotifs.put((Object)inappPreviewPayload);
                        }
                        JSONObject inAppResponseJson = new JSONObject();
                        inAppResponseJson.put("inapp_notifs", (Object)inappNotifs);
                        AnalyticsManager.this.inAppResponse.processResponse(inAppResponseJson, null, AnalyticsManager.this.context);
                    }
                    catch (Throwable t) {
                        Logger.v("Failed to display inapp notification from push notification payload", t);
                    }
                    return null;
                }
            });
            return;
        }
        if (extras.containsKey("wzrk_inbox")) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("testInboxNotification", new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        Logger.v("Received inbox via push payload: " + extras.getString("wzrk_inbox"));
                        JSONObject r = new JSONObject();
                        JSONArray inboxNotifs = new JSONArray();
                        r.put("inbox_notifs", (Object)inboxNotifs);
                        JSONObject testPushObject = new JSONObject(extras.getString("wzrk_inbox"));
                        testPushObject.put("_id", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
                        inboxNotifs.put((Object)testPushObject);
                        InboxResponse cleverTapResponse = new InboxResponse(AnalyticsManager.this.config, AnalyticsManager.this.ctLockManager, AnalyticsManager.this.callbackManager, AnalyticsManager.this.controllerManager);
                        ((CleverTapResponse)cleverTapResponse).processResponse(r, null, AnalyticsManager.this.context);
                    }
                    catch (Throwable t) {
                        Logger.v("Failed to process inbox message from push notification payload", t);
                    }
                    return null;
                }
            });
            return;
        }
        if (extras.containsKey("wzrk_adunit")) {
            this.handleSendTestForDisplayUnits(extras);
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification ID Tag is null, not processing Notification Clicked event for:  " + extras.toString());
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(extras, this.notificationIdTagMap, 5000);
        if (isDuplicate) {
            this.config.getLogger().debug(this.config.getAccountId(), "Already processed Notification Clicked event for " + extras.toString() + ", dropping duplicate.");
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            for (String x : extras.keySet()) {
                if (!x.startsWith("wzrk_")) continue;
                Object value = extras.get(x);
                notif.put(x, value);
            }
            event.put("evtName", (Object)"Notification Clicked");
            event.put("evtData", (Object)notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 4);
            try {
                this.coreMetaData.setWzrkParams(CTJsonConverter.getWzrkFields(extras));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.callbackManager.getPushNotificationListener() != null) {
            this.callbackManager.getPushNotificationListener().onNotificationClickedPayloadReceived(Utils.convertBundleObjectToHashMap(extras));
        } else {
            Logger.d("CTPushNotificationListener is not set");
        }
    }

    private JSONObject getHalfInterstitialInApp(JSONObject inapp) throws JSONException {
        String inAppConfig = inapp.optString("imageInterstitialConfig");
        String htmlContent = this.wrapImageInterstitialContent(inAppConfig);
        if (htmlContent != null) {
            inapp.put("type", (Object)"custom-html");
            Object data = inapp.opt("d");
            if (data instanceof JSONObject) {
                JSONObject dataObject = (JSONObject)data;
                dataObject = new JSONObject(dataObject.toString());
                dataObject.put("html", (Object)htmlContent);
                inapp.put("d", (Object)dataObject);
            } else {
                JSONObject newData = new JSONObject();
                newData.put("html", (Object)htmlContent);
                inapp.put("d", (Object)newData);
            }
        } else {
            this.config.getLogger().debug(this.config.getAccountId(), "Failed to parse the image-interstitial notification");
            return null;
        }
        return inapp;
    }

    public String wrapImageInterstitialContent(String content) {
        try {
            String[] parts;
            String html = Utils.readAssetFile(this.context, "image_interstitial.html");
            if (html != null && content != null && (parts = html.split("\"##Vars##\"")).length == 2) {
                return String.format("%s'%s'%s", parts[0], content, parts[1]);
            }
        }
        catch (IOException e) {
            this.config.getLogger().debug(this.config.getAccountId(), "Failed to read the image-interstitial HTML file");
        }
        return null;
    }

    @Override
    public void pushNotificationViewedEvent(Bundle extras) {
        if (extras == null || extras.isEmpty() || extras.get("wzrk_pn") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification: " + (extras == null ? "NULL" : extras.toString()) + " not from CleverTap - will not process Notification Viewed event.");
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification ID Tag is null, not processing Notification Viewed event for:  " + extras.toString());
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(extras, this.notificationViewedIdTagMap, 2000);
        if (isDuplicate) {
            this.config.getLogger().debug(this.config.getAccountId(), "Already processed Notification Viewed event for " + extras.toString() + ", dropping duplicate.");
            return;
        }
        this.config.getLogger().debug("Recording Notification Viewed event for notification:  " + extras.toString());
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(extras);
            event.put("evtName", (Object)"Notification Viewed");
            event.put("evtData", (Object)notif);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.baseEventQueueManager.queueEvent(this.context, event, 6);
    }

    @Override
    public void pushProfile(final Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("profilePush", new Callable<Void>(){

            @Override
            public Void call() {
                AnalyticsManager.this._push(profile);
                return null;
            }
        });
    }

    @Override
    public void removeMultiValuesForKey(final String key, final ArrayList<String> values) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("removeMultiValuesForKey", new Callable<Void>(){

            @Override
            public Void call() {
                AnalyticsManager.this._handleMultiValues(values, key, "$remove");
                return null;
            }
        });
    }

    @Override
    public void removeValueForKey(final String key) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("removeValueForKey", new Callable<Void>(){

            @Override
            public Void call() {
                AnalyticsManager.this._removeValueForKey(key);
                return null;
            }
        });
    }

    @Override
    public void sendDataEvent(JSONObject event) {
        this.baseEventQueueManager.queueEvent(this.context, event, 5);
    }

    void _generateEmptyMultiValueError(String key) {
        ValidationResult error = ValidationResultFactory.create(512, 1, key);
        this.validationResultStack.pushValidationResult(error);
        this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
    }

    void pushChargedEvent(HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) {
        if (chargeDetails == null || items == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Invalid Charged event: details and or items is null");
            return;
        }
        if (items.size() > 50) {
            ValidationResult error = ValidationResultFactory.create(522);
            this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
            this.validationResultStack.pushValidationResult(error);
        }
        JSONObject evtData = new JSONObject();
        JSONObject chargedEvent = new JSONObject();
        try {
            ValidationResult vr;
            for (String key : chargeDetails.keySet()) {
                Object value = chargeDetails.get(key);
                vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = ValidationResultFactory.create(511, 7, "Charged", key, value != null ? value.toString() : "");
                    this.validationResultStack.pushValidationResult(error);
                    this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                evtData.put(key, value);
            }
            JSONArray jsonItemsArray = new JSONArray();
            for (HashMap<String, Object> map : items) {
                JSONObject itemDetails = new JSONObject();
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    vr = this.validator.cleanObjectKey(key);
                    key = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                    }
                    try {
                        vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                    }
                    catch (IllegalArgumentException e) {
                        ValidationResult error = ValidationResultFactory.create(511, 15, key, value != null ? value.toString() : "");
                        this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                        this.validationResultStack.pushValidationResult(error);
                        continue;
                    }
                    value = vr.getObject();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                    }
                    itemDetails.put(key, value);
                }
                jsonItemsArray.put((Object)itemDetails);
            }
            evtData.put("Items", (Object)jsonItemsArray);
            chargedEvent.put("evtName", (Object)"Charged");
            chargedEvent.put("evtData", (Object)evtData);
            this.baseEventQueueManager.queueEvent(this.context, chargedEvent, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    synchronized void pushDeepLink(Uri uri, boolean install) {
        if (uri == null) {
            return;
        }
        try {
            JSONObject referrer = UriHelper.getUrchinFromUri(uri);
            if (referrer.has("us")) {
                this.coreMetaData.setSource(referrer.get("us").toString());
            }
            if (referrer.has("um")) {
                this.coreMetaData.setMedium(referrer.get("um").toString());
            }
            if (referrer.has("uc")) {
                this.coreMetaData.setCampaign(referrer.get("uc").toString());
            }
            referrer.put("referrer", (Object)uri.toString());
            if (install) {
                referrer.put("install", true);
            }
            this.recordPageEventWithExtras(referrer);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to push deep link", t);
        }
    }

    Future<?> raiseEventForSignedCall(String eventName, JSONObject dcEventProperties) {
        Future<?> future = null;
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)dcEventProperties);
            future = this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (JSONException e) {
            this.config.getLogger().debug(this.config.getAccountId(), "SignedCall : JSON Exception when raising Signed Call event " + eventName + " - " + e.getLocalizedMessage());
        }
        return future;
    }

    Future<?> raiseEventForGeofences(String eventName, JSONObject geofenceProperties) {
        Future<?> future = null;
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)geofenceProperties);
            Location location = new Location("");
            location.setLatitude(geofenceProperties.getDouble("triggered_lat"));
            location.setLongitude(geofenceProperties.getDouble("triggered_lng"));
            geofenceProperties.remove("triggered_lat");
            geofenceProperties.remove("triggered_lng");
            this.coreMetaData.setLocationFromUser(location);
            future = this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (JSONException e) {
            this.config.getLogger().debug(this.config.getAccountId(), "Geofences : JSON Exception when raising GeoFence event " + eventName + " - " + e.getLocalizedMessage());
        }
        return future;
    }

    void recordPageEventWithExtras(JSONObject extras) {
        try {
            JSONObject jsonObject = new JSONObject();
            if (extras != null && extras.length() > 0) {
                Iterator keys = extras.keys();
                while (keys.hasNext()) {
                    try {
                        String key = (String)keys.next();
                        jsonObject.put(key, (Object)extras.getString(key));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            this.baseEventQueueManager.queueEvent(this.context, jsonObject, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setMultiValuesForKey(final String key, final ArrayList<String> values) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("setMultiValuesForKey", new Callable<Void>(){

            @Override
            public Void call() {
                AnalyticsManager.this._handleMultiValues(values, key, "$set");
                return null;
            }
        });
    }

    private JSONArray _cleanMultiValues(ArrayList<String> values, String key) {
        try {
            if (values == null || key == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            for (String value : values) {
                Object _value;
                value = value == null ? "" : value;
                ValidationResult vr = this.validator.cleanMultiValuePropertyValue(value);
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                String string2 = value = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
                if (value == null || value.isEmpty()) {
                    this._generateEmptyMultiValueError(key);
                    return null;
                }
                cleanedValues.put((Object)value);
            }
            return cleanedValues;
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error cleaning multi values for key " + key, t);
            this._generateEmptyMultiValueError(key);
            return null;
        }
    }

    private JSONArray _constructExistingMultiValue(String key, String command) {
        boolean remove = command.equals("$remove");
        boolean add = command.equals("$add");
        if (!remove && !add) {
            return new JSONArray();
        }
        Object existing = this._getProfilePropertyIgnorePersonalizationFlag(key);
        if (existing == null) {
            if (remove) {
                return null;
            }
            return new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray _default = add ? new JSONArray() : null;
        String stringified = this._stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : _default;
    }

    private void _generateInvalidMultiValueKeyError(String key) {
        ValidationResult error = ValidationResultFactory.create(523, 23, key);
        this.validationResultStack.pushValidationResult(error);
        this.config.getLogger().debug(this.config.getAccountId(), "Invalid multi-value property key " + key + " profile multi value operation aborted");
    }

    private Object _getProfilePropertyIgnorePersonalizationFlag(String key) {
        return this.localDataStore.getProfileValueForKey(key);
    }

    private void _handleMultiValues(ArrayList<String> values, String key, String command) {
        Object _key;
        String cleanKey;
        if (key == null) {
            return;
        }
        if (values == null || values.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        ValidationResult vr = this.validator.cleanMultiValuePropertyKey(key);
        if (vr.getErrorCode() != 0) {
            this.validationResultStack.pushValidationResult(vr);
        }
        String string2 = cleanKey = (_key = vr.getObject()) != null ? vr.getObject().toString() : null;
        if (cleanKey == null || cleanKey.isEmpty()) {
            this._generateInvalidMultiValueKeyError(key);
            return;
        }
        key = cleanKey;
        try {
            JSONArray currentValues = this._constructExistingMultiValue(key, command);
            JSONArray newValues = this._cleanMultiValues(values, key);
            this._validateAndPushMultiValue(currentValues, newValues, values, key, command);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error handling multi value operation for key " + key, t);
        }
    }

    private void _constructIncrementDecrementValues(Number value, String key, String command) {
        try {
            if (key == null || value == null) {
                return;
            }
            ValidationResult vr = this.validator.cleanObjectKey(key);
            if ((key = vr.getObject().toString()).isEmpty()) {
                ValidationResult error = ValidationResultFactory.create(512, 2, key);
                this.validationResultStack.pushValidationResult(error);
                this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                return;
            }
            if (value.intValue() < 0 || value.doubleValue() < 0.0 || value.floatValue() < 0.0f) {
                ValidationResult error = ValidationResultFactory.create(512, 25, key);
                this.validationResultStack.pushValidationResult(error);
                this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                return;
            }
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            Number updatedValue = this._handleIncrementDecrementValues(key, value, command);
            this.localDataStore.setProfileField(key, updatedValue);
            JSONObject commandObj = new JSONObject().put(command, (Object)value);
            JSONObject updateObj = new JSONObject().put(key, (Object)commandObj);
            this.baseEventQueueManager.pushBasicProfile(updateObj, false);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to update profile value for key " + key, t);
        }
    }

    private Number _handleIncrementDecrementValues(@NonNull String key, Number value, String command) {
        Number updatedValue = null;
        Number existingValue = (Number)this._getProfilePropertyIgnorePersonalizationFlag(key);
        if (existingValue == null) {
            switch (this.getNumberValueType(value)) {
                case DOUBLE_NUMBER: {
                    if (command.equals("$incr")) {
                        updatedValue = value.doubleValue();
                        break;
                    }
                    if (!command.equals("$decr")) break;
                    updatedValue = -value.doubleValue();
                    break;
                }
                case FLOAT_NUMBER: {
                    if (command.equals("$incr")) {
                        updatedValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (!command.equals("$decr")) break;
                    updatedValue = Float.valueOf(-value.floatValue());
                    break;
                }
                default: {
                    if (command.equals("$incr")) {
                        updatedValue = value.intValue();
                        break;
                    }
                    if (!command.equals("$decr")) break;
                    updatedValue = -value.intValue();
                }
            }
            return updatedValue;
        }
        switch (this.getNumberValueType(existingValue)) {
            case DOUBLE_NUMBER: {
                if (command.equals("$incr")) {
                    updatedValue = existingValue.doubleValue() + value.doubleValue();
                    break;
                }
                if (!command.equals("$decr")) break;
                updatedValue = existingValue.doubleValue() - value.doubleValue();
                break;
            }
            case FLOAT_NUMBER: {
                if (command.equals("$incr")) {
                    updatedValue = Float.valueOf(existingValue.floatValue() + value.floatValue());
                    break;
                }
                if (!command.equals("$decr")) break;
                updatedValue = Float.valueOf(existingValue.floatValue() - value.floatValue());
                break;
            }
            default: {
                if (command.equals("$incr")) {
                    updatedValue = existingValue.intValue() + value.intValue();
                    break;
                }
                if (!command.equals("$decr")) break;
                updatedValue = existingValue.intValue() - value.intValue();
            }
        }
        return updatedValue;
    }

    private NumberValueType getNumberValueType(Number value) {
        if (value.equals(value.intValue())) {
            this.numberValueType = NumberValueType.INT_NUMBER;
        } else if (value.equals(value.doubleValue())) {
            this.numberValueType = NumberValueType.DOUBLE_NUMBER;
        } else if (value.equals(Float.valueOf(value.floatValue()))) {
            this.numberValueType = NumberValueType.FLOAT_NUMBER;
        }
        return this.numberValueType;
    }

    private void _push(Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        try {
            JSONObject customProfile = new JSONObject();
            JSONObject fieldsToUpdateLocally = new JSONObject();
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                ValidationResult vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                if (key.isEmpty()) {
                    ValidationResult keyError = ValidationResultFactory.create(512, 2, new String[0]);
                    this.validationResultStack.pushValidationResult(keyError);
                    this.config.getLogger().debug(this.config.getAccountId(), keyError.getErrorDesc());
                    continue;
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Profile);
                }
                catch (Throwable e) {
                    ValidationResult error = ValidationResultFactory.create(512, 3, value != null ? value.toString() : "", key);
                    this.validationResultStack.pushValidationResult(error);
                    this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                if (key.equalsIgnoreCase("Phone")) {
                    try {
                        String _value;
                        value = value.toString();
                        String countryCode = this.deviceInfo.getCountryCode();
                        if ((countryCode == null || countryCode.isEmpty()) && !(_value = (String)value).startsWith("+")) {
                            ValidationResult error = ValidationResultFactory.create(512, 4, _value);
                            this.validationResultStack.pushValidationResult(error);
                            this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                        }
                        this.config.getLogger().verbose(this.config.getAccountId(), "Profile phone is: " + value + " device country code is: " + (countryCode != null ? countryCode : "null"));
                    }
                    catch (Exception e) {
                        this.validationResultStack.pushValidationResult(ValidationResultFactory.create(512, 5, new String[0]));
                        this.config.getLogger().debug(this.config.getAccountId(), "Invalid phone number: " + e.getLocalizedMessage());
                        continue;
                    }
                }
                fieldsToUpdateLocally.put(key, value);
                customProfile.put(key, value);
            }
            this.config.getLogger().verbose(this.config.getAccountId(), "Constructed custom profile: " + customProfile.toString());
            if (fieldsToUpdateLocally.length() > 0) {
                this.localDataStore.setProfileFields(fieldsToUpdateLocally);
            }
            this.baseEventQueueManager.pushBasicProfile(customProfile, false);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to push profile", t);
        }
    }

    private void _removeValueForKey(String key) {
        try {
            key = key == null ? "" : key;
            ValidationResult vr = this.validator.cleanObjectKey(key);
            key = vr.getObject().toString();
            if (key.isEmpty()) {
                ValidationResult error = ValidationResultFactory.create(512, 6, new String[0]);
                this.validationResultStack.pushValidationResult(error);
                this.config.getLogger().debug(this.config.getAccountId(), error.getErrorDesc());
                return;
            }
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            if (key.toLowerCase().contains("identity")) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Cannot remove value for key " + key + " from user profile");
                return;
            }
            this.localDataStore.removeProfileField(key);
            JSONObject command = new JSONObject().put("$delete", true);
            JSONObject update = new JSONObject().put(key, (Object)command);
            this.baseEventQueueManager.pushBasicProfile(update, true);
            this.config.getLogger().verbose(this.config.getAccountId(), "removing value for key " + key + " from user profile");
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to remove profile value for key " + key, t);
        }
    }

    private String _stringifyAndCleanScalarProfilePropValue(Object value) {
        String val = CTJsonConverter.toJsonString(value);
        if (val != null) {
            Object _value;
            ValidationResult vr = this.validator.cleanMultiValuePropertyValue(val);
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            val = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return val;
    }

    private void _validateAndPushMultiValue(JSONArray currentValues, JSONArray newValues, ArrayList<String> originalValues, String key, String command) {
        try {
            JSONArray localValues;
            if (currentValues == null || newValues == null || originalValues == null || key == null || command == null) {
                return;
            }
            String mergeOperation = command.equals("$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
            ValidationResult vr = this.validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            if ((localValues = (JSONArray)vr.getObject()) == null || localValues.length() <= 0) {
                this.localDataStore.removeProfileField(key);
            } else {
                this.localDataStore.setProfileField(key, localValues);
            }
            JSONObject commandObj = new JSONObject();
            commandObj.put(command, (Object)new JSONArray(originalValues));
            JSONObject fields = new JSONObject();
            fields.put(key, (Object)commandObj);
            this.baseEventQueueManager.pushBasicProfile(fields, false);
            this.config.getLogger().verbose(this.config.getAccountId(), "Constructed multi-value profile push: " + fields.toString());
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error pushing multiValue for key " + key, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDuplicateNotificationIds(Bundle extras, HashMap<String, Object> notificationTagMap, int interval) {
        Object object = this.notificationMapLock;
        synchronized (object) {
            boolean isDupe = false;
            try {
                long timestamp;
                String notificationIdTag = extras.getString("wzrk_id");
                long now = System.currentTimeMillis();
                if (notificationTagMap.containsKey(notificationIdTag) && now - (timestamp = ((Long)notificationTagMap.get(notificationIdTag)).longValue()) < (long)interval) {
                    isDupe = true;
                }
                notificationTagMap.put(notificationIdTag, now);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return isDupe;
        }
    }

    public void sendPingEvent(JSONObject eventObject) {
        this.baseEventQueueManager.queueEvent(this.context, eventObject, 2);
    }

    @Override
    public void sendFetchEvent(JSONObject eventObject) {
        this.baseEventQueueManager.queueEvent(this.context, eventObject, 7);
    }

    private void handleSendTestForDisplayUnits(Bundle extras) {
        try {
            JSONObject r = CTJsonConverter.displayUnitFromExtras(extras);
            DisplayUnitResponse cleverTapResponse = new DisplayUnitResponse(this.config, this.callbackManager, this.controllerManager);
            ((CleverTapResponse)cleverTapResponse).processResponse(r, null, this.context);
        }
        catch (Throwable t) {
            Logger.v("Failed to process Display Unit from push notification payload", t);
        }
    }

    void pushInboxMessageStateEvent(boolean clicked, CTInboxMessage data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.coreMetaData.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static enum NumberValueType {
        INT_NUMBER,
        FLOAT_NUMBER,
        DOUBLE_NUMBER;

    }
}

