/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DidClickForHardPermissionListener;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.InAppListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CTInAppBaseFragment
extends Fragment {
    CloseImageView closeImageView = null;
    CleverTapInstanceConfig config;
    Context context;
    int currentOrientation;
    CTInAppNotification inAppNotification;
    AtomicBoolean isCleanedUp = new AtomicBoolean();
    private WeakReference<InAppListener> listenerWeakReference;
    private DidClickForHardPermissionListener didClickForHardPermissionListener;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.context = context;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.inAppNotification = (CTInAppNotification)bundle.getParcelable("inApp");
            this.config = (CleverTapInstanceConfig)bundle.getParcelable("config");
            this.currentOrientation = this.getResources().getConfiguration().orientation;
            this.generateListener();
            if (context instanceof DidClickForHardPermissionListener) {
                this.didClickForHardPermissionListener = (DidClickForHardPermissionListener)context;
            }
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.didShow(null);
    }

    abstract void cleanup();

    void didClick(Bundle data, HashMap<String, String> keyValueMap) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidClick(this.inAppNotification, data, keyValueMap);
        }
    }

    public void didDismiss(Bundle data) {
        this.cleanup();
        InAppListener listener = this.getListener();
        if (listener != null && this.getActivity() != null && this.getActivity().getBaseContext() != null) {
            listener.inAppNotificationDidDismiss(this.getActivity().getBaseContext(), this.inAppNotification, data);
        }
    }

    void didShow(Bundle data) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.inAppNotification, data);
        }
    }

    void fireUrlThroughIntent(String url, Bundle formData) {
        try {
            Uri uri = Uri.parse((String)url.replace("\n", "").replace("\r", ""));
            Set queryParamSet = uri.getQueryParameterNames();
            Bundle queryBundle = new Bundle();
            if (queryParamSet != null && !queryParamSet.isEmpty()) {
                for (String queryName : queryParamSet) {
                    queryBundle.putString(queryName, uri.getQueryParameter(queryName));
                }
            }
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (!queryBundle.isEmpty()) {
                intent.putExtras(queryBundle);
            }
            Utils.setPackageNameFromResolveInfoList((Context)this.getActivity(), intent);
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.didDismiss(formData);
    }

    abstract void generateListener();

    InAppListener getListener() {
        InAppListener listener = null;
        try {
            listener = (InAppListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    void setListener(InAppListener listener) {
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    void handleButtonClickAtIndex(int index) {
        try {
            CTInAppNotificationButton button = this.inAppNotification.getButtons().get(index);
            Bundle data = new Bundle();
            data.putString("wzrk_id", this.inAppNotification.getCampaignId());
            data.putString("wzrk_c2a", button.getText());
            this.didClick(data, button.getKeyValues());
            if (index == 0 && this.inAppNotification.isLocalInApp() && this.didClickForHardPermissionListener != null) {
                this.didClickForHardPermissionListener.didClickForHardPermissionWithFallbackSettings(this.inAppNotification.fallBackToNotificationSettings());
                return;
            }
            if (index == 1 && this.inAppNotification.isLocalInApp()) {
                this.didDismiss(data);
                return;
            }
            if (button.getType() != null && button.getType().contains("rfp") && this.didClickForHardPermissionListener != null) {
                this.didClickForHardPermissionListener.didClickForHardPermissionWithFallbackSettings(button.isFallbackToSettings());
                return;
            }
            String actionUrl = button.getActionUrl();
            if (actionUrl != null) {
                this.fireUrlThroughIntent(actionUrl, data);
                return;
            }
            this.didDismiss(data);
        }
        catch (Throwable t) {
            this.config.getLogger().debug("Error handling notification button click: " + t.getCause());
            this.didDismiss(null);
        }
    }

    class CTInAppNativeButtonClickListener
    implements View.OnClickListener {
        CTInAppNativeButtonClickListener() {
        }

        public void onClick(View view) {
            CTInAppBaseFragment.this.handleButtonClickAtIndex((Integer)view.getTag());
        }
    }
}

