/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.db.QueueCursor;
import com.clevertap.android.sdk.events.EventGroup;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class DBManager
extends BaseDatabaseManager {
    private DBAdapter dbAdapter;
    private final CTLockManager ctLockManager;
    private final CleverTapInstanceConfig config;

    public DBManager(CleverTapInstanceConfig config, CTLockManager ctLockManager) {
        this.config = config;
        this.ctLockManager = ctLockManager;
    }

    @Override
    @WorkerThread
    public DBAdapter loadDBAdapter(Context context) {
        if (this.dbAdapter == null) {
            this.dbAdapter = new DBAdapter(context, this.config);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.EVENTS);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.PROFILE_EVENTS);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.PUSH_NOTIFICATION_VIEWED);
            this.dbAdapter.cleanUpPushNotifications();
        }
        return this.dbAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearQueues(Context context) {
        Boolean bl = this.ctLockManager.getEventLock();
        synchronized (bl) {
            DBAdapter adapter = this.loadDBAdapter(context);
            DBAdapter.Table tableName = DBAdapter.Table.EVENTS;
            adapter.removeEvents(tableName);
            tableName = DBAdapter.Table.PROFILE_EVENTS;
            adapter.removeEvents(tableName);
            this.clearUserContext(context);
        }
    }

    private void clearIJ(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    private void clearLastRequestTimestamp(Context context) {
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), 0);
    }

    private void clearUserContext(Context context) {
        this.clearIJ(context);
        this.clearFirstRequestTimestampIfNeeded(context);
        this.clearLastRequestTimestamp(context);
    }

    private void clearFirstRequestTimestampIfNeeded(Context context) {
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), 0);
    }

    @Override
    QueueCursor getPushNotificationViewedQueuedEvents(Context context, int batchSize, QueueCursor previousCursor) {
        return this.getQueueCursor(context, DBAdapter.Table.PUSH_NOTIFICATION_VIEWED, batchSize, previousCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    QueueCursor getQueueCursor(Context context, DBAdapter.Table table, int batchSize, QueueCursor previousCursor) {
        Boolean bl = this.ctLockManager.getEventLock();
        synchronized (bl) {
            DBAdapter.Table tableName;
            DBAdapter adapter = this.loadDBAdapter(context);
            DBAdapter.Table table2 = tableName = previousCursor != null ? previousCursor.getTableName() : table;
            if (previousCursor != null) {
                adapter.cleanupEventsFromLastId(previousCursor.getLastId(), previousCursor.getTableName());
            }
            QueueCursor newCursor = new QueueCursor();
            newCursor.setTableName(tableName);
            JSONObject queuedDBEvents = adapter.fetchEvents(tableName, batchSize);
            newCursor = this.updateCursorForDBObject(queuedDBEvents, newCursor);
            return newCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    QueueCursor getQueuedDBEvents(Context context, int batchSize, QueueCursor previousCursor) {
        Boolean bl = this.ctLockManager.getEventLock();
        synchronized (bl) {
            QueueCursor newCursor = this.getQueueCursor(context, DBAdapter.Table.EVENTS, batchSize, previousCursor);
            if (newCursor.isEmpty().booleanValue() && newCursor.getTableName().equals((Object)DBAdapter.Table.EVENTS)) {
                newCursor = this.getQueueCursor(context, DBAdapter.Table.PROFILE_EVENTS, batchSize, null);
            }
            return newCursor.isEmpty() != false ? null : newCursor;
        }
    }

    @Override
    public QueueCursor getQueuedEvents(Context context, int batchSize, QueueCursor previousCursor, EventGroup eventGroup) {
        if (eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Returning Queued Notification Viewed events");
            return this.getPushNotificationViewedQueuedEvents(context, batchSize, previousCursor);
        }
        this.config.getLogger().verbose(this.config.getAccountId(), "Returning Queued events");
        return this.getQueuedDBEvents(context, batchSize, previousCursor);
    }

    @Override
    @WorkerThread
    public void queueEventToDB(Context context, JSONObject event, int type) {
        DBAdapter.Table table = type == 3 ? DBAdapter.Table.PROFILE_EVENTS : DBAdapter.Table.EVENTS;
        this.queueEventInternal(context, event, table);
    }

    @Override
    @WorkerThread
    public void queuePushNotificationViewedEventToDB(Context context, JSONObject event) {
        this.queueEventInternal(context, event, DBAdapter.Table.PUSH_NOTIFICATION_VIEWED);
    }

    @Override
    QueueCursor updateCursorForDBObject(JSONObject dbObject, QueueCursor cursor) {
        if (dbObject == null) {
            return cursor;
        }
        Iterator keys = dbObject.keys();
        if (keys.hasNext()) {
            String key = (String)keys.next();
            cursor.setLastId(key);
            try {
                cursor.setData(dbObject.getJSONArray(key));
            }
            catch (JSONException e) {
                cursor.setLastId(null);
                cursor.setData(null);
            }
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void queueEventInternal(Context context, JSONObject event, DBAdapter.Table table) {
        Boolean bl = this.ctLockManager.getEventLock();
        synchronized (bl) {
            DBAdapter adapter = this.loadDBAdapter(context);
            int returnCode = adapter.storeObject(event, table);
            if (returnCode > 0) {
                this.config.getLogger().debug(this.config.getAccountId(), "Queued event: " + event.toString());
                this.config.getLogger().verbose(this.config.getAccountId(), "Queued event to DB table " + (Object)((Object)table) + ": " + event.toString());
            }
        }
    }
}

