/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.location.Location;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CTFeatureFlagsListener;
import com.clevertap.android.sdk.CTInboxListener;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapFactory;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.CoreState;
import com.clevertap.android.sdk.GeofenceCallback;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppNotificationButtonListener;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.InboxMessageButtonListener;
import com.clevertap.android.sdk.InboxMessageListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.PushPermissionResponseListener;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.UTMDetail;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.displayunits.DisplayUnitListener;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.events.EventDetail;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsController;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import com.clevertap.android.sdk.interfaces.NotificationHandler;
import com.clevertap.android.sdk.interfaces.NotificationRenderedListener;
import com.clevertap.android.sdk.interfaces.OnInitCleverTapIDListener;
import com.clevertap.android.sdk.interfaces.SCDomainListener;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.product_config.CTProductConfigListener;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationListener;
import com.clevertap.android.sdk.pushnotification.CoreNotificationRenderer;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.NotificationInfo;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.amp.CTPushAmpListener;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.UriHelper;
import com.clevertap.android.sdk.validation.ManifestValidator;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.variables.CTVariables;
import com.clevertap.android.sdk.variables.Var;
import com.clevertap.android.sdk.variables.callbacks.FetchVariablesCallback;
import com.clevertap.android.sdk.variables.callbacks.VariablesChangedCallback;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.firebase.messaging.FirebaseMessaging;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.json.JSONException;
import org.json.JSONObject;

public class CleverTapAPI
implements CTInboxActivity.InboxActivityListener {
    public static final String NOTIFICATION_TAG = "wzrk_pn";
    private static int debugLevel = LogLevel.INFO.intValue();
    static CleverTapInstanceConfig defaultConfig;
    private static HashMap<String, CleverTapAPI> instances;
    private static String sdkVersion;
    private static NotificationHandler sNotificationHandler;
    private static NotificationHandler sSignedCallNotificationHandler;
    private static HashMap<String, NotificationRenderedListener> sNotificationRenderedListenerMap;
    private final Context context;
    private CoreState coreState;
    private WeakReference<InboxMessageButtonListener> inboxMessageButtonListener;
    private WeakReference<InboxMessageListener> inboxMessageListener;

    public static void changeCredentials(String accountID, String token) {
        CleverTapAPI.changeCredentials(accountID, token, null);
    }

    public static void changeCredentials(String accountID, String token, String region) {
        if (defaultConfig != null) {
            Logger.i("CleverTap SDK already initialized with accountID:" + defaultConfig.getAccountId() + " and token:" + defaultConfig.getAccountToken() + ". Cannot change credentials to " + accountID + " and " + token);
            return;
        }
        ManifestInfo.changeCredentials(accountID, token, region);
    }

    public static void changeCredentials(String accountID, String token, String proxyDomain, String spikyProxyDomain) {
        if (defaultConfig != null) {
            Logger.i("CleverTap SDK already initialized with accountID:" + defaultConfig.getAccountId() + ", token:" + defaultConfig.getAccountToken() + ", proxyDomain: " + defaultConfig.getProxyDomain() + " and spikyDomain: " + defaultConfig.getSpikyProxyDomain() + ". Cannot change credentials to accountID: " + accountID + ", token: " + token + ", proxyDomain: " + proxyDomain + "and spikyProxyDomain: " + spikyProxyDomain);
            return;
        }
        ManifestInfo.changeCredentials(accountID, token, proxyDomain, spikyProxyDomain);
    }

    public static void changeXiaomiCredentials(String xiaomiAppID, String xiaomiAppKey) {
        ManifestInfo.changeXiaomiCredentials(xiaomiAppID, xiaomiAppKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNotification(Context context, Bundle extras, int notificationId) {
        CleverTapAPI instance = CleverTapAPI.fromBundle(context, extras);
        if (instance != null) {
            CoreState coreState = instance.coreState;
            CleverTapInstanceConfig config = coreState.getConfig();
            try {
                Object object = coreState.getPushProviders().getPushRenderingLock();
                synchronized (object) {
                    coreState.getPushProviders().setPushNotificationRenderer(new CoreNotificationRenderer());
                    coreState.getPushProviders()._createNotification(context, extras, notificationId);
                }
            }
            catch (Throwable t) {
                config.getLogger().debug(config.getAccountId(), "Failed to process createNotification()", t);
            }
        }
    }

    @Nullable
    public static CleverTapAPI getGlobalInstance(Context context, String _accountId) {
        return CleverTapAPI.fromAccountId(context, _accountId);
    }

    public static void processPushNotification(Context context, Bundle extras) {
        CleverTapAPI instance = CleverTapAPI.fromBundle(context, extras);
        if (instance != null) {
            instance.coreState.getPushProviders().processCustomPushNotification(extras);
        }
    }

    public static void createNotification(Context context, Bundle extras) {
        CleverTapAPI.createNotification(context, extras, -1000);
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("createNotificationChannel", new Callable<Void>(){

                    @Override
                    @RequiresApi(api=26)
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    @RequiresApi(api=26)
    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("creatingNotificationChannel", new Callable<Void>(){

                    @Override
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    @RequiresApi(api=26)
    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge, final String sound) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("createNotificationChannel", new Callable<Void>(){

                    @Override
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        String soundfile = "";
                        Uri soundUri = null;
                        if (!sound.isEmpty()) {
                            if (sound.contains(".mp3") || sound.contains(".ogg") || sound.contains(".wav")) {
                                soundfile = sound.substring(0, sound.length() - 4);
                            } else {
                                instance.getConfigLogger().debug(instance.getAccountId(), "Sound file name not supported");
                            }
                            if (!soundfile.isEmpty()) {
                                soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + soundfile));
                            }
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        if (soundUri != null) {
                            notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
                        } else {
                            instance.getConfigLogger().debug(instance.getAccountId(), "Sound file not found, notification channel will be created without custom sound");
                        }
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    @RequiresApi(api=26)
    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge, final String sound) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("creatingNotificationChannel", new Callable<Void>(){

                    @Override
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        String soundfile = "";
                        Uri soundUri = null;
                        if (!sound.isEmpty()) {
                            if (sound.contains(".mp3") || sound.contains(".ogg") || sound.contains(".wav")) {
                                soundfile = sound.substring(0, sound.length() - 4);
                            } else {
                                instance.getConfigLogger().debug(instance.getAccountId(), "Sound file name not supported");
                            }
                            if (!soundfile.isEmpty()) {
                                soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + soundfile));
                            }
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        if (soundUri != null) {
                            notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
                        } else {
                            instance.getConfigLogger().debug(instance.getAccountId(), "Sound file not found, notification channel will be created without custom sound");
                        }
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    @RequiresApi(api=26)
    public static void createNotificationChannelGroup(final Context context, final String groupId, final CharSequence groupName) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificationChannelGroup");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("creatingNotificationChannelGroup", new Callable<Void>(){

                    @Override
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(groupId, groupName));
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel group " + groupName.toString() + " has been created");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel Group", t);
        }
    }

    @RequiresApi(api=26)
    public static void deleteNotificationChannel(final Context context, final String channelId) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#deleteNotificationChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("deletingNotificationChannel", new Callable<Void>(){

                    @Override
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        notificationManager.deleteNotificationChannel(channelId);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelId + " has been deleted");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure deleting Notification Channel", t);
        }
    }

    @RequiresApi(api=26)
    public static void deleteNotificationChannelGroup(final Context context, final String groupId) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#deleteNotificationChannelGroup");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
                task.execute("deletingNotificationChannelGroup", new Callable<Void>(){

                    @Override
                    public Void call() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return null;
                        }
                        notificationManager.deleteNotificationChannelGroup(groupId);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel group " + groupId + " has been deleted");
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure deleting Notification Channel Group", t);
        }
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void fcmTokenRefresh(Context context, String token) {
        for (CleverTapAPI instance : CleverTapAPI.getAvailableInstances(context)) {
            if (instance == null || instance.getCoreState().getConfig().isAnalyticsOnly()) {
                Logger.d("Instance is Analytics Only not processing device token");
                continue;
            }
            instance.getCoreState().getPushProviders().doTokenRefresh(token, PushConstants.PushType.FCM);
        }
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public static void setDebugLevel(LogLevel level) {
        debugLevel = level.intValue();
    }

    public static CleverTapAPI getDefaultInstance(Context context, String cleverTapID) {
        sdkVersion = "!SDK-VERSION-STRING!:com.clevertap.android:clevertap-android-sdk:5.2.2.0";
        if (defaultConfig != null) {
            return CleverTapAPI.instanceWithConfig(context, defaultConfig, cleverTapID);
        }
        defaultConfig = CleverTapAPI.getDefaultConfig(context);
        if (defaultConfig != null) {
            return CleverTapAPI.instanceWithConfig(context, defaultConfig, cleverTapID);
        }
        return null;
    }

    @Nullable
    public static CleverTapAPI getDefaultInstance(Context context) {
        return CleverTapAPI.getDefaultInstance(context, null);
    }

    private static CleverTapAPI fromAccountId(Context context, String _accountId) {
        if (instances == null) {
            return CleverTapAPI.createInstanceIfAvailable(context, _accountId);
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.coreState.getConfig().isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            return instance;
        }
        return null;
    }

    public static HashMap<String, CleverTapAPI> getInstances() {
        return instances;
    }

    public static void setInstances(HashMap<String, CleverTapAPI> instances) {
        CleverTapAPI.instances = instances;
    }

    public static NotificationInfo getNotificationInfo(Bundle extras) {
        if (extras == null) {
            return new NotificationInfo(false, false);
        }
        boolean fromCleverTap = extras.containsKey(NOTIFICATION_TAG);
        boolean shouldRender = fromCleverTap && extras.containsKey("nm");
        return new NotificationInfo(fromCleverTap, shouldRender);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void handleNotificationClicked(Context context, Bundle notification) {
        if (notification == null) {
            return;
        }
        String _accountId = null;
        try {
            _accountId = notification.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.createInstanceIfAvailable(context, _accountId);
            if (instance != null) {
                instance.pushNotificationClickedEvent(notification);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.coreState.getConfig().isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            instance.pushNotificationClickedEvent(notification);
            break;
        }
    }

    public static CleverTapAPI instanceWithConfig(Context context, CleverTapInstanceConfig config) {
        return CleverTapAPI.instanceWithConfig(context, config, null);
    }

    public static CleverTapAPI instanceWithConfig(Context context, @NonNull CleverTapInstanceConfig config, String cleverTapID) {
        CleverTapAPI instance;
        if (config == null) {
            Logger.v("CleverTapInstanceConfig cannot be null");
            return null;
        }
        if (instances == null) {
            instances = new HashMap();
        }
        if ((instance = instances.get(config.getAccountId())) == null) {
            instance = new CleverTapAPI(context, config, cleverTapID);
            instances.put(config.getAccountId(), instance);
            final CleverTapAPI finalInstance = instance;
            Task<Void> task = CTExecutorFactory.executors(instance.coreState.getConfig()).postAsyncSafelyTask();
            task.execute("recordDeviceIDErrors", new Callable<Void>(){

                @Override
                public Void call() {
                    if (finalInstance.getCleverTapID() != null) {
                        finalInstance.coreState.getLoginController().recordDeviceIDErrors();
                    }
                    return null;
                }
            });
        } else if (instance.isErrorDeviceId() && instance.getConfig().getEnableCustomCleverTapId() && Utils.validateCTID(cleverTapID)) {
            instance.coreState.getLoginController().asyncProfileSwitchUser(null, null, cleverTapID);
        }
        Logger.v(config.getAccountId() + ":async_deviceID", "CleverTapAPI instance = " + instance);
        return instance;
    }

    public static boolean isAppForeground() {
        return CoreMetaData.isAppForeground();
    }

    public static void setAppForeground(boolean appForeground) {
        CoreMetaData.setAppForeground(appForeground);
    }

    public static void onActivityPaused() {
        if (instances == null) {
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            try {
                if (instance == null) continue;
                instance.coreState.getActivityLifeCycleManager().activityPaused();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void onActivityResumed(Activity activity) {
        CleverTapAPI.onActivityResumed(activity, null);
    }

    public static void onActivityResumed(Activity activity, String cleverTapID) {
        if (instances == null) {
            CleverTapAPI.createInstanceIfAvailable(activity.getApplicationContext(), null, cleverTapID);
        }
        CoreMetaData.setAppForeground(true);
        if (instances == null) {
            Logger.v("Instances is null in onActivityResumed!");
            return;
        }
        String currentActivityName = CoreMetaData.getCurrentActivityName();
        CoreMetaData.setCurrentActivity(activity);
        if (currentActivityName == null || !currentActivityName.equals(activity.getLocalClassName())) {
            CoreMetaData.incrementActivityCount();
        }
        if (CoreMetaData.getInitialAppEnteredForegroundTime() <= 0) {
            int initialAppEnteredForegroundTime = Utils.getNow();
            CoreMetaData.setInitialAppEnteredForegroundTime(initialAppEnteredForegroundTime);
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            try {
                if (instance == null) continue;
                instance.coreState.getActivityLifeCycleManager().activityResumed(activity);
            }
            catch (Throwable t) {
                Logger.v("Throwable - " + t.getLocalizedMessage());
            }
        }
    }

    private static CleverTapAPI fromBundle(Context context, Bundle extras) {
        String _accountId = extras.getString("wzrk_acct_id");
        return CleverTapAPI.fromAccountId(context, _accountId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void runBackgroundIntentService(Context context) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                if (instance.getConfig().isBackgroundSync()) {
                    instance.coreState.getPushProviders().runInstanceJobWork(context, null);
                } else {
                    Logger.d("Instance doesn't allow Background sync, not running the Job");
                }
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance == null) continue;
            if (instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not processing device token");
                continue;
            }
            if (!instance.getConfig().isBackgroundSync()) {
                Logger.d(accountId, "Instance doesn't allow Background sync, not running the Job");
                continue;
            }
            instance.coreState.getPushProviders().runInstanceJobWork(context, null);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void runJobWork(Context context, JobParameters parameters) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                if (instance.getConfig().isBackgroundSync()) {
                    instance.coreState.getPushProviders().runInstanceJobWork(context, parameters);
                } else {
                    Logger.d("Instance doesn't allow Background sync, not running the Job");
                }
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance != null && instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not running the Job");
                continue;
            }
            if (instance == null || !instance.getConfig().isBackgroundSync()) {
                Logger.d(accountId, "Instance doesn't allow Background sync, not running the Job");
                continue;
            }
            instance.coreState.getPushProviders().runInstanceJobWork(context, parameters);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void tokenRefresh(Context context, String token, PushConstants.PushType pushType) {
        for (CleverTapAPI instance : CleverTapAPI.getAvailableInstances(context)) {
            instance.coreState.getPushProviders().doTokenRefresh(token, pushType);
        }
    }

    @SuppressLint(value={"NewApi"})
    public boolean isPushPermissionGranted() {
        if (CTXtensions.isPackageAndOsTargetsAbove(this.context, 32)) {
            return this.coreState.getInAppController().isPushPermissionGranted();
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public void promptPushPrimer(JSONObject jsonObject) {
        if (CTXtensions.isPackageAndOsTargetsAbove(this.context, 32)) {
            this.coreState.getInAppController().promptPushPrimer(jsonObject);
        } else {
            Logger.v("Ensure your app supports Android 13 to verify permission access for notifications.");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void promptForPushPermission(boolean showFallbackSettings) {
        if (CTXtensions.isPackageAndOsTargetsAbove(this.context, 32)) {
            this.coreState.getInAppController().promptPermission(showFallbackSettings);
        } else {
            Logger.v("Ensure your app supports Android 13 to verify permission access for notifications.");
        }
    }

    private CleverTapAPI(final Context context, final CleverTapInstanceConfig config, String cleverTapID) {
        this.context = context;
        CoreState coreState = CleverTapFactory.getCoreState(context, config, cleverTapID);
        this.setCoreState(coreState);
        this.getConfigLogger().verbose(config.getAccountId() + ":async_deviceID", "CoreState is set");
        Task<Void> task = CTExecutorFactory.executors(config).postAsyncSafelyTask();
        task.execute("CleverTapAPI#initializeDeviceInfo", new Callable<Void>(){

            @Override
            public Void call() {
                if (config.isDefaultInstance()) {
                    CleverTapAPI.this.manifestAsyncValidation();
                }
                return null;
            }
        });
        int now = Utils.getNow();
        if (now - CoreMetaData.getInitialAppEnteredForegroundTime() > 5) {
            this.coreState.getConfig().setCreatedPostAppLaunch();
        }
        task = CTExecutorFactory.executors(config).postAsyncSafelyTask();
        task.execute("setStatesAsync", new Callable<Void>(){

            @Override
            public Void call() {
                CleverTapAPI.this.coreState.getSessionManager().setLastVisitTime();
                CleverTapAPI.this.coreState.getDeviceInfo().setDeviceNetworkInfoReportingFromStorage();
                CleverTapAPI.this.coreState.getDeviceInfo().setCurrentUserOptOutStateFromStorage();
                return null;
            }
        });
        task = CTExecutorFactory.executors(config).postAsyncSafelyTask();
        task.execute("saveConfigtoSharedPrefs", new Callable<Void>(){

            @Override
            public Void call() {
                String configJson = config.toJSONString();
                if (configJson == null) {
                    Logger.v("Unable to save config to SharedPrefs, config Json is null");
                    return null;
                }
                StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(config, "instance"), configJson);
                return null;
            }
        });
        Logger.i("CleverTap SDK initialized with accountId: " + config.getAccountId() + " accountToken: " + config.getAccountToken() + " accountRegion: " + config.getAccountRegion());
    }

    public void addMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this.coreState.getAnalyticsManager()._generateEmptyMultiValueError(key);
            return;
        }
        this.addMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void addMultiValuesForKey(String key, ArrayList<String> values) {
        this.coreState.getAnalyticsManager().addMultiValuesForKey(key, values);
    }

    public void deleteInboxMessage(CTInboxMessage message) {
        if (this.coreState.getControllerManager().getCTInboxController() != null) {
            this.coreState.getControllerManager().getCTInboxController().deleteInboxMessage(message);
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
        }
    }

    public void deleteInboxMessage(String messageId) {
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.deleteInboxMessage(message);
    }

    public void deleteInboxMessagesForIDs(ArrayList<String> messageIDs) {
        if (this.coreState.getControllerManager().getCTInboxController() != null) {
            this.coreState.getControllerManager().getCTInboxController().deleteInboxMessagesForIDs(messageIDs);
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
        }
    }

    public void disablePersonalization() {
        this.coreState.getConfig().enablePersonalization(false);
    }

    public void discardInAppNotifications() {
        if (!this.getCoreState().getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Discarding InApp Notifications...");
            this.getConfigLogger().debug(this.getAccountId(), "Please Note - InApp Notifications will be dropped till resumeInAppNotifications() is not called again");
            this.getCoreState().getInAppController().discardInApps();
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap instance is set for Analytics only! Cannot discard InApp Notifications.");
        }
    }

    public void enableDeviceNetworkInfoReporting(boolean value) {
        this.coreState.getDeviceInfo().enableDeviceNetworkInfoReporting(value);
    }

    public void enablePersonalization() {
        this.coreState.getConfig().enablePersonalization(true);
    }

    @Deprecated
    public CTFeatureFlagsController featureFlag() {
        if (this.getConfig().isAnalyticsOnly()) {
            this.getConfig().getLogger().debug(this.getAccountId(), "Feature flag is not supported with analytics only configuration");
        }
        return this.coreState.getControllerManager().getCTFeatureFlagsController();
    }

    public void flush() {
        this.coreState.getBaseEventQueueManager().flush();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSCDomainListener(SCDomainListener scDomainListener) {
        NetworkManager networkManager;
        String domain;
        this.coreState.getCallbackManager().setSCDomainListener(scDomainListener);
        if (this.coreState.getNetworkManager() != null && (domain = (networkManager = (NetworkManager)this.coreState.getNetworkManager()).getDomainFromPrefsOrMetadata(EventGroup.REGULAR)) != null) {
            scDomainListener.onSCDomainAvailable(Utils.getSCDomain(domain));
        }
    }

    public String getAccountId() {
        return this.coreState.getConfig().getAccountId();
    }

    @Nullable
    public ArrayList<CleverTapDisplayUnit> getAllDisplayUnits() {
        if (this.coreState.getControllerManager().getCTDisplayUnitController() != null) {
            return this.coreState.getControllerManager().getCTDisplayUnitController().getAllDisplayUnits();
        }
        this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to get all Display Units");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTInboxMessage> getAllInboxMessages() {
        Logger.d("CleverTapAPI:getAllInboxMessages: called");
        ArrayList<CTInboxMessage> inboxMessageArrayList = new ArrayList<CTInboxMessage>();
        Object object = this.coreState.getCTLockManager().getInboxControllerLock();
        synchronized (object) {
            if (this.coreState.getControllerManager().getCTInboxController() != null) {
                ArrayList<CTMessageDAO> messageDAOArrayList = this.coreState.getControllerManager().getCTInboxController().getMessages();
                for (CTMessageDAO messageDAO : messageDAOArrayList) {
                    Logger.v("CTMessage Dao - " + messageDAO.toJSON().toString());
                    inboxMessageArrayList.add(new CTInboxMessage(messageDAO.toJSON()));
                }
                return inboxMessageArrayList;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return inboxMessageArrayList;
        }
    }

    public CTInboxListener getCTNotificationInboxListener() {
        return this.coreState.getCallbackManager().getInboxListener();
    }

    public void setCTNotificationInboxListener(CTInboxListener notificationInboxListener) {
        this.coreState.getCallbackManager().setInboxListener(notificationInboxListener);
    }

    public CTPushAmpListener getCTPushAmpListener() {
        return this.coreState.getCallbackManager().getPushAmpListener();
    }

    public void setCTPushAmpListener(CTPushAmpListener pushAmpListener) {
        this.coreState.getCallbackManager().setPushAmpListener(pushAmpListener);
    }

    public CTPushNotificationListener getCTPushNotificationListener() {
        return this.coreState.getCallbackManager().getPushNotificationListener();
    }

    public void setCTPushNotificationListener(CTPushNotificationListener pushNotificationListener) {
        this.coreState.getCallbackManager().setPushNotificationListener(pushNotificationListener);
    }

    @Deprecated
    @WorkerThread
    public String getCleverTapAttributionIdentifier() {
        return this.coreState.getDeviceInfo().getAttributionID();
    }

    @WorkerThread
    public String getCleverTapID() {
        return this.coreState.getDeviceInfo().getDeviceID();
    }

    public void decrementValue(String key, Number value) {
        this.coreState.getAnalyticsManager().decrementValue(key, value);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CoreState getCoreState() {
        return this.coreState;
    }

    void setCoreState(CoreState cleverTapState) {
        this.coreState = cleverTapState;
    }

    public int getCount(String event) {
        EventDetail eventDetail = this.coreState.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getCount();
        }
        return -1;
    }

    public EventDetail getDetails(String event) {
        return this.coreState.getLocalDataStore().getEventDetail(event);
    }

    public String getDevicePushToken(PushConstants.PushType type) {
        return this.coreState.getPushProviders().getCachedToken(type);
    }

    public DevicePushTokenRefreshListener getDevicePushTokenRefreshListener() {
        return this.coreState.getPushProviders().getDevicePushTokenRefreshListener();
    }

    public void setDevicePushTokenRefreshListener(DevicePushTokenRefreshListener tokenRefreshListener) {
        this.coreState.getPushProviders().setDevicePushTokenRefreshListener(tokenRefreshListener);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRequestDevicePushTokenListener(final RequestDevicePushTokenListener requestTokenListener) {
        try {
            Logger.v("PushProvider", PushConstants.FCM_LOG_TAG + "Requesting FCM token using googleservices.json");
            FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                public void onComplete(@NonNull com.google.android.gms.tasks.Task<String> task) {
                    if (!task.isSuccessful()) {
                        Logger.v("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token using googleservices.json failed", task.getException());
                        requestTokenListener.onDevicePushToken(null, PushConstants.PushType.FCM);
                        return;
                    }
                    String token = task.getResult() != null ? (String)task.getResult() : null;
                    Logger.v("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token using googleservices.json - " + token);
                    requestTokenListener.onDevicePushToken(token, PushConstants.PushType.FCM);
                }
            });
        }
        catch (Throwable t) {
            Logger.v("PushProvider", PushConstants.FCM_LOG_TAG + "Error requesting FCM token", t);
            requestTokenListener.onDevicePushToken(null, PushConstants.PushType.FCM);
        }
    }

    @Nullable
    public CleverTapDisplayUnit getDisplayUnitForId(String unitID) {
        if (this.coreState.getControllerManager().getCTDisplayUnitController() != null) {
            return this.coreState.getControllerManager().getCTDisplayUnitController().getDisplayUnitForID(unitID);
        }
        this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to get Display Unit for id: " + unitID);
        return null;
    }

    public int getFirstTime(String event) {
        EventDetail eventDetail = this.coreState.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getFirstTime();
        }
        return -1;
    }

    public GeofenceCallback getGeofenceCallback() {
        return this.coreState.getCallbackManager().getGeofenceCallback();
    }

    public void setGeofenceCallback(GeofenceCallback geofenceCallback) {
        this.coreState.getCallbackManager().setGeofenceCallback(geofenceCallback);
    }

    public Map<String, EventDetail> getHistory() {
        return this.coreState.getLocalDataStore().getEventHistory(this.context);
    }

    public InAppNotificationListener getInAppNotificationListener() {
        return this.coreState.getCallbackManager().getInAppNotificationListener();
    }

    public void setInAppNotificationListener(InAppNotificationListener inAppNotificationListener) {
        this.coreState.getCallbackManager().setInAppNotificationListener(inAppNotificationListener);
    }

    public void unregisterPushPermissionNotificationResponseListener(PushPermissionResponseListener pushPermissionResponseListener) {
        this.coreState.getCallbackManager().unregisterPushPermissionResponseListener(pushPermissionResponseListener);
    }

    public void registerPushPermissionNotificationResponseListener(PushPermissionResponseListener pushPermissionResponseListener) {
        this.coreState.getCallbackManager().registerPushPermissionResponseListener(pushPermissionResponseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboxMessageCount() {
        Object object = this.coreState.getCTLockManager().getInboxControllerLock();
        synchronized (object) {
            if (this.coreState.getControllerManager().getCTInboxController() != null) {
                return this.coreState.getControllerManager().getCTInboxController().count();
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTInboxMessage getInboxMessageForId(String messageId) {
        Logger.d("CleverTapAPI:getInboxMessageForId() called with: messageId = [" + messageId + "]");
        Object object = this.coreState.getCTLockManager().getInboxControllerLock();
        synchronized (object) {
            if (this.coreState.getControllerManager().getCTInboxController() != null) {
                CTMessageDAO message = this.coreState.getControllerManager().getCTInboxController().getMessageForId(messageId);
                CTInboxMessage cTInboxMessage = message != null ? new CTInboxMessage(message.toJSON()) : null;
                return cTInboxMessage;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboxMessageUnreadCount() {
        Object object = this.coreState.getCTLockManager().getInboxControllerLock();
        synchronized (object) {
            if (this.coreState.getControllerManager().getCTInboxController() != null) {
                return this.coreState.getControllerManager().getCTInboxController().unreadCount();
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return -1;
        }
    }

    public int getLastTime(String event) {
        EventDetail eventDetail = this.coreState.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getLastTime();
        }
        return -1;
    }

    public Location getLocation() {
        return this.coreState.getLocationManager()._getLocation();
    }

    public void setLocation(Location location) {
        this.coreState.getLocationManager()._setLocation(location);
    }

    public int getPreviousVisitTime() {
        return this.coreState.getSessionManager().getLastVisitTime();
    }

    public Object getProperty(String name) {
        if (!this.coreState.getConfig().isPersonalizationEnabled()) {
            return null;
        }
        return this.coreState.getLocalDataStore().getProfileProperty(name);
    }

    public String getPushToken(@NonNull PushConstants.PushType pushType) {
        return this.coreState.getPushProviders().getCachedToken(pushType);
    }

    public int getScreenCount() {
        return CoreMetaData.getActivityCount();
    }

    public SyncListener getSyncListener() {
        return this.coreState.getCallbackManager().getSyncListener();
    }

    public void setSyncListener(SyncListener syncListener) {
        this.coreState.getCallbackManager().setSyncListener(syncListener);
    }

    public int getTimeElapsed() {
        int currentSession = this.coreState.getCoreMetaData().getCurrentSessionId();
        if (currentSession == 0) {
            return -1;
        }
        int now = Utils.getNow();
        return now - currentSession;
    }

    public int getTotalVisits() {
        EventDetail ed = this.coreState.getLocalDataStore().getEventDetail("App Launched");
        if (ed != null) {
            return ed.getCount();
        }
        return 0;
    }

    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(this.coreState.getCoreMetaData().getSource());
        ud.setMedium(this.coreState.getCoreMetaData().getMedium());
        ud.setCampaign(this.coreState.getCoreMetaData().getCampaign());
        return ud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTInboxMessage> getUnreadInboxMessages() {
        ArrayList<CTInboxMessage> inboxMessageArrayList = new ArrayList<CTInboxMessage>();
        Object object = this.coreState.getCTLockManager().getInboxControllerLock();
        synchronized (object) {
            if (this.coreState.getControllerManager().getCTInboxController() != null) {
                ArrayList<CTMessageDAO> messageDAOArrayList = this.coreState.getControllerManager().getCTInboxController().getUnreadMessages();
                for (CTMessageDAO messageDAO : messageDAOArrayList) {
                    inboxMessageArrayList.add(new CTInboxMessage(messageDAO.toJSON()));
                }
                return inboxMessageArrayList;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return inboxMessageArrayList;
        }
    }

    public void initializeInbox() {
        this.coreState.getControllerManager().initializeInbox();
    }

    public void markReadInboxMessage(CTInboxMessage message) {
        if (this.coreState.getControllerManager().getCTInboxController() != null) {
            this.coreState.getControllerManager().getCTInboxController().markReadInboxMessage(message);
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
        }
    }

    public void markReadInboxMessage(String messageId) {
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.markReadInboxMessage(message);
    }

    public void markReadInboxMessagesForIDs(ArrayList<String> messageIDs) {
        if (this.coreState.getControllerManager().getCTInboxController() != null) {
            this.coreState.getControllerManager().getCTInboxController().markReadInboxMessagesForIDs(messageIDs);
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
        }
    }

    @Override
    public void messageDidClick(CTInboxActivity ctInboxActivity, int contentPageIndex, CTInboxMessage inboxMessage, Bundle data, HashMap<String, String> keyValue, int buttonIndex) {
        this.coreState.getAnalyticsManager().pushInboxMessageStateEvent(true, inboxMessage, data);
        Logger.v("clicked inbox notification.");
        if (this.inboxMessageListener != null && this.inboxMessageListener.get() != null) {
            ((InboxMessageListener)this.inboxMessageListener.get()).onInboxItemClicked(inboxMessage, contentPageIndex, buttonIndex);
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            Logger.v("clicked button of an inbox notification.");
            if (this.inboxMessageButtonListener != null && this.inboxMessageButtonListener.get() != null) {
                ((InboxMessageButtonListener)this.inboxMessageButtonListener.get()).onInboxButtonClick(keyValue);
            }
        }
    }

    @Override
    public void messageDidShow(CTInboxActivity ctInboxActivity, final CTInboxMessage inboxMessage, final Bundle data) {
        Task<Void> task = CTExecutorFactory.executors(this.coreState.getConfig()).postAsyncSafelyTask();
        task.execute("handleMessageDidShow", new Callable<Void>(){

            @Override
            public Void call() {
                Logger.d("CleverTapAPI:messageDidShow() called  in async with: messageId = [" + inboxMessage.getMessageId() + "]");
                CTInboxMessage message = CleverTapAPI.this.getInboxMessageForId(inboxMessage.getMessageId());
                if (!message.isRead()) {
                    CleverTapAPI.this.markReadInboxMessage(inboxMessage);
                    CleverTapAPI.this.coreState.getAnalyticsManager().pushInboxMessageStateEvent(false, inboxMessage, data);
                }
                return null;
            }
        });
    }

    public void onUserLogin(Map<String, Object> profile, String cleverTapID) {
        this.coreState.getLoginController().onUserLogin(profile, cleverTapID);
    }

    public void onUserLogin(Map<String, Object> profile) {
        this.onUserLogin(profile, null);
    }

    @Deprecated
    public CTProductConfigController productConfig() {
        if (this.getConfig().isAnalyticsOnly()) {
            this.getConfig().getLogger().debug(this.getAccountId(), "Product config is not supported with analytics only configuration");
        }
        return this.coreState.getCtProductConfigController();
    }

    public void pushBaiduRegistrationId(String regId, boolean register) {
        this.coreState.getPushProviders().handleToken(regId, PushConstants.PushType.BPS, register);
    }

    public void pushChargedEvent(HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) {
        this.coreState.getAnalyticsManager().pushChargedEvent(chargeDetails, items);
    }

    public void pushDeepLink(Uri uri) {
        this.coreState.getAnalyticsManager().pushDeepLink(uri, false);
    }

    public void pushDisplayUnitClickedEventForID(String unitID) {
        this.coreState.getAnalyticsManager().pushDisplayUnitClickedEventForID(unitID);
    }

    public void pushDisplayUnitViewedEventForID(String unitID) {
        this.coreState.getAnalyticsManager().pushDisplayUnitViewedEventForID(unitID);
    }

    public void pushError(String errorMessage, int errorCode) {
        this.coreState.getAnalyticsManager().pushError(errorMessage, errorCode);
    }

    public void pushEvent(String eventName) {
        if (eventName == null || eventName.trim().equals("")) {
            return;
        }
        this.pushEvent(eventName, null);
    }

    public void pushEvent(String eventName, Map<String, Object> eventActions) {
        this.coreState.getAnalyticsManager().pushEvent(eventName, eventActions);
    }

    public void pushFcmRegistrationId(String fcmId, boolean register) {
        this.coreState.getPushProviders().handleToken(fcmId, PushConstants.PushType.FCM, register);
    }

    public Future<?> pushSignedCallEvent(String eventName, JSONObject eventProperties) {
        return this.coreState.getAnalyticsManager().raiseEventForSignedCall(eventName, eventProperties);
    }

    public void pushGeoFenceError(int errorCode, String errorMessage) {
        ValidationResult validationResult = new ValidationResult(errorCode, errorMessage);
        this.coreState.getValidationResultStack().pushValidationResult(validationResult);
    }

    public Future<?> pushGeoFenceExitedEvent(JSONObject geoFenceProperties) {
        return this.coreState.getAnalyticsManager().raiseEventForGeofences("Geocluster Exited", geoFenceProperties);
    }

    public Future<?> pushGeofenceEnteredEvent(JSONObject geofenceProperties) {
        return this.coreState.getAnalyticsManager().raiseEventForGeofences("Geocluster Entered", geofenceProperties);
    }

    public void pushHuaweiRegistrationId(String regId, boolean register) {
        this.coreState.getPushProviders().handleToken(regId, PushConstants.PushType.HPS, register);
    }

    public void pushInboxNotificationClickedEvent(String messageId) {
        Logger.v("CleverTapAPI:pushInboxNotificationClickedEvent() called with: messageId = [" + messageId + "]");
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.coreState.getAnalyticsManager().pushInboxMessageStateEvent(true, message, null);
    }

    public void pushInboxNotificationViewedEvent(String messageId) {
        Logger.v("CleverTapAPI:pushInboxNotificationViewedEvent() called with: messageId = [" + messageId + "]");
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.coreState.getAnalyticsManager().pushInboxMessageStateEvent(false, message, null);
    }

    public void pushInstallReferrer(String url) {
        this.coreState.getAnalyticsManager().pushInstallReferrer(url);
    }

    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        this.coreState.getAnalyticsManager().pushInstallReferrer(source, medium, campaign);
    }

    public void pushNotificationClickedEvent(Bundle extras) {
        this.coreState.getAnalyticsManager().pushNotificationClickedEvent(extras);
    }

    public void pushNotificationViewedEvent(Bundle extras) {
        this.coreState.getAnalyticsManager().pushNotificationViewedEvent(extras);
    }

    public void pushProfile(Map<String, Object> profile) {
        this.coreState.getAnalyticsManager().pushProfile(profile);
    }

    public void pushXiaomiRegistrationId(String regId, @NonNull String region, boolean register) {
        if (TextUtils.isEmpty((CharSequence)region)) {
            Logger.d("CleverTapApi : region must not be null or empty , use  MiPushClient.getAppRegion(context) to provide appropriate region");
        } else {
            Logger.d("CleverTapAPI: client called pushXiaomiRegistrationId called with region:" + region);
            PushConstants.PushType.XPS.setServerRegion(region);
            this.coreState.getPushProviders().handleToken(regId, PushConstants.PushType.XPS, register);
        }
    }

    public void recordScreen(String screenName) {
        String currentScreenName = this.coreState.getCoreMetaData().getScreenName();
        if (screenName == null || currentScreenName != null && !currentScreenName.isEmpty() && currentScreenName.equals(screenName)) {
            return;
        }
        this.getConfigLogger().debug(this.getAccountId(), "Screen changed to " + screenName);
        this.coreState.getCoreMetaData().setCurrentScreenName(screenName);
        this.coreState.getAnalyticsManager().recordPageEventWithExtras(null);
    }

    public void removeMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this.coreState.getAnalyticsManager()._generateEmptyMultiValueError(key);
            return;
        }
        this.removeMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void removeMultiValuesForKey(String key, ArrayList<String> values) {
        this.coreState.getAnalyticsManager().removeMultiValuesForKey(key, values);
    }

    public void removeValueForKey(String key) {
        this.coreState.getAnalyticsManager().removeValueForKey(key);
    }

    public void resumeInAppNotifications() {
        if (!this.getCoreState().getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Resuming InApp Notifications...");
            this.getCoreState().getInAppController().resumeInApps();
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap instance is set for Analytics only! Cannot resume InApp Notifications.");
        }
    }

    public static NotificationHandler getNotificationHandler() {
        return sNotificationHandler;
    }

    public static NotificationHandler getSignedCallNotificationHandler() {
        return sSignedCallNotificationHandler;
    }

    public void incrementValue(String key, Number value) {
        this.coreState.getAnalyticsManager().incrementValue(key, value);
    }

    @Deprecated
    public void setCTFeatureFlagsListener(CTFeatureFlagsListener featureFlagsListener) {
        this.coreState.getCallbackManager().setFeatureFlagListener(featureFlagsListener);
    }

    @Deprecated
    public void setCTProductConfigListener(CTProductConfigListener listener) {
        this.coreState.getCallbackManager().setProductConfigListener(listener);
    }

    public void setDisplayUnitListener(DisplayUnitListener listener) {
        this.coreState.getCallbackManager().setDisplayUnitListener(listener);
    }

    public void setInAppNotificationButtonListener(InAppNotificationButtonListener listener) {
        this.coreState.getCallbackManager().setInAppNotificationButtonListener(listener);
    }

    public void setInboxMessageButtonListener(InboxMessageButtonListener listener) {
        this.inboxMessageButtonListener = new WeakReference<InboxMessageButtonListener>(listener);
    }

    public void setCTInboxMessageListener(InboxMessageListener listener) {
        this.inboxMessageListener = new WeakReference<InboxMessageListener>(listener);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void addNotificationRenderedListener(String id2, NotificationRenderedListener notificationRenderedListener) {
        sNotificationRenderedListenerMap.put(id2, notificationRenderedListener);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static NotificationRenderedListener getNotificationRenderedListener(String id2) {
        return sNotificationRenderedListenerMap.get(id2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static NotificationRenderedListener removeNotificationRenderedListener(String id2) {
        return sNotificationRenderedListenerMap.remove(id2);
    }

    public void setLibrary(String library) {
        if (this.coreState.getDeviceInfo() != null) {
            this.coreState.getDeviceInfo().setLibrary(library);
        }
    }

    public Future<?> setLocationForGeofences(Location location, int sdkVersion) {
        this.coreState.getCoreMetaData().setLocationForGeofence(true);
        this.coreState.getCoreMetaData().setGeofenceSDKVersion(sdkVersion);
        return this.coreState.getLocationManager()._setLocation(location);
    }

    public void setMultiValuesForKey(String key, ArrayList<String> values) {
        this.coreState.getAnalyticsManager().setMultiValuesForKey(key, values);
    }

    public void setOffline(boolean value) {
        this.coreState.getCoreMetaData().setOffline(value);
        if (value) {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to offline, won't send events queue");
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to online, sending events queue");
            this.flush();
        }
    }

    public void setOptOut(boolean userOptOut) {
        final boolean enable = userOptOut;
        Task<Void> task = CTExecutorFactory.executors(this.coreState.getConfig()).postAsyncSafelyTask();
        task.execute("setOptOut", new Callable<Void>(){

            @Override
            public Void call() {
                HashMap<String, Object> optOutMap = new HashMap<String, Object>();
                optOutMap.put("ct_optout", enable);
                if (enable) {
                    CleverTapAPI.this.pushProfile(optOutMap);
                    CleverTapAPI.this.coreState.getCoreMetaData().setCurrentUserOptedOut(true);
                } else {
                    CleverTapAPI.this.coreState.getCoreMetaData().setCurrentUserOptedOut(false);
                    CleverTapAPI.this.pushProfile(optOutMap);
                }
                String key = CleverTapAPI.this.coreState.getDeviceInfo().optOutKey();
                if (key == null) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Unable to persist user OptOut state, storage key is null");
                    return null;
                }
                StorageHelper.putBoolean(CleverTapAPI.this.context, StorageHelper.storageKeyWithSuffix(CleverTapAPI.this.getConfig(), key), enable);
                CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Set current user OptOut state to: " + enable);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAppInbox(CTInboxStyleConfig styleConfig) {
        Object object = this.coreState.getCTLockManager().getInboxControllerLock();
        synchronized (object) {
            if (this.coreState.getControllerManager().getCTInboxController() == null) {
                this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
                return;
            }
        }
        CTInboxStyleConfig _styleConfig = new CTInboxStyleConfig(styleConfig);
        Intent intent = new Intent(this.context, CTInboxActivity.class);
        intent.putExtra("styleConfig", (Parcelable)_styleConfig);
        Bundle configBundle = new Bundle();
        configBundle.putParcelable("config", (Parcelable)this.getConfig());
        intent.putExtra("configBundle", configBundle);
        try {
            Activity currentActivity = CoreMetaData.getCurrentActivity();
            if (currentActivity == null) {
                throw new IllegalStateException("Current activity reference not found");
            }
            currentActivity.startActivity(intent);
            Logger.d("Displaying Notification Inbox");
        }
        catch (Throwable t) {
            Logger.v("Please verify the integration of your app. It is not setup to support Notification Inbox yet.", t);
        }
    }

    public void dismissAppInbox() {
        try {
            Activity appInboxActivity = this.getCoreState().getCoreMetaData().getAppInboxActivity();
            if (appInboxActivity == null) {
                throw new IllegalStateException("AppInboxActivity reference not found");
            }
            if (!appInboxActivity.isFinishing()) {
                this.getConfigLogger().verbose(this.getAccountId(), "Finishing the App Inbox");
                appInboxActivity.finish();
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Can't dismiss AppInbox, please ensure to call this method after the usage of cleverTapApiInstance.showAppInbox(). \n" + t);
        }
    }

    public void showAppInbox() {
        CTInboxStyleConfig styleConfig = new CTInboxStyleConfig();
        this.showAppInbox(styleConfig);
    }

    public void suspendInAppNotifications() {
        if (!this.getCoreState().getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Suspending InApp Notifications...");
            this.getConfigLogger().debug(this.getAccountId(), "Please Note - InApp Notifications will be suspended till resumeInAppNotifications() is not called again");
            this.getCoreState().getInAppController().suspendInApps();
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap instance is set for Analytics only! Cannot suspend InApp Notifications.");
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getCustomSdkVersion(String customSdkName) {
        return this.coreState.getCoreMetaData().getCustomSdkVersion(customSdkName);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setCustomSdkVersion(String customSdkName, int customSdkVersion) {
        this.coreState.getCoreMetaData().setCustomSdkVersion(customSdkName, customSdkVersion);
    }

    void deviceIDCreated(String deviceId) {
        CTProductConfigController ctProductConfigController;
        CTFeatureFlagsController ctFeatureFlagsController;
        String accountId = this.coreState.getConfig().getAccountId();
        if (this.coreState.getControllerManager() == null) {
            this.getConfigLogger().verbose(accountId + ":async_deviceID", "ControllerManager not set yet! Returning from deviceIDCreated()");
            return;
        }
        if (this.coreState.getControllerManager().getInAppFCManager() == null) {
            this.getConfigLogger().verbose(accountId + ":async_deviceID", "Initializing InAppFC after Device ID Created = " + deviceId);
            this.coreState.getControllerManager().setInAppFCManager(new InAppFCManager(this.context, this.coreState.getConfig(), deviceId));
        }
        if ((ctFeatureFlagsController = this.coreState.getControllerManager().getCTFeatureFlagsController()) != null && TextUtils.isEmpty((CharSequence)ctFeatureFlagsController.getGuid())) {
            this.getConfigLogger().verbose(accountId + ":async_deviceID", "Initializing Feature Flags after Device ID Created = " + deviceId);
            ctFeatureFlagsController.setGuidAndInit(deviceId);
        }
        if ((ctProductConfigController = this.coreState.getControllerManager().getCTProductConfigController()) != null && TextUtils.isEmpty((CharSequence)ctProductConfigController.getSettings().getGuid())) {
            this.getConfigLogger().verbose(accountId + ":async_deviceID", "Initializing Product Config after Device ID Created = " + deviceId);
            ctProductConfigController.setGuidAndInit(deviceId);
        }
        this.getConfigLogger().verbose(accountId + ":async_deviceID", "Got device id from DeviceInfo, notifying user profile initialized to SyncListener");
        this.coreState.getCallbackManager().notifyUserProfileInitialized(deviceId);
        if (this.coreState.getCallbackManager().getOnInitCleverTapIDListener() != null) {
            this.coreState.getCallbackManager().getOnInitCleverTapIDListener().onInitCleverTapID(deviceId);
        }
    }

    private CleverTapInstanceConfig getConfig() {
        return this.coreState.getConfig();
    }

    private Logger getConfigLogger() {
        return this.getConfig().getLogger();
    }

    private boolean isErrorDeviceId() {
        return this.coreState.getDeviceInfo().isErrorDeviceId();
    }

    private void manifestAsyncValidation() {
        Task<Void> task = CTExecutorFactory.executors(this.coreState.getConfig()).postAsyncSafelyTask();
        task.execute("Manifest Validation", new Callable<Void>(){

            @Override
            public Void call() {
                ManifestValidator.validate(CleverTapAPI.this.context, CleverTapAPI.this.coreState.getDeviceInfo(), CleverTapAPI.this.coreState.getPushProviders());
                return null;
            }
        });
    }

    private void pushAmazonRegistrationId(String token, boolean register) {
        this.coreState.getPushProviders().handleToken(token, PushConstants.PushType.ADM, register);
    }

    static void onActivityCreated(Activity activity) {
        CleverTapAPI.onActivityCreated(activity, null);
    }

    static void onActivityCreated(Activity activity, String cleverTapID) {
        String _accountId;
        Uri deepLink;
        Bundle notification;
        boolean alreadyProcessedByCleverTap;
        block15: {
            if (instances == null) {
                CleverTapAPI.createInstanceIfAvailable(activity.getApplicationContext(), null, cleverTapID);
            }
            if (instances == null) {
                Logger.v("Instances is null in onActivityCreated!");
                return;
            }
            alreadyProcessedByCleverTap = false;
            notification = null;
            deepLink = null;
            _accountId = null;
            try {
                Intent intent = activity.getIntent();
                deepLink = intent.getData();
                if (deepLink != null) {
                    Bundle queryArgs = UriHelper.getAllKeyValuePairs(deepLink.toString(), true);
                    _accountId = queryArgs.getString("wzrk_acct_id");
                }
            }
            catch (Throwable intent) {
                // empty catch block
            }
            try {
                notification = activity.getIntent().getExtras();
                if (notification == null || notification.isEmpty()) break block15;
                try {
                    boolean bl = alreadyProcessedByCleverTap = notification.containsKey("wzrk_from") && "CTPushNotificationReceiver".equals(notification.get("wzrk_from"));
                    if (alreadyProcessedByCleverTap) {
                        Logger.v("ActivityLifecycleCallback: Notification Clicked already processed for " + notification.toString() + ", dropping duplicate.");
                    }
                    if (notification.containsKey("wzrk_acct_id")) {
                        _accountId = (String)notification.get("wzrk_acct_id");
                    }
                }
                catch (Throwable intent) {}
            }
            catch (Throwable intent) {
                // empty catch block
            }
        }
        if (alreadyProcessedByCleverTap && deepLink == null) {
            return;
        }
        try {
            for (String accountId : instances.keySet()) {
                CleverTapAPI instance = instances.get(accountId);
                if (instance == null) continue;
                instance.coreState.getActivityLifeCycleManager().onActivityCreated(notification, deepLink, _accountId);
            }
        }
        catch (Throwable t) {
            Logger.v("Throwable - " + t.getLocalizedMessage());
        }
    }

    private static CleverTapAPI createInstanceIfAvailable(Context context, String _accountId) {
        return CleverTapAPI.createInstanceIfAvailable(context, _accountId, null);
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static CleverTapAPI createInstanceIfAvailable(Context context, String _accountId, String cleverTapID) {
        block8: {
            if (_accountId == null) {
                try {
                    return CleverTapAPI.getDefaultInstance(context, cleverTapID);
                }
                catch (Throwable t) {
                    Logger.v("Error creating shared Instance: ", t.getCause());
                    return null;
                }
            }
            String configJson = StorageHelper.getString(context, "instance:" + _accountId, "");
            if (configJson.isEmpty()) break block8;
            CleverTapInstanceConfig config = CleverTapInstanceConfig.createInstance(configJson);
            Logger.v("Inflated Instance Config: " + configJson);
            return config != null ? CleverTapAPI.instanceWithConfig(context, config, cleverTapID) : null;
            {
                catch (Throwable t) {
                    return null;
                }
            }
        }
        try {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            return instance != null && instance.coreState.getConfig().getAccountId().equals(_accountId) ? instance : null;
        }
        catch (Throwable t) {
            Logger.v("Error creating shared Instance: ", t.getCause());
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static ArrayList<CleverTapAPI> getAvailableInstances(Context context) {
        ArrayList<CleverTapAPI> apiArrayList = new ArrayList<CleverTapAPI>();
        if (instances == null || instances.isEmpty()) {
            CleverTapAPI cleverTapAPI = CleverTapAPI.getDefaultInstance(context);
            if (cleverTapAPI != null) {
                apiArrayList.add(cleverTapAPI);
            }
        } else {
            apiArrayList.addAll(instances.values());
        }
        return apiArrayList;
    }

    private static CleverTapInstanceConfig getDefaultConfig(Context context) {
        ManifestInfo manifest = ManifestInfo.getInstance(context);
        String accountId = manifest.getAccountId();
        String accountToken = manifest.getAcountToken();
        String accountRegion = manifest.getAccountRegion();
        String proxyDomain = manifest.getProxyDomain();
        String spikyProxyDomain = manifest.getSpikeyProxyDomain();
        if (accountId == null || accountToken == null) {
            Logger.i("Account ID or Account token is missing from AndroidManifest.xml, unable to create default instance");
            return null;
        }
        if (accountRegion == null) {
            Logger.i("Account Region not specified in the AndroidManifest - using default region");
        }
        CleverTapInstanceConfig defaultInstanceConfig = CleverTapInstanceConfig.createDefaultInstance(context, accountId, accountToken, accountRegion);
        if (proxyDomain != null && proxyDomain.trim().length() > 0) {
            defaultInstanceConfig.setProxyDomain(proxyDomain);
        }
        if (spikyProxyDomain != null && spikyProxyDomain.trim().length() > 0) {
            defaultInstanceConfig.setSpikyProxyDomain(spikyProxyDomain);
        }
        return defaultInstanceConfig;
    }

    @Nullable
    private static CleverTapAPI getDefaultInstanceOrFirstOther(Context context) {
        CleverTapAPI instance;
        block1: {
            String accountId;
            instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null || instances == null || instances.isEmpty()) break block1;
            Iterator<String> iterator = instances.keySet().iterator();
            while (iterator.hasNext() && (instance = instances.get(accountId = iterator.next())) == null) {
            }
        }
        return instance;
    }

    public static void setNotificationHandler(NotificationHandler notificationHandler) {
        sNotificationHandler = notificationHandler;
    }

    public static void setSignedCallNotificationHandler(NotificationHandler notificationHandler) {
        sSignedCallNotificationHandler = notificationHandler;
    }

    public void getCleverTapID(final @NonNull OnInitCleverTapIDListener onInitCleverTapIDListener) {
        Task<Void> taskDeviceCachedInfo = CTExecutorFactory.executors(this.getConfig()).ioTask();
        taskDeviceCachedInfo.execute("getCleverTapID", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String deviceID = CleverTapAPI.this.coreState.getDeviceInfo().getDeviceID();
                if (deviceID != null) {
                    onInitCleverTapIDListener.onInitCleverTapID(deviceID);
                } else {
                    CleverTapAPI.this.coreState.getCallbackManager().setOnInitCleverTapIDListener(onInitCleverTapIDListener);
                }
                return null;
            }
        });
    }

    public Future<?> renderPushNotification(final @NonNull INotificationRenderer iNotificationRenderer, final Context context, final Bundle extras) {
        CleverTapInstanceConfig config = this.coreState.getConfig();
        Future<?> future = null;
        try {
            Task<Void> task = CTExecutorFactory.executors(config).postAsyncSafelyTask();
            future = task.submit("CleverTapAPI#renderPushNotification", new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    Object object = CleverTapAPI.this.coreState.getPushProviders().getPushRenderingLock();
                    synchronized (object) {
                        CleverTapAPI.this.coreState.getPushProviders().setPushNotificationRenderer(iNotificationRenderer);
                        if (extras != null && extras.containsKey("notificationId")) {
                            CleverTapAPI.this.coreState.getPushProviders()._createNotification(context, extras, extras.getInt("notificationId"));
                        } else {
                            CleverTapAPI.this.coreState.getPushProviders()._createNotification(context, extras, -1000);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            config.getLogger().debug(config.getAccountId(), "Failed to process renderPushNotification()", t);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void renderPushNotificationOnCallerThread(@NonNull INotificationRenderer iNotificationRenderer, Context context, Bundle extras) {
        CleverTapInstanceConfig config = this.coreState.getConfig();
        try {
            Object object = this.coreState.getPushProviders().getPushRenderingLock();
            synchronized (object) {
                config.getLogger().verbose(config.getAccountId(), "rendering push on caller thread with id = " + Thread.currentThread().getId());
                this.coreState.getPushProviders().setPushNotificationRenderer(iNotificationRenderer);
                if (extras != null && extras.containsKey("notificationId")) {
                    this.coreState.getPushProviders()._createNotification(context, extras, extras.getInt("notificationId"));
                } else {
                    this.coreState.getPushProviders()._createNotification(context, extras, -1000);
                }
            }
        }
        catch (Throwable t) {
            config.getLogger().debug(config.getAccountId(), "Failed to process renderPushNotification()", t);
        }
    }

    public static void enableXiaomiPushOn(int xpsRunningDevices) {
        PushConstants.PushType.XPS.setRunningDevices(xpsRunningDevices);
    }

    public static int getEnableXiaomiPushOn() {
        return PushConstants.PushType.XPS.getRunningDevices();
    }

    @Nullable
    public static Bitmap getNotificationBitmapWithTimeoutAndSize(Context context, Bundle bundle, String bitmapSrcUrl, boolean fallbackToAppIcon, long timeoutInMillis, int sizeInBytes) {
        if (CleverTapAPI.checkNotificationBitmapRequestInvalid(context, bundle, timeoutInMillis)) {
            return null;
        }
        if (sizeInBytes < 1) {
            Logger.v("Given sizeInBytes is less than 1 bytes. Not downloading bitmap!");
            return null;
        }
        CleverTapAPI cleverTapAPI = CleverTapAPI.fromBundle(context, bundle);
        if (cleverTapAPI == null) {
            Logger.v("cleverTapAPI is null. Not downloading bitmap!");
            return null;
        }
        return Utils.getNotificationBitmapWithTimeoutAndSize(bitmapSrcUrl, fallbackToAppIcon, context, cleverTapAPI.getConfig(), timeoutInMillis, sizeInBytes).getBitmap();
    }

    private static boolean checkNotificationBitmapRequestInvalid(Context context, Bundle bundle, long timeoutInMillis) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Logger.v("Notification Bitmap Download is not allowed on main thread");
            return true;
        }
        if (context == null) {
            Logger.v("Given Context is null. Not downloading bitmap!");
            return true;
        }
        if (bundle == null) {
            Logger.v("Given Bundle is null. Not downloading bitmap!");
            return true;
        }
        if (timeoutInMillis < 1L) {
            Logger.v("Given timeoutInMillis is less than 1 millis. Not downloading bitmap!");
            return true;
        }
        if (timeoutInMillis > 20000L) {
            Logger.v("Given timeoutInMillis exceeds 20 secs limit. Not downloading bitmap!");
            return true;
        }
        return false;
    }

    @Nullable
    public static Bitmap getNotificationBitmapWithTimeout(Context context, Bundle bundle, String bitmapSrcUrl, boolean fallbackToAppIcon, long timeoutInMillis) {
        if (CleverTapAPI.checkNotificationBitmapRequestInvalid(context, bundle, timeoutInMillis)) {
            return null;
        }
        CleverTapAPI cleverTapAPI = CleverTapAPI.fromBundle(context, bundle);
        if (cleverTapAPI == null) {
            Logger.v("cleverTapAPI is null. Not downloading bitmap!");
            return null;
        }
        return Utils.getNotificationBitmapWithTimeout(bitmapSrcUrl, fallbackToAppIcon, context, cleverTapAPI.getConfig(), timeoutInMillis).getBitmap();
    }

    boolean isDevelopmentMode() {
        return CTVariables.isDevelopmentMode(this.context);
    }

    public <T> Var<T> defineVariable(String name, T defaultValue) {
        return Var.define(name, defaultValue, this.coreState.getCTVariables());
    }

    public void parseVariables(Object ... instances) {
        this.coreState.getParser().parseVariables(instances);
    }

    public void parseVariablesForClasses(Class<?> ... classes) {
        this.coreState.getParser().parseVariablesForClasses(classes);
    }

    public Object getVariableValue(String name) {
        if (name == null) {
            return null;
        }
        return this.coreState.getVarCache().getMergedValue(name);
    }

    public <T> Var<T> getVariable(String name) {
        if (name == null) {
            return null;
        }
        return this.coreState.getVarCache().getVariable(name);
    }

    public void fetchVariables() {
        this.fetchVariables(null);
    }

    public void fetchVariables(FetchVariablesCallback callback) {
        if (this.coreState.getConfig().isAnalyticsOnly()) {
            return;
        }
        Logger.v("variables", "Fetching  variables");
        if (callback != null) {
            this.coreState.getCallbackManager().setFetchVariablesCallback(callback);
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            notif.put("t", 4);
            event.put("evtName", (Object)"wzrk_fetch");
            event.put("evtData", (Object)notif);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.coreState.getAnalyticsManager().sendFetchEvent(event);
    }

    public void syncVariables() {
        if (this.isDevelopmentMode()) {
            Logger.v("variables", "syncVariables: waiting for id to be available");
            this.getCleverTapID(x -> {
                JSONObject js = this.coreState.getVarCache().getDefineVarsData();
                Logger.v("variables", "syncVariables: sending following vars to server:" + js);
                this.coreState.getAnalyticsManager().pushDefineVarsEvent(js);
            });
        } else {
            Logger.v("variables", "Your app is NOT in development mode, variables data will not be sent to server");
        }
    }

    public void addVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        this.coreState.getCTVariables().addVariablesChangedCallback(callback);
    }

    public void addOneTimeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        this.coreState.getCTVariables().addOneTimeVariablesChangedCallback(callback);
    }

    public void removeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        this.coreState.getCTVariables().removeVariablesChangedCallback(callback);
    }

    public void removeOneTimeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        this.coreState.getCTVariables().removeOneTimeVariablesChangedHandler(callback);
    }

    public void removeAllVariablesChangedCallbacks() {
        this.coreState.getCTVariables().removeAllVariablesChangedCallbacks();
    }

    public void removeAllOneTimeVariablesChangedCallbacks() {
        this.coreState.getCTVariables().removeAllOneTimeVariablesChangedCallbacks();
    }

    public void setLocale(String locale) {
        if (TextUtils.isEmpty((CharSequence)locale)) {
            Logger.i("Empty Locale provided for setLocale, not setting it");
            return;
        }
        this.coreState.getDeviceInfo().setCustomLocale(locale);
    }

    public String getLocale() {
        return this.coreState.getDeviceInfo().getCustomLocale();
    }

    static {
        sNotificationRenderedListenerMap = new HashMap();
    }

    public static enum LogLevel {
        OFF(-1),
        INFO(0),
        DEBUG(2),
        VERBOSE(3);

        private final int value;

        private LogLevel(int newValue) {
            this.value = newValue;
        }

        public int intValue() {
            return this.value;
        }
    }

    public static interface DevicePushTokenRefreshListener {
        public void devicePushTokenDidRefresh(String var1, PushConstants.PushType var2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static interface RequestDevicePushTokenListener {
        public void onDevicePushToken(String var1, PushConstants.PushType var2);
    }
}

