/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.core.app.NotificationManagerCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\"\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002\u001a \u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0007\u001a\u0012\u0010\u0011\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000b\u001a\u0012\u0010\u0013\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"targetSdkVersion", "", "Landroid/content/Context;", "getTargetSdkVersion", "(Landroid/content/Context;)I", "areAppNotificationsEnabled", "", "flushPushImpressionsOnPostAsyncSafely", "", "Lcom/clevertap/android/sdk/CleverTapAPI;", "logTag", "", "caller", "context", "getOrCreateChannel", "Landroid/app/NotificationManager;", "msgChannel", "isNotificationChannelEnabled", "channelId", "isPackageAndOsTargetsAbove", "apiLevel", "clevertap-core_release"})
@JvmName(name="CTXtensions")
public final class CTXtensions {
    public static final boolean isPackageAndOsTargetsAbove(@NotNull Context $this$isPackageAndOsTargetsAbove, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackageAndOsTargetsAbove, (String)"<this>");
        return Build.VERSION.SDK_INT > apiLevel && CTXtensions.getTargetSdkVersion($this$isPackageAndOsTargetsAbove) > apiLevel;
    }

    public static final int getTargetSdkVersion(@NotNull Context $this$targetSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$targetSdkVersion, (String)"<this>");
        return $this$targetSdkVersion.getApplicationContext().getApplicationInfo().targetSdkVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotificationChannelEnabled(@NotNull Context $this$isNotificationChannelEnabled, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotificationChannelEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        if (Build.VERSION.SDK_INT >= 26) {
            if (!CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled)) return false;
            try {
                Object object = $this$isNotificationChannelEnabled.getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager nm = (NotificationManager)object;
                if (nm.getNotificationChannel(channelId).getImportance() == 0) return false;
                return true;
            }
            catch (Exception e) {
                Logger.d("Unable to find notification channel with id = " + channelId);
                return false;
            }
        }
        boolean bl = CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled);
        return bl;
    }

    public static final boolean areAppNotificationsEnabled(@NotNull Context $this$areAppNotificationsEnabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$areAppNotificationsEnabled, (String)"<this>");
        try {
            bl = NotificationManagerCompat.from((Context)$this$areAppNotificationsEnabled).areNotificationsEnabled();
        }
        catch (Exception e) {
            Logger.d("Unable to query notifications enabled flag, returning true!");
            e.printStackTrace();
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    @WorkerThread
    @Nullable
    public static final String getOrCreateChannel(@NotNull NotificationManager $this$getOrCreateChannel, @Nullable String msgChannel, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateChannel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            CharSequence charSequence = msgChannel;
            if (!(charSequence == null || charSequence.length() == 0) && $this$getOrCreateChannel.getNotificationChannel(msgChannel) != null) {
                return msgChannel;
            }
            ManifestInfo manifestMetadata = ManifestInfo.getInstance(context);
            String manifestChannel = manifestMetadata.getDevDefaultPushChannelId();
            CharSequence charSequence2 = manifestChannel;
            if (!(charSequence2 == null || charSequence2.length() == 0) && $this$getOrCreateChannel.getNotificationChannel(manifestChannel) != null) {
                return manifestChannel;
            }
            charSequence2 = manifestChannel;
            if (charSequence2 == null || charSequence2.length() == 0) {
                Logger.d("CleverTap", "Missing Default CleverTap Notification Channel metadata in AndroidManifest.");
            } else {
                Logger.d("CleverTap", "Notification Channel set in AndroidManifest.xml has not been created by the app.");
            }
            if ($this$getOrCreateChannel.getNotificationChannel("fcm_fallback_notification_channel") == null) {
                void it;
                String string2;
                try {
                    string2 = context.getString(R.string.ct_fcm_fallback_notification_channel_label);
                }
                catch (Exception e) {
                    string2 = "Misc";
                }
                String string3 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n                  \u2026HANNEL_NAME\n            }");
                String defaultChannelName = string3;
                NotificationChannel notificationChannel = new NotificationChannel("fcm_fallback_notification_channel", (CharSequence)defaultChannelName, 3);
                string2 = notificationChannel;
                NotificationManager notificationManager = $this$getOrCreateChannel;
                boolean bl = false;
                Logger.d("CleverTap", "created default channel: " + it);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            return "fcm_fallback_notification_channel";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void flushPushImpressionsOnPostAsyncSafely(@NotNull CleverTapAPI $this$flushPushImpressionsOnPostAsyncSafely, @NotNull String logTag, @NotNull String caller, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$flushPushImpressionsOnPostAsyncSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Task<Void> flushTask = CTExecutorFactory.executors($this$flushPushImpressionsOnPostAsyncSafely.getCoreState().getConfig()).postAsyncSafelyTask();
        Future<?> flushFutureResult = flushTask.submit(logTag, () -> CTXtensions.flushPushImpressionsOnPostAsyncSafely$lambda$1($this$flushPushImpressionsOnPostAsyncSafely, context, caller, logTag));
        try {
            flushFutureResult.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Void flushPushImpressionsOnPostAsyncSafely$lambda$1(CleverTapAPI $this_flushPushImpressionsOnPostAsyncSafely, Context $context, String $caller, String $logTag) {
        Intrinsics.checkNotNullParameter((Object)$this_flushPushImpressionsOnPostAsyncSafely, (String)"$this_flushPushImpressionsOnPostAsyncSafely");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$caller, (String)"$caller");
        Intrinsics.checkNotNullParameter((Object)$logTag, (String)"$logTag");
        try {
            $this_flushPushImpressionsOnPostAsyncSafely.getCoreState().getBaseEventQueueManager().flushQueueSync($context, EventGroup.PUSH_NOTIFICATION_VIEWED, $caller);
        }
        catch (Exception e) {
            Logger.d($logTag, "failed to flush push impressions on ct instance = " + $this_flushPushImpressionsOnPostAsyncSafely.getCoreState().getConfig().getAccountId());
        }
        return null;
    }
}

