/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.fcm;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.fcm.IFcmSdkHandler;
import com.clevertap.android.sdk.utils.PackageUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.FirebaseMessaging;

public class FcmSdkHandlerImpl
implements IFcmSdkHandler {
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final CTPushProviderListener listener;
    private ManifestInfo manifestInfo;

    public FcmSdkHandlerImpl(CTPushProviderListener listener, Context context, CleverTapInstanceConfig config) {
        this.context = context;
        this.config = config;
        this.listener = listener;
        this.manifestInfo = ManifestInfo.getInstance(context);
    }

    @Override
    public PushConstants.PushType getPushType() {
        return PushConstants.PushType.FCM;
    }

    @Override
    public boolean isAvailable() {
        try {
            if (!PackageUtils.isGooglePlayServicesAvailable(this.context)) {
                this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Google Play services is currently unavailable.");
                return false;
            }
            String senderId = this.getSenderId();
            if (TextUtils.isEmpty((CharSequence)senderId)) {
                this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "The FCM sender ID is not set. Unable to register for FCM.");
                return false;
            }
        }
        catch (Throwable t) {
            this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Unable to register with FCM.", t);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSupported() {
        return PackageUtils.isGooglePlayStoreAvailable(this.context);
    }

    @Override
    public void requestToken() {
        try {
            this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Requesting FCM token using googleservices.json");
            FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                public void onComplete(@NonNull Task<String> task) {
                    if (!task.isSuccessful()) {
                        FcmSdkHandlerImpl.this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token using googleservices.json failed", task.getException());
                        FcmSdkHandlerImpl.this.listener.onNewToken(null, FcmSdkHandlerImpl.this.getPushType());
                        return;
                    }
                    String token = task.getResult() != null ? (String)task.getResult() : null;
                    FcmSdkHandlerImpl.this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token using googleservices.json - " + token);
                    FcmSdkHandlerImpl.this.listener.onNewToken(token, FcmSdkHandlerImpl.this.getPushType());
                }
            });
        }
        catch (Throwable t) {
            this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Error requesting FCM token", t);
            this.listener.onNewToken(null, this.getPushType());
        }
    }

    String getSenderId() {
        FirebaseApp app = FirebaseApp.getInstance();
        return app.getOptions().getGcmSenderId();
    }

    void setManifestInfo(ManifestInfo manifestInfo) {
        this.manifestInfo = manifestInfo;
    }
}

