/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.content.Context;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.BitmapDownloadRequest;
import com.clevertap.android.sdk.bitmap.IBitmapDownloadRequestHandler;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/bitmap/NotificationBitmapDownloadRequestHandler;", "Lcom/clevertap/android/sdk/bitmap/IBitmapDownloadRequestHandler;", "iBitmapDownloadRequestHandler", "(Lcom/clevertap/android/sdk/bitmap/IBitmapDownloadRequestHandler;)V", "handleRequest", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "bitmapDownloadRequest", "Lcom/clevertap/android/sdk/bitmap/BitmapDownloadRequest;", "clevertap-core_release"})
public final class NotificationBitmapDownloadRequestHandler
implements IBitmapDownloadRequestHandler {
    @NotNull
    private final IBitmapDownloadRequestHandler iBitmapDownloadRequestHandler;

    public NotificationBitmapDownloadRequestHandler(@NotNull IBitmapDownloadRequestHandler iBitmapDownloadRequestHandler) {
        Intrinsics.checkNotNullParameter((Object)iBitmapDownloadRequestHandler, (String)"iBitmapDownloadRequestHandler");
        this.iBitmapDownloadRequestHandler = iBitmapDownloadRequestHandler;
    }

    @Override
    @NotNull
    public DownloadedBitmap handleRequest(@NotNull BitmapDownloadRequest bitmapDownloadRequest) {
        Intrinsics.checkNotNullParameter((Object)bitmapDownloadRequest, (String)"bitmapDownloadRequest");
        Logger.v("handling bitmap download request in NotificationBitmapDownloadRequestHandler....");
        String srcUrl = bitmapDownloadRequest.component1();
        boolean fallbackToAppIcon = bitmapDownloadRequest.component2();
        Context context = bitmapDownloadRequest.component3();
        CharSequence charSequence = srcUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            DownloadedBitmap downloadedBitmap = Utils.getDownloadedBitmapPostFallbackIconCheck(fallbackToAppIcon, context, DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.NO_IMAGE));
            Intrinsics.checkNotNullExpressionValue((Object)downloadedBitmap, (String)"getDownloadedBitmapPostF\u2026s(NO_IMAGE)\n            )");
            return downloadedBitmap;
        }
        if (!StringsKt.startsWith$default((String)srcUrl, (String)"http", (boolean)false, (int)2, null)) {
            bitmapDownloadRequest.setBitmapPath("http://static.wizrocket.com/android/ico//" + srcUrl);
        }
        DownloadedBitmap downloadedBitmap = this.iBitmapDownloadRequestHandler.handleRequest(bitmapDownloadRequest);
        DownloadedBitmap downloadedBitmap2 = Utils.getDownloadedBitmapPostFallbackIconCheck(fallbackToAppIcon, context, downloadedBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)downloadedBitmap2, (String)"getDownloadedBitmapPostF\u2026ontext, downloadedBitmap)");
        return downloadedBitmap2;
    }
}

