/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.variables.CTVariables;
import com.clevertap.android.sdk.variables.Var;
import com.clevertap.android.sdk.variables.annotations.Variable;
import com.clevertap.android.sdk.variables.callbacks.VariableCallback;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;

public class Parser {
    private final CTVariables ctVariables;

    private static void log(String msg) {
        Logger.v("variables", msg);
    }

    private static void log(String msg, Throwable t) {
        Logger.v("variables", msg, t);
    }

    public Parser(CTVariables ctVariables) {
        this.ctVariables = ctVariables;
    }

    public void parseVariables(Object ... instances) {
        try {
            for (Object instance : instances) {
                this.parseVariablesHelper(instance, instance.getClass());
            }
        }
        catch (Throwable t) {
            Parser.log("Error parsing variables", t);
        }
    }

    public void parseVariablesForClasses(Class<?> ... classes) {
        try {
            for (Class<?> clazz : classes) {
                this.parseVariablesHelper(null, clazz);
            }
        }
        catch (Throwable t) {
            Parser.log("Error parsing variables", t);
        }
    }

    @VisibleForTesting
    void parseVariablesHelper(Object instance, Class<?> clazz) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getFields()) {
                Class<?> fieldType;
                String fieldTypeString;
                String variableName;
                String group = "";
                String name = "";
                if (!field.isAnnotationPresent(Variable.class)) continue;
                Variable annotation = field.getAnnotation(Variable.class);
                if (annotation != null) {
                    group = annotation.group();
                    name = annotation.name();
                }
                if (TextUtils.isEmpty((CharSequence)(variableName = name))) {
                    variableName = field.getName();
                }
                if (!TextUtils.isEmpty((CharSequence)group)) {
                    variableName = group + "." + variableName;
                }
                if ((fieldTypeString = (fieldType = field.getType()).toString()).equals("int")) {
                    this.defineVariable(instance, variableName, field.getInt(instance), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("byte")) {
                    this.defineVariable(instance, variableName, field.getByte(instance), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("short")) {
                    this.defineVariable(instance, variableName, field.getShort(instance), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("long")) {
                    this.defineVariable(instance, variableName, field.getLong(instance), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("char")) {
                    this.defineVariable(instance, variableName, Character.valueOf(field.getChar(instance)), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("float")) {
                    this.defineVariable(instance, variableName, Float.valueOf(field.getFloat(instance)), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("double")) {
                    this.defineVariable(instance, variableName, field.getDouble(instance), "number", field);
                    continue;
                }
                if (fieldTypeString.equals("boolean")) {
                    this.defineVariable(instance, variableName, field.getBoolean(instance), "boolean", field);
                    continue;
                }
                if (fieldType.isPrimitive()) {
                    Parser.log("Variable " + variableName + " is an unsupported primitive type.");
                    continue;
                }
                if (fieldType.isArray()) {
                    Parser.log("Variable " + variableName + " is an unsupported type of Array.");
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    this.defineVariable(instance, variableName, field.get(instance), "group", field);
                    continue;
                }
                Object value = field.get(instance);
                String stringValue = value == null ? null : value.toString();
                this.defineVariable(instance, variableName, stringValue, "string", field);
            }
        }
        catch (Throwable t) {
            Parser.log("Error parsing variables:", t);
            t.printStackTrace();
        }
    }

    @VisibleForTesting
    <T> void defineVariable(Object instance, String name, T value, String kind, final Field field) {
        final Var<T> var = Var.define(name, value, kind, this.ctVariables);
        if (var == null) {
            Parser.log("Something went wrong, var is null, returning");
            return;
        }
        final boolean hasInstance = instance != null;
        final WeakReference<Object> weakInstance = new WeakReference<Object>(instance);
        var.addValueChangedCallback(new VariableCallback<T>(){

            @Override
            public void onValueChanged(Var<T> variable) {
                Object instanceFromWeakRef = weakInstance.get();
                if (hasInstance && instanceFromWeakRef == null || field == null) {
                    var.removeValueChangedHandler(this);
                    return;
                }
                try {
                    boolean accessible = field.isAccessible();
                    if (!accessible) {
                        field.setAccessible(true);
                    }
                    field.set(instanceFromWeakRef, var.value());
                    if (!accessible) {
                        field.setAccessible(false);
                    }
                }
                catch (IllegalArgumentException e) {
                    Parser.log("Invalid value " + var.value() + " for field " + var.name(), e);
                }
                catch (IllegalAccessException e) {
                    Parser.log("Error setting value for field " + var.name(), e);
                }
            }
        });
    }
}

