/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.pushnotification.PushNotificationHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public interface INotificationRenderer {
    @Nullable
    public Object getCollapseKey(Bundle var1);

    @Nullable
    public String getMessage(Bundle var1);

    @Nullable
    public String getTitle(Bundle var1, Context var2);

    @Nullable
    public NotificationCompat.Builder renderNotification(Bundle var1, Context var2, NotificationCompat.Builder var3, CleverTapInstanceConfig var4, int var5);

    public void setSmallIcon(int var1, Context var2);

    public String getActionButtonIconKey();

    default public NotificationCompat.Builder setActionButtons(Context context, Bundle extras, int notificationId, NotificationCompat.Builder nb, JSONArray actions) {
        String intentServiceName = ManifestInfo.getInstance(context).getIntentServiceName();
        Class<?> clazz = null;
        if (intentServiceName != null) {
            try {
                clazz = Class.forName(intentServiceName);
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
                }
                catch (ClassNotFoundException ex) {
                    Logger.d("No Intent Service found");
                }
            }
        } else {
            try {
                clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
            }
            catch (ClassNotFoundException ex) {
                Logger.d("No Intent Service found");
            }
        }
        boolean isCTIntentServiceAvailable = Utils.isServiceAvailable(context, clazz);
        if (actions != null && actions.length() > 0) {
            for (int i = 0; i < actions.length(); ++i) {
                try {
                    Intent actionLaunchIntent;
                    JSONObject action = actions.getJSONObject(i);
                    String label = action.optString("l");
                    String dl = action.optString("dl");
                    String ico = action.optString(this.getActionButtonIconKey());
                    String id2 = action.optString("id");
                    boolean autoCancel = action.optBoolean("ac", true);
                    if (label.isEmpty() || id2.isEmpty()) {
                        Logger.d("not adding push notification action: action label or id missing");
                        continue;
                    }
                    int icon = 0;
                    if (!ico.isEmpty()) {
                        try {
                            icon = context.getResources().getIdentifier(ico, "drawable", context.getPackageName());
                        }
                        catch (Throwable t) {
                            Logger.d("unable to add notification action icon: " + t.getLocalizedMessage());
                        }
                    }
                    boolean sendToCTIntentService = Build.VERSION.SDK_INT < 31 && autoCancel && isCTIntentServiceAvailable;
                    String dismissOnClick = extras.getString("pt_dismiss_on_click");
                    if (!sendToCTIntentService && PushNotificationHandler.isForPushTemplates(extras) && id2.contains("remind") && dismissOnClick != null && dismissOnClick.equalsIgnoreCase("true") && autoCancel && isCTIntentServiceAvailable) {
                        sendToCTIntentService = true;
                    }
                    if (!sendToCTIntentService && PushNotificationHandler.isForPushTemplates(extras) && dismissOnClick != null && dismissOnClick.equalsIgnoreCase("true") && autoCancel && isCTIntentServiceAvailable) {
                        sendToCTIntentService = true;
                    }
                    if (sendToCTIntentService) {
                        actionLaunchIntent = new Intent("com.clevertap.PUSH_EVENT");
                        actionLaunchIntent.setPackage(context.getPackageName());
                        actionLaunchIntent.putExtra("ct_type", "com.clevertap.ACTION_BUTTON_CLICK");
                        if (!dl.isEmpty()) {
                            actionLaunchIntent.putExtra("dl", dl);
                        }
                    } else if (!dl.isEmpty()) {
                        actionLaunchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)dl));
                        Utils.setPackageNameFromResolveInfoList(context, actionLaunchIntent);
                    } else {
                        actionLaunchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                    }
                    if (actionLaunchIntent != null) {
                        actionLaunchIntent.putExtras(extras);
                        actionLaunchIntent.removeExtra("wzrk_acts");
                        actionLaunchIntent.putExtra("actionId", id2);
                        actionLaunchIntent.putExtra("autoCancel", autoCancel);
                        actionLaunchIntent.putExtra("wzrk_c2a", id2);
                        actionLaunchIntent.putExtra("notificationId", notificationId);
                        actionLaunchIntent.setFlags(0x24000000);
                    }
                    int requestCode = (int)System.currentTimeMillis() + i;
                    int flagsActionLaunchPendingIntent = 0x8000000;
                    if (Build.VERSION.SDK_INT >= 23) {
                        flagsActionLaunchPendingIntent |= 0x4000000;
                    }
                    PendingIntent actionIntent = sendToCTIntentService ? PendingIntent.getService((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)flagsActionLaunchPendingIntent) : PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)flagsActionLaunchPendingIntent);
                    nb.addAction(icon, (CharSequence)label, actionIntent);
                    continue;
                }
                catch (Throwable t) {
                    Logger.d("error adding notification action : " + t.getLocalizedMessage());
                }
            }
        }
        return nb;
    }
}

