/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.product_config;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.BaseAnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.product_config.CTProductConfigConstants;
import com.clevertap.android.sdk.product_config.DefaultXmlParser;
import com.clevertap.android.sdk.product_config.ProductConfigSettings;
import com.clevertap.android.sdk.product_config.ProductConfigUtil;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.OnSuccessListener;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.FileUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class CTProductConfigController {
    @Deprecated
    final Map<String, String> activatedConfigs = Collections.synchronizedMap(new HashMap());
    @Deprecated
    final Map<String, String> defaultConfigs = Collections.synchronizedMap(new HashMap());
    AtomicBoolean isInitialized = new AtomicBoolean(false);
    final FileUtils fileUtils;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final AtomicBoolean isFetchAndActivating = new AtomicBoolean(false);
    private final BaseAnalyticsManager analyticsManager;
    private final BaseCallbackManager callbackManager;
    private final CoreMetaData coreMetaData;
    @Deprecated
    private final ProductConfigSettings settings;
    private final Map<String, String> waitingTobeActivatedConfig = Collections.synchronizedMap(new HashMap());

    @Deprecated
    CTProductConfigController(Context context, CleverTapInstanceConfig config, BaseAnalyticsManager analyticsManager, CoreMetaData coreMetaData, BaseCallbackManager callbackManager, ProductConfigSettings productConfigSettings, FileUtils fileUtils) {
        this.context = context;
        this.config = config;
        this.coreMetaData = coreMetaData;
        this.callbackManager = callbackManager;
        this.analyticsManager = analyticsManager;
        this.settings = productConfigSettings;
        this.fileUtils = fileUtils;
        this.initAsync();
    }

    @Deprecated
    public void activate() {
        if (TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            return;
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.addOnSuccessListener(new OnSuccessListener<Void>(){

            @Override
            public void onSuccess(Void result) {
                CTProductConfigController.this.sendCallback(PROCESSING_STATE.ACTIVATED);
            }
        }).execute("activateProductConfigs", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        HashMap toWriteValues = new HashMap();
                        if (!CTProductConfigController.this.waitingTobeActivatedConfig.isEmpty()) {
                            toWriteValues.putAll(CTProductConfigController.this.waitingTobeActivatedConfig);
                            CTProductConfigController.this.waitingTobeActivatedConfig.clear();
                        } else {
                            toWriteValues = CTProductConfigController.this.getStoredValues(CTProductConfigController.this.getActivatedFullPath());
                        }
                        CTProductConfigController.this.activatedConfigs.clear();
                        if (!CTProductConfigController.this.defaultConfigs.isEmpty()) {
                            CTProductConfigController.this.activatedConfigs.putAll(CTProductConfigController.this.defaultConfigs);
                        }
                        CTProductConfigController.this.activatedConfigs.putAll(toWriteValues);
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Activated successfully with configs: " + CTProductConfigController.this.activatedConfigs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Activate failed: " + e.getLocalizedMessage());
                    }
                    return null;
                }
            }
        });
    }

    @Deprecated
    public void fetch() {
        this.fetch(this.settings.getNextFetchIntervalInSeconds());
    }

    @Deprecated
    public void fetch(long minimumFetchIntervalInSeconds) {
        if (this.canRequest(minimumFetchIntervalInSeconds)) {
            this.fetchProductConfig();
        }
    }

    @Deprecated
    public void fetchAndActivate() {
        this.fetch();
        this.isFetchAndActivating.set(true);
    }

    @Deprecated
    public void fetchProductConfig() {
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            notif.put("t", 0);
            event.put("evtName", (Object)"wzrk_fetch");
            event.put("evtData", (Object)notif);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.analyticsManager.sendFetchEvent(event);
        this.coreMetaData.setProductConfigRequested(true);
        this.config.getLogger().verbose(this.config.getAccountId(), "Product Config : Fetching product config");
    }

    @Deprecated
    public Boolean getBoolean(String Key2) {
        String value;
        if (this.isInitialized.get() && !TextUtils.isEmpty((CharSequence)Key2) && !TextUtils.isEmpty((CharSequence)(value = this.activatedConfigs.get(Key2)))) {
            return Boolean.parseBoolean(value);
        }
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_BOOLEAN;
    }

    @Deprecated
    public Double getDouble(String Key2) {
        if (this.isInitialized.get() && !TextUtils.isEmpty((CharSequence)Key2)) {
            try {
                String value = this.activatedConfigs.get(Key2);
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    return Double.parseDouble(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Error getting Double for Key-" + Key2 + " " + e.getLocalizedMessage());
            }
        }
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_DOUBLE;
    }

    @Deprecated
    public long getLastFetchTimeStampInMillis() {
        return this.settings.getLastFetchTimeStampInMillis();
    }

    @Deprecated
    public Long getLong(String Key2) {
        if (this.isInitialized.get() && !TextUtils.isEmpty((CharSequence)Key2)) {
            try {
                String value = this.activatedConfigs.get(Key2);
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    return Long.parseLong(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Error getting Long for Key-" + Key2 + " " + e.getLocalizedMessage());
            }
        }
        return CTProductConfigConstants.DEFAULT_VALUE_FOR_LONG;
    }

    @Deprecated
    public String getString(String Key2) {
        String value;
        if (this.isInitialized.get() && !TextUtils.isEmpty((CharSequence)Key2) && !TextUtils.isEmpty((CharSequence)(value = this.activatedConfigs.get(Key2)))) {
            return value;
        }
        return "";
    }

    @Deprecated
    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    @Deprecated
    public void onFetchFailed() {
        this.isFetchAndActivating.compareAndSet(true, false);
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Fetch Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void onFetchSuccess(JSONObject kvResponse) {
        if (TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            return;
        }
        CTProductConfigController cTProductConfigController = this;
        synchronized (cTProductConfigController) {
            if (kvResponse != null) {
                try {
                    this.parseFetchedResponse(kvResponse);
                    this.fileUtils.writeJsonToFile(this.getProductConfigDirName(), "activated.json", new JSONObject(this.waitingTobeActivatedConfig));
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Fetch file-[" + this.getActivatedFullPath() + "] write success: " + this.waitingTobeActivatedConfig);
                    Task<Void> task = CTExecutorFactory.executors(this.config).mainTask();
                    task.execute("sendPCFetchSuccessCallback", new Callable<Void>(){

                        @Override
                        public Void call() {
                            CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: fetch Success");
                            CTProductConfigController.this.sendCallback(PROCESSING_STATE.FETCHED);
                            return null;
                        }
                    });
                    if (this.isFetchAndActivating.getAndSet(false)) {
                        this.activate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: fetch Failed");
                    this.sendCallback(PROCESSING_STATE.FETCHED);
                    this.isFetchAndActivating.compareAndSet(true, false);
                }
            }
        }
    }

    @Deprecated
    public void reset() {
        this.defaultConfigs.clear();
        this.activatedConfigs.clear();
        this.settings.initDefaults();
        this.eraseStoredConfigFiles();
    }

    @Deprecated
    public void resetSettings() {
        this.settings.reset(this.fileUtils);
    }

    @Deprecated
    public void setArpValue(JSONObject arp) {
        this.settings.setARPValue(arp);
    }

    @Deprecated
    public void setDefaults(int resourceID) {
        this.setDefaultsWithXmlParser(resourceID, new DefaultXmlParser());
    }

    @Deprecated
    public void setDefaults(final HashMap<String, Object> map) {
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.addOnSuccessListener(new OnSuccessListener<Void>(){

            @Override
            public void onSuccess(Void aVoid) {
                CTProductConfigController.this.initAsync();
            }
        }).execute("ProductConfig#setDefaultsUsingHashMap", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    if (map != null && !map.isEmpty()) {
                        for (Map.Entry entry : map.entrySet()) {
                            if (entry == null) continue;
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            try {
                                if (TextUtils.isEmpty((CharSequence)key) || !ProductConfigUtil.isSupportedDataType(value)) continue;
                                CTProductConfigController.this.defaultConfigs.put(key, String.valueOf(value));
                            }
                            catch (Exception e) {
                                CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: setDefaults Failed for Key: " + key + " with Error: " + e.getLocalizedMessage());
                            }
                        }
                    }
                    CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: setDefaults Completed with: " + CTProductConfigController.this.defaultConfigs);
                    return null;
                }
            }
        });
    }

    @Deprecated
    public void setGuidAndInit(String cleverTapID) {
        if (this.isInitialized() || TextUtils.isEmpty((CharSequence)cleverTapID)) {
            return;
        }
        this.settings.setGuid(cleverTapID);
        this.initAsync();
    }

    @Deprecated
    public void setMinimumFetchIntervalInSeconds(long fetchIntervalInSeconds) {
        this.settings.setMinimumFetchIntervalInSeconds(fetchIntervalInSeconds);
    }

    @Deprecated
    void eraseStoredConfigFiles() {
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.execute("eraseStoredConfigs", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                6 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        String dirName = CTProductConfigController.this.getProductConfigDirName();
                        CTProductConfigController.this.fileUtils.deleteDirectory(dirName);
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Reset Deleted Dir: " + dirName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Reset failed: " + e.getLocalizedMessage());
                    }
                    return null;
                }
            }
        });
    }

    String getActivatedFullPath() {
        return this.getProductConfigDirName() + "/" + "activated.json";
    }

    BaseAnalyticsManager getAnalyticsManager() {
        return this.analyticsManager;
    }

    BaseCallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    CleverTapInstanceConfig getConfig() {
        return this.config;
    }

    CoreMetaData getCoreMetaData() {
        return this.coreMetaData;
    }

    String getProductConfigDirName() {
        return "Product_Config_" + this.config.getAccountId() + "_" + this.settings.getGuid();
    }

    @Deprecated
    public ProductConfigSettings getSettings() {
        return this.settings;
    }

    void initAsync() {
        if (TextUtils.isEmpty((CharSequence)this.settings.getGuid())) {
            return;
        }
        Task<Boolean> task = CTExecutorFactory.executors(this.config).ioTask();
        task.addOnSuccessListener(new OnSuccessListener<Boolean>(){

            @Override
            public void onSuccess(Boolean aVoid) {
                CTProductConfigController.this.sendCallback(PROCESSING_STATE.INIT);
            }
        }).execute("ProductConfig#initAsync", new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                7 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        HashMap storedConfig;
                        if (!CTProductConfigController.this.defaultConfigs.isEmpty()) {
                            CTProductConfigController.this.activatedConfigs.putAll(CTProductConfigController.this.defaultConfigs);
                        }
                        if (!(storedConfig = CTProductConfigController.this.getStoredValues(CTProductConfigController.this.getActivatedFullPath())).isEmpty()) {
                            CTProductConfigController.this.waitingTobeActivatedConfig.putAll(storedConfig);
                        }
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Loaded configs ready to be applied: " + CTProductConfigController.this.waitingTobeActivatedConfig);
                        CTProductConfigController.this.settings.loadSettings(CTProductConfigController.this.fileUtils);
                        CTProductConfigController.this.isInitialized.set(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "InitAsync failed - " + e.getLocalizedMessage());
                        return false;
                    }
                    return true;
                }
            }
        });
    }

    boolean isFetchAndActivating() {
        return this.isFetchAndActivating.get();
    }

    void setDefaultsWithXmlParser(final int resourceID, final @NonNull DefaultXmlParser xmlParser) {
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.addOnSuccessListener(new OnSuccessListener<Void>(){

            @Override
            public void onSuccess(Void aVoid) {
                CTProductConfigController.this.initAsync();
            }
        }).execute("PCController#setDefaultsWithXmlParser", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                9 var1_1 = this;
                synchronized (var1_1) {
                    CTProductConfigController.this.defaultConfigs.putAll(xmlParser.getDefaultsFromXml(CTProductConfigController.this.context, resourceID));
                    CTProductConfigController.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(CTProductConfigController.this.config), "Product Config: setDefaults Completed with: " + CTProductConfigController.this.defaultConfigs);
                    return null;
                }
            }
        });
    }

    private boolean canRequest(long minimumFetchIntervalInSeconds) {
        boolean isTimeExpired;
        boolean validGuid;
        boolean bl = validGuid = !TextUtils.isEmpty((CharSequence)this.settings.getGuid());
        if (!validGuid) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: Throttled due to empty Guid");
            return false;
        }
        long lastRequestTime = this.settings.getLastFetchTimeStampInMillis();
        long timeDifference = System.currentTimeMillis() - lastRequestTime - TimeUnit.SECONDS.toMillis(minimumFetchIntervalInSeconds);
        boolean bl2 = isTimeExpired = timeDifference > 0L;
        if (!isTimeExpired) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Throttled since you made frequent request- [Last Request Time-" + new Date(lastRequestTime) + "], Try again in " + -timeDifference / 1000L + " seconds");
            return false;
        }
        return true;
    }

    private HashMap<String, String> convertServerJsonToMap(JSONObject jsonObject) {
        JSONArray kvArray;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            kvArray = jsonObject.getJSONArray("kv");
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ConvertServerJsonToMap failed - " + e.getLocalizedMessage());
            return map;
        }
        if (kvArray != null && kvArray.length() > 0) {
            for (int i = 0; i < kvArray.length(); ++i) {
                try {
                    JSONObject object = (JSONObject)kvArray.get(i);
                    if (object == null) continue;
                    String Key2 = object.getString("n");
                    String Value = object.getString("v");
                    if (TextUtils.isEmpty((CharSequence)Key2)) continue;
                    map.put(Key2, Value);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ConvertServerJsonToMap failed: " + e.getLocalizedMessage());
                }
            }
        }
        return map;
    }

    private HashMap<String, String> getStoredValues(String fullFilePath) {
        String content;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            content = this.fileUtils.readFromFile(fullFilePath);
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues reading file success:[ " + fullFilePath + "]--[Content]" + content);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues reading file failed: " + e.getLocalizedMessage());
            return map;
        }
        if (!TextUtils.isEmpty((CharSequence)content)) {
            JSONObject jsonObject;
            try {
                jsonObject = new JSONObject(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues failed due to malformed json: " + e.getLocalizedMessage());
                return map;
            }
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String value;
                String key = (String)iterator.next();
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                try {
                    value = String.valueOf(jsonObject.get(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetStoredValues for key " + key + " while parsing json: " + e.getLocalizedMessage());
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    private void onActivated() {
        if (this.callbackManager.getProductConfigListener() != null) {
            this.callbackManager.getProductConfigListener().onActivated();
        }
    }

    private void onFetched() {
        if (this.callbackManager.getProductConfigListener() != null) {
            this.callbackManager.getProductConfigListener().onFetched();
        }
    }

    private void onInit() {
        if (this.callbackManager.getProductConfigListener() != null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Product Config initialized");
            this.callbackManager.getProductConfigListener().onInit();
        }
    }

    private synchronized void parseFetchedResponse(JSONObject jsonObject) {
        HashMap<String, String> map = this.convertServerJsonToMap(jsonObject);
        this.waitingTobeActivatedConfig.clear();
        this.waitingTobeActivatedConfig.putAll(map);
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config: Fetched response:" + jsonObject);
        Integer timestamp = null;
        try {
            timestamp = (Integer)jsonObject.get("ts");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "ParseFetchedResponse failed: " + e.getLocalizedMessage());
        }
        if (timestamp != null) {
            this.settings.setLastFetchTimeStampInMillis((long)timestamp.intValue() * 1000L);
        }
    }

    private void sendCallback(PROCESSING_STATE state) {
        if (state != null) {
            switch (state) {
                case INIT: {
                    this.onInit();
                    break;
                }
                case FETCHED: {
                    this.onFetched();
                    break;
                }
                case ACTIVATED: {
                    this.onActivated();
                }
            }
        }
    }

    private static enum PROCESSING_STATE {
        INIT,
        FETCHED,
        ACTIVATED;

    }
}

