/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.task;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.task.Executable;
import com.clevertap.android.sdk.task.FailureExecutable;
import com.clevertap.android.sdk.task.OnFailureListener;
import com.clevertap.android.sdk.task.OnSuccessListener;
import com.clevertap.android.sdk.task.SuccessExecutable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Task<TResult> {
    protected final CleverTapInstanceConfig config;
    protected final Executor defaultCallbackExecutor;
    protected final Executor executor;
    protected final List<FailureExecutable<Exception>> failureExecutables = new ArrayList<FailureExecutable<Exception>>();
    protected TResult result;
    protected final List<SuccessExecutable<TResult>> successExecutables = new ArrayList<SuccessExecutable<TResult>>();
    protected STATE taskState = STATE.READY_TO_RUN;
    private final String taskName;

    Task(CleverTapInstanceConfig config, Executor executor, Executor defaultCallbackExecutor, String taskName) {
        this.executor = executor;
        this.defaultCallbackExecutor = defaultCallbackExecutor;
        this.config = config;
        this.taskName = taskName;
    }

    @NonNull
    public synchronized Task<TResult> addOnFailureListener(@NonNull Executor executor, OnFailureListener<Exception> listener) {
        if (listener != null) {
            this.failureExecutables.add(new FailureExecutable<Exception>(executor, listener));
        }
        return this;
    }

    @NonNull
    public Task<TResult> addOnFailureListener(@NonNull OnFailureListener<Exception> listener) {
        return this.addOnFailureListener(this.defaultCallbackExecutor, listener);
    }

    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull Executor executor, OnSuccessListener<TResult> listener) {
        if (listener != null) {
            this.successExecutables.add(new SuccessExecutable<TResult>(executor, listener, this.config));
        }
        return this;
    }

    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<TResult> listener) {
        return this.addOnSuccessListener(this.defaultCallbackExecutor, listener);
    }

    public void execute(String logTag, Callable<TResult> callable) {
        this.executor.execute(this.newRunnableForTask(logTag, callable));
    }

    public boolean isSuccess() {
        return this.taskState == STATE.SUCCESS;
    }

    @NonNull
    public Task<TResult> removeOnFailureListener(@NonNull OnFailureListener<Exception> listener) {
        Iterator<FailureExecutable<Exception>> iterator = this.failureExecutables.iterator();
        while (iterator.hasNext()) {
            FailureExecutable<Exception> item = iterator.next();
            if (item.getFailureListener() != listener) continue;
            iterator.remove();
        }
        return this;
    }

    @NonNull
    public Task<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<TResult> listener) {
        Iterator<SuccessExecutable<TResult>> iterator = this.successExecutables.iterator();
        while (iterator.hasNext()) {
            SuccessExecutable<TResult> item = iterator.next();
            if (item.getSuccessListener() != listener) continue;
            iterator.remove();
        }
        return this;
    }

    public Future<?> submit(String logTag, Callable<TResult> callable) {
        if (!(this.executor instanceof ExecutorService)) {
            throw new UnsupportedOperationException("Can't use this method without ExecutorService, Use Execute alternatively ");
        }
        return ((ExecutorService)this.executor).submit(this.newRunnableForTask(logTag, callable));
    }

    @Nullable
    public TResult submitAndGetResult(String logTag, Callable<TResult> callable, long timeoutMillis) {
        if (!(this.executor instanceof ExecutorService)) {
            throw new UnsupportedOperationException("Can't use this method without ExecutorService, Use Execute alternatively ");
        }
        Future<TResult> tResultFuture = null;
        try {
            tResultFuture = ((ExecutorService)this.executor).submit(callable);
            return tResultFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (tResultFuture != null && !tResultFuture.isCancelled()) {
                tResultFuture.cancel(true);
            }
            Logger.v("submitAndGetResult :: " + logTag + " task timed out");
            return null;
        }
    }

    void onFailure(Exception e) {
        this.setState(STATE.FAILED);
        for (Executable executable : this.failureExecutables) {
            executable.execute(e);
        }
    }

    void onSuccess(TResult result) {
        this.setState(STATE.SUCCESS);
        this.setResult(result);
        for (Executable executable : this.successExecutables) {
            executable.execute(this.result);
        }
    }

    void setResult(TResult result) {
        this.result = result;
    }

    void setState(STATE taskState) {
        this.taskState = taskState;
    }

    private Runnable newRunnableForTask(final String logTag, final Callable<TResult> callable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Task.this.config.getLogger().verbose(Task.this.taskName + " Task: " + logTag + " starting on..." + Thread.currentThread().getName());
                    Object result = callable.call();
                    Task.this.config.getLogger().verbose(Task.this.taskName + " Task: " + logTag + " executed successfully on..." + Thread.currentThread().getName());
                    Task.this.onSuccess(result);
                }
                catch (Exception e) {
                    Task.this.onFailure(e);
                    Task.this.config.getLogger().verbose(Task.this.taskName + " Task: " + logTag + " failed to execute on..." + Thread.currentThread().getName(), e);
                    e.printStackTrace();
                }
            }
        };
    }

    protected static enum STATE {
        FAILED,
        SUCCESS,
        READY_TO_RUN,
        RUNNING;

    }
}

