/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import androidx.viewpager.widget.ViewPager;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTCarouselViewPager;
import com.clevertap.android.sdk.inbox.CTCarouselViewPagerAdapter;
import com.clevertap.android.sdk.inbox.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.inbox.CTInboxButtonClickListener;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTInboxMessageContent;

class CTCarouselImageViewHolder
extends CTInboxBaseMessageViewHolder {
    private final TextView carouselTimestamp;
    private final RelativeLayout clickLayout;
    private final CTCarouselViewPager imageViewPager;
    private final LinearLayout sliderDots;

    CTCarouselImageViewHolder(@NonNull View itemView) {
        super(itemView);
        this.imageViewPager = (CTCarouselViewPager)itemView.findViewById(R.id.image_carousel_viewpager);
        this.sliderDots = (LinearLayout)itemView.findViewById(R.id.sliderDots);
        this.carouselTimestamp = (TextView)itemView.findViewById(R.id.carousel_timestamp);
        this.clickLayout = (RelativeLayout)itemView.findViewById(R.id.body_linear_layout);
    }

    @Override
    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, int position) {
        super.configureWithMessage(inboxMessage, parent, position);
        CTInboxListViewFragment parentWeak = this.getParent();
        Context appContext = parent.getActivity().getApplicationContext();
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.carouselTimestamp.setVisibility(0);
        if (inboxMessage.isRead()) {
            this.readDot.setVisibility(8);
        } else {
            this.readDot.setVisibility(0);
        }
        String carouselImageDisplayTimestamp = this.calculateDisplayTimestamp(inboxMessage.getDate());
        this.carouselTimestamp.setText((CharSequence)carouselImageDisplayTimestamp);
        this.carouselTimestamp.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.clickLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.imageViewPager.getLayoutParams();
        CTCarouselViewPagerAdapter carouselViewPagerAdapter = new CTCarouselViewPagerAdapter(appContext, parent, inboxMessage, layoutParams, position);
        this.imageViewPager.setAdapter(carouselViewPagerAdapter);
        int dotsCount = inboxMessage.getInboxMessageContents().size();
        if (this.sliderDots.getChildCount() > 0) {
            this.sliderDots.removeAllViews();
        }
        ImageView[] dots = new ImageView[dotsCount];
        this.setDots(dots, dotsCount, appContext, this.sliderDots);
        dots[0].setImageDrawable(ResourcesCompat.getDrawable((Resources)appContext.getResources(), (int)R.drawable.ct_selected_dot, null));
        CarouselPageChangeListener carouselPageChangeListener = new CarouselPageChangeListener(parent.getActivity().getApplicationContext(), this, dots, inboxMessage);
        this.imageViewPager.addOnPageChangeListener(carouselPageChangeListener);
        this.clickLayout.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, null, parentWeak, this.imageViewPager, true, -1));
        this.markItemAsRead(inboxMessage, position);
    }

    class CarouselPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final Context context;
        private final ImageView[] dots;
        private final CTInboxMessage inboxMessage;
        private final CTCarouselImageViewHolder viewHolder;

        CarouselPageChangeListener(Context context, CTCarouselImageViewHolder viewHolder, ImageView[] dots, CTInboxMessage inboxMessage) {
            this.context = context;
            this.viewHolder = viewHolder;
            this.dots = dots;
            this.inboxMessage = inboxMessage;
            this.dots[0].setImageDrawable(ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.ct_selected_dot, null));
        }

        public void onPageScrollStateChanged(int i) {
        }

        public void onPageScrolled(int i, float v, int i1) {
        }

        public void onPageSelected(int position) {
            for (ImageView dot : this.dots) {
                dot.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_unselected_dot, null));
            }
            this.dots[position].setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_selected_dot, null));
        }
    }
}

