/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.interfaces.AudibleNotification;
import com.clevertap.android.sdk.pushnotification.CTPushProvider;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.CoreNotificationRenderer;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.pushnotification.UnregistrableCTPushProvider;
import com.clevertap.android.sdk.pushnotification.amp.CTBackgroundJobService;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.PackageUtils;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PushProviders
implements CTPushProviderListener {
    private final ArrayList<PushConstants.PushType> allEnabledPushTypes = new ArrayList();
    private final ArrayList<PushConstants.PushType> allDisabledPushTypes = new ArrayList();
    private final ArrayList<CTPushProvider> availableCTPushProviders = new ArrayList();
    private final ArrayList<PushConstants.PushType> customEnabledPushTypes = new ArrayList();
    private final AnalyticsManager analyticsManager;
    private final BaseDatabaseManager baseDatabaseManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private INotificationRenderer iNotificationRenderer = new CoreNotificationRenderer();
    private final ValidationResultStack validationResultStack;
    private final Object tokenLock = new Object();
    private final Object pushRenderingLock = new Object();
    private CleverTapAPI.DevicePushTokenRefreshListener tokenRefreshListener;

    @NonNull
    public static PushProviders load(Context context, CleverTapInstanceConfig config, BaseDatabaseManager baseDatabaseManager, ValidationResultStack validationResultStack, AnalyticsManager analyticsManager, ControllerManager controllerManager) {
        PushProviders providers = new PushProviders(context, config, baseDatabaseManager, validationResultStack, analyticsManager);
        providers.init();
        controllerManager.setPushProviders(providers);
        return providers;
    }

    private PushProviders(Context context, CleverTapInstanceConfig config, BaseDatabaseManager baseDatabaseManager, ValidationResultStack validationResultStack, AnalyticsManager analyticsManager) {
        this.context = context;
        this.config = config;
        this.baseDatabaseManager = baseDatabaseManager;
        this.validationResultStack = validationResultStack;
        this.analyticsManager = analyticsManager;
        this.initPushAmp();
    }

    public void _createNotification(Context context, Bundle extras, int notificationId) {
        if (extras == null || extras.get("wzrk_pn") == null) {
            return;
        }
        if (this.config.isAnalyticsOnly()) {
            this.config.getLogger().debug(this.config.getAccountId(), "Instance is set for Analytics only, cannot create notification");
            return;
        }
        try {
            String notifTitle;
            boolean isSilent = extras.getString("wzrk_pn_s", "").equalsIgnoreCase("true");
            if (isSilent) {
                this.analyticsManager.pushNotificationViewedEvent(extras);
                return;
            }
            String extrasFrom = extras.getString("extras_from");
            if (extrasFrom == null || !extrasFrom.equals("PTReceiver")) {
                this.config.getLogger().debug(this.config.getAccountId(), "Handling notification: " + extras);
                this.config.getLogger().debug(this.config.getAccountId(), "Handling notification::nh_source = " + extras.getString("nh_source", "source not available"));
                if (extras.getString("wzrk_pid") != null && this.baseDatabaseManager.loadDBAdapter(context).doesPushNotificationIdExist(extras.getString("wzrk_pid"))) {
                    this.config.getLogger().debug(this.config.getAccountId(), "Push Notification already rendered, not showing again");
                    return;
                }
                String notifMessage = this.iNotificationRenderer.getMessage(extras);
                String string = notifMessage = notifMessage != null ? notifMessage : "";
                if (notifMessage.isEmpty()) {
                    this.config.getLogger().verbose(this.config.getAccountId(), "Push notification message is empty, not rendering");
                    this.baseDatabaseManager.loadDBAdapter(context).storeUninstallTimestamp();
                    String pingFreq = extras.getString("pf", "");
                    if (!TextUtils.isEmpty((CharSequence)pingFreq)) {
                        this.updatePingFrequencyIfNeeded(context, Integer.parseInt(pingFreq));
                    }
                    return;
                }
            }
            notifTitle = (notifTitle = this.iNotificationRenderer.getTitle(extras, context)).isEmpty() ? context.getApplicationInfo().name : notifTitle;
            this.triggerNotification(context, extras, notificationId);
        }
        catch (Throwable t) {
            this.config.getLogger().debug(this.config.getAccountId(), "Couldn't render notification: ", t);
        }
    }

    public void cacheToken(final String token, final PushConstants.PushType pushType) {
        if (TextUtils.isEmpty((CharSequence)token) || pushType == null) {
            return;
        }
        try {
            Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
            task.execute("PushProviders#cacheToken", new Callable<Void>(){

                @Override
                public Void call() {
                    if (PushProviders.this.alreadyHaveToken(token, pushType)) {
                        return null;
                    }
                    String key = pushType.getTokenPrefKey();
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        return null;
                    }
                    StorageHelper.putStringImmediate(PushProviders.this.context, StorageHelper.storageKeyWithSuffix(PushProviders.this.config, key), token);
                    PushProviders.this.config.log("PushProvider", (Object)((Object)pushType) + "Cached New Token successfully " + token);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.config.log("PushProvider", (Object)((Object)pushType) + "Unable to cache token " + token, t);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void doTokenRefresh(String token, PushConstants.PushType pushType) {
        if (TextUtils.isEmpty((CharSequence)token) || pushType == null) {
            return;
        }
        switch (pushType) {
            case FCM: {
                this.handleToken(token, PushConstants.PushType.FCM, true);
                break;
            }
            case XPS: {
                this.handleToken(token, PushConstants.PushType.XPS, true);
                break;
            }
            case HPS: {
                this.handleToken(token, PushConstants.PushType.HPS, true);
                break;
            }
            case BPS: {
                this.handleToken(token, PushConstants.PushType.BPS, true);
                break;
            }
            case ADM: {
                this.handleToken(token, PushConstants.PushType.ADM, true);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void forcePushDeviceToken(boolean register) {
        for (PushConstants.PushType pushType : this.allEnabledPushTypes) {
            this.pushDeviceTokenEvent(null, register, pushType);
        }
    }

    @NonNull
    public ArrayList<PushConstants.PushType> getAvailablePushTypes() {
        ArrayList<PushConstants.PushType> pushTypes = new ArrayList<PushConstants.PushType>();
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            pushTypes.add(pushProvider.getPushType());
        }
        return pushTypes;
    }

    public String getCachedToken(PushConstants.PushType pushType) {
        String key;
        if (pushType != null && !TextUtils.isEmpty((CharSequence)(key = pushType.getTokenPrefKey()))) {
            String cachedToken = StorageHelper.getStringFromPrefs(this.context, this.config, key, null);
            this.config.log("PushProvider", (Object)((Object)pushType) + "getting Cached Token - " + cachedToken);
            return cachedToken;
        }
        if (pushType != null) {
            this.config.log("PushProvider", (Object)((Object)pushType) + " Unable to find cached Token for type ");
        }
        return null;
    }

    public CleverTapAPI.DevicePushTokenRefreshListener getDevicePushTokenRefreshListener() {
        return this.tokenRefreshListener;
    }

    public void setDevicePushTokenRefreshListener(CleverTapAPI.DevicePushTokenRefreshListener tokenRefreshListener) {
        this.tokenRefreshListener = tokenRefreshListener;
    }

    public void handleToken(String token, PushConstants.PushType pushType, boolean register) {
        if (register) {
            this.registerToken(token, pushType);
        } else {
            this.unregisterToken(token, pushType);
        }
    }

    public boolean isNotificationSupported() {
        for (PushConstants.PushType pushType : this.getAvailablePushTypes()) {
            if (this.getCachedToken(pushType) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNewToken(String freshToken, PushConstants.PushType pushType) {
        if (!TextUtils.isEmpty((CharSequence)freshToken)) {
            this.doTokenRefresh(freshToken, pushType);
            this.deviceTokenDidRefresh(freshToken, pushType);
        }
    }

    public void onTokenRefresh() {
        this.refreshAllTokens();
    }

    public void processCustomPushNotification(final Bundle extras) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("customHandlePushAmplification", new Callable<Void>(){

            @Override
            public Void call() {
                String notifMessage = extras.getString("nm");
                String string = notifMessage = notifMessage != null ? notifMessage : "";
                if (notifMessage.isEmpty()) {
                    PushProviders.this.config.getLogger().verbose(PushProviders.this.config.getAccountId(), "Push notification message is empty, not rendering");
                    PushProviders.this.baseDatabaseManager.loadDBAdapter(PushProviders.this.context).storeUninstallTimestamp();
                    String pingFreq = extras.getString("pf", "");
                    if (!TextUtils.isEmpty((CharSequence)pingFreq)) {
                        PushProviders.this.updatePingFrequencyIfNeeded(PushProviders.this.context, Integer.parseInt(pingFreq));
                    }
                } else {
                    String wzrk_pid = extras.getString("wzrk_pid");
                    String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
                    long wzrk_ttl = Long.parseLong(ttl);
                    DBAdapter dbAdapter = PushProviders.this.baseDatabaseManager.loadDBAdapter(PushProviders.this.context);
                    PushProviders.this.config.getLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
                    dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
                }
                return null;
            }
        });
    }

    public void unregisterToken(String token, PushConstants.PushType pushType) {
        this.pushDeviceTokenEvent(token, false, pushType);
    }

    public void updatePingFrequencyIfNeeded(final Context context, int frequency) {
        this.config.getLogger().verbose("Ping frequency received - " + frequency);
        this.config.getLogger().verbose("Stored Ping Frequency - " + this.getPingFrequency(context));
        if (frequency != this.getPingFrequency(context)) {
            this.setPingFrequency(context, frequency);
            if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
                Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
                task.execute("createOrResetJobScheduler", new Callable<Void>(){

                    @Override
                    public Void call() {
                        if (Build.VERSION.SDK_INT >= 21) {
                            PushProviders.this.config.getLogger().verbose("Creating job");
                            PushProviders.this.createOrResetJobScheduler(context);
                        } else {
                            PushProviders.this.config.getLogger().verbose("Resetting alarm");
                            PushProviders.this.resetAlarmScheduler(context);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private boolean alreadyHaveToken(String newToken, PushConstants.PushType pushType) {
        boolean alreadyAvailable;
        boolean bl = alreadyAvailable = !TextUtils.isEmpty((CharSequence)newToken) && pushType != null && newToken.equalsIgnoreCase(this.getCachedToken(pushType));
        if (pushType != null) {
            this.config.log("PushProvider", (Object)((Object)pushType) + "Token Already available value: " + alreadyAvailable);
        }
        return alreadyAvailable;
    }

    public void runInstanceJobWork(final Context context, final JobParameters parameters) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("runningJobService", new Callable<Void>(){

            @Override
            public Void call() {
                Date endTime;
                if (!PushProviders.this.isNotificationSupported()) {
                    Logger.v(PushProviders.this.config.getAccountId(), "Token is not present, not running the Job");
                    return null;
                }
                Calendar now = Calendar.getInstance();
                int hour = now.get(11);
                int minute = now.get(12);
                Date currentTime = PushProviders.this.parseTimeToDate(hour + ":" + minute);
                Date startTime = PushProviders.this.parseTimeToDate("22:00");
                if (PushProviders.this.isTimeBetweenDNDTime(startTime, endTime = PushProviders.this.parseTimeToDate("06:00"), currentTime)) {
                    Logger.v(PushProviders.this.config.getAccountId(), "Job Service won't run in default DND hours");
                    return null;
                }
                long lastTS = PushProviders.this.baseDatabaseManager.loadDBAdapter(context).getLastUninstallTimestamp();
                if (lastTS == 0L || lastTS > System.currentTimeMillis() - 86400000L) {
                    try {
                        JSONObject eventObject = new JSONObject();
                        eventObject.put("bk", 1);
                        PushProviders.this.analyticsManager.sendPingEvent(eventObject);
                        int flagsAlarmPendingIntent = 0x8000000;
                        if (Build.VERSION.SDK_INT >= 31) {
                            flagsAlarmPendingIntent |= 0x2000000;
                        }
                        if (parameters == null) {
                            int pingFrequency = PushProviders.this.getPingFrequency(context);
                            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                            Intent cancelIntent = new Intent("com.clevertap.BG_EVENT");
                            cancelIntent.setPackage(context.getPackageName());
                            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)PushProviders.this.config.getAccountId().hashCode(), (Intent)cancelIntent, (int)flagsAlarmPendingIntent);
                            if (alarmManager != null) {
                                alarmManager.cancel(alarmPendingIntent);
                            }
                            Intent alarmIntent = new Intent("com.clevertap.BG_EVENT");
                            alarmIntent.setPackage(context.getPackageName());
                            PendingIntent alarmServicePendingIntent = PendingIntent.getService((Context)context, (int)PushProviders.this.config.getAccountId().hashCode(), (Intent)alarmIntent, (int)flagsAlarmPendingIntent);
                            if (alarmManager != null && pingFrequency != -1) {
                                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + (long)pingFrequency * 60000L, 60000L * (long)pingFrequency, alarmServicePendingIntent);
                            }
                        }
                    }
                    catch (JSONException e) {
                        Logger.v("Unable to raise background Ping event");
                    }
                }
                return null;
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=21)
    private void createOrResetJobScheduler(Context context) {
        int existingJobId = StorageHelper.getInt(context, "pfjobid", -1);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (Build.VERSION.SDK_INT < 26) {
            if (existingJobId >= 0) {
                jobScheduler.cancel(existingJobId);
                StorageHelper.putInt(context, "pfjobid", -1);
            }
            this.config.getLogger().debug(this.config.getAccountId(), "Push Amplification feature is not supported below Oreo");
            return;
        }
        if (jobScheduler == null) {
            return;
        }
        int pingFrequency = this.getPingFrequency(context);
        if (existingJobId < 0 && pingFrequency < 0) {
            return;
        }
        if (pingFrequency < 0) {
            jobScheduler.cancel(existingJobId);
            StorageHelper.putInt(context, "pfjobid", -1);
            return;
        }
        ComponentName componentName = new ComponentName(context, CTBackgroundJobService.class);
        boolean needsCreate = existingJobId < 0 && pingFrequency > 0;
        JobInfo existingJobInfo = PushProviders.getJobInfo(existingJobId, jobScheduler);
        if (existingJobInfo != null && existingJobInfo.getIntervalMillis() != (long)pingFrequency * 60000L) {
            jobScheduler.cancel(existingJobId);
            StorageHelper.putInt(context, "pfjobid", -1);
            needsCreate = true;
        }
        if (needsCreate) {
            JobInfo jobInfo;
            int resultCode;
            int jobid = this.config.getAccountId().hashCode();
            JobInfo.Builder builder = new JobInfo.Builder(jobid, componentName);
            builder.setRequiredNetworkType(1);
            builder.setRequiresCharging(false);
            builder.setPeriodic((long)pingFrequency * 60000L, 300000L);
            builder.setRequiresBatteryNotLow(true);
            if (Utils.hasPermission(context, "android.permission.RECEIVE_BOOT_COMPLETED")) {
                builder.setPersisted(true);
            }
            if ((resultCode = jobScheduler.schedule(jobInfo = builder.build())) == 1) {
                Logger.d(this.config.getAccountId(), "Job scheduled - " + jobid);
                StorageHelper.putInt(context, "pfjobid", jobid);
            } else {
                Logger.d(this.config.getAccountId(), "Job not scheduled - " + jobid);
            }
        }
    }

    @NonNull
    private List<CTPushProvider> createProviders() {
        ArrayList<CTPushProvider> providers = new ArrayList<CTPushProvider>();
        for (PushConstants.PushType pushType : this.allEnabledPushTypes) {
            CTPushProvider pushProvider = this.getCTPushProviderFromPushType(pushType, true);
            if (pushProvider == null) continue;
            providers.add(pushProvider);
        }
        for (PushConstants.PushType pushType : this.allDisabledPushTypes) {
            CTPushProvider pushProvider;
            String cachedTokenXps;
            if (pushType != PushConstants.PushType.XPS || TextUtils.isEmpty((CharSequence)(cachedTokenXps = this.getCachedToken(PushConstants.PushType.XPS))) || !((pushProvider = this.getCTPushProviderFromPushType(pushType, false)) instanceof UnregistrableCTPushProvider)) continue;
            ((UnregistrableCTPushProvider)((Object)pushProvider)).unregisterPush(this.context);
            this.config.log("PushProvider", "unregistering existing token for disabled " + (Object)((Object)pushType));
        }
        return providers;
    }

    @Nullable
    private CTPushProvider getCTPushProviderFromPushType(PushConstants.PushType pushType, boolean isInit) {
        String className = pushType.getCtProviderClassName();
        CTPushProvider pushProvider = null;
        try {
            Class<?> providerClass = Class.forName(className);
            if (isInit) {
                Constructor<?> constructor = providerClass.getConstructor(CTPushProviderListener.class, Context.class, CleverTapInstanceConfig.class);
                pushProvider = (CTPushProvider)constructor.newInstance(this, this.context, this.config);
            } else {
                Constructor<?> constructor = providerClass.getConstructor(CTPushProviderListener.class, Context.class, CleverTapInstanceConfig.class, Boolean.class);
                pushProvider = (CTPushProvider)constructor.newInstance(this, this.context, this.config, false);
            }
            this.config.log("PushProvider", "Found provider:" + className);
        }
        catch (InstantiationException e) {
            this.config.log("PushProvider", "Unable to create provider InstantiationException" + className);
        }
        catch (IllegalAccessException e) {
            this.config.log("PushProvider", "Unable to create provider IllegalAccessException" + className);
        }
        catch (ClassNotFoundException e) {
            this.config.log("PushProvider", "Unable to create provider ClassNotFoundException" + className);
        }
        catch (Exception e) {
            this.config.log("PushProvider", "Unable to create provider " + className + " Exception:" + e.getClass().getName());
        }
        return pushProvider;
    }

    private void deviceTokenDidRefresh(String token, PushConstants.PushType type) {
        if (this.tokenRefreshListener != null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Notifying devicePushTokenDidRefresh: " + token);
            this.tokenRefreshListener.devicePushTokenDidRefresh(token, type);
        }
    }

    private void findCTPushProviders(List<CTPushProvider> providers) {
        if (providers.isEmpty()) {
            this.config.log("PushProvider", "No push providers found!. Make sure to install at least one push provider");
            return;
        }
        for (CTPushProvider provider : providers) {
            if (!this.isValid(provider)) {
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass());
                continue;
            }
            if (!provider.isSupported()) {
                this.config.log("PushProvider", "Unsupported Provider: " + provider.getClass());
                continue;
            }
            if (provider.isAvailable()) {
                this.config.log("PushProvider", "Available Provider: " + provider.getClass());
                this.availableCTPushProviders.add(provider);
                continue;
            }
            this.config.log("PushProvider", "Unavailable Provider: " + provider.getClass());
        }
    }

    private void findCustomEnabledPushTypes() {
        this.customEnabledPushTypes.addAll(this.allEnabledPushTypes);
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            this.customEnabledPushTypes.remove((Object)pushProvider.getPushType());
        }
    }

    private void findEnabledPushTypes() {
        for (PushConstants.PushType pushType : PushNotificationUtil.getPushTypes(this.config.getAllowedPushTypes())) {
            String className = pushType.getMessagingSDKClassName();
            try {
                Class.forName(className);
                this.allEnabledPushTypes.add(pushType);
                this.config.log("PushProvider", "SDK Class Available :" + className);
                if (pushType.getRunningDevices() == 3) {
                    this.allEnabledPushTypes.remove((Object)pushType);
                    this.allDisabledPushTypes.add(pushType);
                    this.config.log("PushProvider", "disabling " + (Object)((Object)pushType) + " due to flag set as PushConstants.NO_DEVICES");
                }
                if (pushType.getRunningDevices() != 2 || PackageUtils.isXiaomiDeviceRunningMiui(this.context)) continue;
                this.allEnabledPushTypes.remove((Object)pushType);
                this.allDisabledPushTypes.add(pushType);
                this.config.log("PushProvider", "disabling " + (Object)((Object)pushType) + " due to flag set as PushConstants.XIAOMI_MIUI_DEVICES");
            }
            catch (Exception e) {
                this.config.log("PushProvider", "SDK class Not available " + className + " Exception:" + e.getClass().getName());
            }
        }
    }

    private int getPingFrequency(Context context) {
        return StorageHelper.getInt(context, "pf", 240);
    }

    private void init() {
        this.findEnabledPushTypes();
        List<CTPushProvider> providers = this.createProviders();
        this.findCTPushProviders(providers);
        this.findCustomEnabledPushTypes();
    }

    private void initPushAmp() {
        if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("createOrResetJobScheduler", new Callable<Void>(){

                @Override
                public Void call() {
                    if (Build.VERSION.SDK_INT >= 21) {
                        PushProviders.this.createOrResetJobScheduler(PushProviders.this.context);
                    } else {
                        PushProviders.this.createAlarmScheduler(PushProviders.this.context);
                    }
                    return null;
                }
            });
        }
    }

    private boolean isTimeBetweenDNDTime(Date startTime, Date stopTime, Date currentTime) {
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(startTime);
        Calendar currentTimeCalendar = Calendar.getInstance();
        currentTimeCalendar.setTime(currentTime);
        Calendar stopTimeCalendar = Calendar.getInstance();
        stopTimeCalendar.setTime(stopTime);
        if (stopTime.compareTo(startTime) < 0) {
            if (currentTimeCalendar.compareTo(stopTimeCalendar) < 0) {
                currentTimeCalendar.add(5, 1);
            }
            stopTimeCalendar.add(5, 1);
        }
        return currentTimeCalendar.compareTo(startTimeCalendar) >= 0 && currentTimeCalendar.compareTo(stopTimeCalendar) < 0;
    }

    private boolean isValid(CTPushProvider provider) {
        if (40608 < provider.minSDKSupportVersionCode()) {
            this.config.log("PushProvider", "Provider: %s version %s does not match the SDK version %s. Make sure all CleverTap dependencies are the same version.");
            return false;
        }
        switch (provider.getPushType()) {
            case FCM: 
            case XPS: 
            case HPS: 
            case BPS: {
                if (provider.getPlatform() == 1) break;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass() + " delivery is only available for Android platforms." + (Object)((Object)provider.getPushType()));
                return false;
            }
            case ADM: {
                if (provider.getPlatform() == 2) break;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass() + " ADM delivery is only available for Amazon platforms." + (Object)((Object)provider.getPushType()));
                return false;
            }
        }
        return true;
    }

    private Date parseTimeToDate(String time) {
        String inputFormat = "HH:mm";
        SimpleDateFormat inputParser = new SimpleDateFormat("HH:mm", Locale.US);
        try {
            return inputParser.parse(time);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDeviceTokenEvent(String token, boolean register, PushConstants.PushType pushType) {
        if (pushType == null) {
            return;
        }
        String string = token = !TextUtils.isEmpty((CharSequence)token) ? token : this.getCachedToken(pushType);
        if (TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        Object object = this.tokenLock;
        synchronized (object) {
            JSONObject event = new JSONObject();
            JSONObject data = new JSONObject();
            String action = register ? "register" : "unregister";
            try {
                data.put("action", (Object)action);
                data.put("id", (Object)token);
                data.put("type", (Object)pushType.getType());
                if (pushType == PushConstants.PushType.XPS) {
                    this.config.getLogger().verbose("PushProviders: pushDeviceTokenEvent requesting device region");
                    data.put("region", (Object)pushType.getServerRegion());
                }
                event.put("data", (Object)data);
                this.config.getLogger().verbose(this.config.getAccountId(), (Object)((Object)pushType) + action + " device token " + token);
                this.analyticsManager.sendDataEvent(event);
            }
            catch (Throwable t) {
                this.config.getLogger().verbose(this.config.getAccountId(), (Object)((Object)pushType) + action + " device token failed", t);
            }
        }
    }

    private void refreshAllTokens() {
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.execute("PushProviders#refreshAllTokens", new Callable<Void>(){

            @Override
            public Void call() {
                PushProviders.this.refreshCTProviderTokens();
                PushProviders.this.refreshCustomProviderTokens();
                return null;
            }
        });
    }

    private void refreshCTProviderTokens() {
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            try {
                pushProvider.requestToken();
            }
            catch (Throwable t) {
                this.config.log("PushProvider", "Token Refresh error " + pushProvider, t);
            }
        }
    }

    private void refreshCustomProviderTokens() {
        for (PushConstants.PushType pushType : this.customEnabledPushTypes) {
            try {
                this.pushDeviceTokenEvent(this.getCachedToken(pushType), true, pushType);
            }
            catch (Throwable t) {
                this.config.log("PushProvider", "Token Refresh error " + (Object)((Object)pushType), t);
            }
        }
    }

    private void registerToken(String token, PushConstants.PushType pushType) {
        this.pushDeviceTokenEvent(token, true, pushType);
        this.cacheToken(token, pushType);
    }

    private void resetAlarmScheduler(Context context) {
        if (this.getPingFrequency(context) <= 0) {
            this.stopAlarmScheduler(context);
        } else {
            this.stopAlarmScheduler(context);
            this.createAlarmScheduler(context);
        }
    }

    private void setPingFrequency(Context context, int pingFrequency) {
        StorageHelper.putInt(context, "pf", pingFrequency);
    }

    private void createAlarmScheduler(Context context) {
        int pingFrequency = this.getPingFrequency(context);
        if (pingFrequency > 0) {
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            Intent intent = new Intent("com.clevertap.BG_EVENT");
            intent.setPackage(context.getPackageName());
            int flagsAlarmPendingIntent = 0x8000000;
            if (Build.VERSION.SDK_INT >= 31) {
                flagsAlarmPendingIntent |= 0x2000000;
            }
            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)this.config.getAccountId().hashCode(), (Intent)intent, (int)flagsAlarmPendingIntent);
            if (alarmManager != null) {
                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime(), 60000L * (long)pingFrequency, alarmPendingIntent);
            }
        }
    }

    private void stopAlarmScheduler(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent cancelIntent = new Intent("com.clevertap.BG_EVENT");
        cancelIntent.setPackage(context.getPackageName());
        int flagsAlarmPendingIntent = 0x8000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flagsAlarmPendingIntent |= 0x2000000;
        }
        PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)this.config.getAccountId().hashCode(), (Intent)cancelIntent, (int)flagsAlarmPendingIntent);
        if (alarmManager != null && alarmPendingIntent != null) {
            alarmManager.cancel(alarmPendingIntent);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public INotificationRenderer getPushNotificationRenderer() {
        return this.iNotificationRenderer;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Object getPushRenderingLock() {
        return this.pushRenderingLock;
    }

    @RequiresApi(api=21)
    private static JobInfo getJobInfo(int jobId, JobScheduler jobScheduler) {
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != jobId) continue;
            return jobInfo;
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setPushNotificationRenderer(@NonNull INotificationRenderer iNotificationRenderer) {
        this.iNotificationRenderer = iNotificationRenderer;
    }

    private void triggerNotification(Context context, Bundle extras, int notificationId) {
        NotificationCompat.Builder nb;
        int priorityInt;
        boolean requiresChannelId;
        String channelId;
        NotificationManager notificationManager;
        block37: {
            int smallIcon;
            notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager == null) {
                String notificationManagerError = "Unable to render notification, Notification Manager is null.";
                this.config.getLogger().debug(this.config.getAccountId(), notificationManagerError);
                return;
            }
            channelId = extras.getString("wzrk_cid", "");
            boolean bl = requiresChannelId = Build.VERSION.SDK_INT >= 26;
            if (Build.VERSION.SDK_INT >= 26) {
                int messageCode = -1;
                String value = "";
                if (channelId.isEmpty()) {
                    messageCode = 8;
                    value = extras.toString();
                } else if (notificationManager.getNotificationChannel(channelId) == null) {
                    messageCode = 9;
                    value = channelId;
                }
                if (messageCode != -1) {
                    ValidationResult channelIdError = ValidationResultFactory.create(512, messageCode, value);
                    this.config.getLogger().debug(this.config.getAccountId(), channelIdError.getErrorDesc());
                    this.validationResultStack.pushValidationResult(channelIdError);
                    return;
                }
            }
            try {
                String x = ManifestInfo.getInstance(context).getNotificationIcon();
                if (x == null) {
                    throw new IllegalArgumentException();
                }
                smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                if (smallIcon == 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Throwable t) {
                smallIcon = DeviceInfo.getAppIconAsIntId(context);
            }
            this.iNotificationRenderer.setSmallIcon(smallIcon, context);
            priorityInt = 0;
            String priority = extras.getString("pr");
            if (priority != null) {
                if (priority.equals("high")) {
                    priorityInt = 1;
                }
                if (priority.equals("max")) {
                    priorityInt = 2;
                }
            }
            if (notificationId == -1000) {
                try {
                    Object collapse_key = this.iNotificationRenderer.getCollapseKey(extras);
                    if (collapse_key == null) break block37;
                    if (collapse_key instanceof Number) {
                        notificationId = ((Number)collapse_key).intValue();
                    } else if (collapse_key instanceof String) {
                        try {
                            notificationId = Integer.parseInt(collapse_key.toString());
                            this.config.getLogger().verbose(this.config.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                        }
                        catch (NumberFormatException e) {
                            notificationId = collapse_key.toString().hashCode();
                            this.config.getLogger().verbose(this.config.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                        }
                    }
                    notificationId = Math.abs(notificationId);
                    this.config.getLogger().debug(this.config.getAccountId(), "Creating the notification id: " + notificationId + " from collapse_key: " + collapse_key);
                }
                catch (NumberFormatException collapse_key) {}
            } else {
                this.config.getLogger().debug(this.config.getAccountId(), "Have user provided notificationId: " + notificationId + " won't use collapse_key (if any) as basis for notificationId");
            }
        }
        if (notificationId == -1000) {
            notificationId = (int)(Math.random() * 100.0);
            this.config.getLogger().debug(this.config.getAccountId(), "Setting random notificationId: " + notificationId);
        }
        if (requiresChannelId) {
            String badgeCountParam;
            nb = new NotificationCompat.Builder(context, channelId);
            String badgeIconParam = extras.getString("wzrk_bi", null);
            if (badgeIconParam != null) {
                try {
                    int badgeIconType = Integer.parseInt(badgeIconParam);
                    if (badgeIconType >= 0) {
                        nb.setBadgeIconType(badgeIconType);
                    }
                }
                catch (Throwable badgeIconType) {
                    // empty catch block
                }
            }
            if ((badgeCountParam = extras.getString("wzrk_bc", null)) != null) {
                try {
                    int badgeCount = Integer.parseInt(badgeCountParam);
                    if (badgeCount >= 0) {
                        nb.setNumber(badgeCount);
                    }
                }
                catch (Throwable badgeCount) {}
            }
        } else {
            nb = new NotificationCompat.Builder(context);
        }
        nb.setPriority(priorityInt);
        if (this.iNotificationRenderer instanceof AudibleNotification) {
            nb = ((AudibleNotification)((Object)this.iNotificationRenderer)).setSound(context, extras, nb, this.config);
        }
        if ((nb = this.iNotificationRenderer.renderNotification(extras, context, nb, this.config, notificationId)) == null) {
            return;
        }
        Notification n = nb.build();
        notificationManager.notify(notificationId, n);
        this.config.getLogger().debug(this.config.getAccountId(), "Rendered notification: " + n.toString());
        String extrasFrom = extras.getString("extras_from");
        if (extrasFrom == null || !extrasFrom.equals("PTReceiver")) {
            String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
            long wzrk_ttl = Long.parseLong(ttl);
            String wzrk_pid = extras.getString("wzrk_pid");
            DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(context);
            this.config.getLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
            dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
            boolean notificationViewedEnabled = "true".equals(extras.getString("wzrk_rnv", ""));
            if (!notificationViewedEnabled) {
                ValidationResult notificationViewedError = ValidationResultFactory.create(512, 10, extras.toString());
                this.config.getLogger().debug(notificationViewedError.getErrorDesc());
                this.validationResultStack.pushValidationResult(notificationViewedError);
                return;
            }
            this.analyticsManager.pushNotificationViewedEvent(extras);
            this.config.getLogger().verbose("Rendered Push Notification... from nh_source = " + extras.getString("nh_source", "source not available"));
        }
    }
}

