/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import android.os.Bundle;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationHandler;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushAmpResponse
extends CleverTapResponseDecorator {
    private final BaseCallbackManager callbackManager;
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final Logger logger;
    private final ControllerManager controllerManager;
    private final BaseDatabaseManager baseDatabaseManager;

    public PushAmpResponse(CleverTapResponse cleverTapResponse, Context context, CleverTapInstanceConfig config, BaseDatabaseManager dbManager, BaseCallbackManager callbackManager, ControllerManager controllerManager) {
        this.cleverTapResponse = cleverTapResponse;
        this.context = context;
        this.config = config;
        this.logger = this.config.getLogger();
        this.baseDatabaseManager = dbManager;
        this.callbackManager = callbackManager;
        this.controllerManager = controllerManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        block11: {
            if (this.config.isAnalyticsOnly()) {
                this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing push amp response");
                this.cleverTapResponse.processResponse(response, stringBody, context);
                return;
            }
            try {
                if (!response.has("pushamp_notifs")) break block11;
                this.logger.verbose(this.config.getAccountId(), "Processing pushamp messages...");
                JSONObject pushAmpObject = response.getJSONObject("pushamp_notifs");
                JSONArray pushNotifications = pushAmpObject.getJSONArray("list");
                if (pushNotifications.length() > 0) {
                    this.logger.verbose(this.config.getAccountId(), "Handling Push payload locally");
                    this.handlePushNotificationsInResponse(pushNotifications);
                }
                if (pushAmpObject.has("pf")) {
                    try {
                        int frequency = pushAmpObject.getInt("pf");
                        this.controllerManager.getPushProviders().updatePingFrequencyIfNeeded(context, frequency);
                    }
                    catch (Throwable t) {
                        this.logger.verbose("Error handling ping frequency in response : " + t.getMessage());
                    }
                }
                if (pushAmpObject.has("ack")) {
                    boolean ack = pushAmpObject.getBoolean("ack");
                    this.logger.verbose("Received ACK -" + ack);
                    if (ack) {
                        JSONArray rtlArray = CTJsonConverter.getRenderedTargetList(this.baseDatabaseManager.loadDBAdapter(context));
                        String[] rtlStringArray = new String[]{};
                        if (rtlArray != null) {
                            rtlStringArray = new String[rtlArray.length()];
                        }
                        for (int i = 0; i < rtlStringArray.length; ++i) {
                            rtlStringArray[i] = rtlArray.getString(i);
                        }
                        this.logger.verbose("Updating RTL values...");
                        this.baseDatabaseManager.loadDBAdapter(context).updatePushNotificationIds(rtlStringArray);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cleverTapResponse.processResponse(response, stringBody, context);
    }

    private void handlePushNotificationsInResponse(JSONArray pushNotifications) {
        try {
            for (int i = 0; i < pushNotifications.length(); ++i) {
                Bundle pushBundle = new Bundle();
                JSONObject pushObject = pushNotifications.getJSONObject(i);
                if (pushObject.has("wzrk_ttl")) {
                    pushBundle.putLong("wzrk_ttl", pushObject.getLong("wzrk_ttl"));
                }
                Iterator iterator = pushObject.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    pushBundle.putString(key, pushObject.getString(key));
                }
                if (!pushBundle.isEmpty() && !this.baseDatabaseManager.loadDBAdapter(this.context).doesPushNotificationIdExist(pushObject.getString("wzrk_pid"))) {
                    this.logger.verbose("Creating Push Notification locally");
                    if (this.callbackManager.getPushAmpListener() != null) {
                        this.callbackManager.getPushAmpListener().onPushAmpPayloadReceived(pushBundle);
                        continue;
                    }
                    PushNotificationHandler.getPushNotificationHandler().onMessageReceived(this.context, pushBundle, PushConstants.PushType.FCM.toString());
                    continue;
                }
                this.logger.verbose(this.config.getAccountId(), "Push Notification already shown, ignoring local notification :" + pushObject.getString("wzrk_pid"));
            }
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Error parsing push notification JSON");
        }
    }
}

