/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONObject;

public class BaseResponse
extends CleverTapResponseDecorator {
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final LocalDataStore localDataStore;
    private final Logger logger;
    private final NetworkManager networkManager;

    public BaseResponse(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, NetworkManager networkManager, LocalDataStore localDataStore, CleverTapResponse cleverTapResponse) {
        this.cleverTapResponse = cleverTapResponse;
        this.config = config;
        this.logger = this.config.getLogger();
        this.networkManager = networkManager;
        this.localDataStore = localDataStore;
    }

    @Override
    public void processResponse(JSONObject jsonBody, String responseStr, Context context) {
        if (responseStr == null) {
            this.logger.verbose(this.config.getAccountId(), "Problem processing queue response, response is null");
            return;
        }
        try {
            this.logger.verbose(this.config.getAccountId(), "Trying to process response: " + responseStr);
            JSONObject response = new JSONObject(responseStr);
            this.cleverTapResponse.processResponse(response, responseStr, context);
            try {
                this.localDataStore.syncWithUpstream(context, response);
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to sync local cache with upstream", t);
            }
        }
        catch (Throwable t) {
            this.networkManager.incrementResponseFailureCount();
            this.logger.verbose(this.config.getAccountId(), "Problem process send queue response", t);
        }
    }
}

